BEGIN;

INSERT INTO config.upgrade_log (version) VALUES ('0358'); --atz

-- We won't necessarily use all of these, but they are here for completeness.
-- Source is the EDI spec 6063 codelist, eg: http://www.stylusstudio.com/edifact/D04B/6063.htm
-- Values are the EDI code value + 1200

INSERT INTO acq.cancel_reason (org_unit, keep_debits, id, label, description) VALUES 
(1, 't', 1201, 'Discrete quantity', 'Individually separated and distinct quantity.'),
(1, 't', 1202, 'Charge', 'Quantity relevant for charge.'),
(1, 't', 1203, 'Cumulative quantity', 'Quantity accumulated.'),
(1, 't', 1204, 'Interest for overdrawn account', 'Interest for overdrawing the account.'),
(1, 't', 1205, 'Active ingredient dose per unit', 'The dosage of active ingredient per unit.'),
(1, 't', 1206, 'Auditor', 'The number of entities that audit accounts.'),
(1, 't', 1207, 'Branch locations, leased', 'The number of branch locations being leased by an entity.'),
(1, 't', 1208, 'Inventory quantity at supplier''s subject to inspection by', 'customer Quantity of goods which the customer requires the supplier to have in inventory and which may be inspected by the customer if desired.'),
(1, 't', 1209, 'Branch locations, owned', 'The number of branch locations owned by an entity.'),
(1, 't', 1210, 'Judgements registered', 'The number of judgements registered against an entity.'),
(1, 't', 1211, 'Split quantity', 'Part of the whole quantity.'),
(1, 't', 1212, 'Despatch quantity', 'Quantity despatched by the seller.'),
(1, 't', 1213, 'Liens registered', 'The number of liens registered against an entity.'),
(1, 't', 1214, 'Livestock', 'The number of animals kept for use or profit.'),
(1, 't', 1215, 'Insufficient funds returned cheques', 'The number of cheques returned due to insufficient funds.'),
(1, 't', 1216, 'Stolen cheques', 'The number of stolen cheques.'),
(1, 't', 1217, 'Quantity on hand', 'The total quantity of a product on hand at a location. This includes as well units awaiting return to manufacturer, units unavailable due to inspection procedures and undamaged stock available for despatch, resale or use.'),
(1, 't', 1218, 'Previous quantity', 'Quantity previously referenced.'),
(1, 't', 1219, 'Paid-in security shares', 'The number of security shares issued and for which full payment has been made.'),
(1, 't', 1220, 'Unusable quantity', 'Quantity not usable.'),
(1, 't', 1221, 'Ordered quantity', '[6024] The quantity which has been ordered.'),
(1, 't', 1222, 'Quantity at 100%', 'Equivalent quantity at 100% purity.'),
(1, 't', 1223, 'Active ingredient', 'Quantity at 100% active agent content.'),
(1, 't', 1224, 'Inventory quantity at supplier''s not subject to inspection', 'by customer Quantity of goods which the customer requires the supplier to have in inventory but which will not be checked by the customer.'),
(1, 't', 1225, 'Retail sales', 'Quantity of retail point of sale activity.'),
(1, 't', 1226, 'Promotion quantity', 'A quantity associated with a promotional event.'),
(1, 't', 1227, 'On hold for shipment', 'Article received which cannot be shipped in its present form.'),
(1, 't', 1228, 'Military sales quantity', 'Quantity of goods or services sold to a military organization.'),
(1, 't', 1229, 'On premises sales',  'Sale of product in restaurants or bars.'),
(1, 't', 1230, 'Off premises sales', 'Sale of product directly to a store.'),
(1, 't', 1231, 'Estimated annual volume', 'Volume estimated for a year.'),
(1, 't', 1232, 'Minimum delivery batch', 'Minimum quantity of goods delivered at one time.'),
(1, 't', 1233, 'Maximum delivery batch', 'Maximum quantity of goods delivered at one time.'),
(1, 't', 1234, 'Pipes', 'The number of tubes used to convey a substance.'),
(1, 't', 1235, 'Price break from', 'The minimum quantity of a quantity range for a specified (unit) price.'),
(1, 't', 1236, 'Price break to', 'Maximum quantity to which the price break applies.'),
(1, 't', 1237, 'Poultry', 'The number of domestic fowl.'),
(1, 't', 1238, 'Secured charges registered', 'The number of secured charges registered against an entity.'),
(1, 't', 1239, 'Total properties owned', 'The total number of properties owned by an entity.'),
(1, 't', 1240, 'Normal delivery', 'Quantity normally delivered by the seller.'),
(1, 't', 1241, 'Sales quantity not included in the replenishment', 'calculation Sales which will not be included in the calculation of replenishment requirements.'),
(1, 't', 1242, 'Maximum supply quantity, supplier endorsed', 'Maximum supply quantity endorsed by a supplier.'),
(1, 't', 1243, 'Buyer', 'The number of buyers.'),
(1, 't', 1244, 'Debenture bond', 'The number of fixed-interest bonds of an entity backed by general credit rather than specified assets.'),
(1, 't', 1245, 'Debentures filed against directors', 'The number of notices of indebtedness filed against an entity''s directors.'),
(1, 't', 1246, 'Pieces delivered', 'Number of pieces actually received at the final destination.'),
(1, 't', 1247, 'Invoiced quantity', 'The quantity as per invoice.'),
(1, 't', 1248, 'Received quantity', 'The quantity which has been received.'),
(1, 't', 1249, 'Chargeable distance', '[6110] The distance between two points for which a specific tariff applies.'),
(1, 't', 1250, 'Disposition undetermined quantity', 'Product quantity that has not yet had its disposition determined.'),
(1, 't', 1251, 'Inventory category transfer', 'Inventory that has been moved from one inventory category to another.'),
(1, 't', 1252, 'Quantity per pack', 'Quantity for each pack.'),
(1, 't', 1253, 'Minimum order quantity', 'Minimum quantity of goods for an order.'),
(1, 't', 1254, 'Maximum order quantity', 'Maximum quantity of goods for an order.'),
(1, 't', 1255, 'Total sales', 'The summation of total quantity sales.'),
(1, 't', 1256, 'Wholesaler to wholesaler sales', 'Sale of product to other wholesalers by a wholesaler.'),
(1, 't', 1257, 'In transit quantity', 'A quantity that is en route.'),
(1, 't', 1258, 'Quantity withdrawn', 'Quantity withdrawn from a location.'),
(1, 't', 1259, 'Numbers of consumer units in the traded unit', 'Number of units for consumer sales in a unit for trading.'),
(1, 't', 1260, 'Current inventory quantity available for shipment', 'Current inventory quantity available for shipment.'),
(1, 't', 1261, 'Return quantity', 'Quantity of goods returned.'),
(1, 't', 1262, 'Sorted quantity', 'The quantity that is sorted.'),
(1, 'f', 1263, 'Sorted quantity rejected', 'The sorted quantity that is rejected.'),
(1, 't', 1264, 'Scrap quantity', 'Remainder of the total quantity after split deliveries.'),
(1, 'f', 1265, 'Destroyed quantity', 'Quantity of goods destroyed.'),
(1, 't', 1266, 'Committed quantity', 'Quantity a party is committed to.'),
(1, 't', 1267, 'Estimated reading quantity', 'The value that is estimated to be the reading of a measuring device (e.g. meter).'),
(1, 't', 1268, 'End quantity', 'The quantity recorded at the end of an agreement or period.'),
(1, 't', 1269, 'Start quantity', 'The quantity recorded at the start of an agreement or period.'),
(1, 't', 1270, 'Cumulative quantity received', 'Cumulative quantity of all deliveries of this article received by the buyer.'),
(1, 't', 1271, 'Cumulative quantity ordered', 'Cumulative quantity of all deliveries, outstanding and scheduled orders.'),
(1, 't', 1272, 'Cumulative quantity received end of prior year', 'Cumulative quantity of all deliveries of the product received by the buyer till end of prior year.'),
(1, 't', 1273, 'Outstanding quantity', 'Difference between quantity ordered and quantity received.'),
(1, 't', 1274, 'Latest cumulative quantity', 'Cumulative quantity after complete delivery of all scheduled quantities of the product.'),
(1, 't', 1275, 'Previous highest cumulative quantity', 'Cumulative quantity after complete delivery of all scheduled quantities of the product from a prior schedule period.'),
(1, 't', 1276, 'Adjusted corrector reading', 'A corrector reading after it has been adjusted.'),
(1, 't', 1277, 'Work days', 'Number of work days, e.g. per respective period.'),
(1, 't', 1278, 'Cumulative quantity scheduled', 'Adding the quantity actually scheduled to previous cumulative quantity.'),
(1, 't', 1279, 'Previous cumulative quantity', 'Cumulative quantity prior the actual order.'),
(1, 't', 1280, 'Unadjusted corrector reading', 'A corrector reading before it has been adjusted.'),
(1, 't', 1281, 'Extra unplanned delivery', 'Non scheduled additional quantity.'),
(1, 't', 1282, 'Quantity requirement for sample inspection', 'Required quantity for sample inspection.'),
(1, 't', 1283, 'Backorder quantity', 'The quantity of goods that is on back-order.'),
(1, 't', 1284, 'Urgent delivery quantity', 'Quantity for urgent delivery.'),
(1, 'f', 1285, 'Previous order quantity to be cancelled', 'Quantity ordered previously to be cancelled.'),
(1, 't', 1286, 'Normal reading quantity', 'The value recorded or read from a measuring device (e.g. meter) in the normal conditions.'),
(1, 't', 1287, 'Customer reading quantity', 'The value recorded or read from a measuring device (e.g. meter) by the customer.'),
(1, 't', 1288, 'Information reading quantity', 'The value recorded or read from a measuring device (e.g. meter) for information purposes.'),
(1, 't', 1289, 'Quality control held', 'Quantity of goods held pending completion of a quality control assessment.'),
(1, 't', 1290, 'As is quantity', 'Quantity as it is in the existing circumstances.'),
(1, 't', 1291, 'Open quantity', 'Quantity remaining after partial delivery.'),
(1, 't', 1292, 'Final delivery quantity', 'Quantity of final delivery to a respective order.'),
(1, 't', 1293, 'Subsequent delivery quantity', 'Quantity delivered to a respective order after it''s final delivery.'),
(1, 't', 1294, 'Substitutional quantity', 'Quantity delivered replacing previous deliveries.'),
(1, 't', 1295, 'Redelivery after post processing', 'Quantity redelivered after post processing.'),
(1, 'f', 1296, 'Quality control failed', 'Quantity of goods which have failed quality control.'),
(1, 't', 1297, 'Minimum inventory', 'Minimum stock quantity on which replenishment is based.'),
(1, 't', 1298, 'Maximum inventory', 'Maximum stock quantity on which replenishment is based.'),
(1, 't', 1299, 'Estimated quantity', 'Quantity estimated.'),
(1, 't', 1300, 'Chargeable weight', 'The weight on which charges are based.'),
(1, 't', 1301, 'Chargeable gross weight', 'The gross weight on which charges are based.'),
(1, 't', 1302, 'Chargeable tare weight', 'The tare weight on which charges are based.'),
(1, 't', 1303, 'Chargeable number of axles', 'The number of axles on which charges are based.'),
(1, 't', 1304, 'Chargeable number of containers', 'The number of containers on which charges are based.'),
(1, 't', 1305, 'Chargeable number of rail wagons', 'The number of rail wagons on which charges are based.'),
(1, 't', 1306, 'Chargeable number of packages', 'The number of packages on which charges are based.'),
(1, 't', 1307, 'Chargeable number of units', 'The number of units on which charges are based.'),
(1, 't', 1308, 'Chargeable period', 'The period of time on which charges are based.'),
(1, 't', 1309, 'Chargeable volume', 'The volume on which charges are based.'),
(1, 't', 1310, 'Chargeable cubic measurements', 'The cubic measurements on which charges are based.'),
(1, 't', 1311, 'Chargeable surface', 'The surface area on which charges are based.'),
(1, 't', 1312, 'Chargeable length', 'The length on which charges are based.'),
(1, 't', 1313, 'Quantity to be delivered', 'The quantity to be delivered.'),
(1, 't', 1314, 'Number of passengers', 'Total number of passengers on the conveyance.'),
(1, 't', 1315, 'Number of crew', 'Total number of crew members on the conveyance.'),
(1, 't', 1316, 'Number of transport documents', 'Total number of air waybills, bills of lading, etc. being reported for a specific conveyance.'),
(1, 't', 1317, 'Quantity landed', 'Quantity of goods actually arrived.'),
(1, 't', 1318, 'Quantity manifested', 'Quantity of goods contracted for delivery by the carrier.'),
(1, 't', 1319, 'Short shipped', 'Indication that part of the consignment was not shipped.'),
(1, 't', 1320, 'Split shipment', 'Indication that the consignment has been split into two or more shipments.'),
(1, 't', 1321, 'Over shipped', 'The quantity of goods shipped that exceeds the quantity contracted.'),
(1, 't', 1322, 'Short-landed goods', 'If quantity of goods actually landed is less than the quantity which appears in the documentation. This quantity is the difference between these quantities.'),
(1, 't', 1323, 'Surplus goods', 'If quantity of goods actually landed is more than the quantity which appears in the documentation. This quantity is the difference between these quantities.'),
(1, 'f', 1324, 'Damaged goods', 'Quantity of goods which have deteriorated in transport such that they cannot be used for the purpose for which they were originally intended.'),
(1, 'f', 1325, 'Pilferage goods', 'Quantity of goods stolen during transport.'),
(1, 'f', 1326, 'Lost goods', 'Quantity of goods that disappeared in transport.'),
(1, 't', 1327, 'Report difference', 'The quantity concerning the same transaction differs between two documents/messages and the source of this difference is a typing error.'),
(1, 't', 1328, 'Quantity loaded', 'Quantity of goods loaded onto a means of transport.'),
(1, 't', 1329, 'Units per unit price', 'Number of units per unit price.'),
(1, 't', 1330, 'Allowance', 'Quantity relevant for allowance.'),
(1, 't', 1331, 'Delivery quantity', 'Quantity required by buyer to be delivered.'),
(1, 't', 1332, 'Cumulative quantity, preceding period, planned', 'Cumulative quantity originally planned for the preceding period.'),
(1, 't', 1333, 'Cumulative quantity, preceding period, reached', 'Cumulative quantity reached in the preceding period.'),
(1, 't', 1334, 'Cumulative quantity, actual planned',            'Cumulative quantity planned for now.'),
(1, 't', 1335, 'Period quantity, planned', 'Quantity planned for this period.'),
(1, 't', 1336, 'Period quantity, reached', 'Quantity reached during this period.'),
(1, 't', 1337, 'Cumulative quantity, preceding period, estimated', 'Estimated cumulative quantity reached in the preceding period.'),
(1, 't', 1338, 'Cumulative quantity, actual estimated',            'Estimated cumulative quantity reached now.'),
(1, 't', 1339, 'Cumulative quantity, preceding period, measured', 'Surveyed cumulative quantity reached in the preceding period.'),
(1, 't', 1340, 'Cumulative quantity, actual measured', 'Surveyed cumulative quantity reached now.'),
(1, 't', 1341, 'Period quantity, measured',            'Surveyed quantity reached during this period.'),
(1, 't', 1342, 'Total quantity, planned', 'Total quantity planned.'),
(1, 't', 1343, 'Quantity, remaining', 'Quantity remaining.'),
(1, 't', 1344, 'Tolerance', 'Plus or minus tolerance expressed as a monetary amount.'),
(1, 't', 1345, 'Actual stock',          'The stock on hand, undamaged, and available for despatch, sale or use.'),
(1, 't', 1346, 'Model or target stock', 'The stock quantity required or planned to have on hand, undamaged and available for use.'),
(1, 't', 1347, 'Direct shipment quantity', 'Quantity to be shipped directly to a customer from a manufacturing site.'),
(1, 't', 1348, 'Amortization total quantity',     'Indication of final quantity for amortization.'),
(1, 't', 1349, 'Amortization order quantity',     'Indication of actual share of the order quantity for amortization.'),
(1, 't', 1350, 'Amortization cumulated quantity', 'Indication of actual cumulated quantity of previous and actual amortization order quantity.'),
(1, 't', 1351, 'Quantity advised',  'Quantity advised by supplier or shipper, in contrast to quantity actually received.'),
(1, 't', 1352, 'Consignment stock', 'Quantity of goods with an external customer which is still the property of the supplier. Payment for these goods is only made to the supplier when the ownership has been transferred between the trading partners.'),
(1, 't', 1353, 'Statistical sales quantity', 'Quantity of goods sold in a specified period.'),
(1, 't', 1354, 'Sales quantity planned',     'Quantity of goods required to meet future demands. - Market intelligence quantity.'),
(1, 't', 1355, 'Replenishment quantity',     'Quantity required to maintain the requisite on-hand stock of goods.'),
(1, 't', 1356, 'Inventory movement quantity', 'To specify the quantity of an inventory movement.'),
(1, 't', 1357, 'Opening stock balance quantity', 'To specify the quantity of an opening stock balance.'),
(1, 't', 1358, 'Closing stock balance quantity', 'To specify the quantity of a closing stock balance.'),
(1, 't', 1359, 'Number of stops', 'Number of times a means of transport stops before arriving at destination.'),
(1, 't', 1360, 'Minimum production batch', 'The quantity specified is the minimum output from a single production run.'),
(1, 't', 1361, 'Dimensional sample quantity', 'The quantity defined is a sample for the purpose of validating dimensions.'),
(1, 't', 1362, 'Functional sample quantity', 'The quantity defined is a sample for the purpose of validating function and performance.'),
(1, 't', 1363, 'Pre-production quantity', 'Quantity of the referenced item required prior to full production.'),
(1, 't', 1364, 'Delivery batch', 'Quantity of the referenced item which constitutes a standard batch for deliver purposes.'),
(1, 't', 1365, 'Delivery batch multiple', 'The multiples in which delivery batches can be supplied.'),
(1, 't', 1366, 'All time buy',             'The total quantity of the referenced covering all future needs. Further orders of the referenced item are not expected.'),
(1, 't', 1367, 'Total delivery quantity',  'The total quantity required by the buyer to be delivered.'),
(1, 't', 1368, 'Single delivery quantity', 'The quantity required by the buyer to be delivered in a single shipment.'),
(1, 't', 1369, 'Supplied quantity',  'Quantity of the referenced item actually shipped.'),
(1, 't', 1370, 'Allocated quantity', 'Quantity of the referenced item allocated from available stock for delivery.'),
(1, 't', 1371, 'Maximum stackability', 'The number of pallets/handling units which can be safely stacked one on top of another.'),
(1, 't', 1372, 'Amortisation quantity', 'The quantity of the referenced item which has a cost for tooling amortisation included in the item price.'),
(1, 't', 1373, 'Previously amortised quantity', 'The cumulative quantity of the referenced item which had a cost for tooling amortisation included in the item price.'),
(1, 't', 1374, 'Total amortisation quantity', 'The total quantity of the referenced item which has a cost for tooling amortisation included in the item price.'),
(1, 't', 1375, 'Number of moulds', 'The number of pressing moulds contained within a single piece of the referenced tooling.'),
(1, 't', 1376, 'Concurrent item output of tooling', 'The number of related items which can be produced simultaneously with a single piece of the referenced tooling.'),
(1, 't', 1377, 'Periodic capacity of tooling', 'Maximum production output of the referenced tool over a period of time.'),
(1, 't', 1378, 'Lifetime capacity of tooling', 'Maximum production output of the referenced tool over its productive lifetime.'),
(1, 't', 1379, 'Number of deliveries per despatch period', 'The number of deliveries normally expected to be despatched within each despatch period.'),
(1, 't', 1380, 'Provided quantity', 'The quantity of a referenced component supplied by the buyer for manufacturing of an ordered item.'),
(1, 't', 1381, 'Maximum production batch', 'The quantity specified is the maximum output from a single production run.'),
(1, 'f', 1382, 'Cancelled quantity', 'Quantity of the referenced item which has previously been ordered and is now cancelled.'),
(1, 't', 1383, 'No delivery requirement in this instruction', 'This delivery instruction does not contain any delivery requirements.'),
(1, 't', 1384, 'Quantity of material in ordered time', 'Quantity of the referenced material within the ordered time.'),
(1, 'f', 1385, 'Rejected quantity', 'The quantity of received goods rejected for quantity reasons.'),
(1, 't', 1386, 'Cumulative quantity scheduled up to accumulation start date', 'The cumulative quantity scheduled up to the accumulation start date.'),
(1, 't', 1387, 'Quantity scheduled', 'The quantity scheduled for delivery.'),
(1, 't', 1388, 'Number of identical handling units', 'Number of identical handling units in terms of type and contents.'),
(1, 't', 1389, 'Number of packages in handling unit', 'The number of packages contained in one handling unit.'),
(1, 't', 1390, 'Despatch note quantity', 'The item quantity specified on the despatch note.'),
(1, 't', 1391, 'Adjustment to inventory quantity', 'An adjustment to inventory quantity.'),
(1, 't', 1392, 'Free goods quantity',    'Quantity of goods which are free of charge.'),
(1, 't', 1393, 'Free quantity included', 'Quantity included to which no charge is applicable.'),
(1, 't', 1394, 'Received and accepted',  'Quantity which has been received and accepted at a given location.'),
(1, 'f', 1395, 'Received, not accepted, to be returned',  'Quantity which has been received but not accepted at a given location and which will consequently be returned to the relevant party.'),
(1, 'f', 1396, 'Received, not accepted, to be destroyed', 'Quantity which has been received but not accepted at a given location and which will consequently be destroyed.'),
(1, 't', 1397, 'Reordering level', 'Quantity at which an order may be triggered to replenish.'),
(1, 't', 1399, 'Inventory withdrawal quantity', 'Quantity which has been withdrawn from inventory since the last inventory report.'),
(1, 't', 1400, 'Free quantity not included', 'Free quantity not included in ordered quantity.'),
(1, 't', 1401, 'Recommended overhaul and repair quantity', 'To indicate the recommended quantity of an article required to support overhaul and repair activities.'),
(1, 't', 1402, 'Quantity per next higher assembly', 'To indicate the quantity required for the next higher assembly.'),
(1, 't', 1403, 'Quantity per unit of issue', 'Provides the standard quantity of an article in which one unit can be issued.'),
(1, 't', 1404, 'Cumulative scrap quantity',  'Provides the cumulative quantity of an item which has been identified as scrapped.'),
(1, 't', 1405, 'Publication turn size', 'The quantity of magazines or newspapers grouped together with the spine facing alternate directions in a bundle.'),
(1, 't', 1406, 'Recommended maintenance quantity', 'Recommended quantity of an article which is required to meet an agreed level of maintenance.'),
(1, 't', 1407, 'Labour hours', 'Number of labour hours.'),
(1, 't', 1408, 'Quantity requirement for maintenance and repair of', 'equipment Quantity of the material needed to maintain and repair equipment.'),
(1, 't', 1409, 'Additional replenishment demand quantity', 'Incremental needs over and above normal replenishment calculations, but not intended to permanently change the model parameters.'),
(1, 't', 1410, 'Returned by consumer quantity', 'Quantity returned by a consumer.'),
(1, 't', 1411, 'Replenishment override quantity', 'Quantity to override the normal replenishment model calculations, but not intended to permanently change the model parameters.'),
(1, 't', 1412, 'Quantity sold, net', 'Net quantity sold which includes returns of saleable inventory and other adjustments.'),
(1, 't', 1413, 'Transferred out quantity',   'Quantity which was transferred out of this location.'),
(1, 't', 1414, 'Transferred in quantity',    'Quantity which was transferred into this location.'),
(1, 't', 1415, 'Unsaleable quantity',        'Quantity of inventory received which cannot be sold in its present condition.'),
(1, 't', 1416, 'Consumer reserved quantity', 'Quantity reserved for consumer delivery or pickup and not yet withdrawn from inventory.'),
(1, 't', 1417, 'Out of inventory quantity',  'Quantity of inventory which was requested but was not available.'),
(1, 't', 1418, 'Quantity returned, defective or damaged', 'Quantity returned in a damaged or defective condition.'),
(1, 't', 1419, 'Taxable quantity',           'Quantity subject to taxation.'),
(1, 't', 1420, 'Meter reading', 'The numeric value of measure units counted by a meter.'),
(1, 't', 1421, 'Maximum requestable quantity', 'The maximum quantity which may be requested.'),
(1, 't', 1422, 'Minimum requestable quantity', 'The minimum quantity which may be requested.'),
(1, 't', 1423, 'Daily average quantity', 'The quantity for a defined period divided by the number of days of the period.'),
(1, 't', 1424, 'Budgeted hours',     'The number of budgeted hours.'),
(1, 't', 1425, 'Actual hours',       'The number of actual hours.'),
(1, 't', 1426, 'Earned value hours', 'The number of earned value hours.'),
(1, 't', 1427, 'Estimated hours',    'The number of estimated hours.'),
(1, 't', 1428, 'Level resource task quantity', 'Quantity of a resource that is level for the duration of the task.'),
(1, 't', 1429, 'Available resource task quantity', 'Quantity of a resource available to complete a task.'),
(1, 't', 1430, 'Work time units',   'Quantity of work units of time.'),
(1, 't', 1431, 'Daily work shifts', 'Quantity of work shifts per day.'),
(1, 't', 1432, 'Work time units per shift', 'Work units of time per work shift.'),
(1, 't', 1433, 'Work calendar units',       'Work calendar units of time.'),
(1, 't', 1434, 'Elapsed duration',   'Quantity representing the elapsed duration.'),
(1, 't', 1435, 'Remaining duration', 'Quantity representing the remaining duration.'),
(1, 't', 1436, 'Original duration',  'Quantity representing the original duration.'),
(1, 't', 1437, 'Current duration',   'Quantity representing the current duration.'),
(1, 't', 1438, 'Total float time',   'Quantity representing the total float time.'),
(1, 't', 1439, 'Free float time',    'Quantity representing the free float time.'),
(1, 't', 1440, 'Lag time',           'Quantity representing lag time.'),
(1, 't', 1441, 'Lead time',          'Quantity representing lead time.'),
(1, 't', 1442, 'Number of months', 'The number of months.'),
(1, 't', 1443, 'Reserved quantity customer direct delivery sales', 'Quantity of products reserved for sales delivered direct to the customer.'),
(1, 't', 1444, 'Reserved quantity retail sales', 'Quantity of products reserved for retail sales.'),
(1, 't', 1445, 'Consolidated discount inventory', 'A quantity of inventory supplied at consolidated discount terms.'),
(1, 't', 1446, 'Returns replacement quantity',    'A quantity of goods issued as a replacement for a returned quantity.'),
(1, 't', 1447, 'Additional promotion sales forecast quantity', 'A forecast of additional quantity which will be sold during a period of promotional activity.'),
(1, 't', 1448, 'Reserved quantity', 'Quantity reserved for specific purposes.'),
(1, 't', 1449, 'Quantity displayed not available for sale', 'Quantity displayed within a retail outlet but not available for sale.'),
(1, 't', 1450, 'Inventory discrepancy', 'The difference recorded between theoretical and physical inventory.'),
(1, 't', 1451, 'Incremental order quantity', 'The incremental quantity by which ordering is carried out.'),
(1, 't', 1452, 'Quantity requiring manipulation before despatch', 'A quantity of goods which needs manipulation before despatch.'),
(1, 't', 1453, 'Quantity in quarantine',              'A quantity of goods which are held in a restricted area for quarantine purposes.'),
(1, 't', 1454, 'Quantity withheld by owner of goods', 'A quantity of goods which has been withheld by the owner of the goods.'),
(1, 't', 1455, 'Quantity not available for despatch', 'A quantity of goods not available for despatch.'),
(1, 't', 1456, 'Quantity awaiting delivery', 'Quantity of goods which are awaiting delivery.'),
(1, 't', 1457, 'Quantity in physical inventory',      'A quantity of goods held in physical inventory.'),
(1, 't', 1458, 'Quantity held by logistic service provider', 'Quantity of goods under the control of a logistic service provider.'),
(1, 't', 1459, 'Optimal quantity', 'The optimal quantity for a given purpose.'),
(1, 't', 1460, 'Delivery quantity balance', 'The difference between the scheduled quantity and the quantity delivered to the consignee at a given date.'),
(1, 't', 1461, 'Cumulative quantity shipped', 'Cumulative quantity of all shipments.'),
(1, 't', 1462, 'Quantity suspended', 'The quantity of something which is suspended.'),
(1, 't', 1463, 'Control quantity', 'The quantity designated for control purposes.'),
(1, 't', 1464, 'Equipment quantity', 'A count of a quantity of equipment.'),
(1, 't', 1465, 'Factor', 'Number by which the measured unit has to be multiplied to calculate the units used.'),
(1, 't', 1466, 'Unsold quantity held by wholesaler', 'Unsold quantity held by the wholesaler.'),
(1, 't', 1467, 'Quantity held by delivery vehicle', 'Quantity of goods held by the delivery vehicle.'),
(1, 't', 1468, 'Quantity held by retail outlet', 'Quantity held by the retail outlet.'),
(1, 'f', 1469, 'Rejected return quantity', 'A quantity for return which has been rejected.'),
(1, 't', 1470, 'Accounts', 'The number of accounts.'),
(1, 't', 1471, 'Accounts placed for collection', 'The number of accounts placed for collection.'),
(1, 't', 1472, 'Activity codes', 'The number of activity codes.'),
(1, 't', 1473, 'Agents', 'The number of agents.'),
(1, 't', 1474, 'Airline attendants', 'The number of airline attendants.'),
(1, 't', 1475, 'Authorised shares',  'The number of shares authorised for issue.'),
(1, 't', 1476, 'Employee average',   'The average number of employees.'),
(1, 't', 1477, 'Branch locations',   'The number of branch locations.'),
(1, 't', 1478, 'Capital changes',    'The number of capital changes made.'),
(1, 't', 1479, 'Clerks', 'The number of clerks.'),
(1, 't', 1480, 'Companies in same activity', 'The number of companies doing business in the same activity category.'),
(1, 't', 1481, 'Companies included in consolidated financial statement', 'The number of companies included in a consolidated financial statement.'),
(1, 't', 1482, 'Cooperative shares', 'The number of cooperative shares.'),
(1, 't', 1483, 'Creditors',   'The number of creditors.'),
(1, 't', 1484, 'Departments', 'The number of departments.'),
(1, 't', 1485, 'Design employees', 'The number of employees involved in the design process.'),
(1, 't', 1486, 'Physicians', 'The number of medical doctors.'),
(1, 't', 1487, 'Domestic affiliated companies', 'The number of affiliated companies located within the country.'),
(1, 't', 1488, 'Drivers', 'The number of drivers.'),
(1, 't', 1489, 'Employed at location',     'The number of employees at the specified location.'),
(1, 't', 1490, 'Employed by this company', 'The number of employees at the specified company.'),
(1, 't', 1491, 'Total employees',    'The total number of employees.'),
(1, 't', 1492, 'Employees shared',   'The number of employees shared among entities.'),
(1, 't', 1493, 'Engineers',          'The number of engineers.'),
(1, 't', 1494, 'Estimated accounts', 'The estimated number of accounts.'),
(1, 't', 1495, 'Estimated employees at location', 'The estimated number of employees at the specified location.'),
(1, 't', 1496, 'Estimated total employees',       'The total estimated number of employees.'),
(1, 't', 1497, 'Executives', 'The number of executives.'),
(1, 't', 1498, 'Agricultural workers',   'The number of agricultural workers.'),
(1, 't', 1499, 'Financial institutions', 'The number of financial institutions.'),
(1, 't', 1500, 'Floors occupied', 'The number of floors occupied.'),
(1, 't', 1501, 'Foreign related entities', 'The number of related entities located outside the country.'),
(1, 't', 1502, 'Group employees',    'The number of employees within the group.'),
(1, 't', 1503, 'Indirect employees', 'The number of employees not associated with direct production.'),
(1, 't', 1504, 'Installers',    'The number of employees involved with the installation process.'),
(1, 't', 1505, 'Invoices',      'The number of invoices.'),
(1, 't', 1506, 'Issued shares', 'The number of shares actually issued.'),
(1, 't', 1507, 'Labourers',     'The number of labourers.'),
(1, 't', 1508, 'Manufactured units', 'The number of units manufactured.'),
(1, 't', 1509, 'Maximum number of employees', 'The maximum number of people employed.'),
(1, 't', 1510, 'Maximum number of employees at location', 'The maximum number of people employed at a location.'),
(1, 't', 1511, 'Members in group', 'The number of members within a group.'),
(1, 't', 1512, 'Minimum number of employees at location', 'The minimum number of people employed at a location.'),
(1, 't', 1513, 'Minimum number of employees', 'The minimum number of people employed.'),
(1, 't', 1514, 'Non-union employees', 'The number of employees not belonging to a labour union.'),
(1, 't', 1515, 'Floors', 'The number of floors in a building.'),
(1, 't', 1516, 'Nurses', 'The number of nurses.'),
(1, 't', 1517, 'Office workers', 'The number of workers in an office.'),
(1, 't', 1518, 'Other employees', 'The number of employees otherwise categorised.'),
(1, 't', 1519, 'Part time employees', 'The number of employees working on a part time basis.'),
(1, 't', 1520, 'Accounts payable average overdue days', 'The average number of days accounts payable are overdue.'),
(1, 't', 1521, 'Pilots', 'The number of pilots.'),
(1, 't', 1522, 'Plant workers', 'The number of workers within a plant.'),
(1, 't', 1523, 'Previous number of accounts', 'The number of accounts which preceded the current count.'),
(1, 't', 1524, 'Previous number of branch locations', 'The number of branch locations which preceded the current count.'),
(1, 't', 1525, 'Principals included as employees', 'The number of principals which are included in the count of employees.'),
(1, 't', 1526, 'Protested bills', 'The number of bills which are protested.'),
(1, 't', 1527, 'Registered brands distributed', 'The number of registered brands which are being distributed.'),
(1, 't', 1528, 'Registered brands manufactured', 'The number of registered brands which are being manufactured.'),
(1, 't', 1529, 'Related business entities', 'The number of related business entities.'),
(1, 't', 1530, 'Relatives employed', 'The number of relatives which are counted as employees.'),
(1, 't', 1531, 'Rooms',        'The number of rooms.'),
(1, 't', 1532, 'Salespersons', 'The number of salespersons.'),
(1, 't', 1533, 'Seats',        'The number of seats.'),
(1, 't', 1534, 'Shareholders', 'The number of shareholders.'),
(1, 't', 1535, 'Shares of common stock', 'The number of shares of common stock.'),
(1, 't', 1536, 'Shares of preferred stock', 'The number of shares of preferred stock.'),
(1, 't', 1537, 'Silent partners', 'The number of silent partners.'),
(1, 't', 1538, 'Subcontractors',  'The number of subcontractors.'),
(1, 't', 1539, 'Subsidiaries',    'The number of subsidiaries.'),
(1, 't', 1540, 'Law suits',       'The number of law suits.'),
(1, 't', 1541, 'Suppliers',       'The number of suppliers.'),
(1, 't', 1542, 'Teachers',        'The number of teachers.'),
(1, 't', 1543, 'Technicians',     'The number of technicians.'),
(1, 't', 1544, 'Trainees',        'The number of trainees.'),
(1, 't', 1545, 'Union employees', 'The number of employees who are members of a labour union.'),
(1, 't', 1546, 'Number of units', 'The quantity of units.'),
(1, 't', 1547, 'Warehouse employees', 'The number of employees who work in a warehouse setting.'),
(1, 't', 1548, 'Shareholders holding remainder of shares', 'Number of shareholders owning the remainder of shares.'),
(1, 't', 1549, 'Payment orders filed', 'Number of payment orders filed.'),
(1, 't', 1550, 'Uncovered cheques', 'Number of uncovered cheques.'),
(1, 't', 1551, 'Auctions', 'Number of auctions.'),
(1, 't', 1552, 'Units produced', 'The number of units produced.'),
(1, 't', 1553, 'Added employees', 'Number of employees that were added to the workforce.'),
(1, 't', 1554, 'Number of added locations', 'Number of locations that were added.'),
(1, 't', 1555, 'Total number of foreign subsidiaries not included in', 'financial statement The total number of foreign subsidiaries not included in the financial statement.'),
(1, 't', 1556, 'Number of closed locations', 'Number of locations that were closed.'),
(1, 't', 1557, 'Counter clerks', 'The number of clerks that work behind a flat-topped fitment.'),
(1, 't', 1558, 'Payment experiences in the last 3 months', 'The number of payment experiences received for an entity over the last 3 months.'),
(1, 't', 1559, 'Payment experiences in the last 12 months', 'The number of payment experiences received for an entity over the last 12 months.'),
(1, 't', 1560, 'Total number of subsidiaries not included in the financial', 'statement The total number of subsidiaries not included in the financial statement.'),
(1, 't', 1561, 'Paid-in common shares', 'The number of paid-in common shares.'),
(1, 't', 1562, 'Total number of domestic subsidiaries not included in', 'financial statement The total number of domestic subsidiaries not included in the financial statement.'),
(1, 't', 1563, 'Total number of foreign subsidiaries included in financial statement', 'The total number of foreign subsidiaries included in the financial statement.'),
(1, 't', 1564, 'Total number of domestic subsidiaries included in financial statement', 'The total number of domestic subsidiaries included in the financial statement.'),
(1, 't', 1565, 'Total transactions', 'The total number of transactions.'),
(1, 't', 1566, 'Paid-in preferred shares', 'The number of paid-in preferred shares.'),
(1, 't', 1567, 'Employees', 'Code specifying the quantity of persons working for a company, whose services are used for pay.'),
(1, 't', 1568, 'Active ingredient dose per unit, dispensed', 'The dosage of active ingredient per dispensed unit.'),
(1, 't', 1569, 'Budget', 'Budget quantity.'),
(1, 't', 1570, 'Budget, cumulative to date', 'Budget quantity, cumulative to date.'),
(1, 't', 1571, 'Actual units', 'The number of actual units.'),
(1, 't', 1572, 'Actual units, cumulative to date', 'The number of cumulative to date actual units.'),
(1, 't', 1573, 'Earned value', 'Earned value quantity.'),
(1, 't', 1574, 'Earned value, cumulative to date', 'Earned value quantity accumulated to date.'),
(1, 't', 1575, 'At completion quantity, estimated', 'The estimated quantity when a project is complete.'),
(1, 't', 1576, 'To complete quantity, estimated', 'The estimated quantity required to complete a project.'),
(1, 't', 1577, 'Adjusted units', 'The number of adjusted units.'),
(1, 't', 1578, 'Number of limited partnership shares', 'Number of shares held in a limited partnership.'),
(1, 't', 1579, 'National business failure incidences', 'Number of firms in a country that discontinued with a loss to creditors.'),
(1, 't', 1580, 'Industry business failure incidences', 'Number of firms in a specific industry that discontinued with a loss to creditors.'),
(1, 't', 1581, 'Business class failure incidences', 'Number of firms in a specific class that discontinued with a loss to creditors.'),
(1, 't', 1582, 'Mechanics', 'Number of mechanics.'),
(1, 't', 1583, 'Messengers', 'Number of messengers.'),
(1, 't', 1584, 'Primary managers', 'Number of primary managers.'),
(1, 't', 1585, 'Secretaries', 'Number of secretaries.'),
(1, 't', 1586, 'Detrimental legal filings', 'Number of detrimental legal filings.'),
(1, 't', 1587, 'Branch office locations, estimated', 'Estimated number of branch office locations.'),
(1, 't', 1588, 'Previous number of employees', 'The number of employees for a previous period.'),
(1, 't', 1589, 'Asset seizers', 'Number of entities that seize assets of another entity.'),
(1, 't', 1590, 'Out-turned quantity', 'The quantity discharged.'),
(1, 't', 1591, 'Material on-board quantity, prior to loading', 'The material in vessel tanks, void spaces, and pipelines prior to loading.'),
(1, 't', 1592, 'Supplier estimated previous meter reading', 'Previous meter reading estimated by the supplier.'),
(1, 't', 1593, 'Supplier estimated latest meter reading',   'Latest meter reading estimated by the supplier.'),
(1, 't', 1594, 'Customer estimated previous meter reading', 'Previous meter reading estimated by the customer.'),
(1, 't', 1595, 'Customer estimated latest meter reading',   'Latest meter reading estimated by the customer.'),
(1, 't', 1596, 'Supplier previous meter reading',           'Previous meter reading done by the supplier.'),
(1, 't', 1597, 'Supplier latest meter reading',             'Latest meter reading recorded by the supplier.'),
(1, 't', 1598, 'Maximum number of purchase orders allowed', 'Maximum number of purchase orders that are allowed.'),
(1, 't', 1599, 'File size before compression', 'The size of a file before compression.'),
(1, 't', 1600, 'File size after compression', 'The size of a file after compression.'),
(1, 't', 1601, 'Securities shares', 'Number of shares of securities.'),
(1, 't', 1602, 'Patients',         'Number of patients.'),
(1, 't', 1603, 'Completed projects', 'Number of completed projects.'),
(1, 't', 1604, 'Promoters',        'Number of entities who finance or organize an event or a production.'),
(1, 't', 1605, 'Administrators',   'Number of administrators.'),
(1, 't', 1606, 'Supervisors',      'Number of supervisors.'),
(1, 't', 1607, 'Professionals',    'Number of professionals.'),
(1, 't', 1608, 'Debt collectors',  'Number of debt collectors.'),
(1, 't', 1609, 'Inspectors',       'Number of individuals who perform inspections.'),
(1, 't', 1610, 'Operators',        'Number of operators.'),
(1, 't', 1611, 'Trainers',         'Number of trainers.'),
(1, 't', 1612, 'Active accounts',  'Number of accounts in a current or active status.'),
(1, 't', 1613, 'Trademarks used',  'Number of trademarks used.'),
(1, 't', 1614, 'Machines',         'Number of machines.'),
(1, 't', 1615, 'Fuel pumps',       'Number of fuel pumps.'),
(1, 't', 1616, 'Tables available', 'Number of tables available for use.'),
(1, 't', 1617, 'Directors',        'Number of directors.'),
(1, 't', 1618, 'Freelance debt collectors', 'Number of debt collectors who work on a freelance basis.'),
(1, 't', 1619, 'Freelance salespersons',    'Number of salespersons who work on a freelance basis.'),
(1, 't', 1620, 'Travelling employees',      'Number of travelling employees.'),
(1, 't', 1621, 'Foremen', 'Number of workers with limited supervisory responsibilities.'),
(1, 't', 1622, 'Production workers', 'Number of employees engaged in production.'),
(1, 't', 1623, 'Employees not including owners', 'Number of employees excluding business owners.'),
(1, 't', 1624, 'Beds', 'Number of beds.'),
(1, 't', 1625, 'Resting quantity', 'A quantity of product that is at rest before it can be used.'),
(1, 't', 1626, 'Production requirements', 'Quantity needed to meet production requirements.'),
(1, 't', 1627, 'Corrected quantity', 'The quantity has been corrected.'),
(1, 't', 1628, 'Operating divisions', 'Number of divisions operating.'),
(1, 't', 1629, 'Quantitative incentive scheme base', 'Quantity constituting the base for the quantitative incentive scheme.'),
(1, 't', 1630, 'Petitions filed', 'Number of petitions that have been filed.'),
(1, 't', 1631, 'Bankruptcy petitions filed', 'Number of bankruptcy petitions that have been filed.'),
(1, 't', 1632, 'Projects in process', 'Number of projects in process.'),
(1, 't', 1633, 'Changes in capital structure', 'Number of modifications made to the capital structure of an entity.'),
(1, 't', 1634, 'Detrimental legal filings against directors', 'The number of legal filings that are of a detrimental nature that have been filed against the directors.'),
(1, 't', 1635, 'Number of failed businesses of directors', 'The number of failed businesses with which the directors have been associated.'),
(1, 't', 1636, 'Professor', 'The number of professors.'),
(1, 't', 1637, 'Seller',    'The number of sellers.'),
(1, 't', 1638, 'Skilled worker', 'The number of skilled workers.'),
(1, 't', 1639, 'Trademark represented', 'The number of trademarks represented.'),
(1, 't', 1640, 'Number of quantitative incentive scheme units', 'Number of units allocated to a quantitative incentive scheme.'),
(1, 't', 1641, 'Quantity in manufacturing process', 'Quantity currently in the manufacturing process.'),
(1, 't', 1642, 'Number of units in the width of a layer', 'Number of units which make up the width of a layer.'),
(1, 't', 1643, 'Number of units in the depth of a layer', 'Number of units which make up the depth of a layer.'),
(1, 't', 1644, 'Return to warehouse', 'A quantity of products sent back to the warehouse.'),
(1, 't', 1645, 'Return to the manufacturer', 'A quantity of products sent back from the manufacturer.'),
(1, 't', 1646, 'Delta quantity', 'An increment or decrement to a quantity.'),
(1, 't', 1647, 'Quantity moved between outlets', 'A quantity of products moved between outlets.'),
(1, 't', 1648, 'Pre-paid invoice annual consumption, estimated', 'The estimated annual consumption used for a prepayment invoice.'),
(1, 't', 1649, 'Total quoted quantity', 'The sum of quoted quantities.'),
(1, 't', 1650, 'Requests pertaining to entity in last 12 months', 'Number of requests received in last 12 months pertaining to the entity.'),
(1, 't', 1651, 'Total inquiry matches', 'Number of instances which correspond with the inquiry.'),
(1, 't', 1652, 'En route to warehouse quantity',   'A quantity of products that is en route to a warehouse.'),
(1, 't', 1653, 'En route from warehouse quantity', 'A quantity of products that is en route from a warehouse.'),
(1, 't', 1654, 'Quantity ordered but not yet allocated from stock', 'A quantity of products which has been ordered but which has not yet been allocated from stock.'),
(1, 't', 1655, 'Not yet ordered quantity', 'The quantity which has not yet been ordered.'),
(1, 't', 1656, 'Net reserve power', 'The reserve power available for the net.'),
(1, 't', 1657, 'Maximum number of units per shelf', 'Maximum number of units of a product that can be placed on a shelf.'),
(1, 't', 1658, 'Stowaway', 'Number of stowaway(s) on a conveyance.'),
(1, 't', 1659, 'Tug', 'The number of tugboat(s).'),
(1, 't', 1660, 'Maximum quantity capability of the package', 'Maximum quantity of a product that can be contained in a package.'),
(1, 't', 1661, 'Calculated', 'The calculated quantity.'),
(1, 't', 1662, 'Monthly volume, estimated', 'Volume estimated for a month.'),
(1, 't', 1663, 'Total number of persons', 'Quantity representing the total number of persons.'),
(1, 't', 1664, 'Tariff Quantity', 'Quantity of the goods in the unit as required by Customs for duty/tax/fee assessment. These quantities may also be used for other fiscal or statistical purposes.'),
(1, 't', 1665, 'Deducted tariff quantity',   'Quantity deducted from tariff quantity to reckon duty/tax/fee assessment bases.'),
(1, 't', 1666, 'Advised but not arrived',    'Goods are advised by the consignor or supplier, but have not yet arrived at the destination.'),
(1, 't', 1667, 'Received but not available', 'Goods have been received in the arrival area but are not yet available.'),
(1, 't', 1668, 'Goods blocked for transshipment process', 'Goods are physically present, but can not be ordered because they are scheduled for a transshipment process.'),
(1, 't', 1669, 'Goods blocked for cross docking process', 'Goods are physically present, but can not be ordered because they are scheduled for a cross docking process.'),
(1, 't', 1670, 'Chargeable number of trailers', 'The number of trailers on which charges are based.'),
(1, 't', 1671, 'Number of packages for a set', 'Number of packages used to pack the individual items in a grouping of merchandise that is sold together as a single trade item.'),
(1, 't', 1672, 'Number of items in a set', 'The number of individual items in a grouping of merchandise that is sold together as a single trade item.'),
(1, 't', 1673, 'Order sizing factor', 'A trade item specification other than gross, net weight, or volume for a trade item or a transaction, used for order sizing and pricing purposes.'),
(1, 't', 1674, 'Number of different next lower level trade items', 'Value indicates the number of differrent next lower level trade items contained in a complex trade item.'),
(1, 't', 1675, 'Agreed maximum buying quantity', 'The agreed maximum quantity of the trade item that may be purchased.'),
(1, 't', 1676, 'Agreed minimum buying quantity', 'The agreed minimum quantity of the trade item that may be purchased.'),
(1, 't', 1677, 'Free quantity of next lower level trade item', 'The numeric quantity of free items in a combination pack. The unit of measure used for the free quantity of the next lower level must be the same as the unit of measure of the Net Content of the Child Trade Item.'),
(1, 't', 1678, 'Marine Diesel Oil bunkers on board, on arrival',     'Number of Marine Diesel Oil (MDO) bunkers on board when the vessel arrives in the port.'),
(1, 't', 1679, 'Marine Diesel Oil bunkers, loaded',                  'Number of Marine Diesel Oil (MDO) bunkers taken on in the port.'),
(1, 't', 1680, 'Intermediate Fuel Oil bunkers on board, on arrival', 'Number of Intermediate Fuel Oil (IFO) bunkers on board when the vessel arrives in the port.'),
(1, 't', 1681, 'Intermediate Fuel Oil bunkers, loaded',              'Number of Intermediate Fuel Oil (IFO) bunkers taken on in the port.'),
(1, 't', 1682, 'Bunker C bunkers on board, on arrival',              'Number of Bunker C, or Number 6 fuel oil bunkers on board when the vessel arrives in the port.'),
(1, 't', 1683, 'Bunker C bunkers, loaded', 'Number of Bunker C, or Number 6 fuel oil bunkers, taken on in the port.'),
(1, 't', 1684, 'Number of individual units within the smallest packaging', 'unit Total number of individual units contained within the smallest unit of packaging.'),
(1, 't', 1685, 'Percentage of constituent element', 'The part of a product or material that is composed of the constituent element, as a percentage.'),
(1, 't', 1686, 'Quantity to be decremented (LPCO)', 'Quantity to be decremented from the allowable quantity on a License, Permit, Certificate, or Other document (LPCO).'),
(1, 't', 1687, 'Regulated commodity count', 'The number of regulated items.'),
(1, 't', 1688, 'Number of passengers, embarking', 'The number of passengers going aboard a conveyance.'),
(1, 't', 1689, 'Number of passengers, disembarking', 'The number of passengers disembarking the conveyance.'),
(1, 't', 1690, 'Constituent element or component quantity', 'The specific quantity of the identified constituent element.')
;
-- ZZZ, 'Mutually defined', 'As agreed by the trading partners.'),

COMMIT;
