dump('Loading constants.js\n');

/* to override these locally (with remote xul), create a server/skin/custom.js file containing lines like

    urls['AUDIO_good'] = '/xul/server/skin/media/custom/good.wav';

    urls['opac'] = 'oils://remote/opac/' + LOCALE + '/skin/mylib/xml/advanced.xml?nps=1';
    urls['opac_rdetail'] = 'oils://remote/opac/' + LOCALE + '/skin/mylib/xml/rdetail.xml';
    urls['opac_rresult'] = 'oils://remote/opac/' + LOCALE + '/skin/mylib/xml/rresult.xml';
    urls['browser'] = 'oils://remote/opac/' + LOCALE + '/skin/mylib/xml/advanced.xml?nps=1';

*/

/* Get locale from preferences */
var LOCALE = '';
var pref = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
try {
    LOCALE = pref.getCharPref('general.useragent.locale');
} catch (E) {
    dump("Failed to fetch a locale from preferences: " + E + "\n");
}

/* Fall back to en-US if we didn't get a locale from the preferences */
if (!LOCALE) {
    LOCALE = 'en-US';
}

const MODE_RDONLY   = 0x01;
const MODE_WRONLY   = 0x02;
const MODE_CREATE   = 0x08;
const MODE_APPEND   = 0x10;
const MODE_TRUNCATE = 0x20;
const MODE_SYNC     = 0x40;
const MODE_EXCL     = 0x80;
const PERMS_FILE      = 0644;
const PERMS_DIR      = 0755;

const CLIENT_VERSION = '';
const CLIENT_STAMP   = '';

var my_constants = {
    'magical_statuses' : {
        '1' : { 'disable_in_copy_editor' : true, 'block_mark_item_damaged' : false, 'block_mark_item_action' : true }, /* | Checked out    | t */
        '3' : { 'disable_in_copy_editor' : true, 'block_mark_item_damaged' : false, 'block_mark_item_action' : true }, /* | Lost           | f */
        '6' : { 'disable_in_copy_editor' : true, 'block_mark_item_damaged' : false, 'block_mark_item_action' : true }, /* | In transit     | t */
        '8' : { 'disable_in_copy_editor' : true, 'block_mark_item_damaged' : false, 'block_mark_item_action' : false }, /* | On holds shelf | t */
        '16' : { 'disable_in_copy_editor' : true, 'block_mark_item_damaged' : false, 'block_mark_item_action' : true }, /* | Long Overdue  | f */
        '18' : { 'disable_in_copy_editor' : true, 'block_mark_item_damaged' : false, 'block_mark_item_action' : false} /* | Canceled Transit | t */
    }
}

var api = {
    'PCRUD_XACT_BEGIN' : { 'app' : 'open-ils.pcrud', 'method' : 'open-ils.pcrud.transaction.begin' },
    'PCRUD_XACT_COMMIT' : { 'app' : 'open-ils.pcrud', 'method' : 'open-ils.pcrud.transaction.commit' },
    'PCRUD_XACT_ROLLBACK' : { 'app' : 'open-ils.pcrud', 'method' : 'open-ils.pcrud.transaction.rollback' },
    'TEST_SECURE' : { 'app' : 'open-ils.actor', 'method' : 'opensrf.system.time' },
    'TEST_UNSECURE' : { 'app' : 'open-ils.actor', 'method' : 'opensrf.system.time', 'secure' : false },
    'AUTH_INIT' : { 'app' : 'open-ils.auth', 'method' : 'open-ils.auth.authenticate.init' },
    'AUTH_COMPLETE' : { 'app' : 'open-ils.auth', 'method' : 'open-ils.auth.authenticate.complete' },
    'AUTH_DELETE' : { 'app' : 'open-ils.auth', 'method' : 'open-ils.auth.session.delete' },
    'AUTH_PROXY_ENABLED' : { 'app' : 'open-ils.auth_proxy', 'method' : 'open-ils.auth_proxy.enabled' },
    'AUTH_PROXY_LOGIN' : { 'app' : 'open-ils.auth_proxy', 'method' : 'open-ils.auth_proxy.login' },
    'AUTH_WORKSTATION' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.workstation.register' },
    'AUTH_VERIFY_CREDENTIALS' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.verify_user_password' },
    'AUTOGENERATE_BARCODES' : { 'app' : 'open-ils.cat', 'method' : 'open-ils.cat.item.barcode.autogen' },
    'BILL_PAY' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.money.payment' },
    'BLOB_AU_PARTS_RETRIEVE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.retrieve.parts', 'cacheable' : true, 'ttl' : 120000 },
    'BLOB_MARC_CALLNUMBERS_RETRIEVE' : { 'app' : 'open-ils.cat', 'method' : 'open-ils.cat.biblio.record.marc_cn.retrieve', 'secure' : false },
    'BLOB_MBTS_DETAILS_RETRIEVE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.transaction.fleshed.retrieve.authoritative', 'secure' : false },
    'BLOB_MOBTS_CIRC_MVR_HAVING_BALANCE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.transactions.have_balance.fleshed' },
    'BLOB_MOBTS_CIRC_MVR_OPEN' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.transactions.fleshed' },
    'BLOB_BALANCE_OWED_VIA_USERGROUP' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.usergroup.members.balance_owed.authoritative' },
    'BUCKET_CREATE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.container.create' },
    'BUCKET_FLESH' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.container.flesh.authoritative' },
    'BUCKET_DELETE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.container.full_delete' },
    'BUCKET_RETRIEVE_VIA_USER' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.container.all.retrieve_by_user.authoritative' },
    'BUCKET_ITEM_CREATE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.container.item.create' },
    'BUCKET_ITEM_DELETE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.container.item.delete' },
    'CAPTURE_COPY_FOR_HOLD_VIA_BARCODE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.hold.capture_copy.barcode' },
    'CHECKIN_VIA_BARCODE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.checkin' },
    'CHECKOUT' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.checkout' },
    'CHECKOUT_FULL' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.checkout.full' },
    'CHECKOUT_PERMIT' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.checkout.permit' },
    'CHECKOUT_RENEW' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.renew' },
    'CIRC_MODIFIER_LIST' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.circ_modifier.retrieve.all' },
    'CLEAR_HOLD_SHELF' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.hold.clear_shelf.process', 'secure' : false },
    'FM_ACN_RETRIEVE' : { 'app' : 'open-ils.search', 'method' : 'open-ils.search.callnumber.fleshed.retrieve', 'secure' : false },
    'FM_ACN_RETRIEVE.authoritative' : { 'app' : 'open-ils.search', 'method' : 'open-ils.search.callnumber.fleshed.retrieve.authoritative', 'secure' : false },
    'FM_ACN_TREE_UPDATE' : { 'app' : 'open-ils.cat', 'method' : 'open-ils.cat.asset.volume.fleshed.batch.update' },
    'FM_ACN_TREE_LIST_RETRIEVE_VIA_RECORD_ID_AND_ORG_IDS' : { 'app' : 'open-ils.cat', 'method' : 'open-ils.cat.asset.copy_tree.retrieve', 'secure' : false },
    'FM_ACN_TREE_LIST_RETRIEVE_VIA_RECORD_ID_AND_ORG_IDS.authoritative' : { 'app' : 'open-ils.cat', 'method' : 'open-ils.cat.asset.copy_tree.retrieve.authoritative', 'secure' : false },
    'FM_ACN_TRANSFER' : { 'app' : 'open-ils.cat', 'method' : 'open-ils.cat.asset.volume.batch.transfer' },
    'FM_ACN_FIND_OR_CREATE' : { 'app' : 'open-ils.cat', 'method' : 'open-ils.cat.call_number.find_or_create' },
    'FM_ACNC_RETRIEVE_VIA_PCRUD' : { 'app' : 'open-ils.pcrud', 'method' : 'open-ils.pcrud.search.acnc.atomic' },
    'FM_ACNP_RETRIEVE_VIA_PCRUD' : { 'app' : 'open-ils.pcrud', 'method' : 'open-ils.pcrud.search.acnp.atomic' },
    'FM_ACNS_RETRIEVE_VIA_PCRUD' : { 'app' : 'open-ils.pcrud', 'method' : 'open-ils.pcrud.search.acns.atomic' },
    'FM_ATB_RETRIEVE_VIA_PCRUD' : { 'app' : 'open-ils.pcrud', 'method' : 'open-ils.pcrud.search.atb.atomic' },
    'FM_ACP_DETAILS' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.copy_details.retrieve' },
    'FM_ACP_DETAILS_VIA_BARCODE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.copy_details.retrieve.barcode' },
    'FM_ACP_DETAILS_VIA_BARCODE.authoritative' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.copy_details.retrieve.barcode.authoritative' },
    //'FM_ACP_RETRIEVE' : { 'app' : 'open-ils.search', 'method' : 'open-ils.search.asset.copy.fleshed.retrieve' },
    'FM_ACP_RETRIEVE' : { 'app' : 'open-ils.search', 'method' : 'open-ils.search.asset.copy.fleshed2.retrieve', 'secure' : false },
    //'FM_ACP_RETRIEVE_VIA_BARCODE' : { 'app' : 'open-ils.search', 'method' : 'open-ils.search.asset.copy.find_by_barcode' },
    'FM_ACP_RETRIEVE_VIA_BARCODE' : { 'app' : 'open-ils.search', 'method' : 'open-ils.search.asset.copy.fleshed2.find_by_barcode', 'secure' : false },
    'FM_ACP_RETRIEVE_VIA_BARCODE.authoritative' : { 'app' : 'open-ils.search', 'method' : 'open-ils.search.asset.copy.fleshed2.find_by_barcode.authoritative', 'secure' : false },
    'FM_ACP_FLESHED_BATCH_RETRIEVE' : { 'app' : 'open-ils.search', 'method' : 'open-ils.search.asset.copy.fleshed.batch.retrieve', 'secure' : false },
    'FM_ACP_UNFLESHED_BATCH_RETRIEVE' : { 'app' : 'open-ils.search', 'method' : 'open-ils.search.asset.copy.batch.retrieve', 'secure' : false },
    'FM_ACP_FLESHED_BATCH_RETRIEVE.authoritative' : { 'app' : 'open-ils.search', 'method' : 'open-ils.search.asset.copy.fleshed.batch.retrieve.authoritative', 'secure' : false },
    'FM_ACP_FLESHED_BATCH_UPDATE' : { 'app' : 'open-ils.cat', 'method' : 'open-ils.cat.asset.copy.fleshed.batch.update' },
    'FM_ACP_TRANSFER_COPIES_BATCH' : { 'app' : 'open-ils.cat', 'method' : 'open-ils.cat.transfer_copies_to_volume' },
    'FM_ACP_COUNT' : { 'app' : 'open-ils.search', 'method' : 'open-ils.search.biblio.record.copy_count.staff', 'secure' : false },
    'FM_ACP_COUNT.authoritative' : { 'app' : 'open-ils.search', 'method' : 'open-ils.search.biblio.record.copy_count.staff.authoritative', 'secure' : false },
    'FM_ACPL_RETRIEVE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.copy_location.retrieve.all', 'secure' : false },
    'FM_ACPL_RETRIEVE_VIA_ID' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.copy_location.retrieve', 'secure' : false },
    'FM_ACPL_RETRIEVE_VIA_ID.authoritative' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.copy_location.retrieve.authoritative', 'secure' : false },
    'FM_ACPN_RETRIEVE_ALL' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.copy_note.retrieve.all.authoritative', 'secure' : false },
    'FM_ACPN_CREATE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.copy_note.create' },
    'FM_ACPN_DELETE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.copy_note.delete', 'secure' : false },
    'FM_ACTSC_RETRIEVE_BATCH' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.stat_cat.actor.retrieve.batch', 'secure' : false },
    'FM_ACTSC_RETRIEVE_VIA_AOU' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.stat_cat.actor.retrieve.all', 'secure' : false },
    'FM_ACTSC_RETRIEVE_VIA_PCRUD' : { 'app' : 'open-ils.pcrud', 'method' : 'open-ils.pcrud.search.actsc.atomic', 'secure' : false },
    'FM_AHRN_CREATE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.hold_note.create' },
    'FM_AHN_CREATE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.hold_notification.create' },
    'FM_AHN_RETRIEVE_VIA_AHR' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.hold_notification.retrieve_by_hold' },
    'FM_AHN_RETRIEVE_VIA_AHR.authoritative' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.hold_notification.retrieve_by_hold.authoritative' },
    'FM_AHR_CHECK_AND_CREATE.batch' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.holds.test_and_create.batch' },
    'FM_AHR_CHECK_AND_CREATE.batch.override' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.holds.test_and_create.batch.override' },
    'FM_AHR_RETRIEVE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.holds.retrieve_by_id' },
    'FM_AHR_BLOB_RETRIEVE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.hold.details.retrieve' },
    'FM_AHR_BLOB_RETRIEVE.authoritative' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.hold.details.retrieve.authoritative' },
    'FM_AHR_RETRIEVE_VIA_AU' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.holds.retrieve' },
    'FM_AHR_ID_LIST_RETRIEVE_VIA_AU' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.holds.id_list.retrieve' },
    'FM_AHR_ID_LIST_RETRIEVE_VIA_AU.authoritative' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.holds.id_list.retrieve.authoritative' },
    'FM_AHR_CANCELLED_ID_LIST_RETRIEVE_VIA_AU' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.holds.canceled.id_list.retrieve' },
    'FM_AHR_CANCELLED_ID_LIST_RETRIEVE_VIA_AU.authoritative' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.holds.canceled.id_list.retrieve.authoritative' },
    'FM_AHR_RETRIEVE_VIA_BRE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.open_holds.retrieve' },
    'FM_AHR_RETRIEVE_ALL_VIA_BRE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.holds.retrieve_all_from_title' },
    'FM_AHR_RETRIEVE_VIA_PICKUP_AOU' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.holds.retrieve_by_pickup_lib' },
    'FM_AHR_ID_LIST_RETRIEVE_VIA_PICKUP_AOU' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.holds.id_list.retrieve_by_pickup_lib' },
    'FM_AHR_PULL_LIST' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.hold_pull_list.retrieve' },
    'FM_AHR_PULL_LIST_COUNT' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.hold_pull_list.retrieve.count' },
    'FM_AHR_ID_LIST_PULL_LIST' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.hold_pull_list.id_list.retrieve', 'secure' : false },
    'HTML_HOLD_PULL_LIST' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.hold_pull_list.print' },
    'FM_AHR_ONSHELF_RETRIEVE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.captured_holds.on_shelf.retrieve' },
    'FM_AHR_ID_LIST_ONSHELF_RETRIEVE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.captured_holds.id_list.on_shelf.retrieve.authoritative', 'secure' : false },
    'FM_AHR_ID_LIST_EXPIRED_ONSHELF_RETRIEVE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.captured_holds.id_list.expired_on_shelf_or_wrong_shelf.retrieve', 'secure' : false },
    'FM_AHR_COUNT_FOR_BRE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.bre.holds.count', 'secure' : false },
    'FM_AHR_COUNT_RETRIEVE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.hold_requests.count', 'cacheable' : true, 'ttl' : 60000  },
    'FM_AHR_COUNT_RETRIEVE.authoritative' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.hold_requests.count.authoritative', 'cacheable' : true, 'ttl' : 60000  },
    'FM_AHR_CANCEL' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.hold.cancel' },
    'FM_AHR_UNCANCEL' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.hold.uncancel' },
    'FM_AHR_UPDATE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.hold.update' },
    'FM_AHR_UPDATE_BATCH' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.hold.update.batch' },
    'FM_AHR_RESET' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.hold.reset' },
    'FM_AHR_STATUS' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.hold.status.retrieve' },
    'TRANSFER_TITLE_HOLDS' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.hold.change_title' },
    'TRANSFER_SPECIFIC_TITLE_HOLDS' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.hold.change_title.specific_holds' },
    'FM_AHRCC_PCRUD_SEARCH' : { 'app' : 'open-ils.pcrud', 'method' : 'open-ils.pcrud.search.ahrcc.atomic', 'secure' : false },
    'FM_AIHU_CREATE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.in_house_use.create' },
    'FM_ANCC_RETRIEVE_VIA_ID' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.non_cataloged_circulation.retrieve' },
    'FM_ANCC_RETRIEVE_VIA_USER' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.open_non_cataloged_circulation.user' },
    'FM_ANCC_RETRIEVE_VIA_USER.authoritative' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.open_non_cataloged_circulation.user.authoritative' },
    'FM_ANCIHU_CREATE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.non_cat_in_house_use.create' },
    'FM_AOA_RETRIEVE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.org_unit.address.retrieve', 'secure' : false },
    'FM_AOU_RETRIEVE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.org_tree.retrieve', 'secure' : false },
    'FM_AOU_DESCENDANTS_RETRIEVE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.org_tree.descendants.retrieve', 'secure' : false },
    'FM_AOU_RETRIEVE_RELATED_VIA_SESSION' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.org_unit.full_path.retrieve' },
    'FM_AOU_IDS_RETRIEVE_VIA_RECORD_ID' : { 'app' : 'open-ils.cat', 'method' : 'open-ils.cat.actor.org_unit.retrieve_by_title', 'secure' : false },
    'FM_AOU_IDS_RETRIEVE_VIA_RECORD_ID.authoritative' : { 'app' : 'open-ils.cat', 'method' : 'open-ils.cat.actor.org_unit.retrieve_by_title.authoritative', 'secure' : false },
    'FM_AOUS_RETRIEVE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.org_unit_setting.values.ranged.retrieve' },
    'FM_AOUS_SPECIFIC_RETRIEVE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.ou_setting.ancestor_default' },
    'FM_AOUS_UPDATE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.org_unit.settings.update' },
    'FM_AOUT_RETRIEVE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.org_types.retrieve', 'secure' : false },
    'FM_ASC_BATCH_RETRIEVE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.stat_cat.asset.retrieve.batch', 'secure' : false },
    'FM_ASC_RETRIEVE_VIA_AOU' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.stat_cat.asset.retrieve.all', 'secure' : false },
    'FM_ASV_CREATE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.survey.create' },
    'FM_ASV_RETRIEVE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.survey.retrieve.all', 'secure' : false },
    'FM_ASV_RETRIEVE_REQUIRED' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.survey.retrieve.required' },
    'FM_ASVR_RETRIEVE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.survey.response.retrieve' },
    'FM_ATC_VOID' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.transit.abort' },
    'FM_ATC_RETRIEVE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.transit.retrieve', 'secure' : false },
    'FM_ATC_RETRIEVE_VIA_AOU' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.transit.retrieve_by_lib', 'secure' : false },
    'FM_ATEV_APROPOS_AHR' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.events.ahr', 'secure' : true },
    'FM_ATEV_APROPOS_CIRC' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.events.circ', 'secure' : true },
    'FM_ATEV_APROPOS_AHR_VIA_COPY' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.copy.events.ahr', 'secure' : true },
    'FM_ATEV_APROPOS_CIRC_VIA_COPY' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.copy.events.circ', 'secure' : true },
    'FM_ATEV_CANCEL' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.event.cancel.batch', 'secure' : false },
    'FM_ATEV_RESET' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.event.reset.batch', 'secure' : false },
    'FM_AU_BLOBS_WITH_NEGATIVE_BALANCE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.users.negative_balance' },
    'FM_AU_ID_RETRIEVE_VIA_BARCODE_OR_USERNAME' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.retrieve_id_by_barcode_or_username' },
    'FM_AU_IDS_RETRIEVE_VIA_HASH' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.patron.search.advanced' },
    'FM_AU_LIST_RETRIEVE_VIA_GROUP' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.usergroup.members.retrieve' },
    'FM_AU_LIST_RETRIEVE_VIA_GROUP.authoritative' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.usergroup.members.retrieve.authoritative' },
    'FM_AU_RETRIEVE_VIA_SESSION' : { 'app' : 'open-ils.auth', 'method' : 'open-ils.auth.session.retrieve' },
    'FM_AU_RETRIEVE_VIA_BARCODE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.fleshed.retrieve_by_barcode', 'cacheable' : true, 'ttl' : 60000 },
    'FM_AU_RETRIEVE_VIA_BARCODE.authoritative' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.fleshed.retrieve_by_barcode.authoritative', 'cacheable' : true, 'ttl' : 60000 },
    'FM_AU_RETRIEVE_VIA_ID' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.retrieve', 'cacheable' : true, 'ttl' : 60000 },
    'FM_AU_RETRIEVE_VIA_ID.authoritative' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.retrieve.authoritative', 'cacheable' : true, 'ttl' : 60000 },
    'FM_AU_FLESHED_RETRIEVE_VIA_ID' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.fleshed.retrieve', 'cacheable' : true, 'ttl' : 60000 },
    'FM_AU_FLESHED_RETRIEVE_VIA_ID.authoritative' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.fleshed.retrieve.authoritative', 'cacheable' : true, 'ttl' : 60000 },
    'FM_AU_MERGE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.merge' },
    'FM_AU_NEW_USERGROUP' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.usergroup.new' },
    'FM_AU_UPDATE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.patron.update' },
    'FM_AU_DELETE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.delete' },
    'FM_AUN_RETRIEVE_ALL' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.note.retrieve.all', 'cacheable' : false, 'ttl' : 60000 },
    'FM_AUN_RETRIEVE_ALL.authoritative' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.note.retrieve.all.authoritative', 'cacheable' : false, 'ttl' : 60000 },
    'FM_AUN_CREATE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.note.create' },
    'FM_AUN_DELETE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.note.delete' },
    'FM_AUS_RETRIEVE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.patron.settings.retrieve' },
    'FM_AUS_UPDATE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.patron.settings.update' },
    'FM_AUSP_APPLY' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.note.apply' },
    'FM_AUSP_REMOVE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.note.remove' },
    'FM_AUSP_PCRUD_UPDATE' : { 'app' : 'open-ils.pcrud', 'method' : 'open-ils.pcrud.update.ausp', 'secure' : false },
    'FM_AUSP_UPDATE_NOTE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.note.note.update' },
    'FM_BOOKING_CREATE_BRT_AND_BRSRC' : { 'app' : 'open-ils.booking', 'method' : 'open-ils.booking.create_brt_and_brsrc_from_copies' },
    'FM_BPT_PCRUD_SEARCH' : { 'app' : 'open-ils.pcrud', 'method' : 'open-ils.pcrud.search.bpt.atomic', 'secure' : false },
    'FM_BRESV_RETRIEVE_VIA_PCRUD' : { 'app' : 'open-ils.pcrud', 'method' : 'open-ils.pcrud.search.bresv.atomic' },
    'FM_BRSRC_RETRIEVE_VIA_PCRUD' : { 'app' : 'open-ils.pcrud', 'method' : 'open-ils.pcrud.search.brsrc.atomic' },
    'FM_BRT_RETRIEVE_VIA_PCRUD' : { 'app' : 'open-ils.pcrud', 'method' : 'open-ils.pcrud.search.brt.atomic' },
    'FM_BRE_RETRIEVE_VIA_ID' : { 'app' : 'open-ils.cat', 'method' : 'open-ils.cat.biblio.record.metadata.retrieve', 'secure' : false },
    'FM_BRE_RETRIEVE_VIA_ID.authoritative' : { 'app' : 'open-ils.cat', 'method' : 'open-ils.cat.biblio.record.metadata.retrieve.authoritative', 'secure' : false },
    'FM_BRE_ID_VIA_BARCODE' : { 'app' : 'open-ils.search', 'method' : 'open-ils.search.bib_id.by_barcode', 'secure' : false },
    'FM_BRE_ID_SEARCH_VIA_BARCODE' : { 'app' : 'open-ils.search', 'method' : 'open-ils.search.biblio.find_by_barcode', 'secure' : false },
    'FM_BRE_ID_SEARCH_VIA_MULTICLASS_QUERY' : { 'app' : 'open-ils.search', 'method' : 'open-ils.search.biblio.multiclass.query.staff' },
    'FM_BRE_ID_SEARCH_VIA_TCN' : { 'app' : 'open-ils.search', 'method' : 'open-ils.search.biblio.tcn', 'secure' : false },
    'FM_BRE_DELETE' : { 'app' : 'open-ils.cat', 'method' : 'open-ils.cat.biblio.record_entry.delete', 'secure' : false },
    'FM_BRE_UNDELETE' : { 'app' : 'open-ils.cat', 'method' : 'open-ils.cat.biblio.record_entry.undelete', 'secure' : false },
    'FM_BRN_FROM_MARCXML' : { 'app' : 'open-ils.search', 'method' : 'open-ils.search.z3950.marcxml_to_brn', 'secure' : false },
    'FM_CBC_PCRUD_SEARCH' : { 'app' : 'open-ils.pcrud', 'method' : 'open-ils.pcrud.search.cbc.atomic', 'secure' : false },
    'FM_CBS_RETRIEVE_VIA_PCRUD' : { 'app' : 'open-ils.pcrud', 'method' : 'open-ils.pcrud.retrieve.cbs' },
    'FM_CBT_RETRIEVE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.billing_type.ranged.retrieve.all', 'secure' : false },
    'FM_CCS_RETRIEVE' : { 'app' : 'open-ils.search', 'method' : 'open-ils.search.config.copy_status.retrieve.all', 'secure' : false },
    'FM_CIRC_AGE_TO_LOST' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.circulation.age_to_lost' },
    'FM_CIRC_CHAIN' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.renewal_chain.retrieve_by_circ.atomic' },
    'FM_CIRC_CHAIN_SUMMARY' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.renewal_chain.retrieve_by_circ.summary' },
    'FM_CIRC_PREV_CHAIN' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.prev_renewal_chain.retrieve_by_circ.atomic' },
    'FM_CIRC_PREV_CHAIN_SUMMARY' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.prev_renewal_chain.retrieve_by_circ.summary' },
    'FM_CIRC_DETAILS' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.fleshed.retrieve' },
    'FM_CIRC_DETAILS.authoritative' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.fleshed.retrieve.authoritative' },
    'FM_CIRC_RETRIEVE_VIA_ID' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.retrieve' },
    /*'FM_CIRC_RETRIEVE_VIA_USER' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.actor.user.checked_out.slim' },*/
    'FM_CIRC_IN_WITH_FINES_VIA_USER' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.checked_in_with_fines' },
    'FM_CIRC_IN_WITH_FINES_VIA_USER.authoritative' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.checked_in_with_fines.authoritative' },
    'FM_CIRC_RETRIEVE_VIA_USER' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.checked_out' },
    'FM_CIRC_RETRIEVE_VIA_USER.authoritative' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.checked_out.authoritative' },
    'FM_CIRC_RETRIEVE_VIA_COPY' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.copy_checkout_history.retrieve' },
    /*'FM_CIRC_COUNT_RETRIEVE_VIA_USER' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.checked_out.count' },*/
    'FM_CIRC_HAS_HOLDS_COUNT_RETRIEVE_VIA_COPY' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.copy.has_holds_count', 'secure' : true },
    'FM_CIRC_COUNT_RETRIEVE_VIA_USER' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.checked_out.count', 'cacheable' : true, 'ttl' : 60000 },
    'FM_CIRC_COUNT_RETRIEVE_VIA_USER.authoritative' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.checked_out.count.authoritative', 'cacheable' : true, 'ttl' : 60000 },
    'FM_CIRC_COUNT_RETRIEVE_VIA_COPY' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.circulation.count' },
    'FM_CIRC_IMPROVED_COUNT_VIA_COPY' : { 'app' : 'open-ils.pcrud', 'method' : 'open-ils.pcrud.search.circbyyr.atomic' },
    'FM_CIRC_EDIT_DUE_DATE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.circulation.due_date.update' },
    'FM_CIRC_BACKDATE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.post_checkin_backdate' },
    'FM_CIRC_BACKDATE_BATCH' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.post_checkin_backdate.batch' },
    'FM_CIT_RETRIEVE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.ident_types.retrieve', 'secure' : false },
    'FM_CITM_RETRIEVE' : { 'app' : 'open-ils.fielder', 'method' : 'open-ils.fielder.ccvm.atomic', 'secure' : false },
    'FM_CNAL_RETRIEVE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.net_access_level.retrieve.all', 'secure' : false },
    'FM_CNCT_RETRIEVE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.non_cat_types.retrieve.all', 'secure' : false },
    'FM_CRAHP_RETRIEVE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.config.rules.age_hold_protect.retrieve.all', 'secure' : false },
    'FM_CFG_RETRIEVE_VIA_PCRUD' : { 'app' : 'open-ils.pcrud', 'method' : 'open-ils.pcrud.search.cfg.atomic', 'secure' : false },
    'FM_CSC_RETRIEVE_VIA_PCRUD' : { 'app' : 'open-ils.pcrud', 'method' : 'open-ils.pcrud.search.csc.atomic' },
    'FM_CSP_PCRUD_SEARCH' : { 'app' : 'open-ils.pcrud', 'method' : 'open-ils.pcrud.search.csp.atomic', 'secure' : false },
    'FM_CST_RETRIEVE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.standings.retrieve', 'secure' : false },
    'FM_MB_CREATE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.money.billing.create' },
    'FM_MB_RETRIEVE_VIA_MBTS_ID' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.money.billing.retrieve.all' },
    'FM_MB_RETRIEVE_VIA_MBTS_ID.authoritative' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.money.billing.retrieve.all.authoritative' },
    'FM_MB_VOID' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.money.billing.void' },
    'FM_MB_NOTE_EDIT' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.money.billing.note.edit' },
    'FM_MBTS_RETRIEVE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.money.billable_xact_summary.retrieve' },
    'FM_MBTS_RETRIEVE.authoritative' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.money.billable_xact_summary.retrieve.authoritative' },
    'FM_MBTS_IDS_RETRIEVE_ALL' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.transactions.history.ids' },
    'FM_MBTS_IDS_RETRIEVE_ALL_HAVING_CHARGE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.transactions.history.have_charge.ids' },
    'FM_MBTS_IDS_RETRIEVE_ALL_HAVING_BALANCE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.transactions.history.have_balance.ids' },
    'FM_MBTS_IDS_RETRIEVE_ALL_HAVING_BALANCE.authoritative' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.transactions.history.have_balance.ids.authoritative' },
    'FM_MBTS_IDS_RETRIEVE_ALL_STILL_OPEN' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.transactions.history.still_open.ids' },
    'FM_MBTS_IDS_RETRIEVE_ALL_HAVING_BILL' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.transactions.history.have_bill.ids' },
    'FM_MBTS_IDS_RETRIEVE_ALL_HAVING_BILL.authoritative' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.transactions.history.have_bill.ids.authoritative' },
    'FM_MBTS_IDS_RETRIEVE_FOR_HISTORY' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.transactions.history.have_bill_or_payment.ids' },
    'FM_MBTS_IDS_RETRIEVE_FOR_HISTORY.authoritative' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.transactions.history.have_bill_or_payment.ids.authoritative' },
    'FM_MP_RETRIEVE_VIA_MBTS_ID' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.money.payment.retrieve.all' },
    'FM_MP_RETRIEVE_VIA_MBTS_ID.authoritative' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.money.payment.retrieve.all.authoritative' },
    'FM_MP_RETRIEVE_VIA_USER' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.payments.retrieve' },
    'FM_MP_NOTE_EDIT' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.money.payment.note.edit' },
    'FM_MG_CREATE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.money.grocery.create' },
    'FM_MG_RETRIEVE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.money.grocery.retrieve' },
    'FM_BRESV_RETRIEVE' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.booking.reservation.retrieve' },
    'FM_MOBTS_HAVING_BALANCE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.transactions.have_balance' },
    'FM_MOBTS_HAVING_BALANCE.authoritative' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.transactions.have_balance.authoritative' },
    'FM_MOBTS_TOTAL_HAVING_BALANCE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.transactions.have_balance.total' },
    'FM_MOBTS_COUNT_HAVING_BALANCE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.transactions.have_balance.count' },
    'FM_MOBTS_OPEN' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.transactions' },
    'FM_MOBTS_TOTAL_OPEN' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.transactions.total' },
    'FM_MOBTS_COUNT_OPEN' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.transactions.count' },
    'FM_MOUS_RETRIEVE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.fines.summary', 'cacheable' : true, 'ttl' : 60000 },
    'FM_MOUS_RETRIEVE.authoritative' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.fines.summary.authoritative', 'cacheable' : true, 'ttl' : 60000 },
    'FM_PGT_RETRIEVE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.groups.tree.retrieve', 'secure' : false },
    'FM_STGU_RETRIEVE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.stage.retrieve.by_org', 'secure' : true },
    'FM_STGU_DELETE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.stage.delete', 'secure' : false },
    'MARC_HTML_RETRIEVE' : { 'app' : 'open-ils.search', 'method' : 'open-ils.search.biblio.record.html', 'secure' : false },
    'FM_BLOB_RETRIEVE_VIA_Z3950_SEARCH' : { 'app' : 'open-ils.search', 'method' : 'open-ils.search.z3950.search_class' },
    'FM_BLOB_RETRIEVE_VIA_Z3950_RAW_SEARCH' : { 'app' : 'open-ils.search', 'method' : 'open-ils.search.z3950.search_service' },
    'FM_SBSUM_BATCH_RETRIEVE' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.basic_summary.batch.retrieve', 'secure' : false },
    'FM_SBSUM_BATCH_RETRIEVE.authoritative' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.basic_summary.batch.retrieve.authoritative', 'secure' : false },
    'FM_SCAP_BATCH_RETRIEVE' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.caption_and_pattern.batch.retrieve', 'secure' : false },
    'FM_SCAP_BATCH_RETRIEVE.authoritative' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.caption_and_pattern.batch.retrieve', 'secure' : false },
    'FM_SDIST_AOU_IDS_RETRIEVE_VIA_RECORD_ID' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.distribution.retrieve_orgs_by_title', 'secure' : false },
    'FM_SDIST_AOU_IDS_RETRIEVE_VIA_RECORD_ID.authoritative' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.distribution.retrieve_orgs_by_title.authoritative', 'secure' : false },
    'FM_SDIST_FLESHED_BATCH_RETRIEVE' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.distribution.fleshed.batch.retrieve', 'secure' : false },
    'FM_SDIST_FLESHED_BATCH_RETRIEVE.authoritative' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.distribution.fleshed.batch.retrieve.authoritative', 'secure' : false },
    'FM_SDIST_ID_LIST' : { 'app' : 'open-ils.pcrud', 'method' : 'open-ils.pcrud.id_list.sdist'},
    'FM_SDIST_RETRIEVE' : { 'app' : 'open-ils.pcrud', 'method' : 'open-ils.pcrud.retrieve.sdist'},
    'FM_SDIST_SEARCH' : { 'app' : 'open-ils.pcrud', 'method' : 'open-ils.pcrud.search.sdist'},
    'FM_SDIST_TREE_LIST_RETRIEVE_VIA_RECORD_ID_AND_ORG_IDS' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.distribution_tree.retrieve', 'secure' : false },
    'FM_SDIST_TREE_LIST_RETRIEVE_VIA_RECORD_ID_AND_ORG_IDS.authoritative' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.distribution_tree.retrieve.authoritative', 'secure' : false },
    'FM_SDISTN_UPDATE' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.distribution_note.update' },
    'FM_SDISTN_DELETE' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.distribution_note.delete', 'secure' : false },
    'FM_SDISTN_RETRIEVE_ALL' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.distribution_note.retrieve.all', 'secure' : false },
    'FM_SIN_UPDATE' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.item_note.update' },
    'FM_SIN_DELETE' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.item_note.delete', 'secure' : false },
    'FM_SIN_RETRIEVE_ALL' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.item_note.retrieve.all', 'secure' : false },
    'FM_SISS_FLESHED_BATCH_RETRIEVE' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.issuance.fleshed.batch.retrieve', 'secure' : false },
    'FM_SISS_FLESHED_BATCH_RETRIEVE.authoritative' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.issuance.fleshed.batch.retrieve.authoritative', 'secure' : false },
    'FM_SISUM_BATCH_RETRIEVE' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.index_summary.batch.retrieve', 'secure' : false },
    'FM_SISUM_BATCH_RETRIEVE.authoritative' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.index_summary.batch.retrieve.authoritative', 'secure' : false },
    'FM_SITEM_FLESHED_BATCH_RETRIEVE' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.item.fleshed.batch.retrieve', 'secure' : false },
    'FM_SITEM_FLESHED_BATCH_RETRIEVE.authoritative' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.item.fleshed.batch.retrieve.authoritative', 'secure' : false },
    'FM_SITEM_ID_LIST' : { 'app' : 'open-ils.pcrud', 'method' : 'open-ils.pcrud.id_list.sitem'},
    'FM_SITEM_RETRIEVE' : { 'app' : 'open-ils.pcrud', 'method' : 'open-ils.pcrud.retrieve.sitem'},
    'FM_SITEM_SEARCH' : { 'app' : 'open-ils.pcrud', 'method' : 'open-ils.pcrud.search.sitem'},
    'FM_SRE_RETRIEVE' : { 'app' : 'open-ils.pcrud', 'method' : 'open-ils.pcrud.retrieve.sre'},
    'FM_SRE_SEARCH' : { 'app' : 'open-ils.pcrud', 'method' : 'open-ils.pcrud.search.sre'},
    'FM_SSSUM_BATCH_RETRIEVE' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.supplement_summary.batch.retrieve', 'secure' : false },
    'FM_SSSUM_BATCH_RETRIEVE.authoritative' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.supplement_summary.batch.retrieve.authoritative', 'secure' : false },
    'FM_SSTR_BATCH_RETRIEVE' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.stream.batch.retrieve', 'secure' : false },
    'FM_SSTR_BATCH_RETRIEVE.authoritative' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.stream.batch.retrieve.authoritative', 'secure' : false },
    'FM_SSUB_AOU_IDS_RETRIEVE_VIA_RECORD_ID' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.subscription.retrieve_orgs_by_title', 'secure' : false },
    'FM_SSUB_AOU_IDS_RETRIEVE_VIA_RECORD_ID.authoritative' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.subscription.retrieve_orgs_by_title.authoritative', 'secure' : false },
    'FM_SSUB_FLESHED_BATCH_RETRIEVE' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.subscription.fleshed.batch.retrieve', 'secure' : false },
    'FM_SSUB_FLESHED_BATCH_RETRIEVE.authoritative' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.subscription.fleshed.batch.retrieve.authoritative', 'secure' : false },
    'FM_SSUB_TREE_LIST_RETRIEVE_VIA_RECORD_ID_AND_ORG_IDS' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.subscription_tree.retrieve', 'secure' : false },
    'FM_SSUB_TREE_LIST_RETRIEVE_VIA_RECORD_ID_AND_ORG_IDS.authoritative' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.subscription_tree.retrieve.authoritative', 'secure' : false },
    'FM_SSUBN_UPDATE' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.subscription_note.update' },
    'FM_SSUBN_DELETE' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.subscription_note.delete', 'secure' : false },
    'FM_SSUBN_RETRIEVE_ALL' : { 'app' : 'open-ils.serial', 'method' : 'open-ils.serial.subscription_note.retrieve.all', 'secure' : false },
    'RETRIEVE_Z3950_SERVICES' : { 'app' : 'open-ils.search', 'method' : 'open-ils.search.z3950.retrieve_services', 'secure' : false },
    'MARK_ITEM_DAMAGED' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.mark_item_damaged' },
    'MARK_ITEM_MISSING_PIECES' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.mark_item_missing_pieces' },
    'MARK_ITEM_MISSING' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.mark_item_missing' },
    'MARK_ITEM_LOST' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.circulation.set_lost' },
    'MARK_ITEM_CLAIM_RETURNED' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.circulation.set_claims_returned' },
    'MODS_SLIM_METARECORD_RETRIEVE' : { 'app' : 'open-ils.search', 'method' : 'open-ils.search.biblio.metarecord.mods_slim.retrieve', 'secure' : false },
    'MODS_SLIM_RECORD_RETRIEVE' : { 'app' : 'open-ils.search', 'method' : 'open-ils.search.biblio.record.mods_slim.retrieve', 'secure' : false },
    'MODS_SLIM_RECORD_RETRIEVE.authoritative' : { 'app' : 'open-ils.search', 'method' : 'open-ils.search.biblio.record.mods_slim.retrieve.authoritative', 'secure' : false },
    'MODS_SLIM_RECORD_RETRIEVE_VIA_COPY' : { 'app' : 'open-ils.search', 'method' : 'open-ils.search.biblio.mods_from_copy', 'secure' : false },
    'MODS_SLIM_RECORD_RETRIEVE_VIA_COPY.authoritative' : { 'app' : 'open-ils.search', 'method' : 'open-ils.search.biblio.mods_from_copy', 'secure' : false },
    'PERM_CHECK' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.perm.check' },
    'PERM_MULTI_ORG_CHECK' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.perm.check.multi_org' },
    'PERM_RETRIEVE_HIGHEST_ORG' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.perm.highest_org' },
    'PERM_RETRIEVE_WORK_OU' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.has_work_perm_at' },
    'BATCH_PERM_RETRIEVE_WORK_OU' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.has_work_perm_at.batch' },
    'MARC_XML_RECORD_CREATE' : { 'app' : 'open-ils.cat', 'method' : 'open-ils.cat.biblio.record.xml.create' },
    'MARC_XML_RECORD_IMPORT' : { 'app' : 'open-ils.cat', 'method' : 'open-ils.cat.biblio.record.xml.import' },
    'MARC_XML_RECORD_REPLACE' : { 'app' : 'open-ils.cat', 'method' : 'open-ils.cat.biblio.record.marc.replace' },
    'MARC_XML_RECORD_UPDATE' : { 'app' : 'open-ils.cat', 'method' : 'open-ils.cat.biblio.record.xml.update' },
    'MARC_XML_TEMPLATE_RETRIEVE' : { 'app' : 'open-ils.cat', 'method' : 'open-ils.cat.biblio.marc_template.retrieve', 'secure' : false },
    'MARC_XML_TEMPLATE_LIST' : { 'app' : 'open-ils.cat', 'method' : 'open-ils.cat.marc_template.types.retrieve', 'secure' : false },
    'MERGE_RECORDS' : { 'app' : 'open-ils.cat', 'method' : 'open-ils.cat.biblio.records.merge' },
    'MFHD_XML_RECORD_CREATE' : { 'app': 'open-ils.cat', 'method': 'open-ils.cat.serial.record.xml.create' },
    'PATRON_BARCODE_EXISTS' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.barcode.exists' },
    'PATRON_BARCODE_EXISTS.authoritative' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.barcode.exists.authoritative' },
    'RECALCULATE_STANDING_PENALTIES' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.penalties.update' },
    'USER_ORG_UNIT_OPT_IN_FEATURE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.org_unit_opt_in.enabled' },
    'USER_ORG_UNIT_OPT_IN_CHECK' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.org_unit_opt_in.check' },
    'USER_ORG_UNIT_OPT_IN_CREATE' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.user.org_unit_opt_in.create' },
    'GET_BARCODES' : { 'app' : 'open-ils.actor', 'method' : 'open-ils.actor.get_barcodes' },
    'ADJUST_BILLS_TO_ZERO' : { 'app' : 'open-ils.circ', 'method' : 'open-ils.circ.money.billable_xact.adjust_to_zero' }
}

var urls = {

    'opac' : 'oils://remote/eg/opac/advanced',
    'opac_rdetail' : 'oils://remote/eg/opac/record/',
    'opac_rresult' : 'oils://remote/eg/opac/results',
    'opac_rresult_metarecord' : 'oils://remote/eg/opac/results?metarecord=',
    'org_tree' : '/opac/common/js/' + LOCALE + '/OrgTree.js',
    'browser' : 'oils://remote/eg/opac/advanced',
    'fieldmapper' : '/opac/common/js/fmall.js',
    'xsl_marc2html' : '/opac/extras/xsl/oilsMARC21slim2HTML.xsl',
    'ac_jacket_small' : '/opac/extras/ac/jacket/small/',
    'ac_jacket_large' : '/opac/extras/ac/jacket/large/',
    'MARC_BATCH_EDIT' : 'oils://remote/opac/extras/merge_template/',

    'AUDIO_good' : '/xul/server/skin/media/audio/bonus.wav',
    'AUDIO_bad' : '/xul/server/skin/media/audio/question.wav',
    'AUDIO_horrible' : '/xul/server/skin/media/audio/redalert.wav',
    'AUDIO_circ_good' : '/xul/server/skin/media/audio/toggled.wav',
    'AUDIO_circ_bad' : '/xul/server/skin/media/audio/question.wav',
    'AUDIO_event_ASSET_COPY_NOT_FOUND' : '/xul/server/skin/media/audio/redalert.wav',

    'AUTHORITY_MANAGE' : 'cat/authority/list',
    'MANAGE_MULTI_HOME_ITEMS' : 'oils://remote/xul/server/cat/manage_multi_home_items.xul',
    'XUL_AUTH_SIMPLE' : 'oils://remote/xul/server/main/simple_auth.xul',
    'XUL_BIB_BRIEF' : 'oils://remote/xul/server/cat/bib_brief.xul',
    'XUL_BIB_BRIEF_VERTICAL' : 'oils://remote/xul/server/cat/bib_brief_vertical.xul',
    'XUL_BROWSER' : 'chrome://open_ils_staff_client/content/util/browser.xul',
    'XUL_CHECKIN' : 'oils://remote/xul/server/circ/checkin.xul',
    'XUL_BACKDATE' : 'oils://remote/xul/server/circ/backdate_post_checkin.xul',
    'XUL_RENEW' : 'oils://remote/xul/server/circ/renew.xul',
    'XUL_CHECKOUT' : 'oils://remote/xul/server/circ/checkout.xul',
    'XUL_CIRC_BRIEF' : 'oils://remote/xul/server/circ/circ_brief.xul',
    'XUL_CIRC_SUMMARY' : 'oils://remote/xul/server/circ/circ_summary.xul',
    'XUL_COPY_BUCKETS_QUICK' : 'oils://remote/xul/server/cat/copy_buckets_quick.xul',
    'XUL_COPY_BUCKETS' : 'oils://remote/xul/server/cat/copy_buckets.xul',
    'XUL_COPY_DETAILS' : 'oils://remote/xul/server/circ/copy_details.xul',
    'XUL_COPY_EDITOR' : 'oils://remote/xul/server/cat/copy_editor.xul',
    'XUL_COPY_LOCATION_EDIT' : 'oils://remote/xul/server/admin/copy_locations.xhtml',
    'XUL_COPY_NOTES' : 'oils://remote/xul/server/cat/copy_notes.xul',
    'XUL_COPY_STATUS' : 'oils://remote/xul/server/circ/copy_status.xul',
    'XUL_COPY_SUMMARY' : 'oils://remote/xul/server/cat/copy_summary.xul',
    'XUL_COPY_VOLUME_BROWSE' : 'oils://remote/xul/server/cat/copy_browser.xul',
    'XUL_DEBUG_CONSOLE' : 'chrome://global/content/console.xul',
    'XUL_DEBUG_FIELDMAPPER' : 'oils://remote/xul/server/util/fm_view.xul',
    'XUL_DEBUG_FILTER_CONSOLE' : 'oils://remote/xul/server/util/filter_console.xul',
    'XUL_DEBUG_SHELL' : 'oils://remote/xul/server/util/shell.html',
    'XUL_DEBUG_XULEDITOR' : 'oils://remote/xul/server/util/xuledit.xul',
    'XUL_DO_NOT_AUTO_ATTEMPT_PRINT_SETTING' : 'oils://remote/xul/server/admin/do_not_auto_attempt_print_setting.xul',
    'XUL_FANCY_PROMPT' : 'oils://remote/xul/server/util/fancy_prompt.xul',
    'XUL_HOLD_CAPTURE' : 'oils://remote/xul/server/circ/hold_capture.xul',
    /*'XUL_HOLD_PULL_LIST' : 'oils://remote/xul/server/admin/hold_pull_list.xhtml',*/
    'XUL_HOLD_PULL_LIST' : 'oils://remote/xul/server/patron/holds.xul',
    'XUL_HOLDS_BROWSER' : 'oils://remote/xul/server/patron/holds.xul',
    'XUL_HOLD_DETAILS' : 'oils://remote/xul/server/patron/hold_details.xul',
    'XUL_HOLD_CANCEL' : 'oils://remote/xul/server/patron/hold_cancel.xul',
    'XUL_HOLD_PLACEMENT' : 'oils://remote/xul/server/patron/place_hold.xul',
    'XUL_IN_HOUSE_USE' : 'oils://remote/xul/server/circ/in_house_use.xul',
    'XUL_LIST_CLIPBOARD' : 'oils://remote/xul/server/util/list_clipboard.xul',
    'XUL_LOCAL_ADMIN' : 'oils://remote/xul/server/admin/index.xhtml',
    'XUL_LOGIN_DATA' : 'oils://remote/xul/server/main/data.xul',
    'XUL_MARC_NEW' : 'oils://remote/xul/server/cat/marc_new.xul',
    'XUL_MARC_EDIT' : 'oils://remote/xul/server/cat/marcedit.xul',
    'XUL_MARC_VIEW' : 'oils://remote/xul/server/cat/marc_view.xul',
    'XUL_MENU_FRAME' : 'chrome://open_ils_staff_client/content/main/menu_frame.xul',
    'XUL_NON_CAT_LABEL_EDIT' : 'oils://remote/xul/server/admin/non_cat_types.xhtml',
    'XUL_OFFLINE_UPLOAD_XACTS' : 'oils://remote/xul/server/admin/upload_xacts.xhtml',
    'XUL_OFFLINE_MANAGE_XACTS' : 'oils://remote/xul/server/admin/offline_manage_xacts.xul',
    'XUL_OFFLINE_MANAGE_XACTS_CGI' : '/cgi-bin/offline/offline.pl', // Dunno if this needs oils://remote
    'XUL_OFFLINE_GENERATE_WIDGETS' : 'oils://remote/xul/server/main/gen_offline_widgets.xul',
    'XUL_REMOTE_OPAC_WRAPPER' : 'oils://remote/xul/server/cat/opac.xul',
    'XUL_OPAC_WRAPPER' : 'chrome://open_ils_staff_client/content/cat/opac.xul',
    'XUL_PATRON_BARCODE_ENTRY' : 'oils://remote/xul/server/patron/barcode_entry.xul',
    'XUL_PATRON_BILLS' : 'oils://remote/xul/server/patron/bill2.xul',
    'XUL_PATRON_BILL_CC_INFO' : 'oils://remote/xul/server/patron/bill_cc_info.xul',
    'XUL_PATRON_BILL_CHECK_INFO' : 'oils://remote/xul/server/patron/bill_check_info.xul',
    'XUL_PATRON_BILL_DETAILS' : 'oils://remote/xul/server/patron/bill_details.xul',
    'XUL_PATRON_BILL_HISTORY' : 'oils://remote/xul/server/patron/bill_history.xul',
    'XUL_PATRON_BILL_WIZARD' : 'oils://remote/xul/server/patron/bill_wizard.xul',
    'XUL_PATRON_DISPLAY' : 'oils://remote/xul/server/patron/display.xul',
    'XUL_PATRON_HORIZ_DISPLAY' : 'oils://remote/xul/server/patron/display_horiz.xul',
    'XUL_PATRON_EDIT' : 'oils://remote/eg/actor/user/register',
    'XUL_PATRONS_DUE_REFUNDS' : 'oils://remote/xul/server/admin/patrons_due_refunds.xul',
    'XUL_USER_PERM_EDITOR' : 'oils://remote/xul/server/patron/user_edit.xul',
    'XUL_PATRON_HOLDS' : 'oils://remote/xul/server/patron/holds.xul',
    'XUL_PATRON_INFO_NOTES' : 'oils://remote/xul/server/patron/info_notes.xul',
    'XUL_PATRON_INFO_STAT_CATS' : 'oils://remote/xul/server/patron/info_stat_cats.xul',
    'XUL_PATRON_INFO_SURVEYS' : 'oils://remote/xul/server/patron/info_surveys.xul',
    'XUL_PATRON_INFO_GROUP' : 'oils://remote/xul/server/patron/info_group.xul',
    'XUL_PATRON_ITEMS' : 'oils://remote/xul/server/patron/items.xul',
    'XUL_PATRON_SEARCH_FORM' : 'oils://remote/xul/server/patron/search_form.xul',
    'XUL_PATRON_HORIZONTAL_SEARCH_FORM' : 'oils://remote/xul/server/patron/search_form_horiz.xul',
    'XUL_PATRON_SEARCH_RESULT' : 'oils://remote/xul/server/patron/search_result.xul',
    'XUL_PATRON_SUMMARY' : 'oils://remote/xul/server/patron/summary.xul',
    'XUL_PRE_CAT' : 'oils://remote/xul/server/circ/pre_cat_fields.xul',
    'XUL_PRINT_LIST_TEMPLATE_EDITOR' : 'oils://remote/xul/server/circ/print_list_template_editor.xul',
    'XUL_RECORD_BUCKETS' : 'oils://remote/xul/server/cat/record_buckets.xul',
    'XUL_RECORD_BUCKETS_QUICK' : 'oils://remote/xul/server/cat/record_buckets_quick.xul',
    'XUL_REMOTE_BROWSER' : 'oils://remote/xul/server/util/rbrowser.xul',
    'XUL_SERIAL_ITEM_EDITOR' : 'oils://remote/xul/server/serial/sitem_editor.xul',
    'XUL_SERIAL_NOTES' : 'oils://remote/xul/server/serial/notes.xul',
    'XUL_SERIAL_SELECT_AOU' : 'oils://remote/xul/server/serial/select_aou.xul',
    'XUL_SERIAL_SELECT_UNIT' : 'oils://remote/xul/server/serial/select_unit.xul',
    'XUL_SERIAL_SERCTRL_MAIN' : 'oils://remote/xul/server/serial/serctrl_main.xul',
    'XUL_SPINE_LABEL' : 'oils://remote/xul/server/cat/spine_labels.xul',
    'XUL_STAGED_PATRONS' : 'oils://remote/xul/server/patron/staged.xul',
    'XUL_STANDALONE' : 'chrome://open_ils_staff_client/content/circ/offline.xul',
    'XUL_STANDING_PENALTIES' : 'oils://remote/xul/server/patron/standing_penalties.xul',
    'XUL_NEW_STANDING_PENALTY' : 'oils://remote/xul/server/patron/new_standing_penalty.xul',
    'XUL_EDIT_STANDING_PENALTY' : 'oils://remote/xul/server/patron/edit_standing_penalty.xul',
    'XUL_SCAN_ITEM_AS_MISSING_PIECES' : 'oils://remote/xul/server/circ/missing_pieces.xul',
    'XUL_STAT_CAT_EDIT' : 'oils://remote/xul/server/admin/stat_cat_editor.xhtml',
    'XUL_SURVEY_WIZARD' : 'chrome://open_ils_staff_client/content/admin/survey_wizard.xul',
    'XUL_TIMESTAMP_DIALOG' : 'oils://remote/xul/server/util/timestamp.xul',
    'XUL_TOOLBAR_CONFIG' : 'oils://remote/xul/server/admin/toolbar.xul',
    'XUL_USER_BUCKETS' : 'oils://remote/xul/server/patron/user_buckets.xul',
    'XUL_VERIFY_CREDENTIALS' : 'oils://remote/xul/server/main/verify_credentials.xul',
    'XUL_VOLUME_BUCKETS' : 'oils://remote/xul/server/cat/volume_buckets.xul',
    'XUL_VOLUME_COPY_CREATOR' : 'oils://remote/xul/server/cat/volume_copy_editor.xul',
    'XUL_VOLUME_COPY_CREATOR_HORIZONTAL' : 'oils://remote/xul/server/cat/volume_copy_editor_horiz.xul',
    'XUL_VOLUME_COPY_CREATOR_ORIGINAL' : 'oils://remote/xul/server/cat/volume_copy_creator.xul',
    'XUL_VOLUME_EDITOR' : 'oils://remote/xul/server/cat/volume_editor.xul',
    'XUL_WORK_LOG' : 'oils://remote/xul/server/admin/work_log.xul',
    'XUL_WORKSTATION_INFO' : 'oils://remote/xul/server/main/ws_info.xul',
    'XUL_Z3950_IMPORT' : 'oils://remote/xul/server/cat/z3950.xul',
    'TEST_HTML' : '/xul/server/main/test.html', // This is html, not xul....does it need oils://remote?
    'TEST_XUL' : 'oils://remote/xul/server/main/test.xul',
    'CONIFY' : 'oils://remote/conify/' + LOCALE + '/global',
    'CONIFY_MANAGE_PARTS' : 'oils://remote/eg/conify/global/biblio/monograph_part',
    'EG_WEB_BASE' : 'oils://remote/eg',
    'XUL_LOCAL_ADMIN_BASE' : 'oils://remote/xul/server/admin',
    'XUL_REPORTS' : 'oils://remote/reports/oils_rpt.xhtml',
    'EG_ACQ_PO_VIEW' : 'oils://remote/eg/acq/po/view',
    'EG_ACQ_USER_REQUESTS' : 'oils://remote/eg/acq/picklist/user_request',
    'XUL_SERIAL_BATCH_RECEIVE': 'oils://remote/xul/server/serial/batch_receive.xul',
    'XUL_SERIAL_PATTERN_WIZARD' : 'oils://remote/xul/server/serial/pattern_wizard.xul',
    'EG_MARCEDIT_PHYS_CHAR_WIZARD' : 'oils://remote/eg/cat/marcedit/phys_char_wizard',
    'CUSTOM_JS' : '/xul/server/skin/custom.js',
    'ACQ_LINEITEM' : 'oils://remote/eg/acq/lineitem/related/',
    'SERIAL_LIST_SUBSCRIPTION' : 'oils://remote/eg/serial/list_subscription',
    'BOOKING_RESOURCE' : 'oils://remote/eg/conify/global/booking/resource',
    'BOOKING_RESERVATION' : 'oils://remote/eg/booking/reservation',
    'BOOKING_PICKUP' : 'oils://remote/eg/booking/pickup',
    'BOOKING_RETURN' : 'oils://remote/eg/booking/return',
    'ALT_HOLDS_PRINT' : 'oils://remote/opac/extras/circ/alt_holds_print.html',
    'SERIAL_PRINT_ROUTING_LIST_USERS' : 'oils://remote/eg/serial/print_routing_list_users',
    'XUL_SERIAL_BATCH_RECEIVE': 'oils://remote/xul/server/serial/batch_receive.xul',
    'EG_TRIGGER_EVENTS' : 'oils://remote/eg/actor/user/event_log',
    'EG_PATRON_MESSAGE_CENTER' : 'oils://remote/eg/actor/user/message',
    'XUL_SEARCH_PREFS' : 'chrome://open_ils_staff_client/content/main/search_prefs.xul',
    'XUL_SERVER_ADDONS' : 'oils://remote/xul/server/addon/addons.xul'
}
