"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.RuleTester = void 0;
const rule_tester_1 = require("@typescript-eslint/rule-tester");
const path = __importStar(require("path"));
const VALID_PARSERS = [
    '@angular-eslint/template-parser',
    '@typescript-eslint/parser',
];
function getFixturesRootDir() {
    return path.join(process.cwd(), 'tests/fixtures/');
}
function isValidParser(parser) {
    try {
        if (parser === require('@angular-eslint/template-parser')) {
            return true;
        }
    }
    catch {
        /* empty */
    }
    try {
        if (parser === require('@typescript-eslint/parser')) {
            return true;
        }
    }
    catch {
        /* empty */
    }
    return false;
}
class RuleTester extends rule_tester_1.RuleTester {
    filename = '';
    constructor(options) {
        super(options);
        if (options?.languageOptions?.parserOptions?.project ||
            options?.languageOptions?.parserOptions?.projectService) {
            this.filename = path.join(options?.languageOptions?.parserOptions?.tsconfigRootDir ??
                getFixturesRootDir(), 'file.ts');
        }
    }
    run(ruleName, rule, { valid, invalid }) {
        const errorMessage = `Do not set the parser at the test level unless you want to use a parser other than ${VALID_PARSERS.join(', ')}`;
        const parsedTests = {
            valid: valid.map((test) => {
                if (typeof test !== 'string' &&
                    test.languageOptions?.parser &&
                    !isValidParser(test.languageOptions.parser)) {
                    throw Error(errorMessage);
                }
                return typeof test === 'string'
                    ? { code: test, filename: this.filename }
                    : { ...test, filename: test.filename ?? this.filename };
            }),
            invalid: invalid.map((test) => {
                if (test.languageOptions?.parser &&
                    !isValidParser(test.languageOptions.parser)) {
                    throw Error(errorMessage);
                }
                return {
                    ...test,
                    filename: test.filename ?? this.filename,
                };
            }),
        };
        super.run(ruleName, rule, parsedTests);
    }
}
exports.RuleTester = RuleTester;
