\set xact_id '''IMPORT CONCERTO'''

INSERT INTO authority.record_entry(marc, last_xact_id) VALUES
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00189nz  a2200073O  4500</leader><controlfield tag="001">3022</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">19970725125544.0</controlfield><controlfield tag="008">970601nnbacnnnabbn           a ana     u</controlfield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Girdlestone, Cuthbert Morton,</subfield><subfield code="d">1895-1975</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">3022</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>03250cz  a2200565n  4500</leader><controlfield tag="001">1116068</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060301104318.0</controlfield><controlfield tag="008">800801nn acannaabn           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  50043095 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(OCoLC)oca00078265</subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  50043095</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">MoSW-Mu</subfield><subfield code="d">DLC</subfield><subfield code="d">CtY-Mus</subfield><subfield code="d">DLC</subfield><subfield code="d">OOC</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Kabalevsky, Dmitry Borisovich,</subfield><subfield code="d">1904-1987.</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalevsky, Dmitry Borisovich,</subfield><subfield code="d">1904-</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabelevsky, Dmitri M.,</subfield><subfield code="d">1904-</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalewsky, D.,</subfield><subfield code="d">1904-</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalewski, Dmitri,</subfield><subfield code="d">1904-</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalevsky, Dmitri,</subfield><subfield code="d">1904-</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalewskij, Dmitri M.,</subfield><subfield code="d">1904-</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="w">nna</subfield><subfield code="a">Kabalevskii, Dmitrii Borisovich,</subfield><subfield code="d">1904-</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalevskij, Dmitrij,</subfield><subfield code="d">1904-</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalevskii, D.</subfield><subfield code="q">(Dmitrii),</subfield><subfield code="d">1904-</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalevsky, D.</subfield><subfield code="q">(Dmitri),</subfield><subfield code="d">1904-</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalevsky, Dimitry,</subfield><subfield code="d">1904-</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalevskii, Dm.</subfield><subfield code="q">(Dmitrii),</subfield><subfield code="d">1904-</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalewski, Dimitri,</subfield><subfield code="d">1904-</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalevskij, Dmitrij Borissovic,</subfield><subfield code="d">1904-</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalevsky, Dimitri,</subfield><subfield code="d">1904-</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalevsky, Dm.</subfield><subfield code="q">(Dmitri),</subfield><subfield code="d">1904-</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabarefusuki, Domitori,</subfield><subfield code="d">1904-</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalevski, Dmitri,</subfield><subfield code="d">1904-</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalewsky, Dmitri,</subfield><subfield code="d">1904-</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalevski, Dimitri,</subfield><subfield code="d">1904-</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">His Sonatina in C major for piano, 1945.</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Ency. brit.</subfield><subfield code="b">(Kabalevksy, Dmitry Borisovich, b. 1904)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Linde, B. Konsert for violin och orkester, op. 18 [SR] p1972:</subfield><subfield code="b">label (Dmitrij Kabalevskij)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">His Piano concerto no. 4, op. 99 [SR] 1982:</subfield><subfield code="b">label (Dmitri Kabalevsky; D. Kabalevskii) container (D. Kabalevsky)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Washington post, 2/19/87:</subfield><subfield code="b">obit. (Dimitry Kabalevsky; d. at age 83)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">His Pedagogicheskie razmyshlenii&#x131;&#x310;a&#x131;&#x310;&#x141;, 1986:</subfield><subfield code="b">t.p. (Dm. Kabalevskii)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Zaritskaya, I. Russische Meisterwerke [SR] p1985:</subfield><subfield code="b">container (Dimitri Kabalewski)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Pribegina, G. Moskovskai&#x131;&#x310;a&#x131;&#x310;&#x141; konservatorii&#x131;&#x310;a&#x131;&#x310;&#x141;, 1991:</subfield><subfield code="b">p. 213 (Dmitrii Borisovich Kabalevskii; Dmitry Borisovich Kabalevsky; 1904-1986)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">His Twenty-four preludes [SR] 1991:</subfield><subfield code="b">container (Dmitrij Borissovic Kabalevskij)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">His Piano concerto no. 3 [SR] 1991?:</subfield><subfield code="b">label (Dimitri Kabalevsky)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Kabalevsky, D.B. Un compositeur parle de l''education musicale, c1987:</subfield><subfield code="b">t.p. (Dm. Kabalevsky) p. 4 of cover (Dmitri Kabalevsky)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Tokyo-to Kokyo Gakudan. Kodomo no shinfoni, p1980:</subfield><subfield code="b">label (Dmitri Kabalevsky) container (Domitori Kabarefusuki)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Baker''s biographical dictionary of twentieth-century classical musicians, c1997</subfield><subfield code="b">(Kabalevsky, Dmitri (Borisovich); b. Dec. 30, 1904, St. Petersburg; d. Feb. 14, 1987, Moscow; Russian composer)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Savenko, V. English poets, Russian romances [SR] p2001:</subfield><subfield code="b">container (Dmitry Kabalevsky) insert (Dmitri Kabalevski; Dmitri Kabalewski)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Kabalevsky, D.B. Klaviersonaten 2 &amp; 3 [SR] p2001:</subfield><subfield code="b">label (Dmitri Kabalewsky) insert (Dmitri Kabalewsky; Dmitri Borissowitsch Kabalewsky; Dmitri Kabalevsky; Dmitri Borisovich Kabalevsky; Dimitri Kabalevski; Dimitri Borissovitch Kabalevski)</subfield></datafield><datafield tag="678" ind1=" " ind2=" "><subfield code="a">composer, musician</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1038698</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1116068</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>01959cz  a2200349n  4500</leader><controlfield tag="001">1122809</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060706093222.0</controlfield><controlfield tag="008">910528nn acannaabn           a aaa     c</controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">no 91013518 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(OCoLC)oca02961636</subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)no 91013518</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">InU-Mu</subfield><subfield code="b">eng</subfield><subfield code="c">InU-Mu</subfield><subfield code="d">DLC</subfield><subfield code="d">PPi-MA</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Kabalevsky, Dmitry Borisovich,</subfield><subfield code="d">1904-1987.</subfield><subfield code="t">Detskie p&#xA3;esy,</subfield><subfield code="n">op. 27</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalevsky, Dmitry Borisovich,</subfield><subfield code="d">1904-</subfield><subfield code="t">Detskie p&#xA3;esy,</subfield><subfield code="n">op. 27</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalevsky, Dmitry Borisovich,</subfield><subfield code="d">1904-1987.</subfield><subfield code="t">Kinderstucke</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalevsky, Dmitry Borisovich,</subfield><subfield code="d">1904-1987.</subfield><subfield code="t">30 detskikh p&#xA3;es</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalevsky, Dmitry Borisovich,</subfield><subfield code="d">1904-1987.</subfield><subfield code="t">30 pieces for children</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalevsky, Dmitry Borisovich,</subfield><subfield code="d">1904-1987.</subfield><subfield code="t">Thirty pieces for children</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalevsky, Dmitry Borisovich,</subfield><subfield code="d">1904-1987.</subfield><subfield code="t">Pieces for children,</subfield><subfield code="n">op. 27</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalevsky, Dmitry Borisovich,</subfield><subfield code="d">1904-1987.</subfield><subfield code="t">Tridt&#x131;&#x310;s&#x131;&#x310;&#x141;at&#xA3; detskikh p&#xA3;es</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalevsky, Dmitry Borisovich,</subfield><subfield code="d">1904-1987.</subfield><subfield code="t">Thirty children''s pieces</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalevsky, Dmitry Borisovich,</subfield><subfield code="d">1904-1987.</subfield><subfield code="t">30 children''s pieces</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalevsky, Dmitry Borisovich,</subfield><subfield code="d">1904-1987.</subfield><subfield code="t">Children''s pieces</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalevsky, Dmitry Borisovich,</subfield><subfield code="d">1904-1987.</subfield><subfield code="t">30 piano pieces for young people</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalevsky, Dmitry Borisovich,</subfield><subfield code="d">1904-1987.</subfield><subfield code="t">Thirty piano pieces for young people</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalevsky, Dmitry Borisovich,</subfield><subfield code="d">1904-1987.</subfield><subfield code="t">Piano pieces for young people</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalevsky, Dmitry Borisovich,</subfield><subfield code="d">1904-1987.</subfield><subfield code="t">Pieces pour enfants,</subfield><subfield code="n">op. 27</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalevsky, Dmitry Borisovich,</subfield><subfield code="d">1904-1987.</subfield><subfield code="t">30 pieces pour enfants</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Kabalevsky, Dmitry Borisovich,</subfield><subfield code="d">1904-1987.</subfield><subfield code="t">Trente pieces pour enfants</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Kabalevsky, D.B. Kinderstucke, 1946-51:</subfield><subfield code="b">t.p. (Kinderstucke : op. 27)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Muz. ent&#x131;&#x310;s&#x131;&#x310;&#x141;.</subfield><subfield code="b">(Detskie p&#xA3;esy for piano became very popular; 30 detskikh p&#xA3;es (1938))</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1047431</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1122809</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00529cz  a2200157n  4500</leader><controlfield tag="001">1125297</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060822085121.0</controlfield><controlfield tag="008">980127nn acannaabn           n aaa     c</controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">no 98045360 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(OCoLC)oca04629698</subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)no 98045360</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">OCoLC</subfield><subfield code="c">OCoLC</subfield><subfield code="d">TxDN-Mu</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Kabalevsky, Dmitry Borisovich,</subfield><subfield code="d">1904-</subfield><subfield code="t">Sonatas,</subfield><subfield code="m">violoncello, piano,</subfield><subfield code="n">op. 71,</subfield><subfield code="r">B&#x301;&#x1AF; major</subfield></datafield><datafield tag="667" ind1=" " ind2=" "><subfield code="a">Machine-derived authority record.</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">LCCN 95-750305: Kabalevsky, D.B. Chamber and piano music, p1994</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1045560</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1125297</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00226nz  a2200073O  4500</leader><controlfield tag="001">392923</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20020226160736.0</controlfield><controlfield tag="008">020226nneacnnnabbn           a aaa     u</controlfield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Kabalevsky, Dmitry Borisovich,</subfield><subfield code="d">1904-1987.</subfield><subfield code="t">Concertos,</subfield><subfield code="m">piano,</subfield><subfield code="n">no. 2,</subfield><subfield code="n">op. 23</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">392923</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00684cz  a2200193n  4500</leader><controlfield tag="001">1079351</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20070810104842.0</controlfield><controlfield tag="008">880211nnbacannaabn           n aaa      </controlfield><datafield tag="016" ind1=" " ind2=" "><subfield code="a">0055A8795</subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(CaOONL)0055A8795</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">CaOONL</subfield><subfield code="b">nnn</subfield><subfield code="c">CaOONL</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="042" ind1=" " ind2=" "><subfield code="a">nlc</subfield></datafield><datafield tag="053" ind1=" " ind2="0"><subfield code="a">ML410.F4565</subfield><subfield code="c">Biography</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Finzi, Gerald,</subfield><subfield code="d">1901-1956</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Lovreglio, D.  [Fantasia sull''opera La traviata]  Fantasia on "La traviata" [sound recording].</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">His Prelude and fugue for string trio, c1942.</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">New Grove</subfield><subfield code="b">(Finzi, Gerald (Raphael); b. 7-14-01, London, d. 9-27-56, Oxford; English composer)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">LCNA 1977-1986.  AA2.  Dates.</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">926685</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1079351</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00789cz  a2200181n  4500</leader><controlfield tag="001">1125403</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060823091605.0</controlfield><controlfield tag="008">970903nn acannaabn           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  97088234 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(OCoLC)oca04422229</subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  97088234</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="c">DLC</subfield><subfield code="d">OOC</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Finzi, Gerald,</subfield><subfield code="d">1901-1956.</subfield><subfield code="t">Let us garlands bring</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Finzi, Gerald,</subfield><subfield code="d">1901-1956.</subfield><subfield code="t">Shakespearean songs</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Finzi, Gerald,</subfield><subfield code="d">1901-1956.</subfield><subfield code="t">Apportons des guirlandes</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Harper, H. Songs for soprano and baritone [SR] 195-?:</subfield><subfield code="b">label (Shakespearean songs)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">New Grove</subfield><subfield code="b">(op. 18, Let us garlands bring (Shakespeare), bar, pf: Come away, death, 1938; Who is Sylvia?; Fear no more the heat o'' the sun, 1929; O mistress mine, 1942; It was a lover, 1940)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">105153</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1125403</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00474nz  a2200157n  4500</leader><controlfield tag="001">1125580</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060825090736.0</controlfield><controlfield tag="008">971229nn acannaabn           n aad     c</controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">no 97081251 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(OCoLC)oca04568256</subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)no 97081251</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">OCoLC</subfield><subfield code="c">OCoLC</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Finzi, Gerald,</subfield><subfield code="d">1901-1956.</subfield><subfield code="t">Young man''s exhortation</subfield></datafield><datafield tag="667" ind1=" " ind2=" "><subfield code="a">Machine-derived authority record.</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">LCCN 86-754132: Finzi, G. Earth and air and rain, p1985</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1051251</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1125580</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>01537cz  a2200205n  4500</leader><controlfield tag="001">1095206</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20050131084135.0</controlfield><controlfield tag="008">990609nn acannaabn           a aaa     c</controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">no 99041152 </subfield><subfield code="z">nr 00009485 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(OCoLC)oca05003451</subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)no 99041152</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">ViBlbV</subfield><subfield code="c">ViBlbV</subfield><subfield code="d">DLC</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Petrov, Nikolai</subfield><subfield code="q">(Nikolai Vladimirovich)</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Petrov, Nikolai Vladimirovich</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Politicheskii al&#xA3;manakh Rossii 1997, c1998:</subfield><subfield code="b">t.p. (Nikolai Petrov)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">OCLC, June 7, 1999</subfield><subfield code="b">(hdgs.: Petrov, Nikolai; Petrov, Nikolai (Nikolai Vladimirovich); Petrov, Nikolai Vladimirovich; usage: Nikolai Petrov, Nikolai Vladimirovich Petrov)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Aleksandr Lebed&#xA3; v Krasnoi&#x131;&#x310;a&#x131;&#x310;&#x141;rskom krae, 1999:</subfield><subfield code="b">t.p. (Nikolai Petrov) ob avtore (Petrov Nikolai Vladimorovich, kandidat geograficheskikh nauk, chlen nauchnogo soveta Moskovskogo T&#x131;&#x310;S&#x131;&#x310;&#x141;entr Karnegi)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">www.ceip.org/files/news</subfield><subfield code="b">(Nikolai Petrov has served as chief organizer of the Analysis and Forecast Division in the Supreme Soviet, advisor and analyst for the Russian Presidential Administration, and a scholar at the Kennan Institute for Advanced Russian Studies. Petrov earned his Ph.D. from Moscow State University. Petrov also heads the Center for Political Geographic Research and is a senior research associate with the Institute of Geography at the Russian Academy of Sciences)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">www.politstudies.ru/archive/authors</subfield><subfield code="b">(Petrov Nikolai Vladimirovich; doktor geograficheskikh nauk</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1011722</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1095206</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00163nz  a2200073O  4500</leader><controlfield tag="001">391673</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">19991109155912.0</controlfield><controlfield tag="008">991109nnbadnnnabbn           a aaa     u</controlfield><datafield tag="100" ind1=" " ind2=" "><subfield code="a">Petrov, Nikolai</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">391673</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00164nz  a2200073O  4500</leader><controlfield tag="001">391674</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">19991109155932.0</controlfield><controlfield tag="008">991109nnbadnnnabbn           a aaa     u</controlfield><datafield tag="100" ind1=" " ind2=" "><subfield code="a">Kitaenko, Dmitri</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">391674</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00172nz  a2200073O  4500</leader><controlfield tag="001">391677</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">19991109162048.0</controlfield><controlfield tag="008">991109nnbadnnnabbn           a aaa     u</controlfield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Gilels, Emil,</subfield><subfield code="d">1916-1985</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">391677</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00159nz  a2200073O  4500</leader><controlfield tag="001">391675</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">19991109160012.0</controlfield><controlfield tag="008">991109nnbadnnnabbn           a aaa     u</controlfield><datafield tag="100" ind1=" " ind2=" "><subfield code="a">Popov, Yuri</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">391675</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00160nz  a2200073O  4500</leader><controlfield tag="001">391015</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">19990106135522.0</controlfield><controlfield tag="008">990106nnbacnnnabbn           a aaa     u</controlfield><datafield tag="100" ind1=" " ind2=" "><subfield code="a">Heino, Laura</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">391015</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00175nz  a2200073O  4500</leader><controlfield tag="001">390853</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">19990106113208.0</controlfield><controlfield tag="008">981014nnbacnnnabbn           a aaa     u</controlfield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Hall, Robert George,</subfield><subfield code="d">1954-</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">390853</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00225nz  a2200073O  4500</leader><controlfield tag="001">393366</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20030124120048.0</controlfield><controlfield tag="008">030124nneacnnnabbn           a aaa     u</controlfield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Samson.</subfield><subfield code="m">Vocal score.</subfield><subfield code="l">English &amp; German</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">393366</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>01323mz  a2200265r  4500</leader><controlfield tag="001">971714</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">19970516191853.0</controlfield><controlfield tag="008">800624nn acannaabn           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  79129204 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">ULCAD0379</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759</subfield></datafield><datafield tag="400" ind1="1" ind2="0"><subfield code="a">Haendel, Georges-Frederic,</subfield><subfield code="d">1685-1759</subfield></datafield><datafield tag="400" ind1="1" ind2="0"><subfield code="w">nna</subfield><subfield code="a">Handel, Georg Friedrich,</subfield><subfield code="d">1685-1759</subfield></datafield><datafield tag="400" ind1="1" ind2="0"><subfield code="a">Handel, G. F.</subfield><subfield code="q">(George Frideric),</subfield><subfield code="d">1685-1759</subfield></datafield><datafield tag="400" ind1="1" ind2="0"><subfield code="a">Haendel, G. F.</subfield><subfield code="q">(Georg Friedrich),</subfield><subfield code="d">1685-1759</subfield></datafield><datafield tag="400" ind1="1" ind2="0"><subfield code="a">Haendel, Georg Friedrich,</subfield><subfield code="d">1685-1759</subfield></datafield><datafield tag="400" ind1="1" ind2="0"><subfield code="a">Hendelis, G. F.,</subfield><subfield code="d">1685-1759</subfield></datafield><datafield tag="400" ind1="1" ind2="0"><subfield code="a">Handel, George Frederic,</subfield><subfield code="d">1685-1759</subfield></datafield><datafield tag="400" ind1="1" ind2="0"><subfield code="a">Handel, George Frederick,</subfield><subfield code="d">1685-1759</subfield></datafield><datafield tag="667" ind1=" " ind2=" "><subfield code="a">Thematic catalog numbers are from the Handel-Handbuch.  They are used in uniform titles for types of composition, excluding op. 2-7, and other works as required under AA2 25.31B.  E.g.: Concertos, organ, orchestra, HWV 295, F major; Sonatas, oboe, continuo, HWV 366, C minor; Trio sonatas, violins, continuo, HWV 393, G minor; Suites, harpsichord, HWV 430, E major.</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">His The ways of Zion do mourn, 1979:</subfield><subfield code="b">t.p. (G.F. Handel)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">His The flocks shall leave the mountains, c1988:</subfield><subfield code="b">t.p. (George Frederic Handel)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">AAA4694</subfield></datafield><datafield tag="690" ind1=" " ind2=" "><subfield code="a">chj glob 94/11/24</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">971714</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00698mz  a2200193r  4500</leader><controlfield tag="001">971715</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">19970516191853.0</controlfield><controlfield tag="008">851231nn acannaabn           a aaa     c</controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  85205494 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">ULCAD0380</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">WMUW</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Harpsichord music</subfield></datafield><datafield tag="400" ind1="1" ind2="0"><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Cembalo-Werke</subfield></datafield><datafield tag="400" ind1="1" ind2="0"><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Samtliche Cembalowerke</subfield></datafield><datafield tag="400" ind1="1" ind2="0"><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Clavierwerk</subfield></datafield><datafield tag="400" ind1="1" ind2="0"><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Keyboard works</subfield></datafield><datafield tag="400" ind1="1" ind2="0"><subfield code="w">nna</subfield><subfield code="a">Handel, Georg Friedrich,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Works,</subfield><subfield code="m">harpsichord</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">AAA4404</subfield></datafield><datafield tag="690" ind1=" " ind2=" "><subfield code="a">chj</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">971715</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>01095cz  a2200241n  4500</leader><controlfield tag="001">1022224</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20010117150921.0</controlfield><controlfield tag="008">000428n| acabcaaan          |a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  86731951 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(OCoLC)oca01847712</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield></datafield><datafield tag="050" ind1=" " ind2="0"><subfield code="a">M3</subfield><subfield code="b">.H26 1983 // NOTE: This is not the Barenreiter 1955 edition, for which we are getting added vols.  For that multi-volume set, see bib.#418418.  chj 2001/01/17</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Works.</subfield><subfield code="f">1983</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Hallische Handel-Ausgabe.</subfield><subfield code="f">1983</subfield></datafield><datafield tag="430" ind1=" " ind2="0"><subfield code="a">Hallische Handel-Ausgabe.</subfield><subfield code="f">1983</subfield></datafield><datafield tag="642" ind1=" " ind2=" "><subfield code="a">Ser. 4, Bd. 10/2</subfield><subfield code="5">DLC</subfield></datafield><datafield tag="643" ind1=" " ind2=" "><subfield code="a">Leipzig</subfield><subfield code="b">Deutscher Verlag fur Musik</subfield></datafield><datafield tag="644" ind1=" " ind2=" "><subfield code="a">f</subfield><subfield code="5">DLC</subfield></datafield><datafield tag="645" ind1=" " ind2=" "><subfield code="a">t</subfield><subfield code="5">DLC</subfield></datafield><datafield tag="646" ind1=" " ind2=" "><subfield code="a">c</subfield><subfield code="5">DLC</subfield></datafield><datafield tag="646" ind1=" " ind2=" "><subfield code="a">s</subfield><subfield code="5">DLC</subfield></datafield><datafield tag="667" ind1=" " ind2=" "><subfield code="a">NOTE: This is not the Barenreiter 1955 edition, for which we are getting added vols.  For that multi-volume set, see bib.#418418.     chj 2001/01/17</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel, G.F. Sieben Sonaten fur zwei Violinen und Basso continuo Opus 5 ... 1985:</subfield><subfield code="b">series t.p. (Hallische Handel-Ausgabe)</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1022224</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00674cz  a2200205n  4500</leader><controlfield tag="001">1061944</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20021007152024.0</controlfield><controlfield tag="008">830404n| acabbaaa|          |a ana |||  </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  42010680 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  42010680</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Works.</subfield><subfield code="f">1979</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="w">nnaa</subfield><subfield code="a">Handel, Georg Friedrich,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Works.</subfield><subfield code="k">Selections</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Novello Handel edition.</subfield><subfield code="f">1979</subfield></datafield><datafield tag="430" ind1=" " ind2="0"><subfield code="a">Novello Handel edition.</subfield><subfield code="f">1979</subfield></datafield><datafield tag="643" ind1=" " ind2=" "><subfield code="a">Borough Green, Kent</subfield><subfield code="b">Novello</subfield></datafield><datafield tag="644" ind1=" " ind2=" "><subfield code="a">f</subfield><subfield code="5">DLC</subfield></datafield><datafield tag="645" ind1=" " ind2=" "><subfield code="a">t</subfield><subfield code="5">DLC</subfield></datafield><datafield tag="646" ind1=" " ind2=" "><subfield code="a">s</subfield><subfield code="5">DLC</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel, G. F. The ways of Zion do mourn, 1979.</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1061944</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00864cz  a2200205n  4500</leader><controlfield tag="001">1122009</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060621081535.0</controlfield><controlfield tag="008">811230nn acannaabe           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  81133945 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  81133945</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Concertos,</subfield><subfield code="m">organ, orchestra</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="w">nnaa</subfield><subfield code="a">Handel, Georg Friedrich,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Concertos,</subfield><subfield code="m">organ</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Organ concerti</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Concertos,</subfield><subfield code="m">harpsichord, orchestra</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Concertos,</subfield><subfield code="m">piano, orchestra</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Orgelkonzerte</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Concerti d''organo</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Organ concertos</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1042514</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1122009</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00284nz  a2200097n  4500</leader><controlfield tag="001">1122024</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060621084442.0</controlfield><controlfield tag="008">060621nn acannaaba           n aaa      </controlfield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">CaOWA</subfield><subfield code="c">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Faramondo</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1042514   Handel, George Frideric. Handel, 2004</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1122024</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>01142cz  a2200253n  4500</leader><controlfield tag="001">1122023</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060621083824.0</controlfield><controlfield tag="008">800320nn acannaabn           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  80008124 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(OCoLC)oca00390691</subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  80008124</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="b">eng</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">MoSW-Mu</subfield><subfield code="d">DLC</subfield><subfield code="d">PPi-MA</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Water music</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Musica sull''acqua</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Concertos,</subfield><subfield code="m">orchestra,</subfield><subfield code="n">no. 25</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Wassermusik</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Concerti grossi,</subfield><subfield code="n">no. 25</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Water musick</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Musica sobre el agua</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Handel''s celebrated Water musick compleat</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Water musick compleat</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel, G.F. Water music [SR] 1993?:</subfield><subfield code="b">label (Water music = Wassermusik)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel-Handbuch</subfield><subfield code="b">(348-350. Water music)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1042514</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1122023</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>01950cz  a2200325n  4500</leader><controlfield tag="001">1120293</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060523075720.0</controlfield><controlfield tag="008">820108nn acannaabn           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  81133640 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  81133640</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Suites,</subfield><subfield code="m">harpsichord,</subfield><subfield code="n">HWV 430,</subfield><subfield code="r">E major.</subfield><subfield code="p">Air con variazioni</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Favourite air with variations</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Grobschmied-Variationen</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Harmonious blacksmith</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Aria con variazioni,</subfield><subfield code="m">harpsichord,</subfield><subfield code="n">HWV 430, no. 4,</subfield><subfield code="r">E major</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Herrero armonioso</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="w">nna</subfield><subfield code="a">Handel, Georg Friedrich,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Suite,</subfield><subfield code="m">harpsichord,</subfield><subfield code="n">1st collection, no. 5,</subfield><subfield code="r">E major.</subfield><subfield code="p">Air</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Airs,</subfield><subfield code="m">harpsichord,</subfield><subfield code="n">HWV 430, no. 4,</subfield><subfield code="r">E major</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Air and variations "The harmonious blacksmith"</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Harmonische Grobschmied</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Forgeron harmonieux</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Air and variations,</subfield><subfield code="m">harpsichord,</subfield><subfield code="n">HWV 430, no. 4,</subfield><subfield code="r">E major</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Air with variations,</subfield><subfield code="m">harpsichord,</subfield><subfield code="n">HWV 430, no. 4,</subfield><subfield code="r">E major</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Air con variazioni,</subfield><subfield code="m">harpsichord,</subfield><subfield code="n">HWV 430, no. 4,</subfield><subfield code="r">E major</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Aire and variations "Harmonious blacksmith"</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Harmonious blacksmith variations</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Harmonieux forgeron</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel-Handbuch</subfield><subfield code="b">(430, Suite Nr. 5 E-Dur: 4. Air con variazioni)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1044206</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1120293</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>01132cz  a2200241n  4500</leader><controlfield tag="001">1124603</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060809123207.0</controlfield><controlfield tag="008">840531nn acannaabn           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  84016630 </subfield><subfield code="z">n  82271077 </subfield><subfield code="z">no 97074447 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(OCoLC)oca01115639</subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  84016630</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">MnMpUMNX</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Harpsichord music.</subfield><subfield code="k">Selections</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Virtuoso Handel</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Stucke und Improvisationen</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Music for harpsichord (1733)</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Suites de pieces,</subfield><subfield code="n">2e v.</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Harpsichord pieces from the Aylesford collection</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Piano compositions</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Ausgewahlte Stucke, Klavier zu zwei Handen</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">His The virtuoso Handel [SR] p1982.</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">His Ausgewahlte Stucke, Klavier zu zwei Handen, 1931?</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1050147</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1124603</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00622cz  a2200193n  4500</leader><controlfield tag="001">1125928</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060831075927.0</controlfield><controlfield tag="008">831115nn acannaabn           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  83153234 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  83153234</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Jephtha</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Jephta</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Jeptha</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Handel''s oratorio, Jephtha</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">His Jephta [SR] 197-.</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Bell</subfield><subfield code="b">(Jephtha)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">New Grove</subfield><subfield code="b">(Jephtha)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1051802</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1125928</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>01151cz  a2200217n  4500</leader><controlfield tag="001">1121209</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060612134816.0</controlfield><controlfield tag="008">850207nn acannaabn           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  84183686 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  84183686</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Concertos,</subfield><subfield code="m">oboe, string orchestra,</subfield><subfield code="n">HWV 287,</subfield><subfield code="r">G minor;</subfield><subfield code="o">arr.</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Concertos,</subfield><subfield code="m">bassoon, piano,</subfield><subfield code="r">G minor</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Concertos,</subfield><subfield code="m">trombone, harpsichord,</subfield><subfield code="n">HWV 287,</subfield><subfield code="r">G minor</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Concertos,</subfield><subfield code="m">trombone, harpsichord,</subfield><subfield code="n">B. 5.</subfield><subfield code="n">No. 3</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Sonatas,</subfield><subfield code="m">violoncello, piano,</subfield><subfield code="r">G minor</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Concertos,</subfield><subfield code="m">trombone, piano,</subfield><subfield code="n">HWV 287,</subfield><subfield code="r">F minor</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Concertos,</subfield><subfield code="m">trumpet, piano,</subfield><subfield code="n">HWV 287,</subfield><subfield code="r">F minor</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Sauer, R. Vox Gabrieli [SR] p1983.</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">LC data base, 7/25/86</subfield><subfield code="b">(hdg.: Handel, George Frideric, 1685-1759. Concertos, oboe, string orchestra, B. 5. No. 3; arr.)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1045018</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1121209</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00601cz  a2200181n  4500</leader><controlfield tag="001">1122007</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060621080218.0</controlfield><controlfield tag="008">820628nn acannaabn           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  82066674 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(OCoLC)oca00763509</subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  82066674</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="b">eng</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">PPi-MA</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Messiah</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Messias</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Messie</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel, G.F. The Messiah, c1947.</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Grove music online, Jan. 21, 2004</subfield><subfield code="b">(HWV 56. Messiah)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1042514</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1122007</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>01166cz  a2200265n  4500</leader><controlfield tag="001">1122014</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060621082806.0</controlfield><controlfield tag="008">860604nn acannaabn           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  86134485 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(OCoLC)oca01642232</subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  86134485</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="b">eng</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">OOxM-Mu</subfield><subfield code="d">DLC</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Cantatas.</subfield><subfield code="k">Selections</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Duello amoroso</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Italian cantatas</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Geistliche Kantaten</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Six cantates profanes</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">6 cantates profanes</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Cantates profanes</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Italian secular cantatas</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Latin motets</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Cantatas for alto and continuo</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Arcadian duets</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">His Il duello amoroso [SR] p1985.</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1042514</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1122014</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>01290cz  a2200277n  4500</leader><controlfield tag="001">1122015</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060621083054.0</controlfield><controlfield tag="008">810116nn acannaabn           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  80166824 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(OCoLC)oca00545959</subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  80166824</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="b">eng</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">PPi-MA</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Coronation anthems</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Anthems for the coronation of George II</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Coronation anthems for George II</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Hymnes du couronnement</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Festlieder fur eine Kronung</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Four coronation anthems</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">4 coronation anthems</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Kronungskantaten</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Kronungshymnen fur Konig Georg II</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel, G.F. Four coronation anthems, c1990.</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Bell</subfield><subfield code="b">(78. Coronation anthems for George II)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">New Grove</subfield><subfield code="b">(Coronation anthems)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel-Handbuch</subfield><subfield code="b">(Coronation anthems fur George II; HWV 258-261)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1042514</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1122015</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00928nz  a2200241n  4500</leader><controlfield tag="001">1122008</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060621081243.0</controlfield><controlfield tag="008">870129nn acabaaaan           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  86740906 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  86740906</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Chamber music</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Complete instrumental chamber music of G.F. Handel (1685-1759)</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Instrumental chamber music of G.F. Handel (1685-1759)</subfield></datafield><datafield tag="430" ind1=" " ind2="0"><subfield code="a">Complete instrumental chamber music of G.F. Handel (1685-1759)</subfield></datafield><datafield tag="430" ind1=" " ind2="0"><subfield code="a">Instrumental chamber music of G.F. Handel (1685-1759)</subfield></datafield><datafield tag="642" ind1=" " ind2=" "><subfield code="a">v. 2</subfield><subfield code="5">DLC</subfield></datafield><datafield tag="643" ind1=" " ind2=" "><subfield code="a">London</subfield><subfield code="b">CRD</subfield></datafield><datafield tag="644" ind1=" " ind2=" "><subfield code="a">f</subfield><subfield code="5">DLC</subfield></datafield><datafield tag="645" ind1=" " ind2=" "><subfield code="a">t</subfield><subfield code="5">DLC</subfield></datafield><datafield tag="646" ind1=" " ind2=" "><subfield code="a">s</subfield><subfield code="5">DLC</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel, G. F. The trio sonatas op. 2 for two violins and continuo [SR] p1982:</subfield><subfield code="b">container</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1042514</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1122008</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>01263cz  a2200229n  4500</leader><controlfield tag="001">1122004</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060621080109.0</controlfield><controlfield tag="008">870429nn acannaabn           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  87827713 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(OCoLC)oca01845221</subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  87827713</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="b">eng</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">OCoLC</subfield><subfield code="d">PPi-MA</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Brockes-Passion</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Passion nach Barthold Heinrich Brockes</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Fur die Sunde der Welt gemarterte und sterbende Jesus</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Passionoratorium nach Barthold Heinrich Brockes</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Fur die Sunden der Welt gemarterte und sterbende Jesus</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Passion of Christ</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">His Passion nach Barthold Heinrich Brockes, 1985.</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel-Handbuch</subfield><subfield code="b">(HWV 48. Der fur die Sunde der Welt gemarterte und sterbende Jesus : Passionoratorium nach Barthold Heinrich Brockes. Running title: Brockes-Passion)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Grove music online, Jan. 22, 2004</subfield><subfield code="b">(HWV 48. Der fur die Sunde der Welt gemarterte und sterbende Jesus (Brockes Passion))</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1042514</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1122004</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00552nz  a2200169n  4500</leader><controlfield tag="001">1122005</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060621080139.0</controlfield><controlfield tag="008">950630nn acannaabn           a aaa     c</controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">no 95031605 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(OCoLC)oca03867757</subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)no 95031605</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">MoSW-Mu</subfield><subfield code="c">MoSW-Mu</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Belshazzar</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Belsazar</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel, G.F. Belshazzar [SR] p1991.</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">LC, 6-30-95</subfield><subfield code="b">(hdg.: Handel, George Frideric, 1685-1759. Belshazzar)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1042514</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1122005</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00480nz  a2200157n  4500</leader><controlfield tag="001">1122010</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060621081602.0</controlfield><controlfield tag="008">971216nn acannaabn           n aad     c</controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">no 97072861 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(OCoLC)oca04555559</subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)no 97072861</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">OCoLC</subfield><subfield code="c">OCoLC</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Concerti grossi</subfield></datafield><datafield tag="667" ind1=" " ind2=" "><subfield code="a">Machine-derived authority record.</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">LCCN 81-067183: Handel, G.F. Complete concerti grossi, 1981</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1042514</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1122010</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>01627cz  a2200313n  4500</leader><controlfield tag="001">1122011</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060621081628.0</controlfield><controlfield tag="008">820208nn acannaabn           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  81144352 </subfield><subfield code="z">n  82167597 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(OCoLC)oca00689136</subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  81144352</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="b">eng</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">PPi-MA</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Music for the royal fireworks</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="w">nnaa</subfield><subfield code="a">Handel, Georg Friedrich,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Fireworks music</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Orchesterkonzert Nr. 26</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Feuerwerksmusik</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Royal fireworks music</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Musique pour feux d''artifices royaux</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Boulez conducts Handel</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Fireworks music</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Feuerwerks-Musik</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Musick for the royal fireworks</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Musica per i reali fuochi d''artificio</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Suite for the royal fireworks</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Musica para los reales fuegos articiales</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Music for royal fireworks</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel, G.F. Water music [SR] 1993?:</subfield><subfield code="b">label (Music for the royal fireworks = Feuerwerksmusik)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel-Handbuch</subfield><subfield code="b">(351. Music for the royal fireworks)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1042514</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1122011</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>01749cz  a2200349n  4500</leader><controlfield tag="001">1122013</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060621082605.0</controlfield><controlfield tag="008">810624nn acannaabn           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  81063048 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  81063048</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Deutsche Arien</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="w">nnaa</subfield><subfield code="a">Handel, Georg Friedrich,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Deutsche Arien (ca. 1724-27)</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">9 deutsche Arien</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Neun deutsche Arien</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Neuf airs allemands</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">9 airs allemands</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Airs allemands</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">German arias</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Nine German arias</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">9 German arias</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Devat nemeckych arii</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">9 nemeckych arii</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Nemecke arie</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">9-tsu no Doitsu aria</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Doitsu aria</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Kokonotsu no Doitsu aria</subfield></datafield><datafield tag="667" ind1=" " ind2=" "><subfield code="a">Do not confuse with his [Deutsche Lieder] i.e. 3 deutsche Lieder, B. 3</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">The Baroque bassoon [SR] 1980 (subdiv.)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Bell</subfield><subfield code="b">(79 Neun deutsche Arien)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel-Handbuch, c1978-1986:</subfield><subfield code="b">Bd. 2, p. 625 (HWV 202-210; Neun deutsche Arien; text Barthold Heinrich Brockes)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1042514</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1122013</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00496cz  a2200145n  4500</leader><controlfield tag="001">1122016</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060621083307.0</controlfield><controlfield tag="008">830919nn acannaabn           n aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  83144021 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  83144021</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Rinaldo</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Kubik, R. Handels Rinaldo, c1982 (subj.)</subfield><subfield code="b">t.p. (Handels Rinaldo)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel-Handbuch</subfield><subfield code="b">(HWV 7a, Rinaldo (1. Fassung); HWV 7b, Rinaldo (2./3. Fassung))</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1042514</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1122016</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00404nz  a2200145n  4500</leader><controlfield tag="001">1122017</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060621083335.0</controlfield><controlfield tag="008">811211nn acannaabn           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  81143166 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  81143166</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="c">DLC</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Imeneo</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Hymenaeus</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">His Imeneo, 1980.</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1042514</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1122017</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00475cz  a2200145n  4500</leader><controlfield tag="001">1122019</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060621083415.0</controlfield><controlfield tag="008">820303nn acannaabn           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  82010134 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  82010134</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Acis and Galatea</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">At&#x131;&#x310;s&#x131;&#x310;&#x141;is i Galatei&#x131;&#x310;a&#x131;&#x310;&#x141;</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Acis und Galatea</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1042514</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1122019</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>01276cz  a2200265n  4500</leader><controlfield tag="001">1122021</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060621083722.0</controlfield><controlfield tag="008">861007nn acannaabn           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  86857012 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(OCoLC)oca01696225</subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  86857012</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">MoSW-Mu</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Bohm, Georg,</subfield><subfield code="d">1661-1733.</subfield><subfield code="t">Passion nach dem Evangelisten Johannes</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Passion nach dem Evangelisten Johannes</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Bohm, Georg,</subfield><subfield code="d">1661-1733.</subfield><subfield code="t">Johannes-Passion</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Bohm, Georg,</subfield><subfield code="d">1661-1733.</subfield><subfield code="t">Passion according to Saint John</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Bohm, Georg,</subfield><subfield code="d">1661-1733.</subfield><subfield code="t">Passion according to St. John</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Bohm, Georg,</subfield><subfield code="d">1661-1733.</subfield><subfield code="t">Saint John Passion</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Bohm, Georg,</subfield><subfield code="d">1661-1733.</subfield><subfield code="t">St. John Passion</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Bohm, Georg,</subfield><subfield code="d">1661-1733.</subfield><subfield code="t">Janos-Passio</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">His Passion nach dem Evangelisten Johannes, c1958.</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Bell:</subfield><subfield code="b">p. 394 (?7. St. John Passion (Passion nach dem Evang. Johannes) now generally held to be by a German contemporary (Georg Bohm?) publ. as v. 9 in Handel-Gesellschaft ed.)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">New Grove:</subfield><subfield code="b">v. 2, p. 853 (Bohm, Georg. St. John Passion, 1704; formerly attr. Handel)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1042514</subfield></datafield><datafield tag="675" ind1=" " ind2=" "><subfield code="a">Handel-Handbuch, Bd. 2.</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1122021</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00551nz  a2200157n  4500</leader><controlfield tag="001">1122355</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060626104514.0</controlfield><controlfield tag="008">850614nn acannaabn           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  85006148 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  85006148</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">WMUW</subfield><subfield code="c">DLC</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Floridante.</subfield><subfield code="p">Alma mia</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Alma mia</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Pons, L. Lily Pons [SR] 196-?:</subfield><subfield code="b">label (Floridante (Handel) Alma mia)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel-Handbuch: Bd. 1, Nr. 14</subfield><subfield code="b">(Il Floridante: 5. Alma mia)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1046507</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1122355</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>01368cz  a2200277n  4500</leader><controlfield tag="001">1126991</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060919091850.0</controlfield><controlfield tag="008">880216nn acannaabn           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  88611383 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(OCoLC)oca02204592</subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  88611383</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="b">eng</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">PPi-MA</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Ode for St. Cecilia''s Day</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Ode for Saint Cecilia''s Day</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">From harmony, from heav''nly harmony</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Cacilien-Ode</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Ode a sainte Cecile</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Ode per il giorno di S. Cecilia</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Ode pour la fete de Sainte-Cecile</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Ode on St. Cecilia''s Day</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Cacilienode</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Ode auf St. Caecilia</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">His Ode for St. Cecilia''s Day [SR] p1986.</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel-Handbuch</subfield><subfield code="b">(76. Ode for St. Cecilia''s Day: From harmony, from heav''nly harmony)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">LC data base, 2-16-88</subfield><subfield code="b">(hdg.: Handel, George Frideric, 1685-1759. Ode for St. Cecilia''s Day)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1053542</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1126991</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00682cz  a2200169n  4500</leader><controlfield tag="001">1124749</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060811113547.0</controlfield><controlfield tag="008">830321nn acannaabn           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  83047128 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  83047128</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Orchestra music.</subfield><subfield code="k">Selections</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="w">nna</subfield><subfield code="a">Handel, Georg Friedrich,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Works,</subfield><subfield code="m">orchestra.</subfield><subfield code="k">Selections</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Great orchestral works</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Great concerti and overtures of George Frideric Handel</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Great oboe music</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1050327</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1124749</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00845cz  a2200205n  4500</leader><controlfield tag="001">1125607</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060825110026.0</controlfield><controlfield tag="008">881230nn acannaabn           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  88682588 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(OCoLC)oca02432131</subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  88682588</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">OOC</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Rodelinda.</subfield><subfield code="p">Dove sei? amato bene!</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Dove sei</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Dove sei? amato bene!</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Pompe vane di morte!</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Art thou troubled?</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Drottningholms barockensemble. Barock [SR] 1976:</subfield><subfield code="b">label (Dove sei, ur Rodelinda)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel-Handbuch:</subfield><subfield code="b">v. 1 (19. Rodelinda: 7. Dove sei? amato bene!)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1051289</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1125607</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>01481cz  a2200253n  4500</leader><controlfield tag="001">1125654</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060828080834.0</controlfield><controlfield tag="008">960301nn acannaabn           a aaa     c</controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">no 96010886 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(OCoLC)oca04019648</subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)no 96010886</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">OOC</subfield><subfield code="c">OOC</subfield><subfield code="d">CtY-Mus</subfield><subfield code="d">PU-AML</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Solomon.</subfield><subfield code="p">What though I trace each herb and flow''r</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">What though I trace each herb and flow''r</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">What though I trace each herb</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">What tho'' I trace each herb and flow''r</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Solomon.</subfield><subfield code="p">Blest be the Lord, who look''d with gracious eyes</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Blest be the Lord, who look''d with gracious eyes</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Bless''d be the Lord</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel, G.F. English arias [SR] p1995:</subfield><subfield code="b">container (What though I trace each herb : [from] Solomon)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel-Handbuch, c1984:</subfield><subfield code="b">Bd. 2 (HWV 67, Solomon. 8, Air: What though I trace each herb and flow''r)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel, G. F. Sacred arias [SR] 2001:</subfield><subfield code="b">container (Solomon. Recitatif "Bless''d be the Lord", Air "What though I trace")</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel-Handbuch, c1984:</subfield><subfield code="b">Bd. 2 (HWV 67, Solomon. Recitative: Blest be the Lord; 8, Air: What though I trace each herb and flow''r)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1051332</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1125654</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00909cz  a2200193n  4500</leader><controlfield tag="001">1125930</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060831081144.0</controlfield><controlfield tag="008">890127nn acannaabn           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  89604357 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  89604357</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Tolomeo.</subfield><subfield code="p">Non lo diro col labbro</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Non lo diro col labbro</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Non lo diro col labro</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Silent worship</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">I shall not put into words</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Concert Royal (Musical group : Great Britain). Music at Bowes [SR] p1981:</subfield><subfield code="b">label (Silent worship = Non lo diro col labro [sic]) container (from the opera Ptolemy)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel-Handbuch:</subfield><subfield code="b">Bd. 1 (25. Tolomeo: Non lo diro col labbro)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1051803</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1125930</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>01284cz  a2200217n  4500</leader><controlfield tag="001">1126955</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060918135630.0</controlfield><controlfield tag="008">850624nn acannaabn           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  85023900 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  85023900</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Concerti a due cori</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Concerti a due cori,</subfield><subfield code="n">B. 162-164</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Concerti a due cori,</subfield><subfield code="n">no. 1-3</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Concerti a due cori,</subfield><subfield code="n">HWV 332-334</subfield></datafield><datafield tag="667" ind1=" " ind2=" "><subfield code="a">Catalog as a set</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel, G. Music for the royal fireworks [SR] p1984.</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">New Grove</subfield><subfield code="b">(Concerti a due cori, comp. 1747; no. 1, B&#x301;&#x1AF; major; no. 2, F major; no. 3, F major)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Bell</subfield><subfield code="b">(B. 162, Concerto a due cori in B&#x301;&#x1AF; major; B. 163, Concerto a due cori in F major; B. 164, Concerto a due cori in F major; 1st ed. 1797)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel-Handbuch</subfield><subfield code="b">(332, Concerto (a due cori) B-Dur fur 2 Blaserchore und Streicher (Concerto made from choruses); 333, Concerto (a due cori) F-Dur fur 2 Blaserchore und Streicher; 334, Concerto (a due cori) F-Dur fur 2 Blaserchore und Streicher (Concerto in the oratorio of Judas Maccabaeus))</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1053447</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1126955</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00751nz  a2200181n  4500</leader><controlfield tag="001">1126990</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060919091722.0</controlfield><controlfield tag="008">970211nn acannaabn           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  97014732 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  97014732</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="c">DLC</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Praise of harmony</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Look down, harmonious saint</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Cantate "Praise of harmony"</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Preis der Tonkunst</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Hommage a Teresa Stich-Randall, 1995?:</subfield><subfield code="b">container (Cantate "Praise of harmony")</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel-Handbuch</subfield><subfield code="b">(HWV 124, [The praise of harmony:] Look down, harmonious saint)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1053542</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1126990</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>01237cz  a2200229n  4500</leader><controlfield tag="001">1127488</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060927102056.0</controlfield><controlfield tag="008">860731nn acannaabn           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  86145384 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(OCoLC)oca01651176</subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  86145384</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="b">eng</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">TxU-Mu</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Concertos,</subfield><subfield code="m">oboe, string orchestra,</subfield><subfield code="n">HWV 287,</subfield><subfield code="r">G minor</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Concertos,</subfield><subfield code="m">oboe, string orchestra,</subfield><subfield code="n">no. 1,</subfield><subfield code="r">G minor</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Concertos,</subfield><subfield code="m">oboe, string orchestra,</subfield><subfield code="n">B. 5.</subfield><subfield code="n">No. 3</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Concertos,</subfield><subfield code="m">oboe, string orchestra,</subfield><subfield code="n">no. 3,</subfield><subfield code="r">G minor</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Concerti grossi,</subfield><subfield code="n">no. 10,</subfield><subfield code="r">G minor</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Concertos,</subfield><subfield code="m">flute, string orchestra,</subfield><subfield code="n">HWV 287,</subfield><subfield code="r">G minor</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">His Concerto 1. g-Moll, c1985.</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">LC data base, 7/25/86</subfield><subfield code="b">(hdg.: Handel, George Frideric, 1685-1759. Concertos, oboe, string orchestra, B. 5. No. 3)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel-Handbuch</subfield><subfield code="b">(287, Konzert g-Moll fur Oboe und Orchester (Oboenkonzert Nr. 3); Orchester: v. i, ii, va., cont.)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1054383</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1127488</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>01012cz  a2200205n  4500</leader><controlfield tag="001">1127490</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060927103504.0</controlfield><controlfield tag="008">831216nn acannaabn           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  82235648 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(OCoLC)oca01075447</subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  82235648</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="b">eng</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">PPi-MA</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Trio sonatas,</subfield><subfield code="m">violins, continuo,</subfield><subfield code="n">HWV 393,</subfield><subfield code="r">G minor;</subfield><subfield code="o">arr.</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Sonatas,</subfield><subfield code="m">piano, violas (2),</subfield><subfield code="n">op. 2, no. 8,</subfield><subfield code="r">G minor</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Trio sonatas,</subfield><subfield code="m">violas, continuo,</subfield><subfield code="n">HWV 393,</subfield><subfield code="r">G minor</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Trio sonatas,</subfield><subfield code="m">double basses, continuo,</subfield><subfield code="n">HWV 393,</subfield><subfield code="r">G minor</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Trio sonatas,</subfield><subfield code="m">viole da gamba, continuo,</subfield><subfield code="n">HWV 393,</subfield><subfield code="r">G minor</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">His Sonata in G minor, opus 2, no. 8, for two violas and piano, c1982.</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Bell</subfield><subfield code="b">(68, No. 8; originally for 2 violins and continuo)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1054385</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1127490</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>01297cz  a2200229n  4500</leader><controlfield tag="001">1131831</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20070111124400.0</controlfield><controlfield tag="008">820813nn acannaabn           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  82109757 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(OCoLC)oca00806211</subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  82109757</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="b">eng</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">OOC</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Sonatas,</subfield><subfield code="m">recorder, continuo,</subfield><subfield code="n">HWV 367a,</subfield><subfield code="r">D minor</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Fitzwilliam sonata,</subfield><subfield code="n">no. 3</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Sonatas,</subfield><subfield code="m">recorder, continuo,</subfield><subfield code="n">B. 156, no. 3,</subfield><subfield code="r">D minor</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Sonatas,</subfield><subfield code="m">recorder, continuo,</subfield><subfield code="n">op. 1, no. 9,</subfield><subfield code="r">D minor</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Fitzwilliam-Sonate,</subfield><subfield code="n">no. 3</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Sonatas,</subfield><subfield code="m">flute, continuo,</subfield><subfield code="n">HWV 367a,</subfield><subfield code="r">D minor</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Bruggen, F. Frans Bruggen interpretiert Handel, Bach, Mozart, Hotteterre [SR] p1979:</subfield><subfield code="b">label (Sonate d-Moll fur Blockflote und B.c. : Fitzwilliam-Ms.)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Bell</subfield><subfield code="b">(156. The ''Fitzwilliam'' sonatas for treble recorder and cembalo (with violoncello or viola da gamba ad lib.))</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel-Handbuch</subfield><subfield code="b">(367a, Sonate d-Moll fur Blockflote und B.c. (Fitzwilliam sonata III))</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1060846</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1131831</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>01255cz  a2200241n  4500</leader><controlfield tag="001">1132198</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20070118092606.0</controlfield><controlfield tag="008">910124nn acannaabn           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  91007450 </subfield><subfield code="z">n  94096471 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  91007450</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">CtY-Mus</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Sonatas,</subfield><subfield code="m">violin, continuo,</subfield><subfield code="n">HWV 370,</subfield><subfield code="r">F major;</subfield><subfield code="o">arr.</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Sonatas,</subfield><subfield code="m">marimba, piano,</subfield><subfield code="n">no. 3</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Sonatas,</subfield><subfield code="m">trumpet, piano,</subfield><subfield code="n">no. 3</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Sonatas,</subfield><subfield code="m">horn, piano,</subfield><subfield code="n">HWV 370,</subfield><subfield code="r">F major</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Sonatas,</subfield><subfield code="m">double bass, piano,</subfield><subfield code="n">no. 3,</subfield><subfield code="r">G major</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Sonatas,</subfield><subfield code="m">double bass, piano,</subfield><subfield code="n">HWV 370,</subfield><subfield code="r">G major</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Sonatas,</subfield><subfield code="m">trombone, piano,</subfield><subfield code="n">HWV 370,</subfield><subfield code="r">F major</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Sonatas,</subfield><subfield code="m">trumpet, organ,</subfield><subfield code="r">F major</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">His Third Handel sonata for marimba and piano, c1966.</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">His Sonata no. 3 for trumpet and piano, c1965.</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel Handbuch</subfield><subfield code="b">(370, Sonate F-Dur fur Violine und B.c.)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1061560</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1132198</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00236nz  a2200085O  4500</leader><controlfield tag="001">1003</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">19970725135256.0</controlfield><controlfield tag="008">970601nnbacnnnabbn           a ana     u</controlfield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, Georg Friedrich,</subfield><subfield code="d">1685-1759</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1003</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00192nz  a2200073O  4500</leader><controlfield tag="001">4874</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">19981117195632.0</controlfield><controlfield tag="008">970601 nbacannbabn           a ana     d</controlfield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric, 1685-1759.</subfield><subfield code="x">Operas</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">4874</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00339nz  a2200109O  4500</leader><controlfield tag="001">5158</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">19981117195426.0</controlfield><controlfield tag="008">970601 nbacannbabn           a ana     d</controlfield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759</subfield></datafield><datafield tag="450" ind1=" " ind2=" "><subfield code="a">Handel, Georg Friedrich, 1685-1759</subfield></datafield><datafield tag="450" ind1=" " ind2=" "><subfield code="a">Handel, George Friedrich, 1685-1759</subfield></datafield><datafield tag="450" ind1=" " ind2=" "><subfield code="a">Handel, George Frederick, 1685-1759</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">5158</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00191nz  a2200073O  4500</leader><controlfield tag="001">6184</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">19981117195540.0</controlfield><controlfield tag="008">950228 neanknnbabn           a ana      </controlfield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric, 1685-1759.</subfield><subfield code="x">Humor</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">6184</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00195nz  a2200073O  4500</leader><controlfield tag="001">5344</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">19981117195700.0</controlfield><controlfield tag="008">970601 nbacannbabn           a ana     d</controlfield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric, 1685-1759.</subfield><subfield code="x">Oratorios</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">5344</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00202nz  a2200073O  4500</leader><controlfield tag="001">391686</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">19991117145848.0</controlfield><controlfield tag="008">991117nneadnnnabbn           a aaa     u</controlfield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Samson.</subfield><subfield code="l">English</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">391686</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00203nz  a2200073O  4500</leader><controlfield tag="001">392696</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20011003150856.0</controlfield><controlfield tag="008">011003nneacnnnabbn           a aaa     u</controlfield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Orlando.</subfield><subfield code="l">Italian</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">392696</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>03405cz  a2200505n  4500</leader><controlfield tag="001">943013</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20070927163047.0</controlfield><controlfield tag="008">800624n| acannaabn          |a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  79129204 </subfield><subfield code="z">no 98020932</subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  79129204</subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(OCoLC)oca00360706</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="b">eng</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">CtY-Mus</subfield><subfield code="d">DLC</subfield><subfield code="d">PPi-MA</subfield><subfield code="d">DLC</subfield></datafield><datafield tag="053" ind1=" " ind2="0"><subfield code="a">ML410.H13</subfield><subfield code="c">Biography</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Haendel, Georges-Fr&#xE9;d&#xE9;ric,</subfield><subfield code="d">1685-1759</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Gendel&#x2B9;, Georg Fridrikh,</subfield><subfield code="d">1685-1759</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Khendel, G. F.</subfield><subfield code="q">(Georg Fridrikh),</subfield><subfield code="d">1685-1759</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Khendel, Georg Fridrikh,</subfield><subfield code="d">1685-1759</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="w">nna</subfield><subfield code="a">H&#xE4;ndel, Georg Friedrich,</subfield><subfield code="d">1685-1759</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, G. F.</subfield><subfield code="q">(George Frideric),</subfield><subfield code="d">1685-1759</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Haendel, G. F.</subfield><subfield code="q">(Georg Friedrich),</subfield><subfield code="d">1685-1759</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Haendel, Georg Friedrich,</subfield><subfield code="d">1685-1759</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Gendel&#x2B9;, G. F.</subfield><subfield code="q">(Georg Fridrikh),</subfield><subfield code="d">1685-1759</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, Ge&#x2BC;org-Fridrikh,</subfield><subfield code="d">1685-1759</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Hendelis, G. F.,</subfield><subfield code="d">1685-1759</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Henderu, Georuku Fur&#x12B;dorihhi,</subfield><subfield code="d">1685-1759</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Haendel, George Frideric,</subfield><subfield code="d">1685-1759</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frederick,</subfield><subfield code="d">1685-1759</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Hendel, George Frideric,</subfield><subfield code="d">1685-1759</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Fredrick,</subfield><subfield code="d">1685-1759</subfield></datafield><datafield tag="667" ind1=" " ind2=" "><subfield code="a">Thematic catalog numbers are from the H&#xE4;ndel-Handbuch.  They are used in uniform titles for types of composition, excluding op. 2-7, and other works as required under AACR2 25.31B.  E.g.: Concertos, organ, orchestra, HWV 295, F major; Sonatas, oboe, continuo, HWV 366, C minor; Suites, harpsichord, HWV 430, E major.</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">His The ways of Zion do mourn, 1979:</subfield><subfield code="b">t.p. (G.F. Handel)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">His Georg Friedrich Haendel [SR] 1978:</subfield><subfield code="b">labels (G.F. Haendel)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Sonate au 18&#xE8;me si&#xE8;cle [SR] c1977:</subfield><subfield code="b">labels (Georges-Fr&#xE9;d&#xE9;ric Haendel)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Bach, J.S. Si&#x361;uita no. 2 si minor, V. 1067 [SR] 1968? (a.e.)</subfield><subfield code="b">label (G.F. Gendel&#x2B9;; Georga Fridrikha Gendeli&#x361;a)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Gorali, M. ha-Tanakh bi-yetsirot Ge&#x2BC;org-Fridrikh Handel, c1982:</subfield><subfield code="b">t.p. (Ge&#x2BC;org-Fridrikh Handel)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">His L''Allegro, il Pensieroso ed il Moderato [SR] 1981:</subfield><subfield code="b">labels (G.F. Hendelis)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">His The flocks shall leave the mountains, c1988:</subfield><subfield code="b">t.p. (George Frederic Handel)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Bach, J.S. Sonata za obo&#x12D; i piano v sol minor [SR] 1981?:</subfield><subfield code="b">label (G.Fr. Khendel) container (Georg Fridrikh Khendel)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Botts, T.R. Calligraphic word pictures inspired by the music and text of George Frederick Handel''s Messiah, c1991.</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">His Neun deutsche Arien, 1981:</subfield><subfield code="b">label (H&#xE4;ndel) container (Georg Friedrich H&#xE4;ndel; Georuku Fur&#x12B;dorihhi Henderu)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">S&#xE9;m&#xE9;l&#xE9;, Haendel, 1996:</subfield><subfield code="b">p. 7 (George Frideric Haendel)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">His Bibletone presents the Messiah, 1947?:</subfield><subfield code="b">cover (George Frederick Handel)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">New Grove</subfield><subfield code="b">(Handel (H&#xE4;ndel, Hendel), George Frideric (Georg Friederich (Friedrich)); b. Feb. 23, 1685, Halle, d. Apr. 14, 1759, London; English (naturalized) composer of German birth; "He was baptized Georg Friederich H&#xE4;ndel, the usual spelling of his name in Germany then and now. He used the spelling Hendel in Italy and at first in England, but later always signed himself Handel without the Umlaut; in England he generally used the forms of his first names shown above [i.e. George Frideric]")</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">His Gavotte, c2003:</subfield><subfield code="b">t.p. (George Fredrick Handel)</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">943013</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00721nz  a2200193n  4500</leader><controlfield tag="001">1125726</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060828135509.0</controlfield><controlfield tag="008">860728nn acannaabn           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  86001629 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  86001629</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Scipione</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Scipio</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Scipion</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Publio Cornelio Scipione</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel, G.F. Scipio [SR] 1984:</subfield><subfield code="b">label (Scipio) container (Scipion) insert p. 5 (Scipione)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel-Handbuch</subfield><subfield code="b">(Publio Cornelio Scipione)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">New Grove</subfield><subfield code="b">(Scipione)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1051394</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1125726</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00854cz  a2200217n  4500</leader><controlfield tag="001">1122307</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060626084118.0</controlfield><controlfield tag="008">851004nn acannaabn           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  85064890 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(OCoLC)oca01457052</subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  85064890</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="b">eng</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">CtY-Mus</subfield><subfield code="d">PPi-MA</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Giulio Cesare</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Julius Caesar</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Giulio Cesare in Egitto</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Jules Cesar</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Julius Caesar in Agypten</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">His Julius Caesar [SR] p1985.</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">LC data base, 10-2-85</subfield><subfield code="b">(hdg.: Handel, George Frideric, 1685-1759. Giulio Cesare)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">New Grove</subfield><subfield code="b">(Giulio Cesare)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1046467</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1122307</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00627cz  a2200157n  4500</leader><controlfield tag="001">1127470</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20060927075115.0</controlfield><controlfield tag="008">860117nn acannaabn           a aaa      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  85170584 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  85170584</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Sonatas,</subfield><subfield code="m">violin, continuo,</subfield><subfield code="n">HWV 361,</subfield><subfield code="r">A major;</subfield><subfield code="o">arr.</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Sonatas,</subfield><subfield code="m">viola, piano,</subfield><subfield code="r">A major</subfield></datafield><datafield tag="400" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Sonatas,</subfield><subfield code="m">viola, continuo,</subfield><subfield code="n">HWV 361,</subfield><subfield code="r">A major</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">His Sonata, c1957:</subfield><subfield code="b">cover (Sonata in A major for viola and piano)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1054347</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1127470</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00219nz  a2200073O  4500</leader><controlfield tag="001">390107</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">19971022111554.0</controlfield><controlfield tag="008">971022nneacnnnabbn           a aaa      </controlfield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Funeral anthem for Queen Caroline</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">390107</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00221nz  a2200073O  4500</leader><controlfield tag="001">390118</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">19971022135624.0</controlfield><controlfield tag="008">971022nneacnnnabbn           a aaa     u</controlfield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric,</subfield><subfield code="d">1685-1759.</subfield><subfield code="t">Sonatas, violin, harpsichord, op. 1</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">390118</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00206nz  a2200073O  4500</leader><controlfield tag="001">5160</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">19981117195512.0</controlfield><controlfield tag="008">970601 nbacannbabn           a ana     d</controlfield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric, 1685-1759</subfield><subfield code="x">History and criticism</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">5160</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00213nz  a2200073O  4500</leader><controlfield tag="001">5161</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">19981117195456.0</controlfield><controlfield tag="008">970601 nbacannbabn           a ana     d</controlfield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric, 1685-1759</subfield><subfield code="x">Criticism and interpretation</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">5161</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00193nz  a2200073O  4500</leader><controlfield tag="001">5159</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">19981117195610.0</controlfield><controlfield tag="008">970601 nbacannbabn           a ana     d</controlfield><datafield tag="100" ind1="1" ind2=" "><subfield code="a">Handel, George Frideric, 1685-1759.</subfield><subfield code="x">Messiah</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">5159</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00290nz  a2200097O  4500</leader><controlfield tag="001">1057</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">19970725125544.0</controlfield><controlfield tag="008">970601nnbacnnnabbn           a ana     u</controlfield><datafield tag="110" ind1="2" ind2=" "><subfield code="a">Moscow Philharmonic Symphony Orchestra</subfield></datafield><datafield tag="410" ind1="2" ind2=" "><subfield code="a">Moskovskaia gosudarstvennaia filarmoniia</subfield></datafield><datafield tag="410" ind1="2" ind2=" "><subfield code="a">Moscow Philharmonic Orchestra</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1057</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00748cz  a2200217n  4500</leader><controlfield tag="001">1074870</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20040429140044.0</controlfield><controlfield tag="008">810225nn acannaabn           a ana      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  81014472 </subfield><subfield code="z">n  50053468 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(OCoLC)oca00560354</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="110" ind1="2" ind2=" "><subfield code="a">London Symphony Orchestra</subfield></datafield><datafield tag="410" ind1="2" ind2=" "><subfield code="a">LSO</subfield></datafield><datafield tag="410" ind1="2" ind2=" "><subfield code="a">Orchestre symphonique de Londres</subfield></datafield><datafield tag="410" ind1="2" ind2=" "><subfield code="a">L.S.O.</subfield></datafield><datafield tag="410" ind1="2" ind2=" "><subfield code="a">Londonskii simfonicheskii orkestr</subfield></datafield><datafield tag="410" ind1="2" ind2=" "><subfield code="a">London Symphony Orch.</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Beethoven, L. van. Overtures.</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Liszt, F. Kont&#x131;&#x310;s&#x131;&#x310;&#x141;ert no. 1 ... [SR] 1980:</subfield><subfield code="b">labels (Londonskii simfonicheskii orkestr)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Schumann, R. Concerto in A minor, op. 54 [SR] 194-?:</subfield><subfield code="b">labels (London Symphony Orch.)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">996817</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1074870</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00879cz  a2200217n  4500</leader><controlfield tag="001">1088682</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">20040907094619.0</controlfield><controlfield tag="008">820208nn acannaabn           a ana      </controlfield><datafield tag="010" ind1=" " ind2=" "><subfield code="a">n  81149803 </subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(OCoLC)oca00694555</subfield></datafield><datafield tag="035" ind1=" " ind2=" "><subfield code="a">(DLC)n  81149803</subfield></datafield><datafield tag="040" ind1=" " ind2=" "><subfield code="a">DLC</subfield><subfield code="c">DLC</subfield><subfield code="d">DLC</subfield><subfield code="d">PPi-MA</subfield><subfield code="d">CaOWA</subfield></datafield><datafield tag="110" ind1="2" ind2=" "><subfield code="a">London Symphony Chorus</subfield></datafield><datafield tag="410" ind1="2" ind2=" "><subfield code="w">nna</subfield><subfield code="a">London Symphony Orchestra.</subfield><subfield code="b">Chorus</subfield></datafield><datafield tag="410" ind1="2" ind2=" "><subfield code="a">Khor Londonskogo simf. orkestra</subfield></datafield><datafield tag="410" ind1="2" ind2=" "><subfield code="a">Khor Londonskogo simfonicheskogo orkestra</subfield></datafield><datafield tag="410" ind1="2" ind2=" "><subfield code="a">London Symphony Choir</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Britten, B. [Cantata academica. Latin] [Phonodisc] Cantata academica, 1961.</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Prokofiev, S. Aleksandr Nevskii [SR] 1988, c1976:</subfield><subfield code="b">labels (Khor Londonskogo simf. orkestra) container (Khor Londonskogo simfonicheskogo orkestra)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">Handel, G.F. Messiah [SR] 1987?, p1966:</subfield><subfield code="b">container (London Symphony Choir)</subfield></datafield><datafield tag="670" ind1=" " ind2=" "><subfield code="a">1002413</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">1088682</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id),
('<record    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"    xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd"    xmlns="http://www.loc.gov/MARC21/slim"><leader>00174nz  a2200073O  4500</leader><controlfield tag="001">4266</controlfield><controlfield tag="003">CONIFER</controlfield><controlfield tag="005">19970725125544.0</controlfield><controlfield tag="008">960911nneacnnnabbn          za ana     u</controlfield><datafield tag="110" ind1="2" ind2=" "><subfield code="a">London Symphony Orchestra</subfield></datafield><datafield tag="901" ind1=" " ind2=" "><subfield code="c">4266</subfield><subfield code="t">authority</subfield></datafield></record>', :xact_id)
;
