--Upgrade Script for 2.8.4 to 2.9.0
\set eg_version '''2.9.0'''
BEGIN;
INSERT INTO config.upgrade_log (version, applied_to) VALUES ('2.9.0', :eg_version);

SELECT evergreen.upgrade_deps_block_check('0921', :eg_version);

CREATE TABLE money.account_adjustment (
    billing BIGINT REFERENCES money.billing (id) ON DELETE SET NULL
) INHERITS (money.bnm_payment);
ALTER TABLE money.account_adjustment ADD PRIMARY KEY (id);
CREATE INDEX money_adjustment_id_idx ON money.account_adjustment (id);
CREATE INDEX money_account_adjustment_xact_idx ON money.account_adjustment (xact);
CREATE INDEX money_account_adjustment_bill_idx ON money.account_adjustment (billing);
CREATE INDEX money_account_adjustment_payment_ts_idx ON money.account_adjustment (payment_ts);
CREATE INDEX money_account_adjustment_accepting_usr_idx ON money.account_adjustment (accepting_usr);

CREATE TRIGGER mat_summary_add_tgr AFTER INSERT ON money.account_adjustment FOR EACH ROW EXECUTE PROCEDURE money.materialized_summary_payment_add ('account_adjustment');
CREATE TRIGGER mat_summary_upd_tgr AFTER UPDATE ON money.account_adjustment FOR EACH ROW EXECUTE PROCEDURE money.materialized_summary_payment_update ('account_adjustment');
CREATE TRIGGER mat_summary_del_tgr BEFORE DELETE ON money.account_adjustment FOR EACH ROW EXECUTE PROCEDURE money.materialized_summary_payment_del ('account_adjustment');

-- Insert new org. unit settings.
INSERT INTO config.org_unit_setting_type 
       (name, grp, datatype, label, description)
VALUES
       ('bill.prohibit_negative_balance_default',
        'finance', 'bool',
        oils_i18n_gettext(
            'bill.prohibit_negative_balance_default',
            'Prohibit negative balance on bills (DEFAULT)',
            'coust', 'label'),
        oils_i18n_gettext(
            'bill.prohibit_negative_balance_default',
            'Default setting to prevent negative balances (refunds) on circulation related bills',
            'coust', 'description')
       ),
       ('bill.prohibit_negative_balance_on_overdues',
        'finance', 'bool',
        oils_i18n_gettext(
            'bill.prohibit_negative_balance_on_overdues',
            'Prohibit negative balance on bills for overdue materials',
            'coust', 'label'),
        oils_i18n_gettext(
            'bill.prohibit_negative_balance_on_overdues',
            'Prevent negative balances (refunds) on bills for overdue materials',
            'coust', 'description')
       ),
       ('bill.prohibit_negative_balance_on_lost',
        'finance', 'bool',
        oils_i18n_gettext(
            'bill.prohibit_negative_balance_on_lost',
            'Prohibit negative balance on bills for lost materials',
            'coust', 'label'),
        oils_i18n_gettext(
            'bill.prohibit_negative_balance_on_lost',
            'Prevent negative balances (refunds) on bills for lost/long-overdue materials',
            'coust', 'description')
       ),
       ('bill.negative_balance_interval_default',
        'finance', 'interval',
        oils_i18n_gettext(
            'bill.negative_balance_interval_default',
            'Negative Balance Interval (DEFAULT)',
            'coust', 'label'),
        oils_i18n_gettext(
            'bill.negative_balance_interval_default',
            'Amount of time after which no negative balances (refunds) are allowed on circulation bills',
            'coust', 'description')
       ),
       ('bill.negative_balance_interval_on_overdues',
        'finance', 'interval',
        oils_i18n_gettext(
            'bill.negative_balance_interval_on_overdues',
            'Negative Balance Interval for Overdues',
            'coust', 'label'),
        oils_i18n_gettext(
            'bill.negative_balance_interval_on_overdues',
            'Amount of time after which no negative balances (refunds) are allowed on bills for overdue materials',
            'coust', 'description')
       ),
       ('bill.negative_balance_interval_on_lost',
        'finance', 'interval',
        oils_i18n_gettext(
            'bill.negative_balance_interval_on_lost',
            'Negative Balance Interval for Lost',
            'coust', 'label'),
        oils_i18n_gettext(
            'bill.negative_balance_interval_on_lost',
            'Amount of time after which no negative balances (refunds) are allowed on bills for lost/long overdue materials',
            'coust', 'description')
       );


/* LP#1479953: Adding indexes to foreign key references to
 * vandelay.queued_bib_record will speed up deletions of vqbr records (thereby
 * speeding up vandelay.bib_queue deletions).
 */

SELECT evergreen.upgrade_deps_block_check('0922', :eg_version);

CREATE INDEX acq_lineitem_history_queued_record_idx ON acq.acq_lineitem_history (queued_record);
CREATE INDEX li_queued_record_idx ON acq.lineitem (queued_record);
CREATE INDEX bib_match_queued_record_idx ON vandelay.bib_match (queued_record);
CREATE INDEX import_item_record_idx ON vandelay.import_item (record);

-- Include bib source in XML returned by unapi.bre.

-- check whether patch can be applied
SELECT evergreen.upgrade_deps_block_check('0923', :eg_version);

CREATE OR REPLACE FUNCTION unapi.cbs ( obj_id BIGINT, format TEXT,  ename TEXT, includes TEXT[], org TEXT, depth INT DEFAULT NULL, slimit HSTORE DEFAULT NULL, soffset HSTORE DEFAULT NULL, include_xmlns BOOL DEFAULT TRUE ) RETURNS XML AS $F$
    SELECT  XMLELEMENT(
                name bib_source,
                XMLATTRIBUTES(
                    NULL AS xmlns, -- TODO needs equivalent to http://open-ils.org/spec/holdings/v1
                    id AS ident,
                    quality,
                    transcendant,
                    can_have_copies
                ),
                source
            )
      FROM  config.bib_source
      WHERE id = $1;
$F$ LANGUAGE SQL STABLE;

CREATE OR REPLACE FUNCTION unapi.bre (
    obj_id BIGINT,
    format TEXT,
    ename TEXT,
    includes TEXT[],
    org TEXT,
    depth INT DEFAULT NULL,
    slimit HSTORE DEFAULT NULL,
    soffset HSTORE DEFAULT NULL,
    include_xmlns BOOL DEFAULT TRUE,
    pref_lib INT DEFAULT NULL
)
RETURNS XML AS $F$
DECLARE
    me      biblio.record_entry%ROWTYPE;
    layout  unapi.bre_output_layout%ROWTYPE;
    xfrm    config.xml_transform%ROWTYPE;
    ouid    INT;
    tmp_xml TEXT;
    top_el  TEXT;
    output  XML;
    hxml    XML;
    axml    XML;
    source  XML;
BEGIN

    IF org = '-' OR org IS NULL THEN
        SELECT shortname INTO org FROM evergreen.org_top();
    END IF;

    SELECT id INTO ouid FROM actor.org_unit WHERE shortname = org;

    IF ouid IS NULL THEN
        RETURN NULL::XML;
    END IF;

    IF format = 'holdings_xml' THEN -- the special case
        output := unapi.holdings_xml( obj_id, ouid, org, depth, includes, slimit, soffset, include_xmlns);
        RETURN output;
    END IF;

    SELECT * INTO layout FROM unapi.bre_output_layout WHERE name = format;

    IF layout.name IS NULL THEN
        RETURN NULL::XML;
    END IF;

    SELECT * INTO xfrm FROM config.xml_transform WHERE name = layout.transform;

    SELECT * INTO me FROM biblio.record_entry WHERE id = obj_id;

    -- grab bib_source, if any
    IF ('cbs' = ANY (includes) AND me.source IS NOT NULL) THEN
        source := unapi.cbs(me.source,NULL,NULL,NULL,NULL);
    ELSE
        source := NULL::XML;
    END IF;

    -- grab SVF if we need them
    IF ('mra' = ANY (includes)) THEN 
        axml := unapi.mra(obj_id,NULL,NULL,NULL,NULL);
    ELSE
        axml := NULL::XML;
    END IF;

    -- grab holdings if we need them
    IF ('holdings_xml' = ANY (includes)) THEN 
        hxml := unapi.holdings_xml(obj_id, ouid, org, depth, evergreen.array_remove_item_by_value(includes,'holdings_xml'), slimit, soffset, include_xmlns, pref_lib);
    ELSE
        hxml := NULL::XML;
    END IF;


    -- generate our item node


    IF format = 'marcxml' THEN
        tmp_xml := me.marc;
        IF tmp_xml !~ E'<marc:' THEN -- If we're not using the prefixed namespace in this record, then remove all declarations of it
           tmp_xml := REGEXP_REPLACE(tmp_xml, ' xmlns:marc="http://www.loc.gov/MARC21/slim"', '', 'g');
        END IF; 
    ELSE
        tmp_xml := oils_xslt_process(me.marc, xfrm.xslt)::XML;
    END IF;

    top_el := REGEXP_REPLACE(tmp_xml, E'^.*?<((?:\\S+:)?' || layout.holdings_element || ').*$', E'\\1');

    IF source IS NOT NULL THEN
        tmp_xml := REGEXP_REPLACE(tmp_xml, '</' || top_el || '>(.*?)$', source || '</' || top_el || E'>\\1');
    END IF;

    IF axml IS NOT NULL THEN 
        tmp_xml := REGEXP_REPLACE(tmp_xml, '</' || top_el || '>(.*?)$', axml || '</' || top_el || E'>\\1');
    END IF;

    IF hxml IS NOT NULL THEN -- XXX how do we configure the holdings position?
        tmp_xml := REGEXP_REPLACE(tmp_xml, '</' || top_el || '>(.*?)$', hxml || '</' || top_el || E'>\\1');
    END IF;

    IF ('bre.unapi' = ANY (includes)) THEN 
        output := REGEXP_REPLACE(
            tmp_xml,
            '</' || top_el || '>(.*?)',
            XMLELEMENT(
                name abbr,
                XMLATTRIBUTES(
                    'http://www.w3.org/1999/xhtml' AS xmlns,
                    'unapi-id' AS class,
                    'tag:open-ils.org:U2@bre/' || obj_id || '/' || org AS title
                )
            )::TEXT || '</' || top_el || E'>\\1'
        );
    ELSE
        output := tmp_xml;
    END IF;

    output := REGEXP_REPLACE(output::TEXT,E'>\\s+<','><','gs')::XML;
    RETURN output;
END;
$F$ LANGUAGE PLPGSQL STABLE;


SELECT evergreen.upgrade_deps_block_check('0928', :eg_version);

CREATE OR REPLACE FUNCTION oils_xpath_tag_to_table(marc text, tag text, xpaths text[]) RETURNS SETOF record AS $function$

-- This function currently populates columns with the FIRST matching value
-- of each XPATH.  It would be reasonable to add a 'return_arrays' option
-- where each column is an array of all matching values for each path, but
-- that remains as a TODO

DECLARE
    field RECORD;
    output RECORD;
    select_list TEXT[];
    from_list TEXT[];
    q TEXT;
BEGIN
    -- setup query select
    FOR i IN 1 .. ARRAY_UPPER(xpaths,1) LOOP
        IF xpaths[i] = 'null()' THEN
            select_list := ARRAY_APPEND(select_list, 'NULL::TEXT AS c_' || i );
        ELSE
            select_list := ARRAY_APPEND(select_list, '(oils_xpath(' ||
                quote_literal(
                    CASE
                        WHEN xpaths[i] ~ $re$/[^/[]*@[^/]+$$re$ -- attribute
                            OR xpaths[i] ~ $re$text\(\)$$re$
                        THEN xpaths[i]
                        ELSE xpaths[i] || '//text()'
                    END
                ) || ', field_marc))[1] AS cl_' || i);
                -- hardcoded to first value for each path
        END IF;
    END LOOP;

    -- run query over tag set
    q := 'SELECT ' || ARRAY_TO_STRING(select_list, ',')
        || ' FROM UNNEST(oils_xpath(' || quote_literal('//*[@tag="' || tag
        || '"]') || ', ' || quote_literal(marc) || ')) AS field_marc;';
    --RAISE NOTICE '%', q;

    RETURN QUERY EXECUTE q;
END;

$function$ LANGUAGE PLPGSQL;


SELECT evergreen.upgrade_deps_block_check('0929', :eg_version);

INSERT INTO vandelay.import_error ( code, description ) VALUES (
    'import.item.invalid.stat_cat_format', oils_i18n_gettext('import.item.invalid.stat_cat_format', 'Bad format for stat cat data, should be like: CAT 1|VALUE 1', 'vie', 'description') );
INSERT INTO vandelay.import_error ( code, description ) VALUES (
    'import.item.invalid.stat_cat_data', oils_i18n_gettext('import.item.invalid.stat_cat_data', 'Invalid stat cat data', 'vie', 'description') );

ALTER TABLE vandelay.import_item_attr_definition
    ADD COLUMN stat_cat_data TEXT;

ALTER TABLE vandelay.import_item
    ADD COLUMN stat_cat_data TEXT;

CREATE OR REPLACE FUNCTION vandelay.ingest_items ( import_id BIGINT, attr_def_id BIGINT ) RETURNS SETOF vandelay.import_item AS $$
DECLARE

    owning_lib      TEXT;
    circ_lib        TEXT;
    call_number     TEXT;
    copy_number     TEXT;
    status          TEXT;
    location        TEXT;
    circulate       TEXT;
    deposit         TEXT;
    deposit_amount  TEXT;
    ref             TEXT;
    holdable        TEXT;
    price           TEXT;
    barcode         TEXT;
    circ_modifier   TEXT;
    circ_as_type    TEXT;
    alert_message   TEXT;
    opac_visible    TEXT;
    pub_note        TEXT;
    priv_note       TEXT;
    internal_id     TEXT;
    stat_cat_data   TEXT;

    attr_def        RECORD;
    tmp_attr_set    RECORD;
    attr_set        vandelay.import_item%ROWTYPE;

    xpaths          TEXT[];
    tmp_str         TEXT;

BEGIN

    SELECT * INTO attr_def FROM vandelay.import_item_attr_definition WHERE id = attr_def_id;

    IF FOUND THEN

        attr_set.definition := attr_def.id;

        -- Build the combined XPath

        owning_lib :=
            CASE
                WHEN attr_def.owning_lib IS NULL THEN 'null()'
                WHEN LENGTH( attr_def.owning_lib ) = 1 THEN '*[@code="' || attr_def.owning_lib || '"]'
                ELSE '*' || attr_def.owning_lib
            END;

        circ_lib :=
            CASE
                WHEN attr_def.circ_lib IS NULL THEN 'null()'
                WHEN LENGTH( attr_def.circ_lib ) = 1 THEN '*[@code="' || attr_def.circ_lib || '"]'
                ELSE '*' || attr_def.circ_lib
            END;

        call_number :=
            CASE
                WHEN attr_def.call_number IS NULL THEN 'null()'
                WHEN LENGTH( attr_def.call_number ) = 1 THEN '*[@code="' || attr_def.call_number || '"]'
                ELSE '*' || attr_def.call_number
            END;

        copy_number :=
            CASE
                WHEN attr_def.copy_number IS NULL THEN 'null()'
                WHEN LENGTH( attr_def.copy_number ) = 1 THEN '*[@code="' || attr_def.copy_number || '"]'
                ELSE '*' || attr_def.copy_number
            END;

        status :=
            CASE
                WHEN attr_def.status IS NULL THEN 'null()'
                WHEN LENGTH( attr_def.status ) = 1 THEN '*[@code="' || attr_def.status || '"]'
                ELSE '*' || attr_def.status
            END;

        location :=
            CASE
                WHEN attr_def.location IS NULL THEN 'null()'
                WHEN LENGTH( attr_def.location ) = 1 THEN '*[@code="' || attr_def.location || '"]'
                ELSE '*' || attr_def.location
            END;

        circulate :=
            CASE
                WHEN attr_def.circulate IS NULL THEN 'null()'
                WHEN LENGTH( attr_def.circulate ) = 1 THEN '*[@code="' || attr_def.circulate || '"]'
                ELSE '*' || attr_def.circulate
            END;

        deposit :=
            CASE
                WHEN attr_def.deposit IS NULL THEN 'null()'
                WHEN LENGTH( attr_def.deposit ) = 1 THEN '*[@code="' || attr_def.deposit || '"]'
                ELSE '*' || attr_def.deposit
            END;

        deposit_amount :=
            CASE
                WHEN attr_def.deposit_amount IS NULL THEN 'null()'
                WHEN LENGTH( attr_def.deposit_amount ) = 1 THEN '*[@code="' || attr_def.deposit_amount || '"]'
                ELSE '*' || attr_def.deposit_amount
            END;

        ref :=
            CASE
                WHEN attr_def.ref IS NULL THEN 'null()'
                WHEN LENGTH( attr_def.ref ) = 1 THEN '*[@code="' || attr_def.ref || '"]'
                ELSE '*' || attr_def.ref
            END;

        holdable :=
            CASE
                WHEN attr_def.holdable IS NULL THEN 'null()'
                WHEN LENGTH( attr_def.holdable ) = 1 THEN '*[@code="' || attr_def.holdable || '"]'
                ELSE '*' || attr_def.holdable
            END;

        price :=
            CASE
                WHEN attr_def.price IS NULL THEN 'null()'
                WHEN LENGTH( attr_def.price ) = 1 THEN '*[@code="' || attr_def.price || '"]'
                ELSE '*' || attr_def.price
            END;

        barcode :=
            CASE
                WHEN attr_def.barcode IS NULL THEN 'null()'
                WHEN LENGTH( attr_def.barcode ) = 1 THEN '*[@code="' || attr_def.barcode || '"]'
                ELSE '*' || attr_def.barcode
            END;

        circ_modifier :=
            CASE
                WHEN attr_def.circ_modifier IS NULL THEN 'null()'
                WHEN LENGTH( attr_def.circ_modifier ) = 1 THEN '*[@code="' || attr_def.circ_modifier || '"]'
                ELSE '*' || attr_def.circ_modifier
            END;

        circ_as_type :=
            CASE
                WHEN attr_def.circ_as_type IS NULL THEN 'null()'
                WHEN LENGTH( attr_def.circ_as_type ) = 1 THEN '*[@code="' || attr_def.circ_as_type || '"]'
                ELSE '*' || attr_def.circ_as_type
            END;

        alert_message :=
            CASE
                WHEN attr_def.alert_message IS NULL THEN 'null()'
                WHEN LENGTH( attr_def.alert_message ) = 1 THEN '*[@code="' || attr_def.alert_message || '"]'
                ELSE '*' || attr_def.alert_message
            END;

        opac_visible :=
            CASE
                WHEN attr_def.opac_visible IS NULL THEN 'null()'
                WHEN LENGTH( attr_def.opac_visible ) = 1 THEN '*[@code="' || attr_def.opac_visible || '"]'
                ELSE '*' || attr_def.opac_visible
            END;

        pub_note :=
            CASE
                WHEN attr_def.pub_note IS NULL THEN 'null()'
                WHEN LENGTH( attr_def.pub_note ) = 1 THEN '*[@code="' || attr_def.pub_note || '"]'
                ELSE '*' || attr_def.pub_note
            END;
        priv_note :=
            CASE
                WHEN attr_def.priv_note IS NULL THEN 'null()'
                WHEN LENGTH( attr_def.priv_note ) = 1 THEN '*[@code="' || attr_def.priv_note || '"]'
                ELSE '*' || attr_def.priv_note
            END;

        internal_id :=
            CASE
                WHEN attr_def.internal_id IS NULL THEN 'null()'
                WHEN LENGTH( attr_def.internal_id ) = 1 THEN '*[@code="' || attr_def.internal_id || '"]'
                ELSE '*' || attr_def.internal_id
            END;

        stat_cat_data :=
            CASE
                WHEN attr_def.stat_cat_data IS NULL THEN 'null()'
                WHEN LENGTH( attr_def.stat_cat_data ) = 1 THEN '*[@code="' || attr_def.stat_cat_data || '"]'
                ELSE '*' || attr_def.stat_cat_data
            END;



        xpaths := ARRAY[owning_lib, circ_lib, call_number, copy_number, status, location, circulate,
                        deposit, deposit_amount, ref, holdable, price, barcode, circ_modifier, circ_as_type,
                        alert_message, pub_note, priv_note, internal_id, stat_cat_data, opac_visible];

        FOR tmp_attr_set IN
                SELECT  *
                  FROM  oils_xpath_tag_to_table( (SELECT marc FROM vandelay.queued_bib_record WHERE id = import_id), attr_def.tag, xpaths)
                            AS t( ol TEXT, clib TEXT, cn TEXT, cnum TEXT, cs TEXT, cl TEXT, circ TEXT,
                                  dep TEXT, dep_amount TEXT, r TEXT, hold TEXT, pr TEXT, bc TEXT, circ_mod TEXT,
                                  circ_as TEXT, amessage TEXT, note TEXT, pnote TEXT, internal_id TEXT,
                                  stat_cat_data TEXT, opac_vis TEXT )
        LOOP

            attr_set.import_error := NULL;
            attr_set.error_detail := NULL;
            attr_set.deposit_amount := NULL;
            attr_set.copy_number := NULL;
            attr_set.price := NULL;
            attr_set.circ_modifier := NULL;
            attr_set.location := NULL;
            attr_set.barcode := NULL;
            attr_set.call_number := NULL;

            IF tmp_attr_set.pr != '' THEN
                tmp_str = REGEXP_REPLACE(tmp_attr_set.pr, E'[^0-9\\.]', '', 'g');
                IF tmp_str = '' THEN
                    attr_set.import_error := 'import.item.invalid.price';
                    attr_set.error_detail := tmp_attr_set.pr; -- original value
                    RETURN NEXT attr_set; CONTINUE;
                END IF;
                attr_set.price := tmp_str::NUMERIC(8,2);
            END IF;

            IF tmp_attr_set.dep_amount != '' THEN
                tmp_str = REGEXP_REPLACE(tmp_attr_set.dep_amount, E'[^0-9\\.]', '', 'g');
                IF tmp_str = '' THEN
                    attr_set.import_error := 'import.item.invalid.deposit_amount';
                    attr_set.error_detail := tmp_attr_set.dep_amount;
                    RETURN NEXT attr_set; CONTINUE;
                END IF;
                attr_set.deposit_amount := tmp_str::NUMERIC(8,2);
            END IF;

            IF tmp_attr_set.cnum != '' THEN
                tmp_str = REGEXP_REPLACE(tmp_attr_set.cnum, E'[^0-9]', '', 'g');
                IF tmp_str = '' THEN
                    attr_set.import_error := 'import.item.invalid.copy_number';
                    attr_set.error_detail := tmp_attr_set.cnum;
                    RETURN NEXT attr_set; CONTINUE;
                END IF;
                attr_set.copy_number := tmp_str::INT;
            END IF;

            IF tmp_attr_set.ol != '' THEN
                SELECT id INTO attr_set.owning_lib FROM actor.org_unit WHERE shortname = UPPER(tmp_attr_set.ol); -- INT
                IF NOT FOUND THEN
                    attr_set.import_error := 'import.item.invalid.owning_lib';
                    attr_set.error_detail := tmp_attr_set.ol;
                    RETURN NEXT attr_set; CONTINUE;
                END IF;
            END IF;

            IF tmp_attr_set.clib != '' THEN
                SELECT id INTO attr_set.circ_lib FROM actor.org_unit WHERE shortname = UPPER(tmp_attr_set.clib); -- INT
                IF NOT FOUND THEN
                    attr_set.import_error := 'import.item.invalid.circ_lib';
                    attr_set.error_detail := tmp_attr_set.clib;
                    RETURN NEXT attr_set; CONTINUE;
                END IF;
            END IF;

            IF tmp_attr_set.cs != '' THEN
                SELECT id INTO attr_set.status FROM config.copy_status WHERE LOWER(name) = LOWER(tmp_attr_set.cs); -- INT
                IF NOT FOUND THEN
                    attr_set.import_error := 'import.item.invalid.status';
                    attr_set.error_detail := tmp_attr_set.cs;
                    RETURN NEXT attr_set; CONTINUE;
                END IF;
            END IF;

            IF COALESCE(tmp_attr_set.circ_mod, '') = '' THEN

                -- no circ mod defined, see if we should apply a default
                SELECT INTO attr_set.circ_modifier TRIM(BOTH '"' FROM value)
                    FROM actor.org_unit_ancestor_setting(
                        'vandelay.item.circ_modifier.default',
                        attr_set.owning_lib
                    );

                -- make sure the value from the org setting is still valid
                PERFORM 1 FROM config.circ_modifier WHERE code = attr_set.circ_modifier;
                IF NOT FOUND THEN
                    attr_set.import_error := 'import.item.invalid.circ_modifier';
                    attr_set.error_detail := tmp_attr_set.circ_mod;
                    RETURN NEXT attr_set; CONTINUE;
                END IF;

            ELSE

                SELECT code INTO attr_set.circ_modifier FROM config.circ_modifier WHERE code = tmp_attr_set.circ_mod;
                IF NOT FOUND THEN
                    attr_set.import_error := 'import.item.invalid.circ_modifier';
                    attr_set.error_detail := tmp_attr_set.circ_mod;
                    RETURN NEXT attr_set; CONTINUE;
                END IF;
            END IF;

            IF tmp_attr_set.circ_as != '' THEN
                SELECT code INTO attr_set.circ_as_type FROM config.coded_value_map WHERE ctype = 'item_type' AND code = tmp_attr_set.circ_as;
                IF NOT FOUND THEN
                    attr_set.import_error := 'import.item.invalid.circ_as_type';
                    attr_set.error_detail := tmp_attr_set.circ_as;
                    RETURN NEXT attr_set; CONTINUE;
                END IF;
            END IF;

            IF COALESCE(tmp_attr_set.cl, '') = '' THEN
                -- no location specified, see if we should apply a default

                SELECT INTO attr_set.location TRIM(BOTH '"' FROM value)
                    FROM actor.org_unit_ancestor_setting(
                        'vandelay.item.copy_location.default',
                        attr_set.owning_lib
                    );

                -- make sure the value from the org setting is still valid
                PERFORM 1 FROM asset.copy_location WHERE id = attr_set.location;
                IF NOT FOUND THEN
                    attr_set.import_error := 'import.item.invalid.location';
                    attr_set.error_detail := tmp_attr_set.cs;
                    RETURN NEXT attr_set; CONTINUE;
                END IF;
            ELSE

                -- search up the org unit tree for a matching copy location
                WITH RECURSIVE anscestor_depth AS (
                    SELECT  ou.id,
                        out.depth AS depth,
                        ou.parent_ou
                    FROM  actor.org_unit ou
                        JOIN actor.org_unit_type out ON (out.id = ou.ou_type)
                    WHERE ou.id = COALESCE(attr_set.owning_lib, attr_set.circ_lib)
                        UNION ALL
                    SELECT  ou.id,
                        out.depth,
                        ou.parent_ou
                    FROM  actor.org_unit ou
                        JOIN actor.org_unit_type out ON (out.id = ou.ou_type)
                        JOIN anscestor_depth ot ON (ot.parent_ou = ou.id)
                ) SELECT  cpl.id INTO attr_set.location
                    FROM  anscestor_depth a
                        JOIN asset.copy_location cpl ON (cpl.owning_lib = a.id)
                    WHERE LOWER(cpl.name) = LOWER(tmp_attr_set.cl)
                    ORDER BY a.depth DESC
                    LIMIT 1;

                IF NOT FOUND THEN
                    attr_set.import_error := 'import.item.invalid.location';
                    attr_set.error_detail := tmp_attr_set.cs;
                    RETURN NEXT attr_set; CONTINUE;
                END IF;
            END IF;

            attr_set.circulate      :=
                LOWER( SUBSTRING( tmp_attr_set.circ, 1, 1)) IN ('t','y','1')
                OR LOWER(tmp_attr_set.circ) = 'circulating'; -- BOOL

            attr_set.deposit        :=
                LOWER( SUBSTRING( tmp_attr_set.dep, 1, 1 ) ) IN ('t','y','1')
                OR LOWER(tmp_attr_set.dep) = 'deposit'; -- BOOL

            attr_set.holdable       :=
                LOWER( SUBSTRING( tmp_attr_set.hold, 1, 1 ) ) IN ('t','y','1')
                OR LOWER(tmp_attr_set.hold) = 'holdable'; -- BOOL

            attr_set.opac_visible   :=
                LOWER( SUBSTRING( tmp_attr_set.opac_vis, 1, 1 ) ) IN ('t','y','1')
                OR LOWER(tmp_attr_set.opac_vis) = 'visible'; -- BOOL

            attr_set.ref            :=
                LOWER( SUBSTRING( tmp_attr_set.r, 1, 1 ) ) IN ('t','y','1')
                OR LOWER(tmp_attr_set.r) = 'reference'; -- BOOL

            attr_set.call_number    := tmp_attr_set.cn; -- TEXT
            attr_set.barcode        := tmp_attr_set.bc; -- TEXT,
            attr_set.alert_message  := tmp_attr_set.amessage; -- TEXT,
            attr_set.pub_note       := tmp_attr_set.note; -- TEXT,
            attr_set.priv_note      := tmp_attr_set.pnote; -- TEXT,
            attr_set.alert_message  := tmp_attr_set.amessage; -- TEXT,
            attr_set.internal_id    := tmp_attr_set.internal_id::BIGINT;
            attr_set.stat_cat_data  := tmp_attr_set.stat_cat_data; -- TEXT,

            RETURN NEXT attr_set;

        END LOOP;

    END IF;

    RETURN;

END;
$$ LANGUAGE PLPGSQL;

CREATE OR REPLACE FUNCTION vandelay.ingest_bib_items ( ) RETURNS TRIGGER AS $func$
DECLARE
    attr_def    BIGINT;
    item_data   vandelay.import_item%ROWTYPE;
BEGIN

    IF TG_OP IN ('INSERT','UPDATE') AND NEW.imported_as IS NOT NULL THEN
        RETURN NEW;
    END IF;

    SELECT item_attr_def INTO attr_def FROM vandelay.bib_queue WHERE id = NEW.queue;

    FOR item_data IN SELECT * FROM vandelay.ingest_items( NEW.id::BIGINT, attr_def ) LOOP
        INSERT INTO vandelay.import_item (
            record,
            definition,
            owning_lib,
            circ_lib,
            call_number,
            copy_number,
            status,
            location,
            circulate,
            deposit,
            deposit_amount,
            ref,
            holdable,
            price,
            barcode,
            circ_modifier,
            circ_as_type,
            alert_message,
            pub_note,
            priv_note,
            internal_id,
            opac_visible,
            stat_cat_data,
            import_error,
            error_detail
        ) VALUES (
            NEW.id,
            item_data.definition,
            item_data.owning_lib,
            item_data.circ_lib,
            item_data.call_number,
            item_data.copy_number,
            item_data.status,
            item_data.location,
            item_data.circulate,
            item_data.deposit,
            item_data.deposit_amount,
            item_data.ref,
            item_data.holdable,
            item_data.price,
            item_data.barcode,
            item_data.circ_modifier,
            item_data.circ_as_type,
            item_data.alert_message,
            item_data.pub_note,
            item_data.priv_note,
            item_data.internal_id,
            item_data.opac_visible,
            item_data.stat_cat_data,
            item_data.import_error,
            item_data.error_detail
        );
    END LOOP;

    RETURN NULL;
END;
$func$ LANGUAGE PLPGSQL;


SELECT evergreen.upgrade_deps_block_check('0930', :eg_version);

ALTER TABLE acq.invoice_item_type
    ADD COLUMN blanket BOOLEAN NOT NULL DEFAULT FALSE,
    ADD CONSTRAINT aiit_not_blanket_and_prorate
        CHECK (blanket IS FALSE OR prorate IS FALSE);


SELECT evergreen.upgrade_deps_block_check('0931', :eg_version);

INSERT INTO acq.invoice_item_type (code, blanket, name) VALUES (
    'BLA', TRUE, oils_i18n_gettext('BLA', 'Blanket Order', 'aiit', 'name'));


SELECT evergreen.upgrade_deps_block_check('0932', :eg_version);

UPDATE config.org_unit_setting_type 
    SET description = 'Default setting to prevent negative balances (refunds) on circulation related bills. Set to "true" to prohibit negative balances at all times or, when used in conjunction with an interval setting, to prohibit negative balances after a set period of time.'
    WHERE name = 'bill.prohibit_negative_balance_default';
UPDATE config.org_unit_setting_type
    SET description = 'Prevent negative balances (refunds) on bills for overdue materials. Set to "true" to prohibit negative balances at all times or, when used in conjunction with an interval setting, to prohibit negative balances after a set period of time.'
    WHERE name = 'bill.prohibit_negative_balance_on_overdues';
UPDATE config.org_unit_setting_type
    SET description = 'Prohibit negative balance on bills for lost materials. Set to "true" to prohibit negative balances at all times or, when used in conjunction with an interval setting, to prohibit negative balances after a set period of time.'
    WHERE name = 'bill.prohibit_negative_balance_on_lost';
UPDATE config.org_unit_setting_type
    SET description = 'Amount of time after which no negative balances (refunds) are allowed on circulation bills. The "Prohibit negative balance on bills" setting must also be set to "true".'
    WHERE name = 'bill.negative_balance_interval_default';
UPDATE config.org_unit_setting_type
    SET description = 'Amount of time after which no negative balances (refunds) are allowed on bills for overdue materials. The "Prohibit negative balance on bills for overdue materials" setting must also be set to "true".'
    WHERE name = 'bill.negative_balance_interval_on_overdues';
UPDATE config.org_unit_setting_type
    SET description = 'Amount of time after which no negative balances (refunds) are allowed on bills for lost/long overdue materials. The "Prohibit negative balance on bills for lost materials" setting must also be set to "true".'
    WHERE name = 'bill.negative_balance_interval_on_lost';




SELECT evergreen.upgrade_deps_block_check('0933', :eg_version);


CREATE TABLE config.marc_format (
    id                  SERIAL PRIMARY KEY,
    code                TEXT NOT NULL,
    name                TEXT NOT NULL
);
COMMENT ON TABLE config.marc_format IS $$
List of MARC formats supported by this Evergreen
database. This exists primarily as a hook for future
support of UNIMARC, though whether that will ever
happen remains to be seen.
$$;

CREATE TYPE config.marc_record_type AS ENUM ('biblio', 'authority', 'serial');

CREATE TABLE config.marc_field (
    id                  SERIAL PRIMARY KEY,
    marc_format         INTEGER NOT NULL
                        REFERENCES config.marc_format (id) DEFERRABLE INITIALLY DEFERRED,
    marc_record_type    config.marc_record_type NOT NULL,
    tag                 CHAR(3) NOT NULL,
    name                TEXT,
    description         TEXT,
    fixed_field         BOOLEAN,
    repeatable          BOOLEAN,
    mandatory           BOOLEAN,
    hidden              BOOLEAN,
    owner               INTEGER REFERENCES actor.org_unit (id)
                        -- if the owner is null, the data about the field is
                        -- assumed to come from the controlling MARC standard
);

COMMENT ON TABLE config.marc_field IS $$
This table stores a list of MARC fields recognized by the Evergreen
instance.  Note that we're not aiming for completely generic ISO2709
support: we're assuming things like three characters for a tag,
one-character subfield labels, two indicators per variable data field,
and the like, all of which are technically specializations of ISO2709.

Of particular significance is the owner column; if it's set to a null
value, the field definition is assumed to come from a national
standards body; if it's set to a non-null value, the field definition
is an OU-level addition to or override of the standard.
$$;

CREATE INDEX config_marc_field_tag_idx ON config.marc_field (tag);
CREATE INDEX config_marc_field_owner_idx ON config.marc_field (owner);

CREATE UNIQUE INDEX config_standard_marc_tags_are_unique
    ON config.marc_field(marc_format, marc_record_type, tag)
    WHERE owner IS NULL;
ALTER TABLE config.marc_field
    ADD CONSTRAINT config_standard_marc_tags_are_fully_specified
    CHECK ((owner IS NOT NULL) OR
           (
                owner IS NULL AND
                repeatable IS NOT NULL AND
                mandatory IS NOT NULL AND
                hidden IS NOT NULL
           )
          );

CREATE TABLE config.marc_subfield (
    id                  SERIAL PRIMARY KEY,
    marc_format         INTEGER NOT NULL
                        REFERENCES config.marc_format (id) DEFERRABLE INITIALLY DEFERRED,
    marc_record_type    config.marc_record_type NOT NULL,
    tag                 CHAR(3) NOT NULL,
    code                CHAR(1) NOT NULL,
    description         TEXT,
    repeatable          BOOLEAN,
    mandatory           BOOLEAN,
    hidden              BOOLEAN,
    value_ctype         TEXT
                        REFERENCES config.record_attr_definition (name)
                            DEFERRABLE INITIALLY DEFERRED,
    owner               INTEGER REFERENCES actor.org_unit (id)
                        -- if the owner is null, the data about the subfield is
                        -- assumed to come from the controlling MARC standard
);

COMMENT ON TABLE config.marc_subfield IS $$
This table stores the list of subfields recognized by this Evergreen
instance.  As with config.marc_field, of particular significance is the
owner column; if it's set to a null value, the subfield definition is
assumed to come from a national standards body; if it's set to a non-null
value, the subfield definition is an OU-level addition to or override
of the standard.
$$;

CREATE INDEX config_marc_subfield_tag_code_idx ON config.marc_subfield (tag, code);
CREATE UNIQUE INDEX config_standard_marc_subfields_are_unique
    ON config.marc_subfield(marc_format, marc_record_type, tag, code)
    WHERE owner IS NULL;
ALTER TABLE config.marc_subfield
    ADD CONSTRAINT config_standard_marc_subfields_are_fully_specified
    CHECK ((owner IS NOT NULL) OR
           (
                owner IS NULL AND
                repeatable IS NOT NULL AND
                mandatory IS NOT NULL AND
                hidden IS NOT NULL
           )
          );

CREATE OR REPLACE VIEW config.marc_field_for_ou AS
WITH RECURSIVE ou_marc_fields(id, marc_format, marc_record_type, tag,
                              name, description, fixed_field, repeatable,
                              mandatory, hidden, owner, depth) AS (
    -- start with all MARC fields defined by the controlling national standard
    SELECT id, marc_format, marc_record_type, tag, name, description, fixed_field, repeatable, mandatory, hidden, owner, 0
    FROM config.marc_field
    WHERE owner IS NULL
    UNION
    -- as well as any purely local ones that have been added
    SELECT id, marc_format, marc_record_type, tag, name, description, fixed_field, repeatable, mandatory, hidden, owner, 0
    FROM config.marc_field
    WHERE ARRAY[marc_format::TEXT, marc_record_type::TEXT, tag] NOT IN (
        SELECT ARRAY[marc_format::TEXT, marc_record_type::TEXT, tag]
        FROM config.marc_field
        WHERE owner IS NULL
    )
  UNION
    -- and start walking down the org unit hierarchy,
    -- letting entries for child OUs override field names,
    -- descriptions, repeatability, and the like.  Letting
    -- fixed-fieldness be overridable is something that falls
    -- from the implementation, but is unlikely to be useful
    SELECT c.id, marc_format, marc_record_type, tag,
           COALESCE(c.name, p.name),
           COALESCE(c.description, p.description),
           COALESCE(c.fixed_field, p.fixed_field),
           COALESCE(c.repeatable, p.repeatable),
           COALESCE(c.mandatory, p.mandatory),
           COALESCE(c.hidden, p.hidden),
           c.owner,
           depth + 1
    FROM config.marc_field c
    JOIN ou_marc_fields p USING (marc_format, marc_record_type, tag)
    JOIN actor.org_unit aou ON (c.owner = aou.id)
    WHERE (aou.parent_ou = p.owner OR (aou.parent_ou IS NULL AND p.owner IS NULL))
)
SELECT id, marc_format, marc_record_type, tag,
       name, description, fixed_field, repeatable,
       mandatory, hidden, owner, depth
FROM ou_marc_fields;

CREATE OR REPLACE VIEW config.marc_subfield_for_ou AS
WITH RECURSIVE ou_marc_subfields(id, marc_format, marc_record_type, tag, code,
                              description, repeatable,
                              mandatory, hidden, value_ctype, owner, depth) AS (
    -- start with all MARC subfields defined by the controlling national standard
    SELECT id, marc_format, marc_record_type, tag, code, description, repeatable, mandatory,
           hidden, value_ctype, owner, 0
    FROM config.marc_subfield
    WHERE owner IS NULL
    UNION
    -- as well as any purely local ones that have been added
    SELECT id, marc_format, marc_record_type, tag, code, description, repeatable, mandatory,
           hidden, value_ctype, owner, 0
    FROM config.marc_subfield
    WHERE ARRAY[marc_format::TEXT, marc_record_type::TEXT, tag, code] NOT IN (
        SELECT ARRAY[marc_format::TEXT, marc_record_type::TEXT, tag, code]
        FROM config.marc_subfield
        WHERE owner IS NULL
    )
  UNION
    -- and start walking down the org unit hierarchy,
    -- letting entries for child OUs override subfield
    -- descriptions, repeatability, and the like.
    SELECT c.id, marc_format, marc_record_type, tag, code,
           COALESCE(c.description, p.description),
           COALESCE(c.repeatable, p.repeatable),
           COALESCE(c.mandatory, p.mandatory),
           COALESCE(c.hidden, p.hidden),
           COALESCE(c.value_ctype, p.value_ctype),
           c.owner,
           depth + 1
    FROM config.marc_subfield c
    JOIN ou_marc_subfields p USING (marc_format, marc_record_type, tag, code)
    JOIN actor.org_unit aou ON (c.owner = aou.id)
    WHERE (aou.parent_ou = p.owner OR (aou.parent_ou IS NULL AND p.owner IS NULL))
)
SELECT id, marc_format, marc_record_type, tag, code,
       description, repeatable,
       mandatory, hidden, value_ctype, owner, depth
FROM ou_marc_subfields;

CREATE OR REPLACE FUNCTION config.ou_marc_fields(marc_format INTEGER, marc_record_type config.marc_record_type, ou INTEGER) RETURNS SETOF config.marc_field AS $func$
    SELECT id, marc_format, marc_record_type, tag, name, description, fixed_field, repeatable, mandatory, hidden, owner
    FROM (
        SELECT id, marc_format, marc_record_type, tag, name, description,
              fixed_field, repeatable, mandatory, hidden, owner, depth,
              MAX(depth) OVER (PARTITION BY marc_format, marc_record_type, tag) AS winner
        FROM config.marc_field_for_ou
        WHERE (owner IS NULL
               OR owner IN (SELECT id FROM actor.org_unit_ancestors($3)))
        AND   marc_format = $1
        AND   marc_record_type = $2
    ) AS s
    WHERE depth = winner
    AND not hidden;
$func$ LANGUAGE SQL;

CREATE OR REPLACE FUNCTION config.ou_marc_subfields(marc_format INTEGER, marc_record_type config.marc_record_type, ou INTEGER) RETURNS SETOF config.marc_subfield AS $func$
    SELECT id, marc_format, marc_record_type, tag, code, description, repeatable, mandatory,
           hidden, value_ctype, owner
    FROM (
        SELECT id, marc_format, marc_record_type, tag, code, description,
              repeatable, mandatory, hidden, value_ctype, owner, depth,
              MAX(depth) OVER (PARTITION BY marc_format, marc_record_type, tag, code) AS winner
        FROM config.marc_subfield_for_ou
        WHERE (owner IS NULL
               OR owner IN (SELECT id FROM actor.org_unit_ancestors($3)))
        AND   marc_format = $1
        AND   marc_record_type = $2
    ) AS s
    WHERE depth = winner
    AND not hidden;
$func$ LANGUAGE SQL;


SELECT evergreen.upgrade_deps_block_check('0934', :eg_version);

INSERT INTO config.marc_format(id, code, name) VALUES (1, 'marc21', 'MARC 21');
SELECT SETVAL('config.marc_format_id_seq', 100);
ALTER SEQUENCE config.marc_field_id_seq RESTART WITH 1;
ALTER SEQUENCE config.marc_subfield_id_seq RESTART WITH 1;

INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '001', $$Control Number$$, $$Control number assigned by the organization creating, using, or distributing the record. The MARC code for the organization is contained in field 003 (Control Number Identifier).$$,
TRUE, FALSE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '003', $$Control Number Identifier$$, $$MARC code for the organization whose control number is contained in field 001 (Control Number).$$,
TRUE, FALSE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '005', $$Date and Time of Latest Transaction$$, $$Sixteen characters that indicate the date and time of the latest record transaction and serve as a version identifier for the record. They are recorded according to (ISO 8601). The date requires 8 numeric characters in the pattern . The time requires 8 numeric characters in the pattern expressed in terms of the 24-hour (00-23) clock.$$,
TRUE, FALSE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '006', $$Fixed-Length Data Elements-Additional Material Characteristics$$, $$Eighteen character positions (00-17) that provide for coding information about special aspects of the item being cataloged that cannot be coded in field 008 (Fixed-Length Data Elements). It is used in cases when an item has multiple characteristics (e.g., printed material with an accompanying cassette or a map that is issued serially) and to record the coded serial aspects of nontextual continuing resources.$$,
TRUE, TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '007', $$Physical Description Fixed Field-General Information$$, $$Special information about the physical characteristics in a coded form. The information may represent the whole item or parts of an item such as accompanying material.$$,
TRUE, TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '008', $$Fixed-Length Data Elements-General Information$$, $$Forty character positions (00-39) that provide coded information about the record as a whole and about special bibliographic aspects of the item being cataloged. These coded data elements are potentially useful for retrieval and data management purposes.$$,
TRUE, FALSE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '010', $$Library of Congress Control Number$$, $$Unique number assigned to a MARC record by the Library of Congress. Valid MARC prefixes for LC control numbers are published in .$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_010_ind_1', 'MARC 21 biblio field 010 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_010_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_010_ind_2', 'MARC 21 biblio field 010 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_010_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '010', 'a', $$LC control number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '010', 'b', $$NUCMC control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '010', 'z', $$Canceled/invalid LC control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '010', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '013', $$Patent Control Information$$, $$Information used to control patent documents. In addition to information about patents, this field may contain information relating to inventors' certificates, utility certificates, utility models, patents or certificates of addition, inventors' certificates of addition, utility certificates of addition, and published applications for any of these.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_013_ind_1', 'MARC 21 biblio field 013 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_013_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_013_ind_2', 'MARC 21 biblio field 013 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_013_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '013', 'a', $$Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '013', 'b', $$Country$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '013', 'c', $$Type of number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '013', 'd', $$Date$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '013', 'e', $$Status$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '013', 'f', $$Party to document$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '013', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '013', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '015', $$National Bibliography Number$$, $$Bibliography entry number(s) for cataloging information that is derived from a national bibliography.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_015_ind_1', 'MARC 21 biblio field 015 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_015_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_015_ind_2', 'MARC 21 biblio field 015 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_015_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '015', 'a', $$National bibliography number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '015', 'z', $$Canceled/invalid national bibliography number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '015', '2', $$Source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '015', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '015', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '016', $$National Bibliographic Agency Control Number$$, $$Unique numbers that have been assigned to a record by a national bibliographic agency other than the Library of Congress. The control number may also appear in field 001 (Control Number) in records distributed by the same national agency. This number is a record control number used in a national bibliographic agency system, rather than a number used for an entry in a national bibliographic, field 015 (National Bibliography Number).$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_016_ind_1', 'MARC 21 biblio field 016 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_016_ind_1', '#', $$Library and Archives Canada$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_016_ind_1', '7', $$Source specified in subfield $2$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_016_ind_2', 'MARC 21 biblio field 016 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_016_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '016', 'a', $$Record control number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '016', 'z', $$Canceled/invalid control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '016', '2', $$Source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '016', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '017', $$Copyright or Legal Deposit Number$$, $$Copyright registration or legal deposit number for an item that was acquired by copyright or legal deposit.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_017_ind_1', 'MARC 21 biblio field 017 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_017_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_017_ind_2', 'MARC 21 biblio field 017 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_017_ind_2', '#', $$Copyright or legal deposit number$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_017_ind_2', '8', $$No display constant generated$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '017', 'a', $$Copyright or legal deposit number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '017', 'b', $$Assigning agency$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '017', 'd', $$Date$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '017', 'i', $$Display text$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '017', 'z', $$Canceled/invalid copyright or legal deposit number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '017', '2', $$Source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '017', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '017', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '018', $$Copyright Article-Fee Code$$, $$Unique identification code for component parts appearing in monographs or continuing resources.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_018_ind_1', 'MARC 21 biblio field 018 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_018_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_018_ind_2', 'MARC 21 biblio field 018 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_018_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '018', 'a', $$Copyright article-fee code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '018', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '018', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '020', $$International Standard Book Number$$, $$International Standard Book Number (ISBN) assigned to a monographic publication by designated agencies in each country participating in the program. The field may include terms of availability and canceled or invalid ISBNs, such as ISBNs with invalid check digits or that are not applicable to the item being cataloged. It may be repeated for multiple numbers associated with the item (e.g., ISBNs for the hard bound and paperback manifestations; ISBNs for a set as a whole and for the individual parts in the set).$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_020_ind_1', 'MARC 21 biblio field 020 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_020_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_020_ind_2', 'MARC 21 biblio field 020 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_020_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '020', 'a', $$International Standard Book Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '020', 'c', $$Terms of availability$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '020', 'z', $$Canceled/invalid ISBN$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '020', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '020', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '022', $$International Standard Serial Number$$, $$International Standard Serial Number (ISSN), a unique identification number assigned to a continuing resource, and/or any incorrect or canceled ISSN.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_022_ind_1', 'MARC 21 biblio field 022 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_022_ind_1', '#', $$No level specified$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_022_ind_1', '0', $$Continuing resource of international interest$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_022_ind_1', '1', $$Continuing resource not of international interest$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_022_ind_2', 'MARC 21 biblio field 022 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_022_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '022', 'a', $$International Standard Serial Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '022', 'l', $$ISSN-L$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '022', 'm', $$Canceled ISSN-L$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '022', 'y', $$Incorrect ISSN$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '022', 'z', $$Canceled ISSN$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '022', '2', $$Source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '022', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '022', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '024', $$Other Standard Identifier$$, $$Standard number or code published on an item which cannot be accommodated in another field (e.g., field 020 (International Standard Book Number), 022 (International Standard Serial Number) , and 027 (Standard Technical Report Number)). The type of standard number or code is identified in the first indicator position or in subfield $2 (Source of number or code).$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_024_ind_1', 'MARC 21 biblio field 024 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_024_ind_1', '0', $$International Standard Recording Code$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_024_ind_1', '1', $$Universal Product Code$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_024_ind_1', '2', $$International Standard Music Number$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_024_ind_1', '3', $$International Article Number$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_024_ind_1', '4', $$Serial Item and Contribution Identifier$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_024_ind_1', '7', $$Source specified in subfield $2$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_024_ind_1', '8', $$Unspecified type of standard number or code$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_024_ind_2', 'MARC 21 biblio field 024 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_024_ind_2', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_024_ind_2', '0', $$No difference$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_024_ind_2', '1', $$Difference$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '024', 'a', $$Standard number or code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '024', 'c', $$Terms of availability$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '024', 'd', $$Additional codes following the standard number or code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '024', 'z', $$Canceled/invalid standard number or code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '024', '2', $$Source of number or code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '024', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '024', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '025', $$Overseas Acquisition Number$$, $$Number assigned by the Library of Congress to works acquired through one of its overseas acquisition programs.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_025_ind_1', 'MARC 21 biblio field 025 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_025_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_025_ind_2', 'MARC 21 biblio field 025 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_025_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '025', 'a', $$Overseas acquisition number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '025', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '026', $$Fingerprint Identifier$$, $$Used to assist in the identification of antiquarian books by recording information comprising groups of characters taken from specified positions on specified pages of the book, in accordance with the principles laid down in various published guidelines.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_026_ind_1', 'MARC 21 biblio field 026 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_026_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_026_ind_2', 'MARC 21 biblio field 026 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_026_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '026', 'a', $$First and second groups of characters$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '026', 'b', $$Third and fourth groups of characters$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '026', 'c', $$Date$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '026', 'd', $$Number of volume or part$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '026', 'e', $$Unparsed fingerprint$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '026', '2', $$Source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '026', '5', $$Institution to which field applies$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '026', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '026', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '027', $$Standard Technical Report Number$$, $$International Standard Technical Report number (ISRN) or a Standard Technical Report Number (STRN)assigned to a technical report. Assignment of STRNs is coordinated by the National Technical Information Service (NTIS), which also maintains an assignment registry.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_027_ind_1', 'MARC 21 biblio field 027 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_027_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_027_ind_2', 'MARC 21 biblio field 027 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_027_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '027', 'a', $$Standard technical report number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '027', 'z', $$Canceled/invalid number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '027', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '027', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '028', $$Publisher Number$$, $$Formatted number used for sound recordings, printed music, and videorecordings. Publisher's numbers that are given in an unformatted form are recorded in field 500 (General Note). A print constant identifying the kind of publisher number may be generated based on the value in the first indicator position.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_028_ind_1', 'MARC 21 biblio field 028 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_028_ind_1', '0', $$Issue number$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_028_ind_1', '1', $$Matrix number$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_028_ind_1', '2', $$Plate number$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_028_ind_1', '3', $$Other music number$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_028_ind_1', '4', $$Videorecording number$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_028_ind_1', '5', $$Other publisher number$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_028_ind_2', 'MARC 21 biblio field 028 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_028_ind_2', '0', $$No note, no added entry$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_028_ind_2', '1', $$Note, added entry$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_028_ind_2', '2', $$Note, no added entry$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_028_ind_2', '3', $$No note, added entry$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '028', 'a', $$Publisher number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '028', 'b', $$Source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '028', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '028', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '030', $$CODEN Designation$$, $$CODEN designation for a bibliographic title. The CODEN is assigned by the International CODEN Section of Chemical Abstracts Service.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_030_ind_1', 'MARC 21 biblio field 030 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_030_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_030_ind_2', 'MARC 21 biblio field 030 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_030_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '030', 'a', $$CODEN$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '030', 'z', $$Canceled/invalid CODEN$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '030', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '030', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '031', $$Musical Incipits Information$$, $$Coded data representing the musical incipit for music using established notation schemes that employ ordinary ASCII symbols. Primarily used to identify music manuscripts, but can be applied to any material containing music.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_031_ind_1', 'MARC 21 biblio field 031 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_031_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_031_ind_2', 'MARC 21 biblio field 031 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_031_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '031', 'a', $$Number of work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '031', 'b', $$Number of movement$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '031', 'c', $$Number of excerpt$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '031', 'd', $$Caption or heading$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '031', 'e', $$Role$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '031', 'g', $$Clef$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '031', 'm', $$Voice/instrument$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '031', 'n', $$Key signature$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '031', 'o', $$Time signature$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '031', 'p', $$Musical notation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '031', 'q', $$General note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '031', 'r', $$Key or mode$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '031', 's', $$Coded validity note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '031', 't', $$Text incipit$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '031', 'u', $$Uniform Resource Identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '031', 'y', $$Link text$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '031', 'z', $$Public note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '031', '2', $$System code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '031', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '031', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '032', $$Postal Registration Number$$, $$Number assigned to a publication for which the specified postal service permits the use of a special mailing class privilege.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_032_ind_1', 'MARC 21 biblio field 032 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_032_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_032_ind_2', 'MARC 21 biblio field 032 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_032_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '032', 'a', $$Postal registration number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '032', 'b', $$Source agency assigning number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '032', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '032', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '033', $$Date/Time and Place of an Event$$, $$Formatted date/time and/or coded place of creation, capture, recording, filming, execution, or broadcast associated with an event or the finding of a naturally occurring object. This information in textual form is contained in field 518 (Date/Time and Place of an Event Note).$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_033_ind_1', 'MARC 21 biblio field 033 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_033_ind_1', '#', $$No date information$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_033_ind_1', '0', $$Single date$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_033_ind_1', '1', $$Multiple single dates$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_033_ind_1', '2', $$Range of dates$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_033_ind_2', 'MARC 21 biblio field 033 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_033_ind_2', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_033_ind_2', '0', $$Capture$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_033_ind_2', '1', $$Broadcast$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_033_ind_2', '2', $$Finding$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '033', 'a', $$Formatted date/time$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '033', 'b', $$Geographic classification area code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '033', 'c', $$Geographic classification subarea code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '033', 'p', $$Place of event$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '033', '0', $$Record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '033', '2', $$Source of term$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '033', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '033', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '033', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '034', $$Coded Cartographic Mathematical Data$$, $$Coded form of the mathematical data contained in field 255 (Mathematical Data Area) of the bibliographic record.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_034_ind_1', 'MARC 21 biblio field 034 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_034_ind_1', '0', $$Scale indeterminable/No scale recorded$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_034_ind_1', '1', $$Single scale$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_034_ind_1', '3', $$Range of scales$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_034_ind_2', 'MARC 21 biblio field 034 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_034_ind_2', '#', $$Not applicable$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_034_ind_2', '0', $$Outer ring$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_034_ind_2', '1', $$Exclusion ring$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '034', 'a', $$Category of scale$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '034', 'b', $$Constant ratio linear horizontal scale$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '034', 'c', $$Constant ratio linear vertical scale$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '034', 'd', $$Coordinates$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '034', 'e', $$Coordinates$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '034', 'f', $$Coordinates$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '034', 'g', $$Coordinates$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '034', 'h', $$Angular scale$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '034', 'j', $$Declination$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '034', 'k', $$Declination$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '034', 'm', $$Right ascension$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '034', 'n', $$Right ascension$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '034', 'p', $$Equinox$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '034', 'r', $$Distance from earth$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '034', 's', $$G-ring latitude$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '034', 't', $$G-ring longitude$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '034', 'x', $$Beginning date$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '034', 'y', $$Ending date$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '034', 'z', $$Name of extraterrestrial body$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '034', '2', $$Source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '034', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '034', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '034', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '035', $$System Control Number$$, $$Control number of a system other than the one whose control number is contained in field 001 (Control Number), field 010 (Library of Congress Control Number) or field 016 (National Bibliographic Agency Control Number).$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_035_ind_1', 'MARC 21 biblio field 035 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_035_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_035_ind_2', 'MARC 21 biblio field 035 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_035_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '035', 'a', $$System control number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '035', 'z', $$Canceled/invalid control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '035', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '035', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '036', $$Original Study Number for Computer Data Files$$, $$Original study number assigned by the producer of the computer file. Introductory phrase may be generated based on the field tag.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_036_ind_1', 'MARC 21 biblio field 036 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_036_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_036_ind_2', 'MARC 21 biblio field 036 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_036_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '036', 'a', $$Original study number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '036', 'b', $$Source agency assigning number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '036', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '036', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '037', $$Source of Acquisition$$, $$Source of acquisition information for the item or its reproduction.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_037_ind_1', 'MARC 21 biblio field 037 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_037_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_037_ind_2', 'MARC 21 biblio field 037 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_037_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '037', 'a', $$Stock number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '037', 'b', $$Source of stock number/acquisition$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '037', 'c', $$Terms of availability$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '037', 'f', $$Form of issue$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '037', 'g', $$Additional format characteristics$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '037', 'n', $$Note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '037', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '037', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '038', $$Record Content Licensor$$, $$MARC code of the organization that licenses the intellectual property rights to the data contained in the record, such as with contractual arrangements. See Appendix I: for a listing of sources used in MARC 21 records.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_038_ind_1', 'MARC 21 biblio field 038 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_038_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_038_ind_2', 'MARC 21 biblio field 038 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_038_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '038', 'a', $$Record content licensor$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '038', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '038', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '040', $$Cataloging Source$$, $$MARC code for or the name of the organization(s) that created the original bibliographic record, assigned MARC content designation and transcribed the record into machine-readable form, or modified (except for the addition of holdings symbols) an existing MARC record. These data and the code in 008/39 (Cataloging source) specify the parties responsible for the bibliographic record. See: for a listing of sources used in MARC 21 records.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_040_ind_1', 'MARC 21 biblio field 040 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_040_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_040_ind_2', 'MARC 21 biblio field 040 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_040_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '040', 'a', $$Original cataloging agency$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '040', 'b', $$Language of cataloging$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '040', 'c', $$Transcribing agency$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '040', 'd', $$Modifying agency$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '040', 'e', $$Description conventions$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '040', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '040', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '041', $$Language Code$$, $$Codes for languages associated with an item when the language code in field 008/35-37 of the record is insufficient to convey full information. Includes records for multilingual items, items that involve translation, and items where the medium of communication is a sign language. Sources of the codes are: or other code lists such as ISO 639-1 ( ).$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_041_ind_1', 'MARC 21 biblio field 041 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_041_ind_1', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_041_ind_1', '0', $$Item not a translation/does not include a translation$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_041_ind_1', '1', $$Item is or includes a translation$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_041_ind_2', 'MARC 21 biblio field 041 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_041_ind_2', '#', $$MARC language code$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_041_ind_2', '7', $$Source specified in subfield $2$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '041', 'a', $$Language code of text/sound track or separate title$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '041', 'b', $$Language code of summary or abstract$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '041', 'd', $$Language code of sung or spoken text$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '041', 'e', $$Language code of librettos$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '041', 'f', $$Language code of table of contents$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '041', 'g', $$Language code of accompanying material other than librettos$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '041', 'h', $$Language code of original and/or intermediate translations of text$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '041', 'j', $$Language code of subtitles or captions$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '041', '2', $$Source of code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '041', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '041', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '042', $$Authentication Code$$, $$One or more authentication codes indicating that the record, existing in a national database, has been reviewed in a specific way. Used for codes associated with specifically designated authentication agencies. Code from: .$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_042_ind_1', 'MARC 21 biblio field 042 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_042_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_042_ind_2', 'MARC 21 biblio field 042 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_042_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '042', 'a', $$Authentication code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '043', $$Geographic Area Code$$, $$Geographic area codes associated with an item. Code from: . The source of a local code in subfield $b is indicated in subfield $2. The source of codes in subfield $c is or .$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_043_ind_1', 'MARC 21 biblio field 043 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_043_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_043_ind_2', 'MARC 21 biblio field 043 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_043_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '043', 'a', $$Geographic area code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '043', 'b', $$Local GAC code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '043', 'c', $$ISO code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '043', '2', $$Source of local code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '043', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '043', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '044', $$Country of Publishing/Producing Entity Code$$, $$Two- or three-character code for the country of the publishing or producing entity when field 008/15-17 (Place of publication, production, or execution) is insufficient to convey full information for an item published or produced in more than one country. Code from: . May be used to include country and subentity codes from or .$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_044_ind_1', 'MARC 21 biblio field 044 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_044_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_044_ind_2', 'MARC 21 biblio field 044 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_044_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '044', 'a', $$MARC country code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '044', 'b', $$Local subentity code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '044', 'c', $$ISO country code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '044', '2', $$Source of local subentity code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '044', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '044', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '045', $$Time Period of Content$$, $$Time period code (subfield $a) and/or a formatted time period (subfield $b and/or $c) associated with an item.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_045_ind_1', 'MARC 21 biblio field 045 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_045_ind_1', '#', $$Subfield $b or $c not present$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_045_ind_1', '0', $$Single date/time$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_045_ind_1', '1', $$Multiple single dates/times$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_045_ind_1', '2', $$Range of dates/times$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_045_ind_2', 'MARC 21 biblio field 045 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_045_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '045', 'a', $$Time period code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '045', 'b', $$Formatted 9999 B.C. through C.E. time period$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '045', 'c', $$Formatted pre-9999 B.C. time period$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '045', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '045', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '046', $$Special Coded Dates$$, $$Date of item information that cannot be recorded in 008/06-14 (Type of date/Publication status, Date 1, Date 2) because such information involves one or more Before Common Era (B.C.) dates, incorrect dates, dates when resources have been modified or created, and date spans when resources are valid. When field 046 is used for B.C. dates, 008/06 is set to code b (No date given; B.C. date involved) and field 008/07-10 and 008/11-14 contain blanks (####). When field 046 is used for incorrect dates, field 008/06 is coded for the type of corrected data and field 008/07-10 and 008/11-14 contain correct dates.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_046_ind_1', 'MARC 21 biblio field 046 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_046_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_046_ind_2', 'MARC 21 biblio field 046 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_046_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '046', 'a', $$Type of date code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '046', 'b', $$Date 1, B.C. date$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '046', 'c', $$Date 1, C.E. date$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '046', 'd', $$Date 2, B.C. date$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '046', 'e', $$Date 2, C.E. date$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '046', 'j', $$Date resource modified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '046', 'k', $$Beginning or single date created$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '046', 'l', $$Ending date created$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '046', 'm', $$Beginning of date valid$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '046', 'n', $$End of date valid$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '046', '2', $$Source of date$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '046', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '046', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '047', $$Form of Musical Composition Code$$, $$Codes that indicate the form of musical composition of printed and manuscript music and musical sound recordings when character positions 18 and 19 (Form of composition) of field 008 (Fixed-Length Data Elements) for music contains the code for multiple forms or for non-MARC codes. MARC codes are listed under field 008 Music, /18-19 (Form of composition).$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_047_ind_1', 'MARC 21 biblio field 047 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_047_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_047_ind_2', 'MARC 21 biblio field 047 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_047_ind_2', '#', $$MARC musical composition code$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_047_ind_2', '7', $$Source specified in subfield $2$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '047', 'a', $$Form of musical composition code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '047', '2', $$Source of code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '047', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '048', $$Number of Musical Instruments or Voices Code$$, $$Two-character code that indicates the medium of performance for a musical composition. Also contains the of parts, indicated by a two-digit number immediately following the code for the musical instruments or voices (e.g., va02, a two-part composition for Voices - Soprano). The number of parts may be omitted if not specified.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_048_ind_1', 'MARC 21 biblio field 048 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_048_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_048_ind_2', 'MARC 21 biblio field 048 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_048_ind_2', '#', $$MARC code$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_048_ind_2', '7', $$Source specified in subfield ‡2$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '048', 'a', $$Performer or ensemble$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '048', 'b', $$Soloist$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '048', '2', $$Source of code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '048', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '050', $$Library of Congress Call Number$$, $$Classification or call number that is taken from or . The brackets that customarily surround alternate class/call numbers are not carried in the MARC record; they may be generated based on the presence of repeated ‡a subfields.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_050_ind_1', 'MARC 21 biblio field 050 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_050_ind_1', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_050_ind_1', '0', $$Item is in LC$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_050_ind_1', '1', $$Item is not in LC$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_050_ind_2', 'MARC 21 biblio field 050 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_050_ind_2', '0', $$Assigned by LC$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_050_ind_2', '4', $$Assigned by agency other than LC$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '050', 'a', $$Classification number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '050', 'b', $$Item number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '050', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '050', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '050', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '051', $$Library of Congress Copy, Issue, Offprint Statement$$, $$Information added to a bibliographic record by the Library of Congress that relates to copies, issues, and/or offprints, etc. of the described material that are in its collections.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_051_ind_1', 'MARC 21 biblio field 051 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_051_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_051_ind_2', 'MARC 21 biblio field 051 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_051_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '051', 'a', $$Classification number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '051', 'b', $$Item number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '051', 'c', $$Copy information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '051', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '052', $$Geographic Classification$$, $$Geographic classification code that represents the geographic area and, if applicable, the geographic subarea and populated place name covered by an item.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_052_ind_1', 'MARC 21 biblio field 052 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_052_ind_1', '#', $$Library of Congress Classification$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_052_ind_1', '1', $$U.S. Dept. of Defense Classification$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_052_ind_1', '7', $$Source specified in subfield $2$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_052_ind_2', 'MARC 21 biblio field 052 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_052_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '052', 'a', $$Geographic classification area code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '052', 'b', $$Geographic classification subarea code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '052', 'd', $$Populated place name$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '052', '2', $$Code source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '052', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '052', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '055', $$Classification Numbers Assigned in Canada$$, $$Complete call number or a classification number assigned by Library and Archives Canada (LAC) or a library contributing to LAC.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_055_ind_1', 'MARC 21 biblio field 055 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_055_ind_1', '#', $$Information not provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_055_ind_1', '0', $$Work held by LAC$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_055_ind_1', '1', $$Work not held by LAC$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_055_ind_2', 'MARC 21 biblio field 055 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_055_ind_2', '0', $$LC-based call number assigned by LAC$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_055_ind_2', '1', $$Complete LC class number assigned by LAC$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_055_ind_2', '2', $$Incomplete LC class number assigned by LAC$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_055_ind_2', '3', $$LC-based call number assigned by the contributing library$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_055_ind_2', '4', $$Complete LC class number assigned by the contributing library$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_055_ind_2', '5', $$Incomplete LC class number assigned by the contributing library$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_055_ind_2', '6', $$Other call number assigned by LAC$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_055_ind_2', '7', $$Other class number assigned by LAC$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_055_ind_2', '8', $$Other call number assigned by the contributing library$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_055_ind_2', '9', $$Other class number assigned by the contributing library$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '055', 'a', $$Classification number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '055', 'b', $$Item number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '055', '2', $$Source of call/class number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '055', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '055', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '060', $$National Library of Medicine Call Number$$, $$Either a complete National Library of Medicine (NLM) call number or classification number assigned by either the National Library of Medicine or by other agencies using the . The second indicator values distinguish between content actually assigned by the National Library of Medicine and content assigned by an organization other than NLM.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_060_ind_1', 'MARC 21 biblio field 060 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_060_ind_1', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_060_ind_1', '0', $$Item is in NLM$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_060_ind_1', '1', $$Item is not in NLM$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_060_ind_2', 'MARC 21 biblio field 060 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_060_ind_2', '0', $$Assigned by NLM$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_060_ind_2', '4', $$Assigned by agency other than NLM$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '060', 'a', $$Classification number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '060', 'b', $$Item number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '060', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '061', $$National Library of Medicine Copy Statement$$, $$Information added to a bibliographic record by the National Library of Medicine that relates to second copies or sets of the described item that are in its collections.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_061_ind_1', 'MARC 21 biblio field 061 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_061_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_061_ind_2', 'MARC 21 biblio field 061 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_061_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '061', 'a', $$Classification number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '061', 'b', $$Item number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '061', 'c', $$Copy information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '061', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '066', $$Character Sets Present$$, $$Information that indicates that the records were encoded with characters from sets other than ISO 10646 (or Unicode). A detailed description of the standard escape sequences used in MARC records is provided in$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_066_ind_1', 'MARC 21 biblio field 066 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_066_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_066_ind_2', 'MARC 21 biblio field 066 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_066_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '066', 'a', $$Primary G0 character set$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '066', 'b', $$Primary G1 character set$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '066', 'c', $$Alternate G0 or G1 character set$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '070', $$National Agricultural Library Call Number$$, $$Classification or call number that is assigned by the National Agricultural Library (NAL).$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_070_ind_1', 'MARC 21 biblio field 070 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_070_ind_1', '0', $$Item is in NAL$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_070_ind_1', '1', $$Item is not in NAL$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_070_ind_2', 'MARC 21 biblio field 070 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_070_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '070', 'a', $$Classification number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '070', 'b', $$Item number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '070', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '071', $$National Agricultural Library Copy Statement$$, $$Call number and other information added to a bibliographic record by the National Agricultural Library (NAL) that relates to second copies or sets of the described item that are in its collections.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_071_ind_1', 'MARC 21 biblio field 071 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_071_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_071_ind_2', 'MARC 21 biblio field 071 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_071_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '071', 'a', $$Classification number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '071', 'b', $$Item number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '071', 'c', $$Copy information$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '071', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '072', $$Subject Category Code$$, $$Code for the subject category that is associated with the described item.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_072_ind_1', 'MARC 21 biblio field 072 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_072_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_072_ind_2', 'MARC 21 biblio field 072 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_072_ind_2', '0', $$NAL subject category code list$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_072_ind_2', '7', $$Source specified in subfield $2$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '072', 'a', $$Subject category code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '072', 'x', $$Subject category code subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '072', '2', $$Source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '072', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '072', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '074', $$GPO Item Number$$, $$Item number assigned to publications by the U.S. Government Printing Office (GPO) to manage their distribution to libraries within its Depository Library System. Numbers are assigned from the .$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_074_ind_1', 'MARC 21 biblio field 074 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_074_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_074_ind_2', 'MARC 21 biblio field 074 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_074_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '074', 'a', $$GPO item number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '074', 'z', $$Canceled/invalid GPO item number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '074', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '080', $$Universal Decimal Classification Number$$, $$Number taken from the Universal Decimal Classification scheme.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_080_ind_1', 'MARC 21 biblio field 080 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_080_ind_1', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_080_ind_1', '0', $$Full$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_080_ind_1', '1', $$Abridged$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_080_ind_2', 'MARC 21 biblio field 080 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_080_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '080', 'a', $$Universal Decimal Classification number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '080', 'b', $$Item number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '080', 'x', $$Common auxiliary subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '080', '2', $$Edition identifier$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '080', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '080', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '082', $$Dewey Decimal Classification Number$$, $$Classification number is taken from , the , and electronic updates to either edition. Through 1997, updates were issued in .$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_082_ind_1', 'MARC 21 biblio field 082 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_082_ind_1', '0', $$Full edition$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_082_ind_1', '1', $$Abridged edition$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_082_ind_2', 'MARC 21 biblio field 082 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_082_ind_2', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_082_ind_2', '0', $$Assigned by LC$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_082_ind_2', '4', $$Assigned by agency other than LC$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '082', 'a', $$Classification number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '082', 'b', $$Item number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '082', 'm', $$Standard or optional designation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '082', 'q', $$Assigning agency$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '082', '2', $$Edition number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '082', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '082', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '083', $$Additional Dewey Decimal Classification Number$$, $$Classification number used for subject access. It is taken from , the , and electronic updates to either edition. Through 1997, updates were issued in .$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_083_ind_1', 'MARC 21 biblio field 083 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_083_ind_1', '0', $$Full edition$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_083_ind_1', '1', $$Abridged edition$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_083_ind_2', 'MARC 21 biblio field 083 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_083_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '083', 'a', $$Classification number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '083', 'c', $$Classification number--Ending number of span$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '083', 'm', $$Standard or optional designation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '083', 'q', $$Assigning agency$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '083', 'y', $$Table sequence number for internal subarrangement or add table$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '083', 'z', $$Table identification$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '083', '2', $$Edition number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '083', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '083', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '084', $$Other Classification Number$$, $$Classification number from a scheme not covered by one of the other number fields. The field should not be used for classification numbers assigned from a source for which a subfield $2 source of number code would not be assigned.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_084_ind_1', 'MARC 21 biblio field 084 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_084_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_084_ind_2', 'MARC 21 biblio field 084 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_084_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '084', 'a', $$Classification number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '084', 'b', $$Item number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '084', '2', $$Number source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '084', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '084', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '085', $$Synthesized Classification Number Components$$, $$Information about how a synthesized classification number or a portion of a synthesized classification number was built. It traces the different components of a synthesized number, showing the different portions of the number and where the add instructions are given. If a number was built using two or more instructions, a separate field 085 is given for each instruction.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_085_ind_1', 'MARC 21 biblio field 085 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_085_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_085_ind_2', 'MARC 21 biblio field 085 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_085_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '085', 'a', $$Number where instructions are found-single number or beginning number of span$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '085', 'b', $$Base number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '085', 'c', $$Classification number-ending number of span$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '085', 'f', $$Facet designator$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '085', 'r', $$Root number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '085', 's', $$Digits added from classification number in schedule or external table$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '085', 't', $$Digits added from internal subarrangement or add table$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '085', 'u', $$Number being analyzed$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '085', 'v', $$Number in internal subarrangement or add table where instructions are found$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '085', 'w', $$Table identification-Internal subarrangement or add table$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '085', 'y', $$Table sequence number for internal subarrangement or add table$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '085', 'z', $$Table identification$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '085', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '085', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '086', $$Government Document Classification Number$$, $$Classification number assigned to documents by designated agencies in countries that have a government documents classification program.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_086_ind_1', 'MARC 21 biblio field 086 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_086_ind_1', '#', $$Source specified in subfield $2$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_086_ind_1', '0', $$Superintendent of Documents Classification System$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_086_ind_1', '1', $$Government of Canada Publications: Outline of Classification$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_086_ind_2', 'MARC 21 biblio field 086 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_086_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '086', 'a', $$Classification number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '086', 'z', $$Canceled/invalid classification number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '086', '2', $$Number source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '086', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '086', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '088', $$Report Number$$, $$Report number that is not a Standard Technical Report Number (STRN), recorded in field 027.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_088_ind_1', 'MARC 21 biblio field 088 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_088_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_088_ind_2', 'MARC 21 biblio field 088 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_088_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '088', 'a', $$Report number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '088', 'z', $$Canceled/invalid report number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '088', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '088', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '100', $$Main Entry-Personal Name$$, $$Personal name used as a main entry in a bibliographic record.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_100_ind_1', 'MARC 21 biblio field 100 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_100_ind_1', '0', $$Forename$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_100_ind_1', '1', $$Surname$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_100_ind_1', '3', $$Family name$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_100_ind_2', 'MARC 21 biblio field 100 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_100_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '100', 'a', $$Personal name$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '100', 'b', $$Numeration$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '100', 'c', $$Titles and words associated with a name$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '100', 'd', $$Dates associated with a name$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '100', 'e', $$Relator term$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '100', 'f', $$Date of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '100', 'g', $$Miscellaneous information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '100', 'j', $$Attribution qualifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '100', 'k', $$Form subheading$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '100', 'l', $$Language of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '100', 'n', $$Number of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '100', 'p', $$Name of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '100', 'q', $$Fuller form of name$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '100', 't', $$Title of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '100', 'u', $$Affiliation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '100', '0', $$Authority record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '100', '4', $$Relator code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '100', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '100', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '110', $$Main Entry-Corporate Name$$, $$Corporate name used as a main entry in a bibliographic record.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_110_ind_1', 'MARC 21 biblio field 110 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_110_ind_1', '0', $$Inverted name$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_110_ind_1', '1', $$Jurisdiction name$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_110_ind_1', '2', $$Name in direct order$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_110_ind_2', 'MARC 21 biblio field 110 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_110_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '110', 'a', $$Corporate name or jurisdiction name as entry element$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '110', 'b', $$Subordinate unit$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '110', 'c', $$Location of meeting$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '110', 'd', $$Date of meeting or treaty signing$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '110', 'e', $$Relator term$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '110', 'f', $$Date of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '110', 'g', $$Miscellaneous information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '110', 'k', $$Form subheading$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '110', 'l', $$Language of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '110', 'n', $$Number of part/section/meeting$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '110', 'p', $$Name of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '110', 't', $$Title of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '110', 'u', $$Affiliation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '110', '0', $$Authority record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '110', '4', $$Relator code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '110', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '110', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '111', $$Main Entry-Meeting Name$$, $$Meeting or conference name used as a main entry in a bibliographic record.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_111_ind_1', 'MARC 21 biblio field 111 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_111_ind_1', '0', $$Inverted name$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_111_ind_1', '1', $$Jurisdiction name$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_111_ind_1', '2', $$Name in direct order$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_111_ind_2', 'MARC 21 biblio field 111 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_111_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '111', 'a', $$Meeting name or jurisdiction name as entry element$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '111', 'c', $$Location of meeting$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '111', 'd', $$Date of meeting$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '111', 'e', $$Subordinate unit$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '111', 'f', $$Date of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '111', 'g', $$Miscellaneous information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '111', 'j', $$Relator term$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '111', 'k', $$Form subheading$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '111', 'l', $$Language of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '111', 'n', $$Number of part/section/meeting$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '111', 'p', $$Name of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '111', 'q', $$Name of meeting following jurisdiction name entry element$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '111', 't', $$Title of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '111', 'u', $$Affiliation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '111', '0', $$Authority record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '111', '4', $$Relator code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '111', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '111', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '130', $$Main Entry-Uniform Title$$, $$Uniform title used as a main entry in a bibliographic record.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_130_ind_1', 'MARC 21 biblio field 130 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_130_ind_1', '0', $$No nonfiling characters$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_130_ind_1', '1', $$Number of nonfiling characters - 1$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_130_ind_1', '2', $$Number of nonfiling characters - 2$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_130_ind_1', '3', $$Number of nonfiling characters - 3$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_130_ind_1', '4', $$Number of nonfiling characters - 4$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_130_ind_1', '5', $$Number of nonfiling characters - 5$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_130_ind_1', '6', $$Number of nonfiling characters - 6$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_130_ind_1', '7', $$Number of nonfiling characters - 7$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_130_ind_1', '8', $$Number of nonfiling characters - 8$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_130_ind_1', '9', $$Number of nonfiling characters - 9$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_130_ind_2', 'MARC 21 biblio field 130 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_130_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '130', 'a', $$Uniform title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '130', 'd', $$Date of treaty signing$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '130', 'f', $$Date of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '130', 'g', $$Miscellaneous information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '130', 'h', $$Medium$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '130', 'k', $$Form subheading$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '130', 'l', $$Language of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '130', 'm', $$Medium of performance for music$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '130', 'n', $$Number of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '130', 'o', $$Arranged statement for music$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '130', 'p', $$Name of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '130', 'r', $$Key for music$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '130', 's', $$Version$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '130', 't', $$Title of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '130', '0', $$Authority record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '130', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '130', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '210', $$Abbreviated Title$$, $$Title as abbreviated for indexing or identification. An abbreviated title is supplied by ISSN centers, based on the Key Title (Field 222). Other abbreviated titles are supplied by cataloging agencies, including abstracting and indexing services.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_210_ind_1', 'MARC 21 biblio field 210 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_210_ind_1', '0', $$No added entry$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_210_ind_1', '1', $$Added entry$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_210_ind_2', 'MARC 21 biblio field 210 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_210_ind_2', '#', $$Abbreviated key title$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_210_ind_2', '0', $$Other abbreviated title$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '210', 'a', $$Abbreviated title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '210', 'b', $$Qualifying information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '210', '2', $$Source$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '210', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '210', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '222', $$Key Title$$, $$Unique title for a continuing resource that is assigned in conjunction with an ISSN recorded in field 022 by national centers under the auspices of the ISSN Network.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_222_ind_1', 'MARC 21 biblio field 222 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_222_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_222_ind_2', 'MARC 21 biblio field 222 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_222_ind_2', '0', $$No nonfiling characters$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_222_ind_2', '1', $$Number of nonfiling characters - 1$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_222_ind_2', '2', $$Number of nonfiling characters - 2$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_222_ind_2', '3', $$Number of nonfiling characters - 3$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_222_ind_2', '4', $$Number of nonfiling characters - 4$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_222_ind_2', '5', $$Number of nonfiling characters - 5$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_222_ind_2', '6', $$Number of nonfiling characters - 6$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_222_ind_2', '7', $$Number of nonfiling characters - 7$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_222_ind_2', '8', $$Number of nonfiling characters - 8$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_222_ind_2', '9', $$Number of nonfiling characters - 9$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '222', 'a', $$Key title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '222', 'b', $$Qualifying information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '222', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '222', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '240', $$Uniform Title$$, $$Uniform title for an item when the bibliographic description is entered under a main entry field that contains a personal (field 100), corporate (110), or meeting (111) name.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_240_ind_1', 'MARC 21 biblio field 240 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_240_ind_1', '0', $$Not printed or displayed$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_240_ind_1', '1', $$Printed or displayed$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_240_ind_2', 'MARC 21 biblio field 240 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_240_ind_2', '0', $$No nonfiling characters$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_240_ind_2', '1', $$Number of nonfiling characters - 1$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_240_ind_2', '2', $$Number of nonfiling characters - 2$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_240_ind_2', '3', $$Number of nonfiling characters - 3$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_240_ind_2', '4', $$Number of nonfiling characters - 4$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_240_ind_2', '5', $$Number of nonfiling characters - 5$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_240_ind_2', '6', $$Number of nonfiling characters - 6$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_240_ind_2', '7', $$Number of nonfiling characters - 7$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_240_ind_2', '8', $$Number of nonfiling characters - 8$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_240_ind_2', '9', $$Number of nonfiling characters - 9$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '240', 'a', $$Uniform title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '240', 'd', $$Date of treaty signing$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '240', 'f', $$Date of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '240', 'g', $$Miscellaneous information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '240', 'h', $$Medium$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '240', 'k', $$Form subheading$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '240', 'l', $$Language of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '240', 'm', $$Medium of performance for music$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '240', 'n', $$Number of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '240', 'o', $$Arranged statement for music$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '240', 'p', $$Name of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '240', 'r', $$Key for music$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '240', 's', $$Version$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '240', '0', $$Authority record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '240', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '240', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '242', $$Translation of Title by Cataloging Agency$$, $$Translation of the title proper that is made by the cataloging agency when the translated title does not appear as a parallel title on the item. For a note, the introductory phrase may be generated based on the field tag for display.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_242_ind_1', 'MARC 21 biblio field 242 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_242_ind_1', '0', $$No added entry$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_242_ind_1', '1', $$Added entry$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_242_ind_2', 'MARC 21 biblio field 242 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_242_ind_2', '0', $$No nonfiling characters$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_242_ind_2', '1', $$Number of nonfiling characters - 1$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_242_ind_2', '2', $$Number of nonfiling characters - 2$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_242_ind_2', '3', $$Number of nonfiling characters - 3$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_242_ind_2', '4', $$Number of nonfiling characters - 4$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_242_ind_2', '5', $$Number of nonfiling characters - 5$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_242_ind_2', '6', $$Number of nonfiling characters - 6$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_242_ind_2', '7', $$Number of nonfiling characters - 7$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_242_ind_2', '8', $$Number of nonfiling characters - 8$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_242_ind_2', '9', $$Number of nonfiling characters - 9$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '242', 'a', $$Title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '242', 'b', $$Remainder of title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '242', 'c', $$Statement of responsibility, etc.$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '242', 'h', $$Medium$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '242', 'n', $$Number of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '242', 'p', $$Name of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '242', 'y', $$Language code of translated title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '242', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '242', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '243', $$Collective Uniform Title$$, $$Generic title that is constructed by the cataloger to collect works by a prolific author. Brackets that customarily enclose a collective uniform title are not carried in the MARC record. They may be generated based on the field tag.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_243_ind_1', 'MARC 21 biblio field 243 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_243_ind_1', '0', $$Not printed or displayed$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_243_ind_1', '1', $$Printed or displayed$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_243_ind_2', 'MARC 21 biblio field 243 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_243_ind_2', '0', $$No nonfiling characters$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_243_ind_2', '1', $$Number of nonfiling characters - 1$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_243_ind_2', '2', $$Number of nonfiling characters - 2$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_243_ind_2', '3', $$Number of nonfiling characters - 3$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_243_ind_2', '4', $$Number of nonfiling characters - 4$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_243_ind_2', '5', $$Number of nonfiling characters - 5$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_243_ind_2', '6', $$Number of nonfiling characters - 6$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_243_ind_2', '7', $$Number of nonfiling characters - 7$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_243_ind_2', '8', $$Number of nonfiling characters - 8$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_243_ind_2', '9', $$Number of nonfiling characters - 9$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '243', 'a', $$Uniform title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '243', 'd', $$Date of treaty signing$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '243', 'f', $$Date of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '243', 'g', $$Miscellaneous information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '243', 'h', $$Medium$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '243', 'k', $$Form subheading$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '243', 'l', $$Language of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '243', 'm', $$Medium of performance for music$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '243', 'n', $$Number of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '243', 'o', $$Arranged statement for music$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '243', 'p', $$Name of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '243', 'r', $$Key for music$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '243', 's', $$Version$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '243', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '243', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '245', $$Title Statement$$, $$Title and statement of responsibility area of the bibliographic description of a work.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_245_ind_1', 'MARC 21 biblio field 245 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_245_ind_1', '0', $$No added entry$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_245_ind_1', '1', $$Added entry$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_245_ind_2', 'MARC 21 biblio field 245 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_245_ind_2', '0', $$No nonfiling characters$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_245_ind_2', '1', $$Number of nonfiling characters - 1$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_245_ind_2', '2', $$Number of nonfiling characters - 2$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_245_ind_2', '3', $$Number of nonfiling characters - 3$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_245_ind_2', '4', $$Number of nonfiling characters - 4$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_245_ind_2', '5', $$Number of nonfiling characters - 5$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_245_ind_2', '6', $$Number of nonfiling characters - 6$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_245_ind_2', '7', $$Number of nonfiling characters - 7$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_245_ind_2', '8', $$Number of nonfiling characters - 8$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_245_ind_2', '9', $$Number of nonfiling characters - 9$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '245', 'a', $$Title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '245', 'b', $$Remainder of title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '245', 'c', $$Statement of responsibility, etc.$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '245', 'f', $$Inclusive dates$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '245', 'g', $$Bulk dates$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '245', 'h', $$Medium$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '245', 'k', $$Form$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '245', 'n', $$Number of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '245', 'p', $$Name of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '245', 's', $$Version$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '245', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '245', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '246', $$Varying Form of Title$$, $$Varying forms of the title appearing on different parts of an item or a portion of the title proper, or an alternative form of the title when the form differs substantially from the title statement in field 245 and if they contribute to the further identification of the item.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_246_ind_1', 'MARC 21 biblio field 246 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_246_ind_1', '0', $$Note, no added entry$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_246_ind_1', '1', $$Note, added entry$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_246_ind_1', '2', $$No note, no added entry$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_246_ind_1', '3', $$No note, added entry$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_246_ind_2', 'MARC 21 biblio field 246 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_246_ind_2', '#', $$No type specified$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_246_ind_2', '0', $$Portion of title$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_246_ind_2', '1', $$Parallel title$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_246_ind_2', '2', $$Distinctive title$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_246_ind_2', '3', $$Other title$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_246_ind_2', '4', $$Cover title$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_246_ind_2', '5', $$Added title page title$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_246_ind_2', '6', $$Caption title$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_246_ind_2', '7', $$Running title$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_246_ind_2', '8', $$Spine title$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '246', 'a', $$Title proper/short title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '246', 'b', $$Remainder of title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '246', 'f', $$Date or sequential designation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '246', 'g', $$Miscellaneous information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '246', 'h', $$Medium$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '246', 'i', $$Display text$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '246', 'n', $$Number of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '246', 'p', $$Name of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '246', '5', $$Institution to which field applies$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '246', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '246', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '247', $$Former Title$$, $$Former title proper used when one cataloging record represents several titles associated with an entity.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_247_ind_1', 'MARC 21 biblio field 247 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_247_ind_1', '0', $$No added entry$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_247_ind_1', '1', $$Added entry$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_247_ind_2', 'MARC 21 biblio field 247 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_247_ind_2', '0', $$Display note$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_247_ind_2', '1', $$Do not display note$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '247', 'a', $$Title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '247', 'b', $$Remainder of title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '247', 'f', $$Date or sequential designation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '247', 'g', $$Miscellaneous information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '247', 'h', $$Medium$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '247', 'n', $$Number of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '247', 'p', $$Name of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '247', 'x', $$International Standard Serial Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '247', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '247', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '250', $$Edition Statement$$, $$Information relating to the edition of a work as determined by applicable cataloging rules.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_250_ind_1', 'MARC 21 biblio field 250 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_250_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_250_ind_2', 'MARC 21 biblio field 250 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_250_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '250', 'a', $$Edition statement$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '250', 'b', $$Remainder of edition statement$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '250', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '250', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '254', $$Musical Presentation Statement$$, $$Musical presentation statement for printed or manuscript music that describes the format of the edition, which may differ from that of another edition of the same work.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_254_ind_1', 'MARC 21 biblio field 254 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_254_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_254_ind_2', 'MARC 21 biblio field 254 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_254_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '254', 'a', $$Musical presentation statement$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '254', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '254', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '255', $$Cartographic Mathematical Data$$, $$Mathematical data associated with cartographic material, including celestial charts. This data may also be coded in field 034 (Coded Mathematical Data).$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_255_ind_1', 'MARC 21 biblio field 255 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_255_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_255_ind_2', 'MARC 21 biblio field 255 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_255_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '255', 'a', $$Statement of scale$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '255', 'b', $$Statement of projection$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '255', 'c', $$Statement of coordinates$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '255', 'd', $$Statement of zone$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '255', 'e', $$Statement of equinox$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '255', 'f', $$Outer G-ring coordinate pairs$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '255', 'g', $$Exclusion G-ring coordinate pairs$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '255', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '255', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '256', $$Computer File Characteristics$$, $$Characteristics of a computer file, such as the type of file (e.g., Computer programs), the number of records, statements, etc. (e.g., 1250 records, 5076 bytes).$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_256_ind_1', 'MARC 21 biblio field 256 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_256_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_256_ind_2', 'MARC 21 biblio field 256 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_256_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '256', 'a', $$Computer file characteristics$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '256', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '256', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '257', $$Country of Producing Entity$$, $$Name or abbreviation of the name of the country(s) where the principal offices of the producing entity(s) of a resource are located.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_257_ind_1', 'MARC 21 biblio field 257 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_257_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_257_ind_2', 'MARC 21 biblio field 257 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_257_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '257', 'a', $$Country of producing entity$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '257', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '257', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '258', $$Philatelic Issue Data$$, $$Issuing jurisdiction and denomination information about philatelic material, such as postage stamps, postal stationery (postal cards, etc., made available by a postal administration bearing a stamped impression (indicium) of denomination), revenue stamps (tax stamps), postage due stamps, and registered mail stamps. These are usually valid within a defined area and carry a value signifying prepayment or payment due for services or taxes.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_258_ind_1', 'MARC 21 biblio field 258 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_258_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_258_ind_2', 'MARC 21 biblio field 258 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_258_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '258', 'a', $$Issuing jurisdiction$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '258', 'b', $$Denomination$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '258', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '258', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '260', $$Publication, Distribution, etc. (Imprint)$$, $$Information relating to the publication, printing, distribution, issue, release, or production of a work.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_260_ind_1', 'MARC 21 biblio field 260 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_260_ind_1', '#', $$Not applicable/No information provided/Earliest available publisher$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_260_ind_1', '2', $$Intervening publisher$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_260_ind_1', '3', $$Current/latest publisher$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_260_ind_2', 'MARC 21 biblio field 260 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_260_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '260', 'a', $$Place of publication, distribution, etc.$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '260', 'b', $$Name of publisher, distributor, etc.$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '260', 'c', $$Date of publication, distribution, etc.$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '260', 'e', $$Place of manufacture$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '260', 'f', $$Manufacturer$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '260', 'g', $$Date of manufacture$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '260', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '260', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '260', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '263', $$Projected Publication Date$$, $$Projected date of publication used in bibliographic records for works that have not yet been published.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_263_ind_1', 'MARC 21 biblio field 263 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_263_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_263_ind_2', 'MARC 21 biblio field 263 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_263_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '263', 'a', $$Projected publication date$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '263', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '263', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '264', $$Production, Publication, Distribution, Manufacture, and Copyright Notice$$, $$Statement relating to the publication, printing, distribution, issue, release, or production of a work.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_264_ind_1', 'MARC 21 biblio field 264 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_264_ind_1', '#', $$Not applicable/No information provided/Earliest$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_264_ind_1', '2', $$Intervening$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_264_ind_1', '3', $$Current/latest$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_264_ind_2', 'MARC 21 biblio field 264 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_264_ind_2', '0', $$Production$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_264_ind_2', '1', $$Publication$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_264_ind_2', '2', $$Distribution$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_264_ind_2', '3', $$Manufacture$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_264_ind_2', '4', $$Copyright notice date$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '264', 'a', $$Place of production, publication, distribution, manufacture$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '264', 'b', $$Name of producer, publisher, distributor, manufacturer$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '264', 'c', $$Date of production, publication, distribution, manufacture, or copyright notice$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '264', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '264', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '264', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '270', $$Address$$, $$An address (as well as electronic access information such as email, telephone, fax, TTY, etc. numbers) for contacts related to the content of the bibliographic item. Multiple addresses, such as mailing addresses and addresses corresponding to the physical location of an item or facilities, are recorded in separate occurrences of field 270.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_270_ind_1', 'MARC 21 biblio field 270 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_270_ind_1', '#', $$No level specified$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_270_ind_1', '1', $$Primary$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_270_ind_1', '2', $$Secondary$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_270_ind_2', 'MARC 21 biblio field 270 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_270_ind_2', '#', $$No type specified$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_270_ind_2', '0', $$Mailing$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_270_ind_2', '7', $$Type specified in subfield $i$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '270', 'a', $$Address$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '270', 'b', $$City$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '270', 'c', $$State or province$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '270', 'd', $$Country$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '270', 'e', $$Postal code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '270', 'f', $$Terms preceding attention name$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '270', 'g', $$Attention name$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '270', 'h', $$Attention position$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '270', 'i', $$Type of address$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '270', 'j', $$Specialized telephone number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '270', 'k', $$Telephone number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '270', 'l', $$Fax number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '270', 'm', $$Electronic mail address$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '270', 'n', $$TDD or TTY number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '270', 'p', $$Contact person$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '270', 'q', $$Title of contact person$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '270', 'r', $$Hours$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '270', 'z', $$Public note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '270', '4', $$Relator code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '270', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '270', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '300', $$Physical Description$$, $$Physical description of the described item, including its extent, dimensions, and such other physical details as a description of any accompanying materials and unit type and size.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_300_ind_1', 'MARC 21 biblio field 300 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_300_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_300_ind_2', 'MARC 21 biblio field 300 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_300_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '300', 'a', $$Extent$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '300', 'b', $$Other physical details$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '300', 'c', $$Dimensions$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '300', 'e', $$Accompanying material$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '300', 'f', $$Type of unit$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '300', 'g', $$Size of unit$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '300', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '300', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '300', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '306', $$Playing Time$$, $$Six numeric characters, in the pattern that represent the playing time for a sound recording, videorecording, etc. or the stated duration of performance of printed or manuscript music. If the playing time is less than 1 hour, the hour is recorded as two zeroes; if less than a minute, the minute is also recorded as two zeroes.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_306_ind_1', 'MARC 21 biblio field 306 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_306_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_306_ind_2', 'MARC 21 biblio field 306 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_306_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '306', 'a', $$Playing time$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '306', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '306', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '307', $$Hours, Etc.$$, $$Chronological information identifying the days and/or times an item is available or accessible. Used primarily in records for electronic resources.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_307_ind_1', 'MARC 21 biblio field 307 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_307_ind_1', '#', $$Hours$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_307_ind_1', '8', $$No display constant generated$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_307_ind_2', 'MARC 21 biblio field 307 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_307_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '307', 'a', $$Hours$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '307', 'b', $$Additional information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '307', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '307', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '310', $$Current Publication Frequency$$, $$Current stated publication frequency of either an item or an update to an item. Dates are included when the beginning date of the current frequency is not the same as the beginning date of publication.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_310_ind_1', 'MARC 21 biblio field 310 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_310_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_310_ind_2', 'MARC 21 biblio field 310 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_310_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '310', 'a', $$Current publication frequency$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '310', 'b', $$Date of current publication frequency$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '310', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '310', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '321', $$Former Publication Frequency$$, $$Former publication frequency of either an item or an update to an item when a current publication frequency is given in field 310 (Current Publication Frequency).$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_321_ind_1', 'MARC 21 biblio field 321 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_321_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_321_ind_2', 'MARC 21 biblio field 321 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_321_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '321', 'a', $$Former publication frequency$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '321', 'b', $$Dates of former publication frequency$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '321', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '321', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '336', $$Content Type$$, $$The form of communication through which a work is expressed. Used in conjunction with Leader /06 (Type of record), which indicates the general type of content of the resource. Field 336 information enables expression of more specific content types and content types from various lists.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_336_ind_1', 'MARC 21 biblio field 336 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_336_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_336_ind_2', 'MARC 21 biblio field 336 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_336_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '336', 'a', $$Content type term$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '336', 'b', $$Content type code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '336', '2', $$Source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '336', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '336', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '336', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '337', $$Media Type$$, $$Media type reflects the general type of intermediation device required to view, play, run, etc., the content of a resource. Used as an alternative to or in addition to the coded expression of Media type in field 007/00 (Category of material). Field 337 information enables indication of more specific media types and media types from various lists.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_337_ind_1', 'MARC 21 biblio field 337 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_337_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_337_ind_2', 'MARC 21 biblio field 337 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_337_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '337', 'a', $$Media type term$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '337', 'b', $$Media type code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '337', '2', $$Source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '337', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '337', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '337', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '338', $$Carrier Type$$, $$Carrier type reflects the format of the storage medium and housing of a carrier in combination with the media type (which indicates the intermediation device required to view, play, run, etc., the content of a resource). Used as an alternative to or in addition to the coded expression of carrier type in field 007/01 (Specific material designation). Field 338 information enables indication of more specific carrier types and carrier types from various lists.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_338_ind_1', 'MARC 21 biblio field 338 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_338_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_338_ind_2', 'MARC 21 biblio field 338 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_338_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '338', 'a', $$Carrier type term$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '338', 'b', $$Carrier type code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '338', '2', $$Source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '338', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '338', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '338', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '340', $$Physical Medium$$, $$Physical description information for an item that requires technical equipment for its use or an item that has special conservation or storage needs.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_340_ind_1', 'MARC 21 biblio field 340 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_340_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_340_ind_2', 'MARC 21 biblio field 340 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_340_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '340', 'a', $$Material base and configuration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '340', 'b', $$Dimensions$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '340', 'c', $$Materials applied to surface$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '340', 'd', $$Information recording technique$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '340', 'e', $$Support$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '340', 'f', $$Production rate/ratio$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '340', 'h', $$Location within medium$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '340', 'i', $$Technical specifications of medium$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '340', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '340', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '340', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '342', $$Geospatial Reference Data$$, $$Description of the frame of reference for the coordinates in a data set. To work with a data set a user must be able to identify how location accuracy has been affected through the application of a geospatial reference method, thus enabling the user to manipulate the data set to recover location accuracy.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_342_ind_1', 'MARC 21 biblio field 342 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_342_ind_1', '0', $$Horizontal coordinate system$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_342_ind_1', '1', $$Vertical coordinate system$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_342_ind_2', 'MARC 21 biblio field 342 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_342_ind_2', '0', $$Geographic$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_342_ind_2', '1', $$Map projection$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_342_ind_2', '2', $$Grid coordinate system$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_342_ind_2', '3', $$Local planar$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_342_ind_2', '4', $$Local$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_342_ind_2', '5', $$Geodetic model$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_342_ind_2', '6', $$Altitude$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_342_ind_2', '7', $$Method specified in $2$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_342_ind_2', '8', $$Depth$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '342', 'a', $$Name$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '342', 'b', $$Coordinate units or distance units$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '342', 'c', $$Latitude resolution$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '342', 'd', $$Longitude resolution$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '342', 'e', $$Standard parallel or oblique line latitude$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '342', 'f', $$Oblique line longitude$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '342', 'g', $$Longitude of central meridian or projection center$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '342', 'h', $$Latitude of projection center or projection origin$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '342', 'i', $$False easting$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '342', 'j', $$False northing$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '342', 'k', $$Scale factor$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '342', 'l', $$Height of perspective point above surface$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '342', 'm', $$Azimuthal angle$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '342', 'n', $$Azimuth measure point longitude or straight vertical longitude from pole$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '342', 'o', $$Landsat number and path number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '342', 'p', $$Zone identifier$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '342', 'q', $$Ellipsoid name$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '342', 'r', $$Semi-major axis$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '342', 's', $$Denominator of flattening ratio$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '342', 't', $$Vertical resolution$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '342', 'u', $$Vertical encoding method$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '342', 'v', $$Local planar, local, or other projection or grid description$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '342', 'w', $$Local planar or local georeference information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '342', '2', $$Reference method used$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '342', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '342', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '343', $$Planar Coordinate Data$$, $$Information about the coordinate system developed on a planar surface. The information is provided to allow the user of a geospatial data set to identify the quantities of distances, or distances and angles. These define the position of a point on a reference plane onto which the surface of the Earth has been projected.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_343_ind_1', 'MARC 21 biblio field 343 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_343_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_343_ind_2', 'MARC 21 biblio field 343 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_343_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '343', 'a', $$Planar coordinate encoding method$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '343', 'b', $$Planar distance units$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '343', 'c', $$Abscissa resolution$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '343', 'd', $$Ordinate resolution$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '343', 'e', $$Distance resolution$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '343', 'f', $$Bearing resolution$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '343', 'g', $$Bearing units$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '343', 'h', $$Bearing reference direction$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '343', 'i', $$Bearing reference meridian$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '343', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '343', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '344', $$Sound Characteristics$$, $$Technical specifications relating to the encoding of sound in a resource.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_344_ind_1', 'MARC 21 biblio field 344 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_344_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_344_ind_2', 'MARC 21 biblio field 344 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_344_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '344', 'a', $$Type of recording$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '344', 'b', $$Recording medium$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '344', 'c', $$Playing speed$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '344', 'd', $$Groove characteristic$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '344', 'e', $$Track configuration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '344', 'f', $$Tape configuration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '344', 'g', $$Configuration of playback channels$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '344', 'h', $$Special playback characteristics$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '344', '0', $$Authority record control number or standard number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '344', '2', $$Source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '344', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '344', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '344', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '345', $$Projection Characteristics of Moving Image$$, $$Technical specifications relating to the projection of a moving image resource.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_345_ind_1', 'MARC 21 biblio field 345 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_345_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_345_ind_2', 'MARC 21 biblio field 345 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_345_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '345', 'a', $$Presentation format$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '345', 'b', $$Projection speed$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '345', '0', $$Authority record control number or standard number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '345', '2', $$Source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '345', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '345', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '345', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '346', $$Video Characteristics$$, $$Technical specifications relating to the encoding of video images in a resource.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_346_ind_1', 'MARC 21 biblio field 346 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_346_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_346_ind_2', 'MARC 21 biblio field 346 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_346_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '346', 'a', $$Video format$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '346', 'b', $$Broadcast standard$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '346', '0', $$Authority record control number or standard number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '346', '2', $$Source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '346', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '346', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '346', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '347', $$Digital File Characteristics$$, $$Technical specification relating to the digital encoding of text, image, audio, video, and other types of data in a resource.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_347_ind_1', 'MARC 21 biblio field 347 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_347_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_347_ind_2', 'MARC 21 biblio field 347 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_347_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '347', 'a', $$File type$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '347', 'b', $$Encoding format$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '347', 'c', $$File size$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '347', 'd', $$Resolution$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '347', 'e', $$Regional encoding$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '347', 'f', $$Encoded bitrate$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '347', '0', $$Authority record control number or standard number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '347', '2', $$Source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '347', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '347', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '347', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '351', $$Organization and Arrangement of Materials$$, $$Information about the organization and arrangement of a collection of items.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_351_ind_1', 'MARC 21 biblio field 351 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_351_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_351_ind_2', 'MARC 21 biblio field 351 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_351_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '351', 'a', $$Organization$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '351', 'b', $$Arrangement$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '351', 'c', $$Hierarchical level$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '351', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '351', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '351', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '352', $$Digital Graphic Representation$$, $$Description of the method of referencing and the mechanism used to represent graphic information in a data set. This information consists of the type of storage technique used, the number of items in the data set, and the format in which the data is stored.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_352_ind_1', 'MARC 21 biblio field 352 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_352_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_352_ind_2', 'MARC 21 biblio field 352 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_352_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '352', 'a', $$Direct reference method$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '352', 'b', $$Object type$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '352', 'c', $$Object count$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '352', 'd', $$Row count$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '352', 'e', $$Column count$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '352', 'f', $$Vertical count$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '352', 'g', $$VPF topology level$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '352', 'i', $$Indirect reference description$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '352', 'q', $$Format of the digital image$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '352', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '352', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '355', $$Security Classification Control$$, $$Specifics pertaining to the security classification associated with the document, title, abstract, contents note, and/or the author. In addition, it can contain handling instructions and external dissemination information pertaining to the dissemination of the document, title, abstract, contents note, and author. The field may also contain downgrading or declassification data, the name of the classification system, and a country of origin code.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_355_ind_1', 'MARC 21 biblio field 355 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_355_ind_1', '0', $$Document$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_355_ind_1', '1', $$Title$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_355_ind_1', '2', $$Abstract$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_355_ind_1', '3', $$Contents note$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_355_ind_1', '4', $$Author$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_355_ind_1', '5', $$Record$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_355_ind_1', '8', $$None of the above$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_355_ind_2', 'MARC 21 biblio field 355 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_355_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '355', 'a', $$Security classification$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '355', 'b', $$Handling instructions$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '355', 'c', $$External dissemination information$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '355', 'd', $$Downgrading or declassification event$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '355', 'e', $$Classification system$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '355', 'f', $$Country of origin code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '355', 'g', $$Downgrading date$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '355', 'h', $$Declassification date$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '355', 'j', $$Authorization$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '355', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '355', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '357', $$Originator Dissemination Control$$, $$Specifics pertaining to originator (i.e., author, producer) control of dissemination of the material in hand. Subfield $a contains a specific term denoting that the originator has control over the material.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_357_ind_1', 'MARC 21 biblio field 357 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_357_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_357_ind_2', 'MARC 21 biblio field 357 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_357_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '357', 'a', $$Originator control term$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '357', 'b', $$Originating agency$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '357', 'c', $$Authorized recipients of material$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '357', 'g', $$Other restrictions$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '357', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '357', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '362', $$Dates of Publication and/or Sequential Designation$$, $$Beginning/ending date(s) of an item and/or the sequential designations used on each part. Dates to be used in this field are chronological designations that identify individual issues of the continuing resource. The sequential designations are usually numeric but can be alphabetic as well. The information may be formatted or unformatted. If the date information has been obtained from a source other than the first and/or last issue of the item published, the information is given in an unformatted note and the source of the information is usually cited.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_362_ind_1', 'MARC 21 biblio field 362 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_362_ind_1', '0', $$Formatted style$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_362_ind_1', '1', $$Unformatted note$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_362_ind_2', 'MARC 21 biblio field 362 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_362_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '362', 'a', $$Dates of publication and/or sequential designation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '362', 'z', $$Source of information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '362', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '362', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '363', $$Normalized Date and Sequential Designation$$, $$The numeric, alphabetic and/or normalized date designation used on the bibliographic item that identifies its parts and shows the relationship of the parts to the whole.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_363_ind_1', 'MARC 21 biblio field 363 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_363_ind_1', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_363_ind_1', '0', $$Starting information$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_363_ind_1', '1', $$Ending information$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_363_ind_2', 'MARC 21 biblio field 363 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_363_ind_2', '#', $$Not specified$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_363_ind_2', '0', $$Closed$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_363_ind_2', '1', $$Open$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '363', 'a', $$First level of enumeration$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '363', 'b', $$Second level of enumeration$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '363', 'c', $$Third level of enumeration$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '363', 'd', $$Fourth level of enumeration$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '363', 'e', $$Fifth level of enumeration$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '363', 'f', $$Sixth level of enumeration$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '363', 'g', $$Alternative numbering scheme, first level of enumeration$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '363', 'h', $$Alternative numbering scheme, second level of enumeration$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '363', 'i', $$First level of chronology$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '363', 'j', $$Second level of chronology$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '363', 'k', $$Third level of chronology$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '363', 'l', $$Fourth level of chronology$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '363', 'm', $$Alternative numbering scheme, chronology$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '363', 'u', $$First level textual designation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '363', 'v', $$First level of chronology, issuance$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '363', 'x', $$Nonpublic note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '363', 'z', $$Public note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '363', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '363', '8', $$Field link and sequence number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '365', $$Trade Price$$, $$Current price of an item or the special export price of an item in any currency.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_365_ind_1', 'MARC 21 biblio field 365 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_365_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_365_ind_2', 'MARC 21 biblio field 365 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_365_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '365', 'a', $$Price type code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '365', 'b', $$Price amount$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '365', 'c', $$Currency code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '365', 'd', $$Unit of pricing$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '365', 'e', $$Price note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '365', 'f', $$Price effective from$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '365', 'g', $$Price effective until$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '365', 'h', $$Tax rate 1$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '365', 'i', $$Tax rate 2$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '365', 'j', $$ISO country code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '365', 'k', $$MARC country code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '365', 'm', $$Identification of pricing entity$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '365', '2', $$Source of price type code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '365', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '365', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '366', $$Trade Availability Information$$, $$Detailed information relating to the availability of items from publishers.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_366_ind_1', 'MARC 21 biblio field 366 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_366_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_366_ind_2', 'MARC 21 biblio field 366 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_366_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '366', 'a', $$Publishers' compressed title identification$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '366', 'b', $$Detailed date of publication$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '366', 'c', $$Availability status code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '366', 'd', $$Expected next availability date$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '366', 'e', $$Note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '366', 'f', $$Publisher's discount category$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '366', 'g', $$Date made out of print$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '366', 'j', $$ISO country code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '366', 'k', $$MARC country code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '366', 'm', $$Identification of agency$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '366', '2', $$Source of availability status code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '366', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '366', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '380', $$Form of Work$$, $$A class or genre to which a work belongs. May be used to differentiate a work from another work with the same title.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_380_ind_1', 'MARC 21 biblio field 380 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_380_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_380_ind_2', 'MARC 21 biblio field 380 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_380_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '380', 'a', $$Form of work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '380', '0', $$Record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '380', '2', $$Source of term$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '380', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '380', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '381', $$Other Distinguishing Characteristics of Work or Expression$$, $$Any characteristic that is not accommodated in a special field that serves to characterize a work or expression. Examples are an issuing body, arranged statement of music, version, or a geographic term. May be used to differentiate a work from another work with the same title.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_381_ind_1', 'MARC 21 biblio field 381 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_381_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_381_ind_2', 'MARC 21 biblio field 381 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_381_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '381', 'a', $$Other distinguishing characteristic$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '381', 'u', $$Uniform Resource Identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '381', 'v', $$Source of information$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '381', '0', $$Record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '381', '2', $$Source of term$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '381', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '381', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '382', $$Medium of Performance$$, $$The instrumental, vocal, and/or other medium of performance for which a musical work was originally conceived or for which a musical expression is written or performed. May be used to differentiate a musical work or expression from another with the same title.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_382_ind_1', 'MARC 21 biblio field 382 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_382_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_382_ind_2', 'MARC 21 biblio field 382 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_382_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '382', 'a', $$Medium of performance$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '382', '0', $$Record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '382', '2', $$Source of term$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '382', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '382', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '383', $$Numeric Designation of Musical Work$$, $$A serial number, opus number, or thematic index number assigned to a musical work by the composer, publisher, or a musicologist. May be used to differentiate a musical work from another with the same title.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_383_ind_1', 'MARC 21 biblio field 383 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_383_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_383_ind_2', 'MARC 21 biblio field 383 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_383_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '383', 'a', $$Serial number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '383', 'b', $$Opus number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '383', 'c', $$Thematic index number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '383', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '383', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '384', $$Key$$, $$The set of pitch relationships that establishes a single pitch class as a tonal centre for a musical work or expression. May be used to differentiate a musical work or expression from another with the same title.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_384_ind_1', 'MARC 21 biblio field 384 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_384_ind_1', '#', $$Relationship to original unknown$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_384_ind_1', '0', $$Original key$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_384_ind_1', '1', $$Transposed key$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_384_ind_2', 'MARC 21 biblio field 384 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_384_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '384', 'a', $$Key$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '384', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '384', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '440', $$Series Statement/Added Entry-Title$$, $$Series statement consisting of a series title alone.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_440_ind_1', 'MARC 21 biblio field 440 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_440_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_440_ind_2', 'MARC 21 biblio field 440 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_440_ind_2', '0', $$No nonfiling characters$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_440_ind_2', '1', $$Number of nonfiling characters - 1$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_440_ind_2', '2', $$Number of nonfiling characters - 2$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_440_ind_2', '3', $$Number of nonfiling characters - 3$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_440_ind_2', '4', $$Number of nonfiling characters - 4$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_440_ind_2', '5', $$Number of nonfiling characters - 5$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_440_ind_2', '6', $$Number of nonfiling characters - 6$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_440_ind_2', '7', $$Number of nonfiling characters - 7$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_440_ind_2', '8', $$Number of nonfiling characters - 8$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_440_ind_2', '9', $$Number of nonfiling characters - 9$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '440', 'a', $$Title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '440', 'n', $$Number of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '440', 'p', $$Name of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '440', 'v', $$Volume/sequential designation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '440', 'w', $$Bibliographic record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '440', 'x', $$International Standard Serial Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '440', '0', $$Authority record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '440', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '440', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '490', $$Series Statement$$, $$Series statement for a series title.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_490_ind_1', 'MARC 21 biblio field 490 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_490_ind_1', '0', $$Series not traced$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_490_ind_1', '1', $$Series traced$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_490_ind_2', 'MARC 21 biblio field 490 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_490_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '490', 'a', $$Series statement$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '490', 'l', $$Library of Congress call number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '490', 'v', $$Volume/sequential designation$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '490', 'x', $$International Standard Serial Number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '490', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '490', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '490', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '500', $$General Note$$, $$General information for which a specialized 5XX note field has not been defined.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_500_ind_1', 'MARC 21 biblio field 500 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_500_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_500_ind_2', 'MARC 21 biblio field 500 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_500_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '500', 'a', $$General note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '500', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '500', '5', $$Institution to which field applies$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '500', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '500', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '501', $$With Note$$, $$Note indicating that more than one bibliographical work is contained in the physical item at the time of publishing, release, issue, or execution. The works that are contained in the item usually have distinctive titles and lack a collective title.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_501_ind_1', 'MARC 21 biblio field 501 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_501_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_501_ind_2', 'MARC 21 biblio field 501 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_501_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '501', 'a', $$With note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '501', '5', $$Institution to which field applies$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '501', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '501', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '502', $$Dissertation Note$$, $$Designation of an academic dissertation or thesis and the institution to which it was presented. Other notes indicating the relationship between the item being cataloged and the author's dissertation or thesis, such as statements indicating that the work represents or is based on the author's thesis (e.g., ) are recorded in field 500 (General Note).$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_502_ind_1', 'MARC 21 biblio field 502 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_502_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_502_ind_2', 'MARC 21 biblio field 502 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_502_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '502', 'a', $$Dissertation note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '502', 'b', $$Degree type$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '502', 'c', $$Name of granting institution$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '502', 'd', $$Year degree granted$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '502', 'g', $$Miscellaneous information$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '502', 'o', $$Dissertation identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '502', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '502', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '504', $$Bibliography, Etc. Note$$, $$Information on the presence of one or more bibliographies, discographies, filmographies, and/or other bibliographic references in a described item or in accompanying material.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_504_ind_1', 'MARC 21 biblio field 504 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_504_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_504_ind_2', 'MARC 21 biblio field 504 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_504_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '504', 'a', $$Bibliography, etc. note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '504', 'b', $$Number of references$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '504', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '504', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '505', $$Formatted Contents Note$$, $$Titles of separate works or parts of an item or the table of contents. The field may also contain statements of responsibility and volume numbers or other sequential designations.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_505_ind_1', 'MARC 21 biblio field 505 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_505_ind_1', '0', $$Contents$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_505_ind_1', '1', $$Incomplete contents$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_505_ind_1', '2', $$Partial contents$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_505_ind_1', '8', $$No display constant generated$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_505_ind_2', 'MARC 21 biblio field 505 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_505_ind_2', '#', $$Basic$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_505_ind_2', '0', $$Enhanced$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '505', 'a', $$Formatted contents note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '505', 'g', $$Miscellaneous information$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '505', 'r', $$Statement of responsibility$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '505', 't', $$Title$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '505', 'u', $$Uniform Resource Identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '505', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '505', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '506', $$Restrictions on Access Note$$, $$Information about restrictions imposed on access to the described materials.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_506_ind_1', 'MARC 21 biblio field 506 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_506_ind_1', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_506_ind_1', '0', $$No restrictions$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_506_ind_1', '1', $$Restrictions apply$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_506_ind_2', 'MARC 21 biblio field 506 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_506_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '506', 'a', $$Terms governing access$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '506', 'b', $$Jurisdiction$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '506', 'c', $$Physical access provisions$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '506', 'd', $$Authorized users$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '506', 'e', $$Authorization$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '506', 'f', $$Standardized terminology for access restriction$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '506', 'u', $$Uniform Resource Identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '506', '2', $$Source of term$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '506', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '506', '5', $$Institution to which field applies$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '506', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '506', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '507', $$Scale Note for Graphic Material$$, $$Scale of a graphic material item given as a note. For , this field contains the scale of architectural drawings or three-dimensional artifacts. For , the scale of an item is contained in this field only in pre-AACR 2 cataloging records. Scale information is contained in field 255 (Mathematical Data Area) in AACR 2 formulated records.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_507_ind_1', 'MARC 21 biblio field 507 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_507_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_507_ind_2', 'MARC 21 biblio field 507 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_507_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '507', 'a', $$Representative fraction of scale note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '507', 'b', $$Remainder of scale note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '507', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '507', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '508', $$Creation/Production Credits Note$$, $$Credits for persons or organizations, other than members of the cast, who have participated in the creation and/or production of the work. The introductory term is usually generated as a display constant.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_508_ind_1', 'MARC 21 biblio field 508 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_508_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_508_ind_2', 'MARC 21 biblio field 508 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_508_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '508', 'a', $$Creation/production credits note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '508', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '508', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '510', $$Citation/References Note$$, $$Citations or references to published bibliographic descriptions, reviews, abstracts, or indexes of the content of the described item.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_510_ind_1', 'MARC 21 biblio field 510 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_510_ind_1', '0', $$Coverage unknown$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_510_ind_1', '1', $$Coverage complete$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_510_ind_2', 'MARC 21 biblio field 510 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_510_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '510', 'a', $$Name of source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '510', 'b', $$Coverage of source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '510', 'c', $$Location within source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '510', 'x', $$International Standard Serial Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '510', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '510', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '510', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '511', $$Participant or Performer Note$$, $$Information about the participants, players, narrators, presenters, or performers.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_511_ind_1', 'MARC 21 biblio field 511 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_511_ind_1', '0', $$No display constant generated$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_511_ind_1', '1', $$Cast$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_511_ind_2', 'MARC 21 biblio field 511 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_511_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '511', 'a', $$Participant or performer note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '511', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '511', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '513', $$Type of Report and Period Covered Note$$, $$Information on the type of report and the period covered by the report.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_513_ind_1', 'MARC 21 biblio field 513 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_513_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_513_ind_2', 'MARC 21 biblio field 513 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_513_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '513', 'a', $$Type of report$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '513', 'b', $$Period covered$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '513', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '513', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '514', $$Data Quality Note$$, $$Provides a general assessment of the quality of the data set constituting the item.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_514_ind_1', 'MARC 21 biblio field 514 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_514_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_514_ind_2', 'MARC 21 biblio field 514 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_514_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '514', 'a', $$Attribute accuracy report$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '514', 'b', $$Attribute accuracy value$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '514', 'c', $$Attribute accuracy explanation$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '514', 'd', $$Logical consistency report$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '514', 'e', $$Completeness report$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '514', 'f', $$Horizontal position accuracy report$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '514', 'g', $$Horizontal position accuracy value$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '514', 'h', $$Horizontal position accuracy explanation$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '514', 'i', $$Vertical positional accuracy report$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '514', 'j', $$Vertical positional accuracy value$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '514', 'k', $$Vertical positional accuracy explanation$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '514', 'm', $$Cloud cover$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '514', 'u', $$Uniform Resource Identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '514', 'z', $$Display note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '514', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '514', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '515', $$Numbering Peculiarities Note$$, $$Unformatted note giving irregularities and peculiarities in numbering or publishing patterns, report year coverage, revised editions, and/or issuance in parts.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_515_ind_1', 'MARC 21 biblio field 515 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_515_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_515_ind_2', 'MARC 21 biblio field 515 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_515_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '515', 'a', $$Numbering peculiarities note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '515', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '515', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '516', $$Type of Computer File or Data Note$$, $$General descriptor that characterizes the file (e.g., text, computer program, numeric). Specific information, such as the form or genre of textual material (e.g., biography, dictionaries, indexes) may be included. The general type of computer file information in coded form is recorded in 008/26 (Type of computer file).$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_516_ind_1', 'MARC 21 biblio field 516 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_516_ind_1', '#', $$Type of file$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_516_ind_1', '8', $$No display constant generated$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_516_ind_2', 'MARC 21 biblio field 516 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_516_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '516', 'a', $$Type of computer file or data note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '516', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '516', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '518', $$Date/Time and Place of an Event Note$$, $$Note on the date/time and/or place of creation, capture, recording, filming, execution, or broadcast associated with an event or the finding of a naturally occurring object. Field 033 (Date/Time and Place of an Event) contains the same information in coded form.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_518_ind_1', 'MARC 21 biblio field 518 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_518_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_518_ind_2', 'MARC 21 biblio field 518 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_518_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '518', 'a', $$Date/time and place of an event note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '518', 'd', $$Date of event$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '518', 'o', $$Other event information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '518', 'p', $$Place of event$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '518', '0', $$Record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '518', '2', $$Source of term$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '518', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '518', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '518', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '520', $$Summary, Etc.$$, $$Unformatted information that describes the scope and general contents of the materials.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_520_ind_1', 'MARC 21 biblio field 520 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_520_ind_1', '#', $$Summary$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_520_ind_1', '0', $$Subject$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_520_ind_1', '1', $$Review$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_520_ind_1', '2', $$Scope and content$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_520_ind_1', '3', $$Abstract$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_520_ind_1', '4', $$Content advice$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_520_ind_1', '8', $$No display constant generated$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_520_ind_2', 'MARC 21 biblio field 520 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_520_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '520', 'a', $$Summary, etc.$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '520', 'b', $$Expansion of summary note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '520', 'c', $$Assigning source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '520', 'u', $$Uniform Resource Identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '520', '2', $$Source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '520', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '520', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '520', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '521', $$Target Audience Note$$, $$Information that identifies the specific audience or intellectual level for which the content of the described item is considered appropriate.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_521_ind_1', 'MARC 21 biblio field 521 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_521_ind_1', '#', $$Audience$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_521_ind_1', '0', $$Reading grade level$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_521_ind_1', '1', $$Interest age level$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_521_ind_1', '2', $$Interest grade level$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_521_ind_1', '3', $$Special audience characteristics$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_521_ind_1', '4', $$Motivation/interest level$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_521_ind_1', '8', $$No display constant generated$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_521_ind_2', 'MARC 21 biblio field 521 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_521_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '521', 'a', $$Target audience note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '521', 'b', $$Source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '521', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '521', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '521', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '522', $$Geographic Coverage Note$$, $$Information about the geographic coverage of the described material (usually survey material). This information in coded form may be contained in field 052 (Geographic Classification Code).$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_522_ind_1', 'MARC 21 biblio field 522 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_522_ind_1', '#', $$Geographic coverage$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_522_ind_1', '8', $$No display constant generated$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_522_ind_2', 'MARC 21 biblio field 522 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_522_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '522', 'a', $$Geographic coverage note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '522', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '522', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '524', $$Preferred Citation of Described Materials Note$$, $$Format for the citation of the described materials that is preferred by the custodian.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_524_ind_1', 'MARC 21 biblio field 524 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_524_ind_1', '#', $$Cite as$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_524_ind_1', '8', $$No display constant generated$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_524_ind_2', 'MARC 21 biblio field 524 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_524_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '524', 'a', $$Preferred citation of described materials note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '524', '2', $$Source of schema used$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '524', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '524', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '524', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '525', $$Supplement Note$$, $$Information on the existence of supplements or special issues that are neither cataloged in separate records nor recorded in a linking entry field 770 (Supplement/Special Issue Entry).$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_525_ind_1', 'MARC 21 biblio field 525 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_525_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_525_ind_2', 'MARC 21 biblio field 525 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_525_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '525', 'a', $$Supplement note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '525', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '525', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '526', $$Study Program Information Note$$, $$Note giving the name of a study program which uses the title described in the record. Details about the study program data elements are also contained in the field. Field 526 is generally used for formal curriculum-based study or reading programs.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_526_ind_1', 'MARC 21 biblio field 526 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_526_ind_1', '0', $$Reading program$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_526_ind_1', '8', $$No display constant generated$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_526_ind_2', 'MARC 21 biblio field 526 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_526_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '526', 'a', $$Program name$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '526', 'b', $$Interest level$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '526', 'c', $$Reading level$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '526', 'd', $$Title point value$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '526', 'i', $$Display text$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '526', 'x', $$Nonpublic note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '526', 'z', $$Public note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '526', '5', $$Institution to which field applies$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '526', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '526', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '530', $$Additional Physical Form Available Note$$, $$Information concerning a different physical format in which the described item is available.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_530_ind_1', 'MARC 21 biblio field 530 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_530_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_530_ind_2', 'MARC 21 biblio field 530 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_530_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '530', 'a', $$Additional physical form available note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '530', 'b', $$Availability source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '530', 'c', $$Availability conditions$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '530', 'd', $$Order number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '530', 'u', $$Uniform Resource Identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '530', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '530', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '530', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '533', $$Reproduction Note$$, $$Descriptive data for a reproduction of an original item when the main portion of the bibliographic record describes the original item and the data differ.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_533_ind_1', 'MARC 21 biblio field 533 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_533_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_533_ind_2', 'MARC 21 biblio field 533 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_533_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '533', 'a', $$Type of reproduction$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '533', 'b', $$Place of reproduction$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '533', 'c', $$Agency responsible for reproduction$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '533', 'd', $$Date of reproduction$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '533', 'e', $$Physical description of reproduction$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '533', 'f', $$Series statement of reproduction$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '533', 'm', $$Dates and/or sequential designation of issues reproduced$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '533', 'n', $$Note about reproduction$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '533', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '533', '5', $$Institution to which field applies$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '533', '7', $$Fixed-length data elements of reproduction$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '533', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '533', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '534', $$Original Version Note$$, $$Descriptive data for an original item when the main portion of the bibliographic record describes a reproduction of that item and the data differ. Details relevant to the original are given in field 534.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_534_ind_1', 'MARC 21 biblio field 534 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_534_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_534_ind_2', 'MARC 21 biblio field 534 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_534_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '534', 'a', $$Main entry of original$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '534', 'b', $$Edition statement of original$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '534', 'c', $$Publication, distribution, etc. of original$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '534', 'e', $$Physical description, etc. of original$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '534', 'f', $$Series statement of original$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '534', 'k', $$Key title of original$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '534', 'l', $$Location of original$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '534', 'm', $$Material specific details$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '534', 'n', $$Note about original$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '534', 'o', $$Other resource identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '534', 'p', $$Introductory phrase$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '534', 't', $$Title statement of original$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '534', 'x', $$International Standard Serial Number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '534', 'z', $$International Standard Book Number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '534', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '534', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '534', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '535', $$Location of Originals/Duplicates Note$$, $$Name and address of the repository with custody over originals or duplicates of the described materials. This field is used only when the originals or duplicates are housed in a repository different from that of the materials being described.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_535_ind_1', 'MARC 21 biblio field 535 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_535_ind_1', '1', $$Holder of originals$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_535_ind_1', '2', $$Holder of duplicates$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_535_ind_2', 'MARC 21 biblio field 535 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_535_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '535', 'a', $$Custodian$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '535', 'b', $$Postal address$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '535', 'c', $$Country$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '535', 'd', $$Telecommunications address$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '535', 'g', $$Repository location code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '535', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '535', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '535', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '536', $$Funding Information Note$$, $$Contract, grant, and project numbers when the material results from a funded project. Information concerning the sponsor or funding agency also may be included.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_536_ind_1', 'MARC 21 biblio field 536 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_536_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_536_ind_2', 'MARC 21 biblio field 536 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_536_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '536', 'a', $$Text of note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '536', 'b', $$Contract number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '536', 'c', $$Grant number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '536', 'd', $$Undifferentiated number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '536', 'e', $$Program element number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '536', 'f', $$Project number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '536', 'g', $$Task number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '536', 'h', $$Work unit number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '536', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '536', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '538', $$System Details Note$$, $$Technical information about an item, such as the presence or absence of certain kinds of codes; or the physical characteristics of a computer file, such as recording densities, parity, blocking factors, mode of access, software programming language, computer requirements, peripheral requirements, trade name or recording systems, number of lines of resolution, and modulation frequency. For sound and videorecordings, information about the trade name or recording system(s) (e.g., VHS), modulation frequency and number of lines of resolution may be included.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_538_ind_1', 'MARC 21 biblio field 538 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_538_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_538_ind_2', 'MARC 21 biblio field 538 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_538_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '538', 'a', $$System details note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '538', 'i', $$Display text$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '538', 'u', $$Uniform Resource Identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '538', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '538', '5', $$Institution to which field applies$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '538', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '538', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '540', $$Terms Governing Use and Reproduction Note$$, $$Terms governing the use of the materials after access has been provided. The field includes, but is not limited to, copyrights, film rights, trade restrictions, etc. that restrict the right to reproduce, exhibit, fictionalize, quote, etc.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_540_ind_1', 'MARC 21 biblio field 540 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_540_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_540_ind_2', 'MARC 21 biblio field 540 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_540_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '540', 'a', $$Terms governing use and reproduction$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '540', 'b', $$Jurisdiction$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '540', 'c', $$Authorization$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '540', 'd', $$Authorized users$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '540', 'u', $$Uniform Resource Identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '540', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '540', '5', $$Institution to which field applies$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '540', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '540', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '541', $$Immediate Source of Acquisition Note$$, $$Information about the immediate source of acquisition of the described materials and is used primarily with original or historical items, or other archival collections.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_541_ind_1', 'MARC 21 biblio field 541 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_541_ind_1', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_541_ind_1', '0', $$Private$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_541_ind_1', '1', $$Not private$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_541_ind_2', 'MARC 21 biblio field 541 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_541_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '541', 'a', $$Source of acquisition$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '541', 'b', $$Address$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '541', 'c', $$Method of acquisition$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '541', 'd', $$Date of acquisition$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '541', 'e', $$Accession number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '541', 'f', $$Owner$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '541', 'h', $$Purchase price$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '541', 'n', $$Extent$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '541', 'o', $$Type of unit$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '541', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '541', '5', $$Institution to which field applies$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '541', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '541', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '542', $$Information Relating to Copyright Status$$, $$Information known about the item that may be used to determine copyright status.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_542_ind_1', 'MARC 21 biblio field 542 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_542_ind_1', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_542_ind_1', '0', $$Private$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_542_ind_1', '1', $$Not private$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_542_ind_2', 'MARC 21 biblio field 542 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_542_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '542', 'a', $$Personal creator$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '542', 'b', $$Personal creator death date$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '542', 'c', $$Corporate creator$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '542', 'd', $$Copyright holder$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '542', 'e', $$Copyright holder contact information$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '542', 'f', $$Copyright statement$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '542', 'g', $$Copyright date$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '542', 'h', $$Copyright renewal date$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '542', 'i', $$Publication date$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '542', 'j', $$Creation date$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '542', 'k', $$Publisher$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '542', 'l', $$Copyright status$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '542', 'm', $$Publication status$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '542', 'n', $$Note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '542', 'o', $$Research date$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '542', 'p', $$Country of publication or creation$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '542', 'q', $$Supplying agency$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '542', 'r', $$Jurisdiction of copyright assessment$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '542', 's', $$Source of information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '542', 'u', $$Uniform Resource Identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '542', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '542', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '542', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '544', $$Location of Other Archival Materials Note$$, $$Name and address of custodians of archival materials related to the described materials by provenance, specifically by having been, at a previous time, a part of the same collection or record group.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_544_ind_1', 'MARC 21 biblio field 544 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_544_ind_1', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_544_ind_1', '0', $$Associated materials$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_544_ind_1', '1', $$Related materials$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_544_ind_2', 'MARC 21 biblio field 544 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_544_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '544', 'a', $$Custodian$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '544', 'b', $$Address$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '544', 'c', $$Country$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '544', 'd', $$Title$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '544', 'e', $$Provenance$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '544', 'n', $$Note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '544', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '544', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '544', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '545', $$Biographical or Historical Data$$, $$Biographical information about an individual or historical information about an institution or event used as the main entry for the item being cataloged. When a distinction between levels of detail is required, a brief summary is given in subfield $a and a fuller annotation is given in subfield $b.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_545_ind_1', 'MARC 21 biblio field 545 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_545_ind_1', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_545_ind_1', '0', $$Biographical sketch$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_545_ind_1', '1', $$Administrative history$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_545_ind_2', 'MARC 21 biblio field 545 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_545_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '545', 'a', $$Biographical or historical data$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '545', 'b', $$Expansion$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '545', 'u', $$Uniform Resource Identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '545', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '545', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '546', $$Language Note$$, $$Textual information on the language of the described materials. A description of the alphabet, script, or other symbol system (e.g., arabic alphabet, ASCII, musical notation system, bar code, logarithmic graphing) may also be included. Coded language information is contained in fields 008/35-37 (Language) and/or 041 (Language code).$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_546_ind_1', 'MARC 21 biblio field 546 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_546_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_546_ind_2', 'MARC 21 biblio field 546 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_546_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '546', 'a', $$Language note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '546', 'b', $$Information code or alphabet$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '546', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '546', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '546', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '547', $$Former Title Complexity Note$$, $$Description of the complex relationship between titles proper whenever an intelligible note cannot be system generated from the data in field 247 (Former Title).$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_547_ind_1', 'MARC 21 biblio field 547 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_547_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_547_ind_2', 'MARC 21 biblio field 547 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_547_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '547', 'a', $$Former title complexity note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '547', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '547', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '550', $$Issuing Body Note$$, $$Information about the current and former issuing bodies of a continuing resource.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_550_ind_1', 'MARC 21 biblio field 550 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_550_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_550_ind_2', 'MARC 21 biblio field 550 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_550_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '550', 'a', $$Issuing body note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '550', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '550', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '552', $$Entity and Attribute Information Note$$, $$Description of the information content of the data set, including the entity types, their attributes, and the domains from which attribute values may be assigned.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_552_ind_1', 'MARC 21 biblio field 552 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_552_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_552_ind_2', 'MARC 21 biblio field 552 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_552_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '552', 'a', $$Entity type label$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '552', 'b', $$Entity type definition and source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '552', 'c', $$Attribute label$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '552', 'd', $$Attribute definition and source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '552', 'e', $$Enumerated domain value$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '552', 'f', $$Enumerated domain value definition and source$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '552', 'g', $$Range domain minimum and maximum$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '552', 'h', $$Codeset name and source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '552', 'i', $$Unrepresentable domain$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '552', 'j', $$Attribute units of measurement and resolution$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '552', 'k', $$Beginning and ending date of attribute values$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '552', 'l', $$Attribute value accuracy$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '552', 'm', $$Attribute value accuracy explanation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '552', 'n', $$Attribute measurement frequency$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '552', 'o', $$Entity and attribute overview$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '552', 'p', $$Entity and attribute detail citation$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '552', 'u', $$Uniform Resource Identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '552', 'z', $$Display note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '552', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '552', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '555', $$Cumulative Index/Finding Aids Note$$, $$Information on the availability of cumulative indexes for continuing resources or finding aids and similar control materials for archival and manuscripts control and visual materials whose only or major focus is the described material.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_555_ind_1', 'MARC 21 biblio field 555 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_555_ind_1', '#', $$Indexes$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_555_ind_1', '0', $$Finding aids$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_555_ind_1', '8', $$No display constant generated$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_555_ind_2', 'MARC 21 biblio field 555 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_555_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '555', 'a', $$Cumulative index/finding aids note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '555', 'b', $$Availability source$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '555', 'c', $$Degree of control$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '555', 'd', $$Bibliographic reference$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '555', 'u', $$Uniform Resource Identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '555', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '555', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '555', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '556', $$Information About Documentation Note$$, $$Information about the documentation of the described materials, such as codebooks which explain the contents and use of the file or a users’ manual to a serial.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_556_ind_1', 'MARC 21 biblio field 556 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_556_ind_1', '#', $$Documentation$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_556_ind_1', '8', $$No display constant generated$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_556_ind_2', 'MARC 21 biblio field 556 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_556_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '556', 'a', $$Information about documentation note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '556', 'z', $$International Standard Book Number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '556', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '556', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '561', $$Ownership and Custodial History$$, $$Copy-specific field that contains information concerning the ownership and custodial history of the described materials from the time of their creation to the time of their accessioning, including the time at which individual items or groups of items were first brought together in their current arrangement or collation.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_561_ind_1', 'MARC 21 biblio field 561 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_561_ind_1', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_561_ind_1', '0', $$Private$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_561_ind_1', '1', $$Not private$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_561_ind_2', 'MARC 21 biblio field 561 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_561_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '561', 'a', $$History$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '561', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '561', '5', $$Institution to which field applies$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '561', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '561', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '562', $$Copy and Version Identification Note$$, $$Information that distinguishes the copy(s) or version(s) of materials held by an archive or manuscript repository when more than one copy or version exists or could exist.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_562_ind_1', 'MARC 21 biblio field 562 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_562_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_562_ind_2', 'MARC 21 biblio field 562 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_562_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '562', 'a', $$Identifying markings$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '562', 'b', $$Copy identification$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '562', 'c', $$Version identification$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '562', 'd', $$Presentation format$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '562', 'e', $$Number of copies$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '562', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '562', '5', $$Institution to which field applies$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '562', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '562', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '563', $$Binding Information$$, $$Binding information intended primarily for use with antiquarian materials, rare books and other special collections.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_563_ind_1', 'MARC 21 biblio field 563 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_563_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_563_ind_2', 'MARC 21 biblio field 563 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_563_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '563', 'a', $$Binding note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '563', 'u', $$Uniform Resource Identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '563', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '563', '5', $$Institution to which field applies$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '563', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '563', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '565', $$Case File Characteristics Note$$, $$Information about the content and characteristics of case files and/or the number of cases or variables making up a case file or a database.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_565_ind_1', 'MARC 21 biblio field 565 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_565_ind_1', '#', $$File size$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_565_ind_1', '0', $$Case file characteristics$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_565_ind_1', '8', $$No display constant generated$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_565_ind_2', 'MARC 21 biblio field 565 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_565_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '565', 'a', $$Number of cases/variables$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '565', 'b', $$Name of variable$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '565', 'c', $$Unit of analysis$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '565', 'd', $$Universe of data$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '565', 'e', $$Filing scheme or code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '565', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '565', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '565', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '567', $$Methodology Note$$, $$Information concerning significant methodological characteristics of the material, such as the algorithm, universe description, sampling procedures, classification, or validation characteristics.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_567_ind_1', 'MARC 21 biblio field 567 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_567_ind_1', '#', $$Methodology$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_567_ind_1', '8', $$No display constant generated$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_567_ind_2', 'MARC 21 biblio field 567 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_567_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '567', 'a', $$Methodology note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '567', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '567', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '580', $$Linking Entry Complexity Note$$, $$Description of the complex relationship between the item described in the record and other items that cannot be adequately generated from the linking entry fields 760-787.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_580_ind_1', 'MARC 21 biblio field 580 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_580_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_580_ind_2', 'MARC 21 biblio field 580 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_580_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '580', 'a', $$Linking entry complexity note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '580', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '580', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '581', $$Publications About Described Materials Note$$, $$Citation or information about a publication that is based on the use, study, or analysis of the materials described in the record.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_581_ind_1', 'MARC 21 biblio field 581 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_581_ind_1', '#', $$Publications$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_581_ind_1', '8', $$No display constant generated$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_581_ind_2', 'MARC 21 biblio field 581 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_581_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '581', 'a', $$Publications about described materials note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '581', 'z', $$International Standard Book Number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '581', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '581', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '581', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '583', $$Action Note$$, $$Information about processing, reference, and preservation actions.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_583_ind_1', 'MARC 21 biblio field 583 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_583_ind_1', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_583_ind_1', '0', $$Private$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_583_ind_1', '1', $$Not private$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_583_ind_2', 'MARC 21 biblio field 583 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_583_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '583', 'a', $$Action$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '583', 'b', $$Action identification$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '583', 'c', $$Time/date of action$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '583', 'd', $$Action interval$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '583', 'e', $$Contingency for action$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '583', 'f', $$Authorization$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '583', 'h', $$Jurisdiction$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '583', 'i', $$Method of action$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '583', 'j', $$Site of action$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '583', 'k', $$Action agent$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '583', 'l', $$Status$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '583', 'n', $$Extent$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '583', 'o', $$Type of unit$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '583', 'u', $$Uniform Resource Identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '583', 'x', $$Nonpublic note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '583', 'z', $$Public note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '583', '2', $$Source of term$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '583', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '583', '5', $$Institution to which field applies$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '583', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '583', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '584', $$Accumulation and Frequency of Use Note$$, $$Measurements of and information about the rates of accumulation (for continuing, open-ended accessions) and/or the rate of reference use of the described materials.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_584_ind_1', 'MARC 21 biblio field 584 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_584_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_584_ind_2', 'MARC 21 biblio field 584 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_584_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '584', 'a', $$Accumulation$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '584', 'b', $$Frequency of use$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '584', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '584', '5', $$Institution to which field applies$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '584', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '584', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '585', $$Exhibitions Note$$, $$Copy-specific field that contains a note which cites exhibitions where the material described has been shown.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_585_ind_1', 'MARC 21 biblio field 585 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_585_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_585_ind_2', 'MARC 21 biblio field 585 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_585_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '585', 'a', $$Exhibitions note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '585', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '585', '5', $$Institution to which field applies$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '585', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '585', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '586', $$Awards Note$$, $$Information on awards associated with the described item.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_586_ind_1', 'MARC 21 biblio field 586 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_586_ind_1', '#', $$Awards$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_586_ind_1', '8', $$No display constant generated$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_586_ind_2', 'MARC 21 biblio field 586 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_586_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '586', 'a', $$Awards note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '586', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '586', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '586', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '588', $$Source of Description Note$$, $$Information used for tracking and controlling the metadata contained in the record. It includes general and specific source of description notes that are especially of interest to other catalogers.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_588_ind_1', 'MARC 21 biblio field 588 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_588_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_588_ind_2', 'MARC 21 biblio field 588 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_588_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '588', 'a', $$Source of description note$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '588', '5', $$Institution to which field applies$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '588', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '588', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '600', $$Subject Added Entry-Personal Name$$, $$Subject added entry in which the entry element is a personal name.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_600_ind_1', 'MARC 21 biblio field 600 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_600_ind_1', '0', $$Forename$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_600_ind_1', '1', $$Surname$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_600_ind_1', '3', $$Family name$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_600_ind_2', 'MARC 21 biblio field 600 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_600_ind_2', '0', $$Library of Congress Subject Headings$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_600_ind_2', '1', $$LC subject headings for children's literature$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_600_ind_2', '2', $$Medical Subject Headings$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_600_ind_2', '3', $$National Agricultural Library subject authority file$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_600_ind_2', '4', $$Source not specified$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_600_ind_2', '5', $$Canadian Subject Headings$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_600_ind_2', '6', $$Répertoire de vedettes-matière$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_600_ind_2', '7', $$Source specified in subfield $2$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '600', 'a', $$Personal name$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '600', 'b', $$Numeration$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '600', 'c', $$Titles and other words associated with a name$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '600', 'd', $$Dates associated with a name$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '600', 'e', $$Relator term$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '600', 'f', $$Date of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '600', 'g', $$Miscellaneous information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '600', 'h', $$Medium$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '600', 'j', $$Attribution qualifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '600', 'k', $$Form subheading$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '600', 'l', $$Language of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '600', 'm', $$Medium of performance for music$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '600', 'n', $$Number of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '600', 'o', $$Arranged statement for music$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '600', 'p', $$Name of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '600', 'q', $$Fuller form of name$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '600', 'r', $$Key for music$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '600', 's', $$Version$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '600', 't', $$Title of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '600', 'u', $$Affiliation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '600', 'v', $$Form subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '600', 'x', $$General subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '600', 'y', $$Chronological subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '600', 'z', $$Geographic subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '600', '0', $$Authority record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '600', '2', $$Source of heading or term$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '600', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '600', '4', $$Relator code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '600', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '600', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '610', $$Subject Added Entry-Corporate Name$$, $$Subject added entry in which the entry element is a corporate name.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_610_ind_1', 'MARC 21 biblio field 610 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_610_ind_1', '0', $$Inverted name$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_610_ind_1', '1', $$Jurisdiction name$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_610_ind_1', '2', $$Name in direct order$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_610_ind_2', 'MARC 21 biblio field 610 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_610_ind_2', '0', $$Library of Congress Subject Headings$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_610_ind_2', '1', $$LC subject headings for children's literature$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_610_ind_2', '2', $$Medical Subject Headings$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_610_ind_2', '3', $$National Agricultural Library subject authority file$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_610_ind_2', '4', $$Source not specified$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_610_ind_2', '5', $$Canadian Subject Headings$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_610_ind_2', '6', $$Répertoire de vedettes-matière$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_610_ind_2', '7', $$Source specified in subfield $2$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '610', 'a', $$Corporate name or jurisdiction name as entry element$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '610', 'b', $$Subordinate unit$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '610', 'c', $$Location of meeting$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '610', 'd', $$Date of meeting or treaty signing$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '610', 'e', $$Relator term$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '610', 'f', $$Date of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '610', 'g', $$Miscellaneous information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '610', 'h', $$Medium$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '610', 'k', $$Form subheading$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '610', 'l', $$Language of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '610', 'm', $$Medium of performance for music$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '610', 'n', $$Number of part/section/meeting$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '610', 'o', $$Arranged statement for music$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '610', 'p', $$Name of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '610', 'r', $$Key for music$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '610', 's', $$Version$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '610', 't', $$Title of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '610', 'u', $$Affiliation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '610', 'v', $$Form subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '610', 'x', $$General subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '610', 'y', $$Chronological subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '610', 'z', $$Geographic subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '610', '0', $$Authority record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '610', '2', $$Source of heading or term$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '610', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '610', '4', $$Relator code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '610', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '610', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '611', $$Subject Added Entry-Meeting Name$$, $$Subject added entry in which the entry element is a meeting or conference name.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_611_ind_1', 'MARC 21 biblio field 611 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_611_ind_1', '0', $$Inverted name$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_611_ind_1', '1', $$Jurisdiction name$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_611_ind_1', '2', $$Name in direct order$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_611_ind_2', 'MARC 21 biblio field 611 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_611_ind_2', '0', $$Library of Congress Subject Headings$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_611_ind_2', '1', $$LC subject headings for children's literature$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_611_ind_2', '2', $$Medical Subject Headings$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_611_ind_2', '3', $$National Agricultural Library subject authority file$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_611_ind_2', '4', $$Source not specified$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_611_ind_2', '5', $$Canadian Subject Headings$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_611_ind_2', '6', $$Répertoire de vedettes-matière$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_611_ind_2', '7', $$Source specified in subfield $2$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '611', 'a', $$Meeting name or jurisdiction name as entry element$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '611', 'c', $$Location of meeting$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '611', 'd', $$Date of meeting$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '611', 'e', $$Subordinate unit$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '611', 'f', $$Date of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '611', 'g', $$Miscellaneous information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '611', 'h', $$Medium$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '611', 'j', $$Relator term$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '611', 'k', $$Form subheading$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '611', 'l', $$Language of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '611', 'n', $$Number of part/section/meeting$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '611', 'p', $$Name of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '611', 'q', $$Name of meeting following jurisdiction name entry element$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '611', 's', $$Version$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '611', 't', $$Title of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '611', 'u', $$Affiliation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '611', 'v', $$Form subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '611', 'x', $$General subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '611', 'y', $$Chronological subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '611', 'z', $$Geographic subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '611', '0', $$Authority record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '611', '2', $$Source of heading or term$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '611', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '611', '4', $$Relator code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '611', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '611', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '630', $$Subject Added Entry-Uniform Title$$, $$Subject added entry in which the entry element is a uniform title.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_630_ind_1', 'MARC 21 biblio field 630 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_630_ind_1', '0', $$No nonfiling characters$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_630_ind_1', '1', $$Number of nonfiling characters - 1$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_630_ind_1', '2', $$Number of nonfiling characters - 2$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_630_ind_1', '3', $$Number of nonfiling characters - 3$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_630_ind_1', '4', $$Number of nonfiling characters - 4$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_630_ind_1', '5', $$Number of nonfiling characters - 5$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_630_ind_1', '6', $$Number of nonfiling characters - 6$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_630_ind_1', '7', $$Number of nonfiling characters - 7$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_630_ind_1', '8', $$Number of nonfiling characters - 8$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_630_ind_1', '9', $$Number of nonfiling characters - 9$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_630_ind_2', 'MARC 21 biblio field 630 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_630_ind_2', '0', $$Library of Congress Subject Headings$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_630_ind_2', '1', $$LC subject headings for children's literature$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_630_ind_2', '2', $$Medical Subject Headings$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_630_ind_2', '3', $$National Agricultural Library subject authority file$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_630_ind_2', '4', $$Source not specified$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_630_ind_2', '5', $$Canadian Subject Headings$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_630_ind_2', '6', $$Répertoire de vedettes-matière$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_630_ind_2', '7', $$Source specified in subfield $2$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '630', 'a', $$Uniform title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '630', 'd', $$Date of treaty signing$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '630', 'e', $$Relator term$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '630', 'f', $$Date of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '630', 'g', $$Miscellaneous information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '630', 'h', $$Medium$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '630', 'k', $$Form subheading$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '630', 'l', $$Language of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '630', 'm', $$Medium of performance for music$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '630', 'n', $$Number of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '630', 'o', $$Arranged statement for music$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '630', 'p', $$Name of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '630', 'r', $$Key for music$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '630', 's', $$Version$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '630', 't', $$Title of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '630', 'v', $$Form subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '630', 'x', $$General subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '630', 'y', $$Chronological subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '630', 'z', $$Geographic subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '630', '0', $$Authority record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '630', '2', $$Source of heading or term$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '630', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '630', '4', $$Relator code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '630', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '630', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '648', $$Subject Added Entry-Chronological Term$$, $$Subject added entry in which the entry element is a chronological term.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_648_ind_1', 'MARC 21 biblio field 648 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_648_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_648_ind_2', 'MARC 21 biblio field 648 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_648_ind_2', '0', $$Library of Congress Subject Headings$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_648_ind_2', '1', $$LC subject headings for children's literature$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_648_ind_2', '2', $$Medical Subject Headings$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_648_ind_2', '3', $$National Agricultural Library subject authority file$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_648_ind_2', '4', $$Source not specified$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_648_ind_2', '5', $$Canadian Subject Headings$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_648_ind_2', '6', $$Répertoire de vedettes-matière$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_648_ind_2', '7', $$Source specified in subfield $2$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '648', 'a', $$Chronological term$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '648', 'v', $$Form subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '648', 'x', $$General subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '648', 'y', $$Chronological subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '648', 'z', $$Geographic subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '648', '0', $$Authority record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '648', '2', $$Source of heading or term$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '648', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '648', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '648', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '650', $$Subject Added Entry-Topical Term$$, $$Subject added entry in which the entry element is a topical term.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_650_ind_1', 'MARC 21 biblio field 650 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_650_ind_1', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_650_ind_1', '0', $$No level specified$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_650_ind_1', '1', $$Primary$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_650_ind_1', '2', $$Secondary$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_650_ind_2', 'MARC 21 biblio field 650 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_650_ind_2', '0', $$Library of Congress Subject Headings$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_650_ind_2', '1', $$LC subject headings for children's literature$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_650_ind_2', '2', $$Medical Subject Headings$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_650_ind_2', '3', $$National Agricultural Library subject authority file$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_650_ind_2', '4', $$Source not specified$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_650_ind_2', '5', $$Canadian Subject Headings$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_650_ind_2', '6', $$Répertoire de vedettes-matière$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_650_ind_2', '7', $$Source specified in subfield $2$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '650', 'a', $$Topical term or geographic name entry element$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '650', 'b', $$Topical term following geographic name entry element$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '650', 'c', $$Location of event$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '650', 'd', $$Active dates$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '650', 'e', $$Relator term$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '650', 'v', $$Form subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '650', 'x', $$General subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '650', 'y', $$Chronological subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '650', 'z', $$Geographic subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '650', '0', $$Authority record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '650', '2', $$Source of heading or term$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '650', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '650', '4', $$Relator code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '650', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '650', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '651', $$Subject Added Entry-Geographic Name$$, $$Subject added entry in which the entry element is a geographic name.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_651_ind_1', 'MARC 21 biblio field 651 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_651_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_651_ind_2', 'MARC 21 biblio field 651 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_651_ind_2', '0', $$Library of Congress Subject Headings$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_651_ind_2', '1', $$LC subject headings for children's literature$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_651_ind_2', '2', $$Medical Subject Headings$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_651_ind_2', '3', $$National Agricultural Library subject authority file$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_651_ind_2', '4', $$Source not specified$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_651_ind_2', '5', $$Canadian Subject Headings$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_651_ind_2', '6', $$Répertoire de vedettes-matière$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_651_ind_2', '7', $$Source specified in subfield $2$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '651', 'a', $$Geographic name$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '651', 'e', $$Relator term$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '651', 'v', $$Form subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '651', 'x', $$General subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '651', 'y', $$Chronological subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '651', 'z', $$Geographic subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '651', '0', $$Authority record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '651', '2', $$Source of heading or term$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '651', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '651', '4', $$Relator code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '651', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '651', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '653', $$Index Term-Uncontrolled$$, $$Index term added entry that is not constructed by standard subject heading/thesaurus-building conventions.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_653_ind_1', 'MARC 21 biblio field 653 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_653_ind_1', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_653_ind_1', '0', $$No level specified$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_653_ind_1', '1', $$Primary$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_653_ind_1', '2', $$Secondary$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_653_ind_2', 'MARC 21 biblio field 653 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_653_ind_2', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_653_ind_2', '0', $$Topical term$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_653_ind_2', '1', $$Personal name$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_653_ind_2', '2', $$Corporate name$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_653_ind_2', '3', $$Meeting name$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_653_ind_2', '4', $$Chronological term$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_653_ind_2', '5', $$Geographic name$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_653_ind_2', '6', $$Genre/form term$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '653', 'a', $$Uncontrolled term$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '653', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '653', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '654', $$Subject Added Entry-Faceted Topical Terms$$, $$Topical subject constructed from a faceted vocabulary.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_654_ind_1', 'MARC 21 biblio field 654 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_654_ind_1', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_654_ind_1', '0', $$No level specified$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_654_ind_1', '1', $$Primary$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_654_ind_1', '2', $$Secondary$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_654_ind_2', 'MARC 21 biblio field 654 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_654_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '654', 'a', $$Focus term$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '654', 'b', $$Non-focus term$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '654', 'c', $$Facet/hierarchy designation$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '654', 'e', $$Relator term$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '654', 'v', $$Form subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '654', 'y', $$Chronological subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '654', 'z', $$Geographic subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '654', '0', $$Authority record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '654', '2', $$Source of heading or term$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '654', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '654', '4', $$Relator code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '654', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '654', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '655', $$Index Term-Genre/Form$$, $$Terms indicating the genre, form, and/or physical characteristics of the materials being described. A designates the style or technique of the intellectual content of textual materials or, for graphic materials, aspects such as vantage point, intended purpose, characteristics of the creator, publication status, or method of representation. A designates historically and functionally specific kinds of materials distinguished by their physical character, the subject of their intellectual content, or the order of information within them. terms designate historically and functionally specific kinds of materials as distinguished by an examination of their physical character, subject of their intellectual content, or the order of information with them.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_655_ind_1', 'MARC 21 biblio field 655 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_655_ind_1', '#', $$Basic$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_655_ind_1', '0', $$Faceted$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_655_ind_2', 'MARC 21 biblio field 655 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_655_ind_2', '0', $$Library of Congress Subject Headings$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_655_ind_2', '1', $$LC subject headings for children's literature$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_655_ind_2', '2', $$Medical Subject Headings$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_655_ind_2', '3', $$National Agricultural Library subject authority file$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_655_ind_2', '4', $$Source not specified$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_655_ind_2', '5', $$Canadian Subject Headings$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_655_ind_2', '6', $$Répertoire de vedettes-matière$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_655_ind_2', '7', $$Source specified in subfield $2$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '655', 'a', $$Genre/form data or focus term$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '655', 'b', $$Non-focus term$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '655', 'c', $$Facet/hierarchy designation$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '655', 'v', $$Form subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '655', 'x', $$General subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '655', 'y', $$Chronological subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '655', 'z', $$Geographic subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '655', '0', $$Authority record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '655', '2', $$Source of term$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '655', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '655', '5', $$Institution to which field applies$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '655', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '655', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '656', $$Index Term-Occupation$$, $$Index term that is descriptive of the occupation (including avocation) reflected in the contents of the described materials.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_656_ind_1', 'MARC 21 biblio field 656 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_656_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_656_ind_2', 'MARC 21 biblio field 656 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_656_ind_2', '7', $$Source specified in subfield $2$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '656', 'a', $$Occupation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '656', 'k', $$Form$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '656', 'v', $$Form subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '656', 'x', $$General subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '656', 'y', $$Chronological subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '656', 'z', $$Geographic subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '656', '0', $$Authority record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '656', '2', $$Source of term$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '656', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '656', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '656', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '657', $$Index Term-Function$$, $$Index term that describes the activity or function that generated the described materials.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_657_ind_1', 'MARC 21 biblio field 657 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_657_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_657_ind_2', 'MARC 21 biblio field 657 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_657_ind_2', '7', $$Source specified in subfield $2$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '657', 'a', $$Function$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '657', 'v', $$Form subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '657', 'x', $$General subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '657', 'y', $$Chronological subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '657', 'z', $$Geographic subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '657', '0', $$Authority record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '657', '2', $$Source of term$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '657', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '657', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '657', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '658', $$Index Term-Curriculum Objective$$, $$Index terms denoting curriculum or course-of-study objectives applicable to the content of the described materials. The field may also contain correlation factors indicating the degree to which the described materials meet an objective. Codes assigned to specific objectives in published lists are also recorded in this field.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_658_ind_1', 'MARC 21 biblio field 658 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_658_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_658_ind_2', 'MARC 21 biblio field 658 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_658_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '658', 'a', $$Main curriculum objective$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '658', 'b', $$Subordinate curriculum objective$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '658', 'c', $$Curriculum code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '658', 'd', $$Correlation factor$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '658', '2', $$Source of term or code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '658', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '658', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '662', $$Subject Added Entry-Hierarchical Place Name$$, $$Hierarchical form of a geographic name used as a subject added entry.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_662_ind_1', 'MARC 21 biblio field 662 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_662_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_662_ind_2', 'MARC 21 biblio field 662 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_662_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '662', 'a', $$Country or larger entity$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '662', 'b', $$First-order political jurisdiction$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '662', 'c', $$Intermediate political jurisdiction$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '662', 'd', $$City$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '662', 'e', $$Relator term$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '662', 'f', $$City subsection$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '662', 'g', $$Other nonjurisdictional geographic region and feature$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '662', 'h', $$Extraterrestrial area$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '662', '0', $$Authority record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '662', '2', $$Source of heading or term$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '662', '4', $$Relator code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '662', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '662', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '700', $$Added Entry-Personal Name$$, $$Added entry in which the entry element is a personal name.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_700_ind_1', 'MARC 21 biblio field 700 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_700_ind_1', '0', $$Forename$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_700_ind_1', '1', $$Surname$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_700_ind_1', '3', $$Family name$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_700_ind_2', 'MARC 21 biblio field 700 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_700_ind_2', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_700_ind_2', '2', $$Analytical entry$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '700', 'a', $$Personal name$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '700', 'b', $$Numeration$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '700', 'c', $$Titles and other words associated with a name$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '700', 'd', $$Dates associated with a name$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '700', 'e', $$Relator term$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '700', 'f', $$Date of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '700', 'g', $$Miscellaneous information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '700', 'h', $$Medium$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '700', 'j', $$Attribution qualifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '700', 'k', $$Form subheading$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '700', 'l', $$Language of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '700', 'm', $$Medium of performance for music$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '700', 'n', $$Number of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '700', 'o', $$Arranged statement for music$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '700', 'p', $$Name of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '700', 'q', $$Fuller form of name$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '700', 'r', $$Key for music$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '700', 's', $$Version$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '700', 't', $$Title of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '700', 'u', $$Affiliation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '700', 'x', $$International Standard Serial Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '700', '0', $$Authority record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '700', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '700', '4', $$Relator code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '700', '5', $$Institution to which field applies$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '700', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '700', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '710', $$Added Entry-Corporate Name$$, $$Added entry in which the entry element is a corporate name.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_710_ind_1', 'MARC 21 biblio field 710 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_710_ind_1', '0', $$Inverted name$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_710_ind_1', '1', $$Jurisdiction name$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_710_ind_1', '2', $$Name in direct order$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_710_ind_2', 'MARC 21 biblio field 710 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_710_ind_2', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_710_ind_2', '2', $$Analytical entry$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '710', 'a', $$Corporate name or jurisdiction name as entry element$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '710', 'b', $$Subordinate unit$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '710', 'c', $$Location of meeting$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '710', 'd', $$Date of meeting or treaty signing$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '710', 'e', $$Relator term$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '710', 'f', $$Date of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '710', 'g', $$Miscellaneous information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '710', 'h', $$Medium$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '710', 'k', $$Form subheading$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '710', 'l', $$Language of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '710', 'm', $$Medium of performance for music$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '710', 'n', $$Number of part/section/meeting$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '710', 'o', $$Arranged statement for music$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '710', 'p', $$Name of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '710', 'r', $$Key for music$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '710', 's', $$Version$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '710', 't', $$Title of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '710', 'u', $$Affiliation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '710', 'x', $$International Standard Serial Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '710', '0', $$Authority record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '710', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '710', '4', $$Relator code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '710', '5', $$Institution to which field applies$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '710', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '710', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '711', $$Added Entry-Meeting Name$$, $$Added entry in which the entry element is a meeting name.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_711_ind_1', 'MARC 21 biblio field 711 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_711_ind_1', '0', $$Inverted name$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_711_ind_1', '1', $$Jurisdiction name$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_711_ind_1', '2', $$Name in direct order$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_711_ind_2', 'MARC 21 biblio field 711 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_711_ind_2', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_711_ind_2', '2', $$Analytical entry$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '711', 'a', $$Meeting name or jurisdiction name as entry element$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '711', 'c', $$Location of meeting$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '711', 'd', $$Date of meeting$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '711', 'e', $$Subordinate unit$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '711', 'f', $$Date of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '711', 'g', $$Miscellaneous information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '711', 'h', $$Medium$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '711', 'j', $$Relator term$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '711', 'k', $$Form subheading$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '711', 'l', $$Language of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '711', 'n', $$Number of part/section/meeting$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '711', 'p', $$Name of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '711', 'q', $$Name of meeting following jurisdiction name entry element$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '711', 's', $$Version$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '711', 't', $$Title of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '711', 'u', $$Affiliation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '711', 'x', $$International Standard Serial Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '711', '0', $$Authority record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '711', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '711', '4', $$Relator code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '711', '5', $$Institution to which field applies$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '711', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '711', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '720', $$Added Entry-Uncontrolled Name$$, $$Added entry in which the name is not controlled in an authority file or list. It is also used for names that have not been formulated according to cataloging rules. Names may be of any type (e.g., personal, corporate, meeting).$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_720_ind_1', 'MARC 21 biblio field 720 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_720_ind_1', '#', $$Not specified$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_720_ind_1', '1', $$Personal$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_720_ind_1', '2', $$Other$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_720_ind_2', 'MARC 21 biblio field 720 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_720_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '720', 'a', $$Name$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '720', 'e', $$Relator term$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '720', '4', $$Relator code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '720', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '720', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '730', $$Added Entry-Uniform Title$$, $$Uniform title, a related or an analytical title that is controlled by an authority file or list, used as an added entry.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_730_ind_1', 'MARC 21 biblio field 730 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_730_ind_1', '0', $$No nonfiling characters$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_730_ind_1', '1', $$Number of nonfiling characters - 1$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_730_ind_1', '2', $$Number of nonfiling characters - 2$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_730_ind_1', '3', $$Number of nonfiling characters - 3$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_730_ind_1', '4', $$Number of nonfiling characters - 4$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_730_ind_1', '5', $$Number of nonfiling characters - 5$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_730_ind_1', '6', $$Number of nonfiling characters - 6$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_730_ind_1', '7', $$Number of nonfiling characters - 7$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_730_ind_1', '8', $$Number of nonfiling characters - 8$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_730_ind_1', '9', $$Number of nonfiling characters - 9$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_730_ind_2', 'MARC 21 biblio field 730 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_730_ind_2', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_730_ind_2', '2', $$Analytical entry$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '730', 'a', $$Uniform title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '730', 'd', $$Date of treaty signing$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '730', 'f', $$Date of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '730', 'g', $$Miscellaneous information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '730', 'h', $$Medium$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '730', 'k', $$Form subheading$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '730', 'l', $$Language of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '730', 'm', $$Medium of performance for music$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '730', 'n', $$Number of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '730', 'o', $$Arranged statement for music$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '730', 'p', $$Name of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '730', 'r', $$Key for music$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '730', 's', $$Version$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '730', 't', $$Title of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '730', 'x', $$International Standard Serial Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '730', '0', $$Authority record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '730', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '730', '5', $$Institution to which field applies$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '730', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '730', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '740', $$Added Entry-Uncontrolled Related/Analytical Title$$, $$Added entries for related or analytical titles that are not controlled through an authority file or list. (If related or analytical titles are controlled by an authority file, use field 730 (Added entry - uniform title)).$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_740_ind_1', 'MARC 21 biblio field 740 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_740_ind_1', '0', $$No nonfiling characters$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_740_ind_1', '1', $$Number of nonfiling characters - 1$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_740_ind_1', '2', $$Number of nonfiling characters - 2$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_740_ind_1', '3', $$Number of nonfiling characters - 3$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_740_ind_1', '4', $$Number of nonfiling characters - 4$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_740_ind_1', '5', $$Number of nonfiling characters - 5$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_740_ind_1', '6', $$Number of nonfiling characters - 6$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_740_ind_1', '7', $$Number of nonfiling characters - 7$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_740_ind_1', '8', $$Number of nonfiling characters - 8$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_740_ind_1', '9', $$Number of nonfiling characters - 9$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_740_ind_2', 'MARC 21 biblio field 740 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_740_ind_2', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_740_ind_2', '2', $$Analytical entry$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '740', 'a', $$Uncontrolled related/analytical title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '740', 'h', $$Medium$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '740', 'n', $$Number of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '740', 'p', $$Name of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '740', '5', $$Institution to which field applies$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '740', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '740', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '751', $$Added Entry-Geographic Name$$, $$Added entry in which the entry element is a geographic name that is related to a particular attribute of the described item, e.g., the place of publication for a rare book, place of distribution, place of a university to which a dissertation is submitted, place of an event such as a conference, etc.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_751_ind_1', 'MARC 21 biblio field 751 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_751_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_751_ind_2', 'MARC 21 biblio field 751 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_751_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '751', 'a', $$Geographic name$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '751', 'e', $$Relator term$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '751', '0', $$Authority record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '751', '2', $$Source of heading or term$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '751', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '751', '4', $$Relator code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '751', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '751', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '752', $$Added Entry-Hierarchical Place Name$$, $$Added entry in which the entry element is a hierarchical form of place name that is related to a particular attribute of the described item, e.g., the place of publication for a rare book. For display, a dash (--) may be generated to separate the subelements of the place name, e.g., Canada -- British Columbia -- Vancouver.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_752_ind_1', 'MARC 21 biblio field 752 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_752_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_752_ind_2', 'MARC 21 biblio field 752 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_752_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '752', 'a', $$Country or larger entity$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '752', 'b', $$First-order political jurisdiction$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '752', 'c', $$Intermediate political jurisdiction$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '752', 'd', $$City$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '752', 'f', $$City subsection$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '752', 'g', $$Other nonjurisdictional geographic region and feature$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '752', 'h', $$Extraterrestrial area$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '752', '0', $$Authority record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '752', '2', $$Source of heading or term$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '752', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '752', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '753', $$System Details Access to Computer Files$$, $$Information on the technical aspects of a computer file and any accompanying material that may be used to select and arrange the record with other records in a printed index.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_753_ind_1', 'MARC 21 biblio field 753 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_753_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_753_ind_2', 'MARC 21 biblio field 753 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_753_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '753', 'a', $$Make and model of machine$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '753', 'b', $$Programming language$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '753', 'c', $$Operating system$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '753', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '753', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '754', $$Added Entry-Taxonomic Identification$$, $$Added entry in which the entry element is the taxonomic name or category associated with the described item.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_754_ind_1', 'MARC 21 biblio field 754 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_754_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_754_ind_2', 'MARC 21 biblio field 754 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_754_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '754', 'a', $$Taxonomic name$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '754', 'c', $$Taxonomic category$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '754', 'd', $$Common or alternative name$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '754', 'x', $$Non-public note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '754', 'z', $$Public note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '754', '0', $$Authority record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '754', '2', $$Source of taxonomic identification$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '754', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '754', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '760', $$Main Series Entry$$, $$Information concerning the related main series when the target item is a subseries (vertical relationship). When a note is generated from this field, the introductory phrase or may be generated based on the field tag for display.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_760_ind_1', 'MARC 21 biblio field 760 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_760_ind_1', '0', $$Display note$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_760_ind_1', '1', $$Do not display note$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_760_ind_2', 'MARC 21 biblio field 760 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_760_ind_2', '#', $$Main series$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_760_ind_2', '8', $$No display constant generated$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '760', 'a', $$Main entry heading$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '760', 'b', $$Edition$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '760', 'c', $$Qualifying information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '760', 'd', $$Place, publisher, and date of publication$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '760', 'g', $$Related parts$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '760', 'h', $$Physical description$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '760', 'i', $$Relationship information$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '760', 'm', $$Material-specific details$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '760', 'n', $$Note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '760', 'o', $$Other item identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '760', 's', $$Uniform title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '760', 't', $$Title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '760', 'w', $$Record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '760', 'x', $$International Standard Serial Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '760', 'y', $$CODEN designation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '760', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '760', '7', $$Control subfield$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '760', 'p', $$Personal name$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '762', $$Subseries Entry$$, $$Information concerning a related subseries when the target item is a main series or a parent subseries (vertical relationship). When a note is generated from this field, the introductory phrase may be generated based on the field tag for display.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_762_ind_1', 'MARC 21 biblio field 762 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_762_ind_1', '0', $$Display note$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_762_ind_1', '1', $$Do not display note$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_762_ind_2', 'MARC 21 biblio field 762 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_762_ind_2', '#', $$Has subseries$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_762_ind_2', '8', $$No display constant generated$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '762', 'a', $$Main entry heading$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '762', 'b', $$Edition$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '762', 'c', $$Qualifying information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '762', 'd', $$Place, publisher, and date of publication$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '762', 'g', $$Related parts$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '762', 'h', $$Physical description$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '762', 'i', $$Relationship information$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '762', 'm', $$Material-specific details$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '762', 'n', $$Note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '762', 'o', $$Other item identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '762', 's', $$Uniform title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '762', 't', $$Title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '762', 'w', $$Record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '762', 'x', $$International Standard Serial Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '762', 'y', $$CODEN designation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '762', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '762', '7', $$Control subfield$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '762', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '765', $$Original Language Entry$$, $$Information concerning the publication in its original language when the target item is a translation (horizontal relationship). When a note is generated from this field, the introductory phrase may be generated based on the field tag for display.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_765_ind_1', 'MARC 21 biblio field 765 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_765_ind_1', '0', $$Display note$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_765_ind_1', '1', $$Do not display note$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_765_ind_2', 'MARC 21 biblio field 765 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_765_ind_2', '#', $$Translation of$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_765_ind_2', '8', $$No display constant generated$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '765', 'a', $$Main entry heading$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '765', 'b', $$Edition$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '765', 'c', $$Qualifying information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '765', 'd', $$Place, publisher, and date of publication$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '765', 'g', $$Related parts$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '765', 'h', $$Physical description$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '765', 'i', $$Relationship information$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '765', 'k', $$Series data for related item$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '765', 'm', $$Material-specific details$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '765', 'n', $$Note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '765', 'o', $$Other item identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '765', 'r', $$Report number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '765', 's', $$Uniform title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '765', 't', $$Title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '765', 'u', $$Standard Technical Report Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '765', 'w', $$Record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '765', 'x', $$International Standard Serial Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '765', 'y', $$CODEN designation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '765', 'z', $$International Standard Book Number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '765', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '765', '7', $$Control subfield$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '765', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '767', $$Translation Entry$$, $$Information concerning the publication in some other language other than the original when the target item is in the original language or is another translation (horizontal relationship). When a note is generated from this field, the introductory phrase may be generated based on the field tag for display.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_767_ind_1', 'MARC 21 biblio field 767 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_767_ind_1', '0', $$Display note$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_767_ind_1', '1', $$Do not display note$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_767_ind_2', 'MARC 21 biblio field 767 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_767_ind_2', '#', $$Translated as$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_767_ind_2', '8', $$No display constant generated$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '767', 'a', $$Main entry heading$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '767', 'b', $$Edition$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '767', 'c', $$Qualifying information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '767', 'd', $$Place, publisher, and date of publication$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '767', 'g', $$Related parts$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '767', 'h', $$Physical description$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '767', 'i', $$Relationship information$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '767', 'k', $$Series data for related item$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '767', 'm', $$Material-specific details$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '767', 'n', $$Note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '767', 'o', $$Other item identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '767', 'r', $$Report number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '767', 's', $$Uniform title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '767', 't', $$Title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '767', 'u', $$Standard Technical Report Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '767', 'w', $$Record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '767', 'x', $$International Standard Serial Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '767', 'y', $$CODEN designation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '767', 'z', $$International Standard Book Number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '767', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '767', '7', $$Control subfield$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '767', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '770', $$Supplement/Special Issue Entry$$, $$Information concerning the supplement or special issue associated with the target item but cataloged and/or input as a separate record (vertical relationship). When a note is generated from this field, the introductory phrase may be generated based on the field tag for display.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_770_ind_1', 'MARC 21 biblio field 770 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_770_ind_1', '0', $$Display note$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_770_ind_1', '1', $$Do not display note$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_770_ind_2', 'MARC 21 biblio field 770 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_770_ind_2', '#', $$Has supplement$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_770_ind_2', '8', $$No display constant generated$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '770', 'a', $$Main entry heading$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '770', 'b', $$Edition$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '770', 'c', $$Qualifying information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '770', 'd', $$Place, publisher, and date of publication$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '770', 'g', $$Related parts$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '770', 'h', $$Physical description$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '770', 'i', $$Relationship information$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '770', 'k', $$Series data for related item$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '770', 'm', $$Material-specific details$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '770', 'n', $$Note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '770', 'o', $$Other item identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '770', 'r', $$Report number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '770', 's', $$Uniform title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '770', 't', $$Title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '770', 'u', $$Standard Technical Report Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '770', 'w', $$Record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '770', 'x', $$International Standard Serial Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '770', 'y', $$CODEN designation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '770', 'z', $$International Standard Book Number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '770', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '770', '7', $$Control subfield$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '770', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '772', $$Supplement Parent Entry$$, $$Information concerning the related parent record when the target item is a single issue, supplement or special issue (vertical relationship) of the parent item. When a note is generated from this field, the introductory phrase may be generated based on the field tag for display.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_772_ind_1', 'MARC 21 biblio field 772 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_772_ind_1', '0', $$Display note$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_772_ind_1', '1', $$Do not display note$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_772_ind_2', 'MARC 21 biblio field 772 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_772_ind_2', '#', $$Supplement to$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_772_ind_2', '0', $$Parent$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_772_ind_2', '8', $$No display constant generated$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '772', 'a', $$Main entry heading$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '772', 'b', $$Edition$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '772', 'c', $$Qualifying information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '772', 'd', $$Place, publisher, and date of publication$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '772', 'g', $$Related parts$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '772', 'h', $$Physical description$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '772', 'i', $$Relationship information$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '772', 'k', $$Series data for related item$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '772', 'm', $$Material-specific details$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '772', 'n', $$Note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '772', 'o', $$Other item identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '772', 'r', $$Report number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '772', 's', $$Uniform title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '772', 't', $$Title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '772', 'u', $$Standard Technical Report Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '772', 'w', $$Record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '772', 'x', $$International Standard Serial Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '772', 'y', $$CODEN designation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '772', 'z', $$International Standard Book Number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '772', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '772', '7', $$Control subfield$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '772', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '773', $$Host Item Entry$$, $$Information concerning the host item for the constituent unit described in the record (vertical relationship). In the case of host items that are serial or multi-volume in nature, information in subfields $g and $q is necessary to point to the exact location of the component part within the bibliographic item.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_773_ind_1', 'MARC 21 biblio field 773 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_773_ind_1', '0', $$Display note$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_773_ind_1', '1', $$Do not display note$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_773_ind_2', 'MARC 21 biblio field 773 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_773_ind_2', '#', $$In$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_773_ind_2', '8', $$No display constant generated$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '773', 'a', $$Main entry heading$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '773', 'b', $$Edition$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '773', 'd', $$Place, publisher, and date of publication$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '773', 'g', $$Related parts$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '773', 'h', $$Physical description$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '773', 'i', $$Relationship information$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '773', 'k', $$Series data for related item$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '773', 'm', $$Material-specific details$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '773', 'n', $$Note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '773', 'o', $$Other item identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '773', 'p', $$Abbreviated title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '773', 'q', $$Enumeration and first page$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '773', 'r', $$Report number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '773', 's', $$Uniform title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '773', 't', $$Title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '773', 'u', $$Standard Technical Report Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '773', 'w', $$Record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '773', 'x', $$International Standard Serial Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '773', 'y', $$CODEN designation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '773', 'z', $$International Standard Book Number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '773', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '773', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '773', '7', $$Control subfield$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '773', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '774', $$Constituent Unit Entry$$, $$Information concerning a constituent unit associated with a larger bibliographic unit (vertical relationship). When a note is generated from this field, the introductory term may be generated based on the field tag for display.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_774_ind_1', 'MARC 21 biblio field 774 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_774_ind_1', '0', $$Display note$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_774_ind_1', '1', $$Do not display note$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_774_ind_2', 'MARC 21 biblio field 774 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_774_ind_2', '#', $$Constituent unit$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_774_ind_2', '8', $$No display constant generated$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '774', 'a', $$Main entry heading$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '774', 'b', $$Edition$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '774', 'c', $$Qualifying information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '774', 'd', $$Place, publisher, and date of publication$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '774', 'g', $$Related parts$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '774', 'h', $$Physical description$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '774', 'i', $$Relationship information$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '774', 'k', $$Series data for related item$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '774', 'm', $$Material-specific details$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '774', 'n', $$Note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '774', 'o', $$Other item identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '774', 'r', $$Report number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '774', 's', $$Uniform title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '774', 't', $$Title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '774', 'u', $$Standard Technical Report Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '774', 'w', $$Record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '774', 'x', $$International Standard Serial Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '774', 'y', $$CODEN designation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '774', 'z', $$International Standard Book Number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '774', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '774', '7', $$Control subfield$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '774', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '775', $$Other Edition Entry$$, $$Entry for another available edition of the target item (horizontal relationship). When a note is generated from this field, the introductory phrase may be generated based on the field tag for display.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_775_ind_1', 'MARC 21 biblio field 775 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_775_ind_1', '0', $$Display note$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_775_ind_1', '1', $$Do not display note$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_775_ind_2', 'MARC 21 biblio field 775 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_775_ind_2', '#', $$Other edition available$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_775_ind_2', '8', $$No display constant generated$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '775', 'a', $$Main entry heading$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '775', 'b', $$Edition$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '775', 'c', $$Qualifying information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '775', 'd', $$Place, publisher, and date of publication$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '775', 'e', $$Language code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '775', 'f', $$Country code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '775', 'g', $$Related parts$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '775', 'h', $$Physical description$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '775', 'i', $$Relationship information$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '775', 'k', $$Series data for related item$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '775', 'm', $$Material-specific details$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '775', 'n', $$Note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '775', 'o', $$Other item identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '775', 'r', $$Report number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '775', 's', $$Uniform title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '775', 't', $$Title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '775', 'u', $$Standard Technical Report Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '775', 'w', $$Record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '775', 'x', $$International Standard Serial Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '775', 'y', $$CODEN designation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '775', 'z', $$International Standard Book Number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '775', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '775', '7', $$Control subfield$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '775', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '776', $$Additional Physical Form Entry$$, $$Information concerning another available physical form of the target item (horizontal relationship). When a note is generated from this field, the introductory phrase may be generated based on the field tag for display.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_776_ind_1', 'MARC 21 biblio field 776 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_776_ind_1', '0', $$Display note$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_776_ind_1', '1', $$Do not display note$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_776_ind_2', 'MARC 21 biblio field 776 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_776_ind_2', '#', $$Available in another form$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_776_ind_2', '8', $$No display constant generated$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '776', 'a', $$Main entry heading$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '776', 'b', $$Edition$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '776', 'c', $$Qualifying information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '776', 'd', $$Place, publisher, and date of publication$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '776', 'g', $$Related parts$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '776', 'h', $$Physical description$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '776', 'i', $$Relationship information$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '776', 'k', $$Series data for related item$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '776', 'm', $$Material-specific details$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '776', 'n', $$Note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '776', 'o', $$Other item identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '776', 'r', $$Report number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '776', 's', $$Uniform title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '776', 't', $$Title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '776', 'u', $$Standard Technical Report Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '776', 'w', $$Record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '776', 'x', $$International Standard Serial Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '776', 'y', $$CODEN designation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '776', 'z', $$International Standard Book Number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '776', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '776', '7', $$Control subfield$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '776', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '777', $$Issued With Entry$$, $$Information concerning the publication that is separately cataloged but that is issued with or included in the target item (horizontal relationship). When a note is generated from this field, the introductory phrase may be generated based on the field tag for display.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_777_ind_1', 'MARC 21 biblio field 777 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_777_ind_1', '0', $$Display note$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_777_ind_1', '1', $$Do not display note$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_777_ind_2', 'MARC 21 biblio field 777 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_777_ind_2', '#', $$Issued with$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_777_ind_2', '8', $$No display constant generated$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '777', 'a', $$Main entry heading$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '777', 'b', $$Edition$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '777', 'c', $$Qualifying information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '777', 'd', $$Place, publisher, and date of publication$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '777', 'g', $$Related parts$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '777', 'h', $$Physical description$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '777', 'i', $$Relationship information$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '777', 'k', $$Series data for related item$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '777', 'm', $$Material-specific details$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '777', 'n', $$Note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '777', 'o', $$Other item identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '777', 's', $$Uniform title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '777', 't', $$Title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '777', 'w', $$Record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '777', 'x', $$International Standard Serial Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '777', 'y', $$CODEN designation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '777', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '777', '7', $$Control subfield$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '777', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '780', $$Preceding Entry$$, $$Information concerning the immediate predecessor of the target item (chronological relationship). When a note is generated from this field, the introductory term or phrase may be generated based on the value in the second indicator position for display.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_780_ind_1', 'MARC 21 biblio field 780 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_780_ind_1', '0', $$Display note$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_780_ind_1', '1', $$Do not display note$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_780_ind_2', 'MARC 21 biblio field 780 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_780_ind_2', '0', $$Continues$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_780_ind_2', '1', $$Continues in part$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_780_ind_2', '2', $$Supersedes$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_780_ind_2', '3', $$Supersedes in part$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_780_ind_2', '4', $$Formed by the union of ... and ...$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_780_ind_2', '5', $$Absorbed$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_780_ind_2', '6', $$Absorbed in part$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_780_ind_2', '7', $$Separated from$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '780', 'a', $$Main entry heading$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '780', 'b', $$Edition$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '780', 'c', $$Qualifying information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '780', 'd', $$Place, publisher, and date of publication$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '780', 'g', $$Related parts$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '780', 'h', $$Physical description$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '780', 'i', $$Relationship information$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '780', 'k', $$Series data for related item$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '780', 'm', $$Material-specific details$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '780', 'n', $$Note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '780', 'o', $$Other item identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '780', 'r', $$Report number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '780', 's', $$Uniform title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '780', 't', $$Title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '780', 'u', $$Standard Technical Report Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '780', 'w', $$Record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '780', 'x', $$International Standard Serial Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '780', 'y', $$CODEN designation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '780', 'z', $$International Standard Book Number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '780', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '780', '7', $$Control subfield$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '780', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '785', $$Succeeding Entry$$, $$Information concerning the immediate successor to the target item (chronological relationship). When a note is generated from this field, the introductory phrase may be generated based on the value in the second indicator position for display.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_785_ind_1', 'MARC 21 biblio field 785 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_785_ind_1', '0', $$Display note$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_785_ind_1', '1', $$Do not display note$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_785_ind_2', 'MARC 21 biblio field 785 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_785_ind_2', '0', $$Continued by$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_785_ind_2', '1', $$Continued in part by$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_785_ind_2', '2', $$Superseded by$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_785_ind_2', '3', $$Superseded in part by$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_785_ind_2', '4', $$Absorbed by$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_785_ind_2', '5', $$Absorbed in part by$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_785_ind_2', '6', $$Split into ... and ...$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_785_ind_2', '7', $$Merged with ... to form ...$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_785_ind_2', '8', $$Changed back to$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '785', 'a', $$Main entry heading$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '785', 'b', $$Edition$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '785', 'c', $$Qualifying information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '785', 'd', $$Place, publisher, and date of publication$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '785', 'g', $$Related parts$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '785', 'h', $$Physical description$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '785', 'i', $$Relationship information$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '785', 'k', $$Series data for related item$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '785', 'm', $$Material-specific details$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '785', 'n', $$Note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '785', 'o', $$Other item identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '785', 'r', $$Report number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '785', 's', $$Uniform title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '785', 't', $$Title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '785', 'u', $$Standard Technical Report Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '785', 'w', $$Record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '785', 'x', $$International Standard Serial Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '785', 'y', $$CODEN designation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '785', 'z', $$International Standard Book Number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '785', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '785', '7', $$Control subfield$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '785', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '786', $$Data Source Entry$$, $$Information pertaining to a data source to which the described item is related. It may contain information about other files, printed sources, or collection procedures.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_786_ind_1', 'MARC 21 biblio field 786 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_786_ind_1', '0', $$Display note$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_786_ind_1', '1', $$Do not display note$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_786_ind_2', 'MARC 21 biblio field 786 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_786_ind_2', '#', $$Data source$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_786_ind_2', '8', $$No display constant generated$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '786', 'a', $$Main entry heading$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '786', 'b', $$Edition$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '786', 'c', $$Qualifying information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '786', 'd', $$Place, publisher, and date of publication$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '786', 'g', $$Related parts$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '786', 'h', $$Physical description$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '786', 'i', $$Relationship information$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '786', 'j', $$Period of content$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '786', 'k', $$Series data for related item$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '786', 'm', $$Material-specific details$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '786', 'n', $$Note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '786', 'o', $$Other item identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '786', 'p', $$Abbreviated title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '786', 'r', $$Report number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '786', 's', $$Uniform title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '786', 't', $$Title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '786', 'u', $$Standard Technical Report Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '786', 'v', $$Source Contribution$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '786', 'w', $$Record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '786', 'x', $$International Standard Serial Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '786', 'y', $$CODEN designation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '786', 'z', $$International Standard Book Number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '786', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '786', '7', $$Control subfield$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '786', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '787', $$Other Relationship Entry$$, $$Information concerning the work related to the target item when the relationship does not fit any of those defined in fields 760-785.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_787_ind_1', 'MARC 21 biblio field 787 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_787_ind_1', '0', $$Display note$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_787_ind_1', '1', $$Do not display note$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_787_ind_2', 'MARC 21 biblio field 787 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_787_ind_2', '#', $$Related item$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_787_ind_2', '8', $$No display constant generated$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '787', 'a', $$Main entry heading$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '787', 'b', $$Edition$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '787', 'c', $$Qualifying information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '787', 'd', $$Place, publisher, and date of publication$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '787', 'g', $$Related parts$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '787', 'h', $$Physical description$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '787', 'i', $$Relationship information$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '787', 'k', $$Series data for related item$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '787', 'm', $$Material-specific details$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '787', 'n', $$Note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '787', 'o', $$Other item identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '787', 'r', $$Report number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '787', 's', $$Uniform title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '787', 't', $$Title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '787', 'u', $$Standard Technical Report Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '787', 'w', $$Record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '787', 'x', $$International Standard Serial Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '787', 'y', $$CODEN designation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '787', 'z', $$International Standard Book Number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '787', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '787', '7', $$Control subfield$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '787', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '800', $$Series Added Entry-Personal Name$$, $$Author/title series added entry in which the author portion is a personal name.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_800_ind_1', 'MARC 21 biblio field 800 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_800_ind_1', '0', $$Forename$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_800_ind_1', '1', $$Surname$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_800_ind_1', '3', $$Family name$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_800_ind_2', 'MARC 21 biblio field 800 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_800_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '800', 'a', $$Personal name$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '800', 'b', $$Numeration$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '800', 'c', $$Titles and other words associated with a name$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '800', 'd', $$Dates associated with a name$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '800', 'e', $$Relator term$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '800', 'f', $$Date of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '800', 'g', $$Miscellaneous information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '800', 'h', $$Medium$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '800', 'j', $$Attribution qualifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '800', 'k', $$Form subheading$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '800', 'l', $$Language of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '800', 'm', $$Medium of performance for music$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '800', 'n', $$Number of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '800', 'o', $$Arranged statement for music$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '800', 'p', $$Name of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '800', 'q', $$Fuller form of name$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '800', 'r', $$Key for music$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '800', 's', $$Version$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '800', 't', $$Title of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '800', 'u', $$Affiliation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '800', 'v', $$Volume/sequential designation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '800', 'w', $$Bibliographic record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '800', 'x', $$International Standard Serial Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '800', '0', $$Authority record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '800', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '800', '4', $$Relator code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '800', '5', $$Institution to which field applies$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '800', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '800', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '810', $$Series Added Entry-Corporate Name$$, $$Author/title series added entry in which the author portion is a corporate name.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_810_ind_1', 'MARC 21 biblio field 810 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_810_ind_1', '0', $$Inverted name$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_810_ind_1', '1', $$Jurisdiction name$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_810_ind_1', '2', $$Name in direct order$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_810_ind_2', 'MARC 21 biblio field 810 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_810_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '810', 'a', $$Corporate name or jurisdiction name as entry element$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '810', 'b', $$Subordinate unit$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '810', 'c', $$Location of meeting$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '810', 'd', $$Date of meeting or treaty signing$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '810', 'e', $$Relator term$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '810', 'f', $$Date of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '810', 'g', $$Miscellaneous information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '810', 'h', $$Medium$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '810', 'k', $$Form subheading$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '810', 'l', $$Language of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '810', 'm', $$Medium of performance for music$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '810', 'n', $$Number of part/section/meeting$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '810', 'o', $$Arranged statement for music$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '810', 'p', $$Name of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '810', 'r', $$Key for music$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '810', 's', $$Version$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '810', 't', $$Title of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '810', 'u', $$Affiliation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '810', 'v', $$Volume/sequential designation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '810', 'w', $$Bibliographic record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '810', 'x', $$International Standard Serial Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '810', '0', $$Authority record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '810', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '810', '4', $$Relator code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '810', '5', $$Institution to which field applies$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '810', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '810', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '811', $$Series Added Entry-Meeting Name$$, $$Author/title series added entry in which the author portion is a meeting name or conference name.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_811_ind_1', 'MARC 21 biblio field 811 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_811_ind_1', '0', $$Inverted name$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_811_ind_1', '1', $$Jurisdiction name$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_811_ind_1', '2', $$Name in direct order$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_811_ind_2', 'MARC 21 biblio field 811 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_811_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '811', 'a', $$Meeting name or jurisdiction name as entry element$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '811', 'c', $$Location of meeting$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '811', 'd', $$Date of meeting$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '811', 'e', $$Subordinate unit$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '811', 'f', $$Date of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '811', 'g', $$Miscellaneous information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '811', 'h', $$Medium$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '811', 'j', $$Relator term$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '811', 'k', $$Form subheading$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '811', 'l', $$Language of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '811', 'n', $$Number of part/section/meeting$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '811', 'p', $$Name of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '811', 'q', $$Name of meeting following jurisdiction name entry element$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '811', 's', $$Version$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '811', 't', $$Title of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '811', 'u', $$Affiliation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '811', 'v', $$Volume/sequential designation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '811', 'w', $$Bibliographic record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '811', 'x', $$International Standard Serial Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '811', '0', $$Authority record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '811', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '811', '4', $$Relator code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '811', '5', $$Institution to which field applies$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '811', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '811', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '830', $$Series Added Entry-Uniform Title$$, $$Series added entry consisting of a series title alone.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_830_ind_1', 'MARC 21 biblio field 830 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_830_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_830_ind_2', 'MARC 21 biblio field 830 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_830_ind_2', '0', $$No nonfiling characters$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_830_ind_2', '1', $$Number of nonfiling characters - 1$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_830_ind_2', '2', $$Number of nonfiling characters - 2$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_830_ind_2', '3', $$Number of nonfiling characters - 3$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_830_ind_2', '4', $$Number of nonfiling characters - 4$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_830_ind_2', '5', $$Number of nonfiling characters - 5$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_830_ind_2', '6', $$Number of nonfiling characters - 6$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_830_ind_2', '7', $$Number of nonfiling characters - 7$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_830_ind_2', '8', $$Number of nonfiling characters - 8$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_830_ind_2', '9', $$Number of nonfiling characters - 9$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '830', 'a', $$Uniform title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '830', 'd', $$Date of treaty signing$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '830', 'f', $$Date of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '830', 'g', $$Miscellaneous information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '830', 'h', $$Medium$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '830', 'k', $$Form subheading$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '830', 'l', $$Language of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '830', 'm', $$Medium of performance for music$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '830', 'n', $$Number of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '830', 'o', $$Arranged statement for music$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '830', 'p', $$Name of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '830', 'r', $$Key for music$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '830', 's', $$Version$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '830', 't', $$Title of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '830', 'v', $$Volume/sequential designation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '830', 'w', $$Bibliographic record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '830', 'x', $$International Standard Serial Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '830', '0', $$Authority record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '830', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '830', '5', $$Institution to which field applies$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '830', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '830', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '841', $$Holdings Coded Data Values$$, $$When holdings data are embedded in a bibliographic record, this field contains certain coded information that would apply to the holdings information if it were in a separate holdings record in field 008 (Fixed-Length Data Elements).$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_841_ind_1', 'MARC 21 biblio field 841 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_841_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_841_ind_2', 'MARC 21 biblio field 841 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_841_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '841', 'a', $$Type of record$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '841', 'b', $$Fixed-length data elements$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '841', 'e', $$Encoding level$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '842', $$Textual Physical Form Designator$$, $$Designation in textual form of the physical form of the item. The physical form designator specifies the physical medium or form, or type of material of the unit held. The general physical form designator in coded form is recorded in field 007 (Physical Description Fixed Field).$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_842_ind_1', 'MARC 21 biblio field 842 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_842_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_842_ind_2', 'MARC 21 biblio field 842 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_842_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '842', 'a', $$Textual physical form designator$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '842', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '842', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '843', $$Reproduction Note$$, $$Description of an item that is a reproduction of original materials. Used when an institution chooses to have the main portion of the bibliographic record description reflect the original and the notes in field 843 reflect information about the copy.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_843_ind_1', 'MARC 21 biblio field 843 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_843_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_843_ind_2', 'MARC 21 biblio field 843 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_843_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '843', 'a', $$Type of reproduction$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '843', 'b', $$Place of reproduction$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '843', 'c', $$Agency responsible for reproduction$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '843', 'd', $$Date of reproduction$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '843', 'e', $$Physical description of reproduction$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '843', 'f', $$Series statement of reproduction$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '843', 'm', $$Dates of publication and/or sequential designation of issues reproduced$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '843', 'n', $$Note about reproduction$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '843', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '843', '5', $$Institution to which field applies$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '843', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '843', '7', $$Fixed-length data elements of reproduction$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '843', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '844', $$Name of Unit$$, $$Bibliographic title or a supplied designation describing a basic bibliographic unit, supplementary material, or an index. A supplement or index designation used as a caption is contained in fields 853-855 (Captions and Pattern), subfield $a-$h (Enumeration captions).$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_844_ind_1', 'MARC 21 biblio field 844 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_844_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_844_ind_2', 'MARC 21 biblio field 844 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_844_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '844', 'a', $$Name of unit$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '844', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '844', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '845', $$Terms Governing Use and Reproduction Note$$, $$Terms governing the use and reproduction of a bibliographic item when the holding organization will lend (008/20, Lending policy, code a) and reproduce (008/21, Reproduction policy, code a) the item.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_845_ind_1', 'MARC 21 biblio field 845 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_845_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_845_ind_2', 'MARC 21 biblio field 845 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_845_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '845', 'a', $$Terms governing use and reproduction$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '845', 'b', $$Jurisdiction$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '845', 'c', $$Authorization$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '845', 'd', $$Authorized users$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '845', 'u', $$Uniform Resource Identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '845', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '845', '5', $$Institution to which field applies$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '845', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '845', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '850', $$Holding Institution$$, $$Information concerning holdings of the described item by the specified institution.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_850_ind_1', 'MARC 21 biblio field 850 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_850_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_850_ind_2', 'MARC 21 biblio field 850 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_850_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '850', 'a', $$Holding institution$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '850', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '852', $$Location$$, $$Identifies the organization holding the item or from which it is available. May also contain detailed information about how to locate the item in a collection.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_852_ind_1', 'MARC 21 biblio field 852 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_852_ind_1', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_852_ind_1', '0', $$Library of Congress classification$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_852_ind_1', '1', $$Dewey Decimal classification$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_852_ind_1', '2', $$National Library of Medicine classification$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_852_ind_1', '3', $$Superintendent of Documents classification$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_852_ind_1', '4', $$Shelving control number$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_852_ind_1', '5', $$Title$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_852_ind_1', '6', $$Shelved separately$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_852_ind_1', '7', $$Source specified in subfield $2$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_852_ind_1', '8', $$Other scheme$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_852_ind_2', 'MARC 21 biblio field 852 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_852_ind_2', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_852_ind_2', '0', $$Not enumeration$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_852_ind_2', '1', $$Primary enumeration$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_852_ind_2', '2', $$Alternative enumeration$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '852', 'a', $$Location$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '852', 'b', $$Sublocation or collection$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '852', 'c', $$Shelving location$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '852', 'd', $$Former shelving location$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '852', 'e', $$Address$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '852', 'f', $$Coded location qualifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '852', 'g', $$Non-coded location qualifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '852', 'h', $$Classification part$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '852', 'i', $$Item part$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '852', 'j', $$Shelving control number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '852', 'k', $$Call number prefix$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '852', 'l', $$Shelving form of title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '852', 'm', $$Call number suffix$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '852', 'n', $$Country code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '852', 'p', $$Piece designation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '852', 'q', $$Piece physical condition$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '852', 's', $$Copyright article-fee code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '852', 't', $$Copy number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '852', 'u', $$Uniform Resource Identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '852', 'x', $$Nonpublic note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '852', 'z', $$Public note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '852', '2', $$Source of classification or shelving scheme$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '852', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '852', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '852', '8', $$Sequence number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '853', $$Captions and Pattern - Basic Bibliographic Unit$$, $$Captions that identify the enumeration and chronology levels and codes that define the publication pattern of the holdings described in the 863-865 Enumeration and Chronology fields. Any related 853-855 and 863-865 fields are linked by a number in subfield $8 (Field link and sequence number).$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_853_ind_1', 'MARC 21 biblio field 853 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_853_ind_1', '0', $$Cannot compress or expand$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_853_ind_1', '1', $$Can compress but not expand$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_853_ind_1', '2', $$Can compress or expand$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_853_ind_1', '3', $$Unknown$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_853_ind_2', 'MARC 21 biblio field 853 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_853_ind_2', '0', $$Captions verified; all levels present$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_853_ind_2', '1', $$Captions verified; all levels may not be present$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_853_ind_2', '2', $$Captions unverified; all levels present$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_853_ind_2', '3', $$Captions unverified; all levels may not be present$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '853', 'a', $$First level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '853', 'b', $$Second level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '853', 'c', $$Third level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '853', 'd', $$Fourth level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '853', 'e', $$Fifth level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '853', 'f', $$Sixth level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '853', 'g', $$Alternative numbering scheme, first level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '853', 'h', $$Alternative numbering scheme, second level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '853', 'i', $$First level of chronology$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '853', 'j', $$Second level of chronology$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '853', 'k', $$Third level of chronology$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '853', 'l', $$Fourth level of chronology$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '853', 'm', $$Alternative numbering scheme, chronology$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '853', 'n', $$Pattern note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '853', 'o', $$Type of unit$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '853', 'p', $$Number of pieces per issuance$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '853', 't', $$Copy$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '853', 'u', $$Bibliographic units per next higher level$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '853', 'v', $$Numbering continuity$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '853', 'w', $$Frequency$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '853', 'x', $$Calendar change$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '853', 'y', $$Regularity pattern$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '853', 'z', $$Numbering scheme$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '853', '2', $$Source of caption abbreviation$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '853', '3', $$Materials specified$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '853', '6', $$Linkage$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '853', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '854', $$Captions and Pattern - Supplementary Material$$, $$Captions that identify the enumeration and chronology levels and codes that define the publication pattern of the holdings described in the 863-865 Enumeration and Chronology fields. Any related 853-855 and 863-865 fields are linked by a number in subfield $8 (Field link and sequence number).$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_854_ind_1', 'MARC 21 biblio field 854 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_854_ind_1', '0', $$Cannot compress or expand$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_854_ind_1', '1', $$Can compress but not expand$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_854_ind_1', '2', $$Can compress or expand$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_854_ind_1', '3', $$Unknown$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_854_ind_2', 'MARC 21 biblio field 854 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_854_ind_2', '0', $$Captions verified; all levels present$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_854_ind_2', '1', $$Captions verified; all levels may not be present$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_854_ind_2', '2', $$Captions unverified; all levels present$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_854_ind_2', '3', $$Captions unverified; all levels may not be present$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '854', 'a', $$First level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '854', 'b', $$Second level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '854', 'c', $$Third level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '854', 'd', $$Fourth level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '854', 'e', $$Fifth level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '854', 'f', $$Sixth level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '854', 'g', $$Alternative numbering scheme, first level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '854', 'h', $$Alternative numbering scheme, second level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '854', 'i', $$First level of chronology$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '854', 'j', $$Second level of chronology$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '854', 'k', $$Third level of chronology$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '854', 'l', $$Fourth level of chronology$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '854', 'm', $$Alternative numbering scheme, chronology$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '854', 'n', $$Pattern note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '854', 'o', $$Type of unit$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '854', 'p', $$Number of pieces per issuance$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '854', 't', $$Copy$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '854', 'u', $$Bibliographic units per next higher level$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '854', 'v', $$Numbering continuity$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '854', 'w', $$Frequency$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '854', 'x', $$Calendar change$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '854', 'y', $$Regularity pattern$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '854', 'z', $$Numbering scheme$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '854', '2', $$Source of caption abbreviation$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '854', '3', $$Materials specified$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '854', '6', $$Linkage$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '854', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '855', $$Captions and Pattern - Indexes$$, $$Captions that identify the enumeration and chronology levels and codes that define the publication pattern of the holdings described in the 863-865 Enumeration and Chronology fields. Any related 853-855 and 863-865 fields are linked by a number in subfield $8 (Field link and sequence number).$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_855_ind_1', 'MARC 21 biblio field 855 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_855_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_855_ind_2', 'MARC 21 biblio field 855 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_855_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '855', 'a', $$First level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '855', 'b', $$Second level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '855', 'c', $$Third level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '855', 'd', $$Fourth level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '855', 'e', $$Fifth level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '855', 'f', $$Sixth level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '855', 'g', $$Alternative numbering scheme, first level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '855', 'h', $$Alternative numbering scheme, second level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '855', 'i', $$First level of chronology$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '855', 'j', $$Second level of chronology$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '855', 'k', $$Third level of chronology$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '855', 'l', $$Fourth level of chronology$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '855', 'm', $$Alternative numbering scheme, chronology$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '855', 'n', $$Pattern note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '855', 'o', $$Type of unit$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '855', 'p', $$Number of pieces per issuance$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '855', 't', $$Copy$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '855', 'u', $$Bibliographic units per next higher level$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '855', 'v', $$Numbering continuity$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '855', 'w', $$Frequency$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '855', 'x', $$Calendar change$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '855', 'y', $$Regularity pattern$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '855', 'z', $$Numbering scheme$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '855', '2', $$Source of caption abbreviation$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '855', '3', $$Materials specified$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '855', '6', $$Linkage$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '855', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '856', $$Electronic Location and Access$$, $$Information needed to locate and access an electronic resource. The field may be used in a bibliographic record for a resource when that resource or a subset of it is available electronically. In addition, it may be used to locate and access an electronic version of a non-electronic resource described in the bibliographic record or a related electronic resource.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_856_ind_1', 'MARC 21 biblio field 856 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_856_ind_1', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_856_ind_1', '0', $$Email$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_856_ind_1', '1', $$FTP$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_856_ind_1', '2', $$Remote login (Telnet)$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_856_ind_1', '3', $$Dial-up$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_856_ind_1', '4', $$HTTP$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_856_ind_1', '7', $$Method specified in subfield $2$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_856_ind_2', 'MARC 21 biblio field 856 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_856_ind_2', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_856_ind_2', '0', $$Resource$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_856_ind_2', '1', $$Version of resource$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_856_ind_2', '2', $$Related resource$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_856_ind_2', '8', $$No display constant generated$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '856', 'a', $$Host name$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '856', 'b', $$Access number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '856', 'c', $$Compression information$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '856', 'd', $$Path$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '856', 'f', $$Electronic name$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '856', 'h', $$Processor of request$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '856', 'i', $$Instruction$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '856', 'j', $$Bits per second$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '856', 'k', $$Password$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '856', 'l', $$Logon$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '856', 'm', $$Contact for access assistance$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '856', 'n', $$Name of location of host$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '856', 'o', $$Operating system$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '856', 'p', $$Port$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '856', 'q', $$Electronic format type$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '856', 'r', $$Settings$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '856', 's', $$File size$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '856', 't', $$Terminal emulation$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '856', 'u', $$Uniform Resource Identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '856', 'v', $$Hours access method available$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '856', 'w', $$Record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '856', 'x', $$Nonpublic note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '856', 'y', $$Link text$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '856', 'z', $$Public note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '856', '2', $$Access method$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '856', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '856', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '856', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '863', $$Enumeration and Chronology - Basic Bibliographic Unit$$, $$Description of the holdings of a bibliographic item in the collections of the reporting organization. The captions that identify the enumeration and chronology levels and the codes that define the publication pattern of the holdings are contained in the Captions and Pattern fields (853-855) that are linked to the 863-865 fields by a number in subfield $8 (Field link and sequence number).$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_863_ind_1', 'MARC 21 biblio field 863 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_863_ind_1', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_863_ind_1', '3', $$Holdings level 3$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_863_ind_1', '4', $$Holdings level 4$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_863_ind_1', '5', $$Holdings level 4 with piece designation$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_863_ind_2', 'MARC 21 biblio field 863 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_863_ind_2', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_863_ind_2', '0', $$Compressed$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_863_ind_2', '1', $$Uncompressed$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_863_ind_2', '2', $$Compressed, use textual display$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_863_ind_2', '3', $$Uncompressed, use textual display$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_863_ind_2', '4', $$Item(s) not published$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '863', 'a', $$First level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '863', 'b', $$Second level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '863', 'c', $$Third level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '863', 'd', $$Fourth level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '863', 'e', $$Fifth level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '863', 'f', $$Sixth level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '863', 'g', $$Alternative numbering scheme, first level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '863', 'h', $$Alternative numbering scheme, second level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '863', 'i', $$First level of chronology$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '863', 'j', $$Second level of chronology$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '863', 'k', $$Third level of chronology$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '863', 'l', $$Fourth level of chronology$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '863', 'm', $$Alternative numbering scheme, chronology$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '863', 'n', $$Converted Gregorian year$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '863', 'o', $$Type of unit$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '863', 'p', $$Piece designation$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '863', 'q', $$Piece physical condition$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '863', 's', $$Copyright article-fee code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '863', 't', $$Copy number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '863', 'v', $$Issuing date$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '863', 'w', $$Break indicator$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '863', 'x', $$Nonpublic note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '863', 'z', $$Public note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '863', '6', $$Linkage$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '863', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '864', $$Enumeration and Chronology - Supplementary Material$$, $$Description of the holdings of a bibliographic item in the collections of the reporting organization. The captions that identify the enumeration and chronology levels and the codes that define the publication pattern of the holdings are contained in the Captions and Pattern fields (853-855) that are linked to the 863-865 fields by a number in subfield $8 (Field link and sequence number).$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_864_ind_1', 'MARC 21 biblio field 864 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_864_ind_1', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_864_ind_1', '3', $$Holdings level 3$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_864_ind_1', '4', $$Holdings level 4$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_864_ind_1', '5', $$Holdings level 4 with piece designation$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_864_ind_2', 'MARC 21 biblio field 864 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_864_ind_2', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_864_ind_2', '0', $$Compressed$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_864_ind_2', '1', $$Uncompressed$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_864_ind_2', '2', $$Compressed, use textual display$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_864_ind_2', '3', $$Uncompressed, use textual display$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_864_ind_2', '4', $$Item(s) not published$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '864', 'a', $$First level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '864', 'b', $$Second level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '864', 'c', $$Third level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '864', 'd', $$Fourth level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '864', 'e', $$Fifth level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '864', 'f', $$Sixth level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '864', 'g', $$Alternative numbering scheme, first level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '864', 'h', $$Alternative numbering scheme, second level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '864', 'i', $$First level of chronology$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '864', 'j', $$Second level of chronology$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '864', 'k', $$Third level of chronology$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '864', 'l', $$Fourth level of chronology$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '864', 'm', $$Alternative numbering scheme, chronology$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '864', 'n', $$Converted Gregorian year$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '864', 'o', $$Type of unit$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '864', 'p', $$Piece designation$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '864', 'q', $$Piece physical condition$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '864', 's', $$Copyright article-fee code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '864', 't', $$Copy number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '864', 'v', $$Issuing date$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '864', 'w', $$Break indicator$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '864', 'x', $$Nonpublic note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '864', 'z', $$Public note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '864', '6', $$Linkage$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '864', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '865', $$Enumeration and Chronology - Indexes$$, $$Description of the holdings of a bibliographic item in the collections of the reporting organization. The captions that identify the enumeration and chronology levels and the codes that define the publication pattern of the holdings are contained in the Captions and Pattern fields (853-855) that are linked to the 863-865 fields by a number in subfield $8 (Field link and sequence number).$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_865_ind_1', 'MARC 21 biblio field 865 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_865_ind_1', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_865_ind_1', '4', $$Holdings level 4$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_865_ind_1', '5', $$Holdings level 4 with piece designation$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_865_ind_2', 'MARC 21 biblio field 865 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_865_ind_2', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_865_ind_2', '1', $$Uncompressed$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_865_ind_2', '3', $$Uncompressed, use textual display$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '865', 'a', $$First level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '865', 'b', $$Second level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '865', 'c', $$Third level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '865', 'd', $$Fourth level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '865', 'e', $$Fifth level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '865', 'f', $$Sixth level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '865', 'g', $$Alternative numbering scheme, first level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '865', 'h', $$Alternative numbering scheme, second level of enumeration$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '865', 'i', $$First level of chronology$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '865', 'j', $$Second level of chronology$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '865', 'k', $$Third level of chronology$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '865', 'l', $$Fourth level of chronology$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '865', 'm', $$Alternative numbering scheme, chronology$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '865', 'n', $$Converted Gregorian year$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '865', 'o', $$Type of unit$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '865', 'p', $$Piece designation$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '865', 'q', $$Piece physical condition$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '865', 's', $$Copyright article-fee code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '865', 't', $$Copy number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '865', 'v', $$Issuing date$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '865', 'w', $$Break indicator$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '865', 'x', $$Nonpublic note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '865', 'z', $$Public note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '865', '6', $$Linkage$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '865', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '866', $$Textual Holdings - Basic Bibliographic Unit$$, $$Textual description which may include both the captions and enumeration and chronology for the holdings of a bibliographic item in the collections of the reporting organization. These fields are normally not used in holdings for single-part items. They may be used the coded 853-855 Captions and Pattern and 863-865 Enumeration and Chronology fields for multipart and serial items when those fields cannot be used adequately to describe the holdings. The 866-868 fields may also be used an Enumeration and Chronology field and any related Captions and Pattern field to record and generate an alternative display for all or part of the enumeration and chronology and captions and pattern fields.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_866_ind_1', 'MARC 21 biblio field 866 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_866_ind_1', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_866_ind_1', '3', $$Holdings level 3$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_866_ind_1', '4', $$Holdings level 4$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_866_ind_1', '5', $$Holdings level 4 with piece designation$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_866_ind_2', 'MARC 21 biblio field 866 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_866_ind_2', '0', $$Non-standard$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_866_ind_2', '1', $$ANSI/NISO Z39.71 or ISO 10324$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_866_ind_2', '2', $$ANSI Z39.42$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_866_ind_2', '7', $$Source specified in subfield $2$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '866', 'a', $$Textual holdings$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '866', 'x', $$Nonpublic note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '866', 'z', $$Public note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '866', '2', $$Source of notation$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '866', '6', $$Linkage$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '866', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '867', $$Textual Holdings - Supplementary Material$$, $$Textual description which may include both the captions and enumeration and chronology for the holdings of a bibliographic item in the collections of the reporting organization. These fields are normally not used in holdings for single-part items. They may be used the coded 853-855 Captions and Pattern and 863-865 Enumeration and Chronology fields for multipart and serial items when those fields cannot be used adequately to describe the holdings. The 866-868 fields may also be used an Enumeration and Chronology field and any related Captions and Pattern field to record and generate an alternative display for all or part of the enumeration and chronology and captions and pattern fields.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_867_ind_1', 'MARC 21 biblio field 867 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_867_ind_1', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_867_ind_1', '3', $$Holdings level 3$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_867_ind_1', '4', $$Holdings level 4$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_867_ind_1', '5', $$Holdings level 4 with piece designation$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_867_ind_2', 'MARC 21 biblio field 867 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_867_ind_2', '0', $$Non-standard$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_867_ind_2', '1', $$ANSI/NISO Z39.71 or ISO 10324$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_867_ind_2', '2', $$ANSI Z39.42$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_867_ind_2', '7', $$Source specified in subfield $2$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '867', 'a', $$Textual holdings$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '867', 'x', $$Nonpublic note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '867', 'z', $$Public note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '867', '2', $$Source of notation$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '867', '6', $$Linkage$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '867', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '868', $$Textual Holdings - Indexes$$, $$Textual description which may include both the captions and enumeration and chronology for the holdings of a bibliographic item in the collections of the reporting organization. These fields are normally not used in holdings for single-part items. They may be used the coded 853-855 Captions and Pattern and 863-865 Enumeration and Chronology fields for multipart and serial items when those fields cannot be used adequately to describe the holdings. The 866-868 fields may also be used an Enumeration and Chronology field and any related Captions and Pattern field to record and generate an alternative display for all or part of the enumeration and chronology and captions and pattern fields.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_868_ind_1', 'MARC 21 biblio field 868 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_868_ind_1', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_868_ind_1', '3', $$Holdings level 3$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_868_ind_1', '4', $$Holdings level 4$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_868_ind_1', '5', $$Holdings level 4 with piece designation$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_868_ind_2', 'MARC 21 biblio field 868 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_868_ind_2', '0', $$Non-standard$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_868_ind_2', '1', $$ANSI/NISO Z39.71 or ISO 10324$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_868_ind_2', '2', $$ANSI Z39.42$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_868_ind_2', '7', $$Source specified in subfield $2$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '868', 'a', $$Textual holdings$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '868', 'x', $$Nonpublic note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '868', 'z', $$Public note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '868', '2', $$Source of notation$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '868', '6', $$Linkage$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '868', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '876', $$Item Information - Basic Bibliographic Unit$$, $$Item level information about the pieces to the item specified in the holdings record. They contain various data elements that it may be desirable to record for specific items for use in acquisition or circulation applications, among others.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_876_ind_1', 'MARC 21 biblio field 876 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_876_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_876_ind_2', 'MARC 21 biblio field 876 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_876_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '876', 'a', $$Internal item number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '876', 'b', $$Invalid or canceled internal item number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '876', 'c', $$Cost$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '876', 'd', $$Date acquired$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '876', 'e', $$Source of acquisition$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '876', 'h', $$Use restrictions$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '876', 'j', $$Item status$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '876', 'l', $$Temporary location$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '876', 'p', $$Piece designation$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '876', 'r', $$Invalid or canceled piece designation$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '876', 't', $$Copy number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '876', 'x', $$Nonpublic note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '876', 'z', $$Public note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '876', '3', $$Materials specified$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '876', '6', $$Linkage$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '876', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '877', $$Item Information - Supplementary Material$$, $$Item level information about the pieces to the item specified in the holdings record. They contain various data elements that it may be desirable to record for specific items for use in acquisition or circulation applications, among others.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_877_ind_1', 'MARC 21 biblio field 877 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_877_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_877_ind_2', 'MARC 21 biblio field 877 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_877_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '877', 'a', $$Internal item number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '877', 'b', $$Invalid or canceled internal item number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '877', 'c', $$Cost$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '877', 'd', $$Date acquired$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '877', 'e', $$Source of acquisition$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '877', 'h', $$Use restrictions$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '877', 'j', $$Item status$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '877', 'l', $$Temporary location$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '877', 'p', $$Piece designation$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '877', 'r', $$Invalid or canceled piece designation$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '877', 't', $$Copy number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '877', 'x', $$Nonpublic note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '877', 'z', $$Public note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '877', '3', $$Materials specified$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '877', '6', $$Linkage$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '877', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '878', $$Item Information - Indexes$$, $$Item level information about the pieces to the item specified in the holdings record. They contain various data elements that it may be desirable to record for specific items for use in acquisition or circulation applications, among others.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_878_ind_1', 'MARC 21 biblio field 878 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_878_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_878_ind_2', 'MARC 21 biblio field 878 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_878_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '878', 'a', $$Internal item number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '878', 'b', $$Invalid or canceled internal item number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '878', 'c', $$Cost$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '878', 'd', $$Date acquired$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '878', 'e', $$Source of acquisition$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '878', 'h', $$Use restrictions$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '878', 'j', $$Item status$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '878', 'l', $$Temporary location$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '878', 'p', $$Piece designation$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '878', 'r', $$Invalid or canceled piece designation$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '878', 't', $$Copy number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '878', 'x', $$Nonpublic note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '878', 'z', $$Public note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '878', '3', $$Materials specified$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '878', '6', $$Linkage$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '878', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '880', $$Alternate Graphic Representation$$, $$Fully content-designated representation, in a different script, of another field in the same record. Field 880 is linked to the associated regular field by subfield $6 (Linkage). A subfield $6 in the associated field also links that field to the 880 field. The data in field 880 may be in more than one script.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '880', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '882', $$Replacement Record Information$$, $$Information about the replacement bibliographic record in a deleted record. The replacement title(s) may be contained in subfield(s) $a.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_882_ind_1', 'MARC 21 biblio field 882 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_882_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_882_ind_2', 'MARC 21 biblio field 882 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_882_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '882', 'a', $$Replacement title$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '882', 'i', $$Explanatory text$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '882', 'w', $$Replacement bibliographic record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '882', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '882', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '886', $$Foreign MARC Information Field$$, $$Used when converting foreign MARC records into the MARC format. Contains data from a foreign MARC record for which there is no corresponding MARC field.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_886_ind_1', 'MARC 21 biblio field 886 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_886_ind_1', '0', $$Leader$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_886_ind_1', '1', $$Variable control fields (002-009)$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_886_ind_1', '2', $$Variable data fields (010-999)$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_886_ind_2', 'MARC 21 biblio field 886 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_886_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '886', 'a', $$Tag of the foreign MARC field$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '886', 'b', $$Content of the foreign MARC field$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '886', '2', $$Source of data$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'biblio', '887', $$Non-MARC Information Field$$, $$Data from non-MARC records for which there are no corresponding MARC 21 fields. Used when converting non-MARC records into the MARC 21 format.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_887_ind_1', 'MARC 21 biblio field 887 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_887_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_biblio_887_ind_2', 'MARC 21 biblio field 887 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_biblio_887_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '887', 'a', $$Content of non-MARC field$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'biblio', '887', '2', $$Source of data$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '001', $$Control Number$$, $$Control number assigned by the organization creating, using, or distributing the record.$$,
TRUE, FALSE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '003', $$Control Number Identifier$$, $$MARC code for the agency whose system control number is contained in field 001 (Control Number).$$,
TRUE, FALSE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '005', $$Date and Time of Latest Transaction$$, $$Sixteen characters that specify the date and time of the latest record transaction and serve as a version identifier for the record. The data and time are recorded according to (ISO 8601) in the pattern and .$$,
TRUE, FALSE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '008', $$Fixed-Length Data Elements$$, $$Forty character positions (00-39) that contain positionally-defined data elements that provide coded information about the record as a whole or about special aspects of the 1XX heading or 4XX/5XX tracing fields. Undefined character positions contain a blank (#). All defined character positions must contain a defined code; for some 008 positions, this may be the fill character (|). The fill character may be used (in certain character positions) when a cataloging organization makes no attempt to code the character position. Field 008 is not repeatable.$$,
TRUE, FALSE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '010', $$Library of Congress Control Number$$, $$Unique number assigned to a record by the Library of Congress (LC) or a cooperative cataloging partner contributing authority records to the Name Authority Cooperative Program (NACO) database. The field is also assigned to records created by LC for the Library of Congress Subject Headings (LCSH).$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_010_ind_1', 'MARC 21 authority field 010 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_010_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_010_ind_2', 'MARC 21 authority field 010 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_010_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '010', 'a', $$LC control number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '010', 'z', $$Canceled/invalid LC control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '010', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '014', $$Link to Bibliographic Record for Serial or Multipart Item$$, $$Control number from field 001 of a MARC 21 bibliographic record for a serial or a multipart item that is cataloged as a set.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_014_ind_1', 'MARC 21 authority field 014 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_014_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_014_ind_2', 'MARC 21 authority field 014 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_014_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '014', 'a', $$Control number of related bibliographic record$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '014', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '014', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '016', $$National Bibliographic Agency Control Number$$, $$Unique numbers that have been assigned to a record by a national bibliographic agency other than the Library of Congress (Library of Congress control numbers are recorded in ).$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_016_ind_1', 'MARC 21 authority field 016 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_016_ind_1', '#', $$Library and Archives Canada$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_016_ind_1', '7', $$Source specified in subfield $2$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_016_ind_2', 'MARC 21 authority field 016 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_016_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '016', 'a', $$Record control number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '016', 'z', $$Canceled or invalid record control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '016', '2', $$Source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '016', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '020', $$International Standard Book Number$$, $$International Standard Book Number (ISBN), terms of availability, and any canceled/invalid ISBN copied from field 020 of a MARC bibliographic record for a multipart item that is cataloged as a set.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_020_ind_1', 'MARC 21 authority field 020 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_020_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_020_ind_2', 'MARC 21 authority field 020 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_020_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '020', 'a', $$International Standard Book Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '020', 'c', $$Terms of availability$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '020', 'z', $$Canceled/invalid ISBN$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '020', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '020', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '022', $$International Standard Serial Number$$, $$International Standard Serial Number (ISSN) and/or any incorrect and canceled ISSNs copied from field 022 of a MARC 21 bibliographic record for a continuing resource.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_022_ind_1', 'MARC 21 authority field 022 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_022_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_022_ind_2', 'MARC 21 authority field 022 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_022_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '022', 'a', $$International Standard Serial Number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '022', 'l', $$ISSN-L$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '022', 'm', $$Canceled ISSN-L$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '022', 'y', $$Incorrect ISSN$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '022', 'z', $$Canceled ISSN$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '022', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '022', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '024', $$Other Standard Identifier$$, $$Standard number or code associated with the entity named in the 1XX field which cannot be accommodated in another field (e.g., fields 020 (International Standard Book Number) and 022 (International Standard Serial Number)). The source of the standard number or code is identified in subfield $2 (Source of number or code).$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_024_ind_1', 'MARC 21 authority field 024 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_024_ind_1', '7', $$Source specified in subfield $2$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_024_ind_1', '8', $$Unspecified type of standard number or code$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_024_ind_2', 'MARC 21 authority field 024 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_024_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '024', 'a', $$Standard number or code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '024', 'c', $$Terms of availability$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '024', 'd', $$Additional codes following the standard number or code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '024', 'z', $$Canceled/invalid standard number or code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '024', '2', $$Source of number or code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '024', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '024', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '031', $$Musical Incipits Information$$, $$Coded data representing the musical incipit for music using established notation schemes that employ ordinary ASCII symbols. Used in an established heading record primarily to identify music manuscripts, but can be applied to any material containing music.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_031_ind_1', 'MARC 21 authority field 031 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_031_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_031_ind_2', 'MARC 21 authority field 031 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_031_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '031', 'b', $$Number of movement$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '031', 'c', $$Number of excerpt$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '031', 'd', $$Caption or heading$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '031', 'e', $$Role$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '031', 'g', $$Clef$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '031', 'm', $$Voice/instrument$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '031', 'n', $$Key signature$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '031', 'o', $$Time signature$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '031', 'p', $$Musical notation$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '031', 'q', $$General note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '031', 'r', $$Key or mode$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '031', 's', $$Coded validity note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '031', 't', $$Text incipit$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '031', 'u', $$Uniform Resource Identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '031', 'y', $$Link text$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '031', 'z', $$Public note$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '031', '2', $$System code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '031', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '031', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '034', $$Coded Cartographic Mathematical Data$$, $$Coded form of the cartographic mathematical data relevant to the entity described in the authority record. The data that is recorded usually derives from authoritative sources.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_034_ind_1', 'MARC 21 authority field 034 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_034_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_034_ind_2', 'MARC 21 authority field 034 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_034_ind_2', '#', $$Not applicable$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_034_ind_2', '0', $$Outer ring$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_034_ind_2', '1', $$Exclusion ring$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '034', 'd', $$Coordinates$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '034', 'e', $$Coordinates$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '034', 'f', $$Coordinates$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '034', 'g', $$Coordinates$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '034', 'j', $$Declination$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '034', 'k', $$Declination$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '034', 'm', $$Right ascension$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '034', 'n', $$Right ascension$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '034', 'p', $$Equinox$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '034', 'r', $$Distance from earth$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '034', 's', $$G-ring latitude$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '034', 't', $$G-ring longitude$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '034', 'x', $$Beginning date$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '034', 'y', $$Ending date$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '034', 'z', $$Name of extraterrestrial body$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '034', '2', $$Source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '034', '3', $$Materials specified$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '034', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '034', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '035', $$System Control Number$$, $$Control number for the record in a system other than the one whose control number is contained in (Control Number), (Library of Congress Control Number), or (National Bibliographic Agency Control Number).$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_035_ind_1', 'MARC 21 authority field 035 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_035_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_035_ind_2', 'MARC 21 authority field 035 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_035_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '035', 'a', $$System control number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '035', 'z', $$Canceled/invalid system control number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '035', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '035', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '040', $$Cataloging Source$$, $$MARC code or the name of the organization(s) that created the original authority record, assigned MARC content designation and transcribed the record into machine-readable form, or modified an existing MARC record. These MARC codes and the code in 008/39 (Cataloging source) specify the parties responsible for content, content designation, and transcription of an the authority record. See: .$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_040_ind_1', 'MARC 21 authority field 040 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_040_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_040_ind_2', 'MARC 21 authority field 040 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_040_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '040', 'a', $$Original cataloging agency$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '040', 'b', $$Language of cataloging$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '040', 'c', $$Transcribing agency$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '040', 'd', $$Modifying agency$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '040', 'e', $$Description conventions$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '040', 'f', $$Subject heading/thesaurus conventions$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '040', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '040', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '042', $$Authentication Code$$, $$One or more authentication codes indicating that the record, existing in a national database, has been reviewed in a specific way. The codes are associated with specifically designated authentication agencies.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_042_ind_1', 'MARC 21 authority field 042 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_042_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_042_ind_2', 'MARC 21 authority field 042 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_042_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '042', 'a', $$Authentication code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '043', $$Geographic Area Code$$, $$Geographic area codes (GAC) associated with the 1XX heading in an established heading record or a subdivision record. Source of the code in subfield $a is . The source of a local code in subfield $b is indicated in subfield $2. The source of codes in subfield $c is , .$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_043_ind_1', 'MARC 21 authority field 043 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_043_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_043_ind_2', 'MARC 21 authority field 043 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_043_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '043', 'a', $$Geographic area code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '043', 'b', $$Local GAC code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '043', 'c', $$ISO code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '043', '2', $$Source of local code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '043', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '043', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '045', $$Time Period of Heading$$, $$Time period code (subfield $a) and/or a formatted time period (subfield $b or $c) associated with a 15X heading in an established heading record or a 18X heading in a subdivision record.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_045_ind_1', 'MARC 21 authority field 045 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_045_ind_1', '#', $$Subfield $b or $c not present$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_045_ind_1', '0', $$Single date/time$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_045_ind_1', '1', $$Multiple single dates/times$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_045_ind_1', '2', $$Range of dates/times$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_045_ind_2', 'MARC 21 authority field 045 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_045_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '045', 'a', $$Time period code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '045', 'b', $$Formatted 9999 B.C. through C.E. time period$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '045', 'c', $$Formatted pre-9999 B.C. time period$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '045', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '045', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '046', $$Special Coded Dates$$, $$Dates that are associated with the entity described in the record. These include:$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_046_ind_1', 'MARC 21 authority field 046 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_046_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_046_ind_2', 'MARC 21 authority field 046 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_046_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '046', 'f', $$Birth date$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '046', 'g', $$Death date$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '046', 'k', $$Beginning or single date created$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '046', 'l', $$Ending date created$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '046', 's', $$Start period$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '046', 't', $$End period$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '046', 'u', $$Uniform Resource Identifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '046', 'v', $$Source of information$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '046', '2', $$Source of date scheme$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '046', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '046', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '050', $$Library of Congress Call Number$$, $$Call/and or class number for a series when all or part of the series is classified as a collected set or with the main series (646, Series Classification Practice, subfield $a, code c or m). The classification number is taken from the and/or the that are maintained by the Library of Congress.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_050_ind_1', 'MARC 21 authority field 050 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_050_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_050_ind_2', 'MARC 21 authority field 050 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_050_ind_2', '0', $$Assigned by LC$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_050_ind_2', '4', $$Assigned by agency other than LC$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '050', 'a', $$Classification number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '050', 'b', $$Item number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '050', 'd', $$Volumes/dates to which call number applies$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '050', '5', $$Institution to which field applies$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '050', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '050', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '052', $$Geographic Classification$$, $$Classification code for a geographic area associated with the 151 field in an established heading record or 181 field in a subdivision record for a geographic name.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_052_ind_1', 'MARC 21 authority field 052 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_052_ind_1', '#', $$Library of Congress Classification$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_052_ind_1', '1', $$U.S. Dept. of Defense Classification$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_052_ind_1', '7', $$Source specified in subfield $2$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_052_ind_2', 'MARC 21 authority field 052 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_052_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '052', 'a', $$Geographic classification area code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '052', 'b', $$Geographic classification subarea code$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '052', 'd', $$Populated place name$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '052', '2', $$Code source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '052', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '052', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '053', $$LC Classification Number$$, $$Single LC classification number or a number span associated with a 1XX heading in an established heading record or a subdivision record. Source of the classification number is and/or the that are maintained by the Library of Congress. The hyphen (-) between the two class numbers in a range of numbers may be generated based on the presence of both subfields $a and $b.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_053_ind_1', 'MARC 21 authority field 053 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_053_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_053_ind_2', 'MARC 21 authority field 053 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_053_ind_2', '0', $$Assigned by LC$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_053_ind_2', '4', $$Assigned by agency other than LC$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '053', 'a', $$Classification number element-single number or beginning number of span$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '053', 'b', $$Classification number element-ending number of span$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '053', 'c', $$Explanatory term$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '053', '5', $$Institution to which field applies$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '053', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '053', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '055', $$Library and Archives Canada Call Number$$, $$Call number for a series assigned in Canada if the institution has classified all of part of the series as a collected set.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_055_ind_1', 'MARC 21 authority field 055 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_055_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_055_ind_2', 'MARC 21 authority field 055 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_055_ind_2', '0', $$Assigned by LAC$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_055_ind_2', '4', $$Assigned by agency other than LAC$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '055', 'a', $$Classification number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '055', 'b', $$Item number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '055', 'd', $$Volumes/dates to which call number applies$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '055', '5', $$Institution to which field applies$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '055', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '055', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '060', $$National Library of Medicine Call Number$$, $$National Library of Medicine (NLM) call number for a series when all or part of the series is classified as a collected set or with the main series (646, Series Classification Practice, subfield $a, code c or m).$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_060_ind_1', 'MARC 21 authority field 060 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_060_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_060_ind_2', 'MARC 21 authority field 060 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_060_ind_2', '0', $$Assigned by NLM$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_060_ind_2', '4', $$Assigned by agency other than NLM$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '060', 'a', $$Classification number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '060', 'b', $$Item number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '060', 'd', $$Volumes/dates to which call number applies$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '060', '5', $$Institution to which field applies$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '060', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '060', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '065', $$Other Classification Number$$, $$Single classification number, number stem, or a number span associated with a 1XX heading in an established heading record or subdivision record. It is used for all classification schemes except those already accommodated in other fields of this type in the format: 053 (LC Classification Number), 083 (Dewey Decimal Classification number), and 087 (Government Document Classification Number). The classification number(s) may be qualified by explanatory information when the heading is represented in more than one place in the same classification scheme. Each classification number or number span associated with a heading is contained in separate field 065.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_065_ind_1', 'MARC 21 authority field 065 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_065_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_065_ind_2', 'MARC 21 authority field 065 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_065_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '065', 'a', $$Classification number element-single number or beginning of span$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '065', 'b', $$Classification number element-ending number of span$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '065', 'c', $$Explanatory term$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '065', '2', $$Number source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '065', '5', $$Institution to which field applies$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '065', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '065', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '066', $$Character Sets Present$$, $$Used in records encoded with characters from sets other than ISO 10646 (or ) to specify the character sets for data content that are present in the record. The field alerts users that special processing may be required. A detailed description of the standard escape sequences used in MARC records is provided in$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_066_ind_1', 'MARC 21 authority field 066 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_066_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_066_ind_2', 'MARC 21 authority field 066 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_066_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '066', 'a', $$Primary G0 character set$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '066', 'b', $$Primary G1 character set$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '066', 'c', $$Alternate G0 or G1 character set$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '070', $$National Agricultural Library Call Number$$, $$Call number assigned by the National Agricultural Library (NAL) to a series when all or part of the series is classified as a collected set or with the main series (646, Series Classification Practice, subfield $a, code c or m).$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_070_ind_1', 'MARC 21 authority field 070 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_070_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_070_ind_2', 'MARC 21 authority field 070 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_070_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '070', 'a', $$Classification number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '070', 'b', $$Item number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '070', 'd', $$Volumes/dates to which call number applies$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '070', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '070', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '072', $$Subject Category Code$$, $$Code for the subject category that is associated with the 1XX field in an established heading record or a node label record.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_072_ind_1', 'MARC 21 authority field 072 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_072_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_072_ind_2', 'MARC 21 authority field 072 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_072_ind_2', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_072_ind_2', '0', $$NAL subject category code list$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_072_ind_2', '7', $$Source specified in subfield $2$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '072', 'a', $$Subject category code$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '072', 'x', $$Subject category code subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '072', '2', $$Code source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '072', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '072', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '073', $$Subdivision Usage$$, $$Code specifying the topical term or geographic name with which the 1XX heading in a subdivision record may be used in a particular thesaurus.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_073_ind_1', 'MARC 21 authority field 073 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_073_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_073_ind_2', 'MARC 21 authority field 073 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_073_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '073', 'a', $$Subdivision usage$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '073', 'z', $$Code source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '073', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '073', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '080', $$Universal Decimal Classification Number$$, $$Classification number associated with a 1XX heading in an established heading record. Number is taken from the Universal Decimal Classification scheme.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_080_ind_1', 'MARC 21 authority field 080 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_080_ind_1', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_080_ind_1', '0', $$Full$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_080_ind_1', '1', $$Abridged$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_080_ind_2', 'MARC 21 authority field 080 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_080_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '080', 'a', $$Universal Decimal Classification number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '080', 'b', $$Item number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '080', 'x', $$Common auxiliary subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '080', '2', $$Edition identifier$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '080', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '080', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '082', $$Dewey Decimal Call Number$$, $$Call number for a series when all or part of the series is classified as a collected set or with the main series (646, Series Classification Practice, subfield $a, code c or m). Source of the classification number is the the the and electronic updates to either edition. Through 1997, updates were issued in the$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_082_ind_1', 'MARC 21 authority field 082 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_082_ind_1', '0', $$Full$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_082_ind_1', '1', $$Abridged$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_082_ind_2', 'MARC 21 authority field 082 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_082_ind_2', '#', $$No information provided$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_082_ind_2', '0', $$Assigned by LC$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_082_ind_2', '4', $$Assigned by agency other than LC$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '082', 'a', $$Classification number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '082', 'b', $$Item number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '082', 'd', $$Volumes/dates to which call number applies$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '082', '2', $$Edition number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '082', '5', $$Institution to which field applies$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '082', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '082', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '083', $$Dewey Decimal Classification Number$$, $$Single Dewey classification number or a a number span associated with a 1XX heading in an established heading record or a subdivision record. Source of the classification number is the the and electronic updates to either edition. Through 1997, updates were issued in the .$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_083_ind_1', 'MARC 21 authority field 083 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_083_ind_1', '0', $$Full$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_083_ind_1', '1', $$Abridged$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_083_ind_2', 'MARC 21 authority field 083 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_083_ind_2', '0', $$Assigned by LC$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_083_ind_2', '4', $$Assigned by agency other than LC$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '083', 'a', $$Classification number element-single number or beginning number of span$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '083', 'b', $$Classification number element-ending number of span$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '083', 'c', $$Explanatory term$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '083', 'y', $$Table sequence number for internal subarrangement or add table$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '083', 'z', $$Table identification-table number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '083', '2', $$Edition number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '083', '5', $$Institution to which field applies$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '083', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '083', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '086', $$Government Document Call Number$$, $$Government document call number for a series when all or part of the series is classified as a collected set or with a main series (646, Series Classification Practice, subfield $a, code c or m). The organization assigning the number may be identified in subfield $5.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_086_ind_1', 'MARC 21 authority field 086 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_086_ind_1', '#', $$Source specified in subfield $2$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_086_ind_1', '0', $$Superintendent of Documents Classification System$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_086_ind_1', '1', $$Government of Canada Publications: Outline of Classification$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_086_ind_2', 'MARC 21 authority field 086 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_086_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '086', 'a', $$Call number$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '086', 'd', $$Volumes/dates to which call number applies$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '086', 'z', $$Canceled/invalid call number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '086', '2', $$Number source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '086', '5', $$Institution to which field applies$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '086', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '086', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '087', $$Government Document Classification Number$$, $$Single government document classification number, number stem, or a number span associated with a 1XX heading in an established heading record. The classification number(s) may be qualified by explanatory information when the heading is represented by more than one number in the same classification scheme.$$,
FALSE, TRUE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_087_ind_1', 'MARC 21 authority field 087 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_087_ind_1', '#', $$Source specified in subfield $2$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_087_ind_1', '0', $$Superintendent of Documents Classification System$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_087_ind_1', '1', $$Government of Canada Publications: Outline of Classification$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_087_ind_2', 'MARC 21 authority field 087 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_087_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '087', 'a', $$Classification number element-Single number of beginning number of span$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '087', 'b', $$Classification number element-Ending number of span$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '087', 'c', $$Explanatory information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '087', '2', $$Number source$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '087', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '087', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '100', $$Heading-Personal Name$$, $$Established personal name used in a name, name/title, or extended subject heading established heading records or an unestablished personal name used in these types of headings a traced or an untraced reference record.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_100_ind_1', 'MARC 21 authority field 100 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_100_ind_1', '0', $$Forename$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_100_ind_1', '1', $$Surname$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_100_ind_1', '3', $$Family name$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_100_ind_2', 'MARC 21 authority field 100 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_100_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '100', 'a', $$Personal name$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '100', 'b', $$Numeration$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '100', 'c', $$Titles and other words associated with a name$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '100', 'd', $$Dates associated with a name$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '100', 'e', $$Relator term$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '100', 'f', $$Date of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '100', 'g', $$Miscellaneous information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '100', 'h', $$Medium$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '100', 'j', $$Attribution qualifier$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '100', 'k', $$Form subheading$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '100', 'l', $$Language of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '100', 'm', $$Medium of performance for music$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '100', 'n', $$Number of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '100', 'o', $$Arranged statement for music$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '100', 'p', $$Name of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '100', 'q', $$Fuller form of name$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '100', 'r', $$Key for music$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '100', 's', $$Version$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '100', 't', $$Title of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '100', 'v', $$Form subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '100', 'x', $$General subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '100', 'y', $$Chronological subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '100', 'z', $$Geographic subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '100', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '100', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '110', $$Heading-Corporate Name$$, $$Corporate name used in a name, name/title, or extended subject heading in established heading records or an unestablished corporate name used in a traced or an untraced reference record.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_110_ind_1', 'MARC 21 authority field 110 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_110_ind_1', '0', $$Inverted name$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_110_ind_1', '1', $$Jurisdiction name$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_110_ind_1', '2', $$Name in direct order$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_110_ind_2', 'MARC 21 authority field 110 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_110_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '110', 'a', $$Corporate name or jurisdiction name as entry element$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '110', 'b', $$Subordinate unit$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '110', 'c', $$Location of meeting$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '110', 'd', $$Date of meeting or treaty signing$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '110', 'e', $$Relator term$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '110', 'f', $$Date of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '110', 'g', $$Miscellaneous information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '110', 'h', $$Medium$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '110', 'k', $$Form subheading$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '110', 'l', $$Language of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '110', 'm', $$Medium of performance for music$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '110', 'n', $$Number of part/section/meeting$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '110', 'o', $$Arranged statement for music$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '110', 'p', $$Name of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '110', 'r', $$Key for music$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '110', 's', $$Version$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '110', 't', $$Title of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '110', 'v', $$Form subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '110', 'x', $$General subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '110', 'y', $$Chronological subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '110', 'z', $$Geographic subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '110', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '110', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '111', $$Heading-Meeting Name$$, $$Established meeting name used in a name or name/title heading in established heading records or an unestablished meeting name used in these types of headings in traced or untraced reference records.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_111_ind_1', 'MARC 21 authority field 111 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_111_ind_1', '0', $$Inverted name$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_111_ind_1', '1', $$Jurisdiction name$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_111_ind_1', '2', $$Name in direct order$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_111_ind_2', 'MARC 21 authority field 111 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_111_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '111', 'a', $$Meeting name or jurisdiction name as entry element$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '111', 'c', $$Location of meeting$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '111', 'd', $$Date of meeting$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '111', 'e', $$Subordinate unit$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '111', 'f', $$Date of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '111', 'g', $$Miscellaneous information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '111', 'h', $$Medium$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '111', 'j', $$Relator term$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '111', 'k', $$Form subheading$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '111', 'l', $$Language of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '111', 'n', $$Number of part/section/meeting$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '111', 'p', $$Name of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '111', 'q', $$Name of meeting following jurisdiction name entry element$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '111', 's', $$Version$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '111', 't', $$Title of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '111', 'v', $$Form subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '111', 'x', $$General subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '111', 'y', $$Chronological subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '111', 'z', $$Geographic subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '111', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '111', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '130', $$Heading-Uniform Title$$, $$Uniform title used in a title or extended subject heading in established heading records or an unestablished uniform title used in a traced or untraced reference record.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_130_ind_1', 'MARC 21 authority field 130 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_130_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_130_ind_2', 'MARC 21 authority field 130 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_130_ind_2', '0', $$No nonfiling characters$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_130_ind_2', '1', $$Number of nonfiling characters - 1$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_130_ind_2', '2', $$Number of nonfiling characters - 2$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_130_ind_2', '3', $$Number of nonfiling characters - 3$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_130_ind_2', '4', $$Number of nonfiling characters - 4$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_130_ind_2', '5', $$Number of nonfiling characters - 5$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_130_ind_2', '6', $$Number of nonfiling characters - 6$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_130_ind_2', '7', $$Number of nonfiling characters - 7$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_130_ind_2', '8', $$Number of nonfiling characters - 8$$, FALSE, TRUE);
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_130_ind_2', '9', $$Number of nonfiling characters - 9$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '130', 'a', $$Uniform title$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '130', 'd', $$Date of treaty signing$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '130', 'f', $$Date of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '130', 'g', $$Miscellaneous information$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '130', 'h', $$Medium$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '130', 'k', $$Form subheading$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '130', 'l', $$Language of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '130', 'm', $$Medium of performance for music$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '130', 'n', $$Number of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '130', 'o', $$Arranged statement for music$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '130', 'p', $$Name of part/section of a work$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '130', 'r', $$Key for music$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '130', 's', $$Version$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '130', 't', $$Title of a work$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '130', 'v', $$Form subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '130', 'x', $$General subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '130', 'y', $$Chronological subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '130', 'z', $$Geographic subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '130', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '130', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '148', $$Heading-Chronological Term$$, $$Chronological term used as a heading in an established heading record, an established heading and subdivision record, a traced or untraced reference record, or a reference and subdivision record.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_148_ind_1', 'MARC 21 authority field 148 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_148_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_148_ind_2', 'MARC 21 authority field 148 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_148_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '148', 'a', $$Chronological term$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '148', 'v', $$Form subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '148', 'x', $$General subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '148', 'y', $$Chronological subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '148', 'z', $$Geographic subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '148', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '148', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '150', $$Heading-Topical Term$$, $$Topical term used as a heading in an established heading record, an established heading and subdivision record, a traced or an untraced reference record, a reference and subdivision record, or a node label record.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_150_ind_1', 'MARC 21 authority field 150 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_150_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_150_ind_2', 'MARC 21 authority field 150 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_150_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '150', 'a', $$Topical term or geographic name entry element$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '150', 'b', $$Topical term following geographic name entry element$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '150', 'v', $$Form subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '150', 'x', $$General subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '150', 'y', $$Chronological subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '150', 'z', $$Geographic subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '150', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '150', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '151', $$Heading-Geographic Name$$, $$Geographic name used as a heading in an established heading record, an established heading and subdivision record, a traced or an untraced reference record, or a reference and subdivision record.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_151_ind_1', 'MARC 21 authority field 151 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_151_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_151_ind_2', 'MARC 21 authority field 151 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_151_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '151', 'a', $$Geographic name$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '151', 'v', $$Form subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '151', 'x', $$General subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '151', 'y', $$Chronological subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '151', 'z', $$Geographic subdivision$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '151', '6', $$Linkage$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '151', '8', $$Field link and sequence number$$,
TRUE, FALSE, FALSE);
INSERT INTO config.marc_field(marc_format, marc_record_type, tag, name, description,
                              fixed_field, repeatable, mandatory, hidden)
VALUES (1, 'authority', '155', $$Heading-Genre/Form Term$$, $$Genre or form term used as a heading in an established heading record, an established heading and subdivision record, a traced or an untraced reference record, or a reference and subdivision record. The term may consist of more than one word.$$,
FALSE, FALSE, FALSE, FALSE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_155_ind_1', 'MARC 21 authority field 155 indicator position 1');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_155_ind_1', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.record_attr_definition(name, label)
VALUES ('marc21_authority_155_ind_2', 'MARC 21 authority field 155 indicator position 2');
INSERT INTO config.coded_value_map(ctype, code, value, opac_visible, is_simple)
VALUES ('marc21_authority_155_ind_2', '#', $$Undefined$$, FALSE, TRUE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandatory, hidden)
VALUES (1, 'authority', '155', 'a', $$Genre/form term$$,
FALSE, FALSE, FALSE);
INSERT INTO config.marc_subfield(marc_format, marc_record_type, tag, code, description,
                                 repeatable, mandat